/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.machine.MachineDiFurnace;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityDiFurnace
extends TileEntity
implements ISidedInventory {
    private ItemStack[] slots = new ItemStack[4];
    public int dualCookTime;
    public int dualPower;
    public static final int maxPower = 12800;
    public static final int processingSpeed = 400;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{3};
    private static final int[] slots_side = new int[]{1};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.diFurnace";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i != 3;
    }

    public boolean hasItemPower(ItemStack itemStack) {
        return TileEntityDiFurnace.getItemPower(itemStack) > 0;
    }

    private static int getItemPower(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151044_h) {
            return 200;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
            return 2000;
        }
        if (item == Items.field_151129_at) {
            return 12800;
        }
        if (item == Items.field_151072_bj) {
            return 1000;
        }
        if (item == Items.field_151065_br) {
            return 300;
        }
        if (item == ModItems.lignite) {
            return 150;
        }
        if (item == ModItems.powder_lignite) {
            return 150;
        }
        if (item == ModItems.powder_coal) {
            return 200;
        }
        if (item == ModItems.briquette_lignite) {
            return 200;
        }
        if (item == ModItems.coke) {
            return 400;
        }
        if (item == ModItems.solid_fuel) {
            return 400;
        }
        return 0;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.dualPower = nbt.func_74762_e("powerTime");
        this.dualCookTime = nbt.func_74765_d("cookTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("powerTime", this.dualPower);
        nbt.func_74777_a("cookTime", (short)this.dualCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.dualCookTime * i / 400;
    }

    public int getPowerRemainingScaled(int i) {
        return this.dualPower * i / 12800;
    }

    public boolean canProcess() {
        if (this.slots[0] == null || this.slots[1] == null) {
            return false;
        }
        ItemStack itemStack = MachineRecipes.getFurnaceProcessingResult(this.slots[0], this.slots[1]);
        if (itemStack == null) {
            return false;
        }
        if (this.slots[3] == null) {
            return true;
        }
        if (!this.slots[3].func_77969_a(itemStack)) {
            return false;
        }
        if (this.slots[3].field_77994_a < this.func_70297_j_() && this.slots[3].field_77994_a < this.slots[3].func_77976_d()) {
            return true;
        }
        return this.slots[3].field_77994_a < itemStack.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack itemStack = MachineRecipes.getFurnaceProcessingResult(this.slots[0], this.slots[1]);
            if (this.slots[3] == null) {
                this.slots[3] = itemStack.func_77946_l();
            } else if (this.slots[3].func_77969_a(itemStack)) {
                this.slots[3].field_77994_a += itemStack.field_77994_a;
            }
            for (int i = 0; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
        }
    }

    public boolean hasPower() {
        return this.dualPower > 0;
    }

    public boolean isProcessing() {
        return this.dualCookTime > 0;
    }

    public void func_145845_h() {
        this.hasPower();
        boolean flag1 = false;
        if (this.hasPower() && this.isProcessing()) {
            --this.dualPower;
            if (this.dualPower < 0) {
                this.dualPower = 0;
            }
        }
        if (this.hasItemPower(this.slots[2]) && this.dualPower <= 12800 - TileEntityDiFurnace.getItemPower(this.slots[2])) {
            this.dualPower += TileEntityDiFurnace.getItemPower(this.slots[2]);
            if (this.slots[2] != null) {
                flag1 = true;
                --this.slots[2].field_77994_a;
                if (this.slots[2].field_77994_a == 0) {
                    this.slots[2] = this.slots[2].func_77973_b().getContainerItem(this.slots[2]);
                }
            }
        }
        if (this.hasPower() && this.canProcess()) {
            ++this.dualCookTime;
            if (this.dualCookTime == 400) {
                this.dualCookTime = 0;
                this.processItem();
                flag1 = true;
            }
        } else {
            this.dualCookTime = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.dualCookTime == 0) {
                trigger = false;
            }
            if (this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.pellet_rtg) {
                this.dualPower = 12800;
            }
            if (trigger) {
                flag1 = true;
                MachineDiFurnace.updateBlockState(this.dualCookTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }
}

