/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IConsumer;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemLens;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCoreStabilizer
extends TileEntityMachineBase
implements IConsumer {
    public long power;
    public static final long maxPower = 2500000000L;
    public int watts;
    public int beam;
    public static final int range = 15;

    public TileEntityCoreStabilizer() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.dfcStabilizer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.watts = MathHelper.func_76125_a((int)this.watts, (int)1, (int)100);
            int demand = (int)Math.pow(this.watts, 4.0);
            this.beam = 0;
            if (this.power >= (long)demand && this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.ams_lens && ItemLens.getLensDamage(this.slots[0]) < ((ItemLens)ModItems.ams_lens).field_77699_b) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                for (int i = 1; i <= 15; ++i) {
                    int x = this.field_145851_c + dir.offsetX * i;
                    int y = this.field_145848_d + dir.offsetY * i;
                    int z = this.field_145849_e + dir.offsetZ * i;
                    TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                    if (te instanceof TileEntityCore) {
                        TileEntityCore core = (TileEntityCore)te;
                        core.field = this.watts;
                        this.power -= (long)demand;
                        this.beam = i;
                        long dmg = ItemLens.getLensDamage(this.slots[0]);
                        if ((dmg += (long)this.watts) >= ((ItemLens)ModItems.ams_lens).field_77699_b) {
                            this.slots[0] = null;
                            break;
                        }
                        ItemLens.setLensDamage(this.slots[0], dmg);
                        break;
                    }
                    if (this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150350_a) break;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("watts", this.watts);
            data.func_74768_a("beam", this.beam);
            this.networkPack(data, 250);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.watts = data.func_74762_e("watts");
        this.beam = data.func_74762_e("beam");
    }

    public long getPowerScaled(long i) {
        return this.power * i / 2500000000L;
    }

    public int getWattsScaled(int i) {
        return this.watts * i / 100;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 2500000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.watts = nbt.func_74762_e("watts");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("watts", this.watts);
    }
}

