/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.ILaserable;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCoreReceiver
extends TileEntityMachineBase
implements ISource,
IFluidAcceptor,
ILaserable {
    public long power;
    public long joules;
    public FluidTank tank;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public int age = 0;

    public TileEntityCoreReceiver() {
        super(0);
        this.tank = new FluidTank(FluidTypeHandler.FluidType.CRYOGEL, 64000, 0);
    }

    @Override
    public String getName() {
        return "container.dfcReceiver";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.power += this.joules * 5000L;
            if (this.joules > 0L) {
                if (this.tank.getFill() >= 20) {
                    this.tank.setFill(this.tank.getFill() - 20);
                } else {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k);
                    return;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("joules", this.joules);
            this.networkPack(data, 50);
            this.joules = 0L;
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
                if (!this.getTact()) {
                    this.power = 0L;
                }
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.joules = data.func_74763_f("joules");
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            return this.tank.getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            return this.tank.getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }

    @Override
    public void addEnergy(long energy, ForgeDirection dir) {
        if (dir.getOpposite().ordinal() == this.func_145832_p()) {
            this.joules += energy;
        } else {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 2.5f, true);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.joules = nbt.func_74763_f("joules");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74772_a("joules", this.joules);
        this.tank.writeToNBT(nbt, "tank");
    }
}

