/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.inventory.FluidTank;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCoreInjector
extends TileEntityMachineBase
implements IFluidAcceptor {
    public FluidTank[] tanks = new FluidTank[2];
    public static final int range = 15;
    public int beam;

    public TileEntityCoreInjector() {
        super(4);
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.DEUTERIUM, 128000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.TRITIUM, 128000, 1);
    }

    @Override
    public String getName() {
        return "container.dfcInjector";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tanks[0].setType(0, 1, this.slots);
            this.tanks[1].setType(2, 3, this.slots);
            this.beam = 0;
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
            for (int i = 1; i <= 15; ++i) {
                int x = this.field_145851_c + dir.offsetX * i;
                int y = this.field_145848_d + dir.offsetY * i;
                int z = this.field_145849_e + dir.offsetZ * i;
                TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                if (te instanceof TileEntityCore) {
                    TileEntityCore core = (TileEntityCore)te;
                    for (int t = 0; t < 2; ++t) {
                        int f;
                        if (core.tanks[t].getTankType() == this.tanks[t].getTankType()) {
                            f = Math.min(this.tanks[t].getFill(), core.tanks[t].getMaxFill() - core.tanks[t].getFill());
                            this.tanks[t].setFill(this.tanks[t].getFill() - f);
                            core.tanks[t].setFill(core.tanks[t].getFill() + f);
                            core.func_70296_d();
                            continue;
                        }
                        if (core.tanks[t].getFill() != 0) continue;
                        core.tanks[t].setTankType(this.tanks[t].getTankType());
                        f = Math.min(this.tanks[t].getFill(), core.tanks[t].getMaxFill() - core.tanks[t].getFill());
                        this.tanks[t].setFill(this.tanks[t].getFill() - f);
                        core.tanks[t].setFill(core.tanks[t].getFill() + f);
                        core.func_70296_d();
                    }
                    this.beam = i;
                    break;
                }
                if (this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150350_a) break;
            }
            this.func_70296_d();
            this.tanks[0].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.tanks[1].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("beam", this.beam);
            this.networkPack(data, 250);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.beam = data.func_74762_e("beam");
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "fuel1");
        this.tanks[1].readFromNBT(nbt, "fuel2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "fuel1");
        this.tanks[1].writeToNBT(nbt, "fuel2");
    }
}

