/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.ILaserable;
import com.hbm.inventory.FluidTank;
import com.hbm.lib.ModDamageSource;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCoreEmitter
extends TileEntityMachineBase
implements IConsumer,
IFluidAcceptor,
ILaserable {
    public long power;
    public static final long maxPower = 1000000000L;
    public int watts;
    public int beam;
    public long joules;
    public boolean isOn;
    public FluidTank tank = new FluidTank(FluidTypeHandler.FluidType.CRYOGEL, 64000, 0);
    public long prev;
    public static final int range = 50;

    public TileEntityCoreEmitter() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.dfcEmitter";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.watts = MathHelper.func_76125_a((int)this.watts, (int)1, (int)100);
            long demand = 1000000000L * (long)this.watts / 2000L;
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.beam = 0;
            if (this.joules > 0L || this.prev > 0L) {
                if (this.tank.getFill() >= 20) {
                    this.tank.setFill(this.tank.getFill() - 20);
                } else {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k);
                    return;
                }
            }
            if (this.isOn) {
                if (this.power >= demand) {
                    this.power -= demand;
                    long add = this.watts * 100;
                    this.joules += add;
                }
                this.prev = this.joules;
                if (this.joules > 0L) {
                    long out = this.joules * 98L / 100L;
                    ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                    for (int i = 1; i <= 50; ++i) {
                        this.beam = i;
                        int x = this.field_145851_c + dir.offsetX * i;
                        int y = this.field_145848_d + dir.offsetY * i;
                        int z = this.field_145849_e + dir.offsetZ * i;
                        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
                        if (te instanceof ILaserable) {
                            ((ILaserable)te).addEnergy(out * 98L / 100L, dir);
                            break;
                        }
                        if (te instanceof TileEntityCore) {
                            out = ((TileEntityCore)te).burn(out);
                            continue;
                        }
                        Block b = this.field_145850_b.func_147439_a(x, y, z);
                        if (b == Blocks.field_150350_a) continue;
                        if (b.func_149688_o().func_76224_d()) {
                            this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, 1.0f);
                            this.field_145850_b.func_147468_f(x, y, z);
                            break;
                        }
                        float hardness = b.func_149638_a(null);
                        if (!(hardness < 6000.0f) || this.field_145850_b.field_73012_v.nextInt(20) != 0) break;
                        this.field_145850_b.func_147480_a(x, y, z, false);
                        break;
                    }
                    this.joules = 0L;
                    double blx = (double)Math.min(this.field_145851_c, this.field_145851_c + dir.offsetX * this.beam) + 0.2;
                    double bux = (double)Math.max(this.field_145851_c, this.field_145851_c + dir.offsetX * this.beam) + 0.8;
                    double bly = (double)Math.min(this.field_145848_d, this.field_145848_d + dir.offsetY * this.beam) + 0.2;
                    double buy = (double)Math.max(this.field_145848_d, this.field_145848_d + dir.offsetY * this.beam) + 0.8;
                    double blz = (double)Math.min(this.field_145849_e, this.field_145849_e + dir.offsetZ * this.beam) + 0.2;
                    double buz = (double)Math.max(this.field_145849_e, this.field_145849_e + dir.offsetZ * this.beam) + 0.8;
                    List list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)blx, (double)bly, (double)blz, (double)bux, (double)buy, (double)buz));
                    for (Entity e : list) {
                        e.func_70097_a(ModDamageSource.amsCore, 50.0f);
                        e.func_70015_d(10);
                    }
                }
            } else {
                this.joules = 0L;
                this.prev = 0L;
            }
            this.func_70296_d();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("watts", this.watts);
            data.func_74772_a("prev", this.prev);
            data.func_74768_a("beam", this.beam);
            data.func_74757_a("isOn", this.isOn);
            this.networkPack(data, 250);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.watts = data.func_74762_e("watts");
        this.prev = data.func_74763_f("prev");
        this.beam = data.func_74762_e("beam");
        this.isOn = data.func_74767_n("isOn");
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000000L;
    }

    public int getWattsScaled(int i) {
        return this.watts * i / 100;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            return this.tank.getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            return this.tank.getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000000L;
    }

    @Override
    public void addEnergy(long energy, ForgeDirection dir) {
        if (dir.getOpposite().ordinal() != this.func_145832_p()) {
            this.joules += energy;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.watts = nbt.func_74762_e("watts");
        this.joules = nbt.func_74763_f("joules");
        this.prev = nbt.func_74763_f("prev");
        this.isOn = nbt.func_74767_n("isOn");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("watts", this.watts);
        nbt.func_74772_a("joules", this.joules);
        nbt.func_74772_a("prev", this.prev);
        nbt.func_74757_a("isOn", this.isOn);
        this.tank.writeToNBT(nbt, "tank");
    }
}

