/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.effect.EntityCloudFleijaRainbow;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCatalyst;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ArmorUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityCore
extends TileEntityMachineBase {
    public int field;
    public int heat;
    public int color;
    public FluidTank[] tanks = new FluidTank[2];

    public TileEntityCore() {
        super(3);
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.DEUTERIUM, 128000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.TRITIUM, 128000, 1);
    }

    @Override
    public String getName() {
        return "container.dfcCore";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.heat > 0 && this.heat >= this.field) {
                int fill = this.tanks[0].getFill() + this.tanks[1].getFill();
                int max = this.tanks[0].getMaxFill() + this.tanks[1].getMaxFill();
                int mod = this.heat * 10;
                int size = Math.max(Math.min(fill * mod / max, 1000), 50);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.explode", 100000.0f, 1.0f);
                EntityNukeExplosionMK3 exp = new EntityNukeExplosionMK3(this.field_145850_b);
                exp.field_70165_t = this.field_145851_c;
                exp.field_70163_u = this.field_145848_d;
                exp.field_70161_v = this.field_145849_e;
                exp.destructionRange = size;
                exp.speed = 25;
                exp.coefficient = 1.0f;
                exp.waste = false;
                this.field_145850_b.func_72838_d((Entity)exp);
                EntityCloudFleijaRainbow cloud = new EntityCloudFleijaRainbow(this.field_145850_b, size);
                cloud.field_70165_t = this.field_145851_c;
                cloud.field_70163_u = this.field_145848_d;
                cloud.field_70161_v = this.field_145849_e;
                this.field_145850_b.func_72838_d((Entity)cloud);
            }
            this.color = this.slots[0] != null && this.slots[2] != null && this.slots[0].func_77973_b() instanceof ItemCatalyst && this.slots[2].func_77973_b() instanceof ItemCatalyst ? this.calcAvgHex(((ItemCatalyst)this.slots[0].func_77973_b()).getColor(), ((ItemCatalyst)this.slots[2].func_77973_b()).getColor()) : 0;
            if (this.heat > 0) {
                this.radiation();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("tank0", this.tanks[0].getTankType().ordinal());
            data.func_74768_a("tank1", this.tanks[1].getTankType().ordinal());
            data.func_74768_a("fill0", this.tanks[0].getFill());
            data.func_74768_a("fill1", this.tanks[1].getFill());
            data.func_74768_a("field", this.field);
            data.func_74768_a("heat", this.heat);
            data.func_74768_a("color", this.color);
            this.networkPack(data, 250);
            this.heat = 0;
            this.field = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.tanks[0].setTankType(FluidTypeHandler.FluidType.getEnum(data.func_74762_e("tank0")));
        this.tanks[1].setTankType(FluidTypeHandler.FluidType.getEnum(data.func_74762_e("tank1")));
        this.tanks[0].setFill(data.func_74762_e("fill0"));
        this.tanks[1].setFill(data.func_74762_e("fill1"));
        this.field = data.func_74762_e("field");
        this.heat = data.func_74762_e("heat");
        this.color = data.func_74762_e("color");
    }

    private void radiation() {
        double scale = 2.0;
        List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)(this.field_145851_c - 10) + 0.5), (double)((double)(this.field_145848_d - 10) + 0.5 + 6.0), (double)((double)(this.field_145849_e - 10) + 0.5), (double)((double)(this.field_145851_c + 10) + 0.5), (double)((double)(this.field_145848_d + 10) + 0.5 + 6.0), (double)((double)(this.field_145849_e + 10) + 0.5)));
        for (Entity e : list) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityPlayer)e) || Library.isObstructed(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5 + 6.0, (double)this.field_145849_e + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) continue;
            e.func_70097_a(ModDamageSource.ams, 1000.0f);
            e.func_70015_d(3);
        }
        List list2 = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - scale + 0.5), (double)((double)this.field_145848_d - scale + 0.5 + 6.0), (double)((double)this.field_145849_e - scale + 0.5), (double)((double)this.field_145851_c + scale + 0.5), (double)((double)this.field_145848_d + scale + 0.5 + 6.0), (double)((double)this.field_145849_e + scale + 0.5)));
        for (Entity e : list2) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHaz2((EntityPlayer)e)) continue;
            e.func_70097_a(ModDamageSource.amsCore, 10000.0f);
        }
    }

    public int getFieldScaled(int i) {
        return this.field * i / 100;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 100;
    }

    public boolean isReady() {
        if (this.getCore() == 0) {
            return false;
        }
        if (this.color == 0) {
            return false;
        }
        return !(this.getFuelEfficiency(this.tanks[0].getTankType()) <= 0.0f) && !(this.getFuelEfficiency(this.tanks[1].getTankType()) <= 0.0f);
    }

    public long burn(long joules) {
        if (!this.isReady()) {
            return joules;
        }
        int demand = (int)Math.ceil((double)joules / 1000.0);
        if (this.tanks[0].getFill() < demand || this.tanks[1].getFill() < demand) {
            return joules;
        }
        this.heat += (int)Math.ceil((double)joules / 10000.0);
        this.tanks[0].setFill(this.tanks[0].getFill() - demand);
        this.tanks[1].setFill(this.tanks[1].getFill() - demand);
        return (long)((float)(joules * (long)this.getCore()) * this.getFuelEfficiency(this.tanks[0].getTankType()) * this.getFuelEfficiency(this.tanks[1].getTankType()));
    }

    public float getFuelEfficiency(FluidTypeHandler.FluidType type) {
        switch (type) {
            case HYDROGEN: {
                return 1.0f;
            }
            case DEUTERIUM: {
                return 1.5f;
            }
            case TRITIUM: {
                return 1.7f;
            }
            case OXYGEN: {
                return 1.2f;
            }
            case ACID: {
                return 1.4f;
            }
            case XENON: {
                return 1.5f;
            }
            case SAS3: {
                return 2.0f;
            }
            case BALEFIRE: {
                return 2.5f;
            }
            case AMAT: {
                return 2.2f;
            }
            case ASCHRAB: {
                return 2.7f;
            }
        }
        return 0.0f;
    }

    public int getCore() {
        if (this.slots[1] == null) {
            return 0;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_sing) {
            return 500;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_wormhole) {
            return 650;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_eyeofharmony) {
            return 800;
        }
        if (this.slots[1].func_77973_b() == ModItems.ams_core_thingy) {
            return 2500;
        }
        return 0;
    }

    private int calcAvgHex(int h1, int h2) {
        int r1 = (h1 & 0xFF0000) >> 16;
        int g1 = (h1 & 0xFF00) >> 8;
        int b1 = (h1 & 0xFF) >> 0;
        int r2 = (h2 & 0xFF0000) >> 16;
        int g2 = (h2 & 0xFF00) >> 8;
        int b2 = (h2 & 0xFF) >> 0;
        int r = (r1 + r2) / 2 << 16;
        int g = (g1 + g2) / 2 << 8;
        int b = (b1 + b2) / 2 << 0;
        return r | g | b;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "fuel1");
        this.tanks[1].readFromNBT(nbt, "fuel2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "fuel1");
        this.tanks[1].writeToNBT(nbt, "fuel2");
    }
}

