/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.hbm.calc.Location;
import com.hbm.interfaces.IConsumer;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityConverterHeRf
extends TileEntityMachineBase
implements IConsumer,
IEnergyHandler {
    public long power;
    public long maxPower = 500000000L;
    public EnergyStorage storage = new EnergyStorage(2000000000, 2000000000, 2000000000);
    public int buf;

    public TileEntityConverterHeRf() {
        super(0);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.storage.setCapacity((int)this.power * 4);
            this.storage.setEnergyStored((int)this.power * 4);
            this.buf = this.storage.getEnergyStored();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Location loc = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).add(dir);
                TileEntity entity = loc.getTileEntity();
                if (entity == null || !(entity instanceof IEnergyReceiver)) continue;
                IEnergyReceiver receiver = (IEnergyReceiver)entity;
                int maxExtract = this.storage.getMaxExtract();
                int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                int energyTransferred = receiver.receiveEnergy(dir.getOpposite(), maxAvailable, false);
                this.storage.extractEnergy(energyTransferred, false);
            }
            this.power = this.storage.getEnergyStored() / 4;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("rf", this.storage.getEnergyStored());
            data.func_74768_a("maxrf", this.storage.getEnergyStored());
            data.func_74772_a("he", this.power);
            data.func_74772_a("maxhe", this.power);
            this.networkPack(data, 25);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.storage.setEnergyStored(nbt.func_74762_e("rf"));
        this.storage.setCapacity(nbt.func_74762_e("maxrf"));
        this.power = nbt.func_74763_f("he");
        this.maxPower = nbt.func_74763_f("maxhe");
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        if (this.power < 1000000L) {
            return 500000000L;
        }
        return this.maxPower;
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.maxPower;
    }

    public long getFluxScaled(long i) {
        return (long)this.storage.getEnergyStored() * i / (long)this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }
}

