/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.interfaces.ISource;
import com.hbm.interfaces.Untested;
import com.hbm.inventory.FluidTank;
import com.hbm.inventory.MachineRecipes;
import com.hbm.lib.Library;
import com.hbm.packet.NBTPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChungus
extends TileEntity
implements IFluidAcceptor,
IFluidSource,
ISource,
INBTPacketReceiver {
    public long power;
    public static final long maxPower = 100000000000L;
    private int turnTimer;
    public float rotor;
    public float lastRotor;
    public List<IConsumer> list1 = new ArrayList<IConsumer>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks = new FluidTank[2];

    public TileEntityChungus() {
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.STEAM, 1000000000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.WATER, 1000000000, 1);
    }

    @Untested
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            Object[] outs = MachineRecipes.getTurbineOutput(this.tanks[0].getTankType());
            this.tanks[1].setTankType((FluidTypeHandler.FluidType)((Object)outs[0]));
            int processMax = (int)Math.ceil(this.tanks[0].getFill() / (Integer)outs[2]);
            int processSteam = this.tanks[0].getFill() / (Integer)outs[2];
            int processWater = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / (Integer)outs[1];
            int cycles = Math.min(processMax, Math.min(processSteam, processWater));
            this.tanks[0].setFill(this.tanks[0].getFill() - (Integer)outs[2] * cycles);
            this.tanks[1].setFill(this.tanks[1].getFill() + (Integer)outs[1] * cycles);
            this.power += (long)((Integer)outs[3] * cycles);
            if (this.power > 100000000000L) {
                this.power = 100000000000L;
            }
            --this.turnTimer;
            if (cycles > 0) {
                this.turnTimer = 25;
            }
            this.fillFluidInit(this.tanks[1].getTankType());
            this.ffgeuaInit();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("type", this.tanks[0].getTankType().ordinal());
            data.func_74768_a("operational", this.turnTimer);
            this.networkPack(data, 150);
        } else {
            this.lastRotor = this.rotor;
            if (this.turnTimer > 0) {
                this.rotor += 25.0f;
                if (this.rotor >= 360.0f) {
                    this.rotor -= 360.0f;
                    this.lastRotor -= 360.0f;
                }
                Random rand = this.field_145850_b.field_73012_v;
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                ForgeDirection side = dir.getRotation(ForgeDirection.UP);
                for (int i = 0; i < 10; ++i) {
                    this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 + (double)dir.offsetX * (rand.nextDouble() + 1.25) + rand.nextGaussian() * (double)side.offsetX * 0.65, (double)this.field_145848_d + 2.5 + rand.nextGaussian() * 0.65, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * (rand.nextDouble() + 1.25) + rand.nextGaussian() * (double)side.offsetZ * 0.65, (double)(-dir.offsetX) * 0.2, 0.0, (double)(-dir.offsetZ) * 0.2);
                }
            }
        }
    }

    public void networkPack(NBTTagCompound nbt, int range) {
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new NBTPacket(nbt, this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)range));
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.turnTimer = data.func_74762_e("operational");
        this.tanks[0].setTankType(FluidTypeHandler.FluidType.values()[data.func_74762_e("type")]);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        this.ffgeua(this.field_145851_c - dir.offsetX * 11, this.field_145848_d, this.field_145849_e - dir.offsetZ * 11, this.getTact());
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        dir = dir.getRotation(ForgeDirection.UP);
        this.fillFluid(this.field_145851_c + dir.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3, this.getTact(), type);
        this.fillFluid(this.field_145851_c + dir.offsetX * -3, this.field_145848_d, this.field_145849_e + dir.offsetZ * -3, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 2L == 0L;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list2;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list2.clear();
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list1;
    }

    @Override
    public void clearList() {
        this.list1.clear();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

