/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityBarrel
extends TileEntityMachineBase
implements IFluidAcceptor,
IFluidSource {
    public FluidTank tank;
    public short mode = 0;
    public static final short modes = 4;
    public int age = 0;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();

    public TileEntityBarrel() {
        super(6);
        this.tank = new FluidTank(FluidTypeHandler.FluidType.NONE, 0, 0);
    }

    public TileEntityBarrel(int capacity) {
        super(6);
        this.tank = new FluidTank(FluidTypeHandler.FluidType.NONE, capacity, 0);
    }

    @Override
    public String getName() {
        return "container.barrel";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.setType(0, 1, this.slots);
            this.tank.loadTank(2, 3, this.slots);
            this.tank.unloadTank(4, 5, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (!(this.mode != 1 && this.mode != 2 || this.age != 9 && this.age != 19)) {
                this.fillFluidInit(this.tank.getTankType());
            }
            if (this.tank.getFill() > 0) {
                Block b = this.func_145838_q();
                if (b != ModBlocks.barrel_antimatter && this.tank.getTankType().traits.contains((Object)FluidTypeHandler.FluidTrait.AMAT)) {
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                    this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
                }
                if (b == ModBlocks.barrel_plastic && (this.tank.getTankType().isCorrosive() || this.tank.getTankType().isHot())) {
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 1.0f);
                }
                if (b == ModBlocks.barrel_iron && this.tank.getTankType().isCorrosive() || b == ModBlocks.barrel_steel && this.tank.getTankType().traits.contains((Object)FluidTypeHandler.FluidTrait.CORROSIVE_2)) {
                    ItemStack[] copy = (ItemStack[])this.slots.clone();
                    this.slots = new ItemStack[6];
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.barrel_corroded);
                    TileEntityBarrel barrel = (TileEntityBarrel)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    if (barrel != null) {
                        barrel.tank.setTankType(this.tank.getTankType());
                        barrel.tank.setFill(Math.min(barrel.tank.getMaxFill(), this.tank.getFill()));
                        barrel.slots = copy;
                    }
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 1.0f);
                }
                if (b == ModBlocks.barrel_corroded && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
                    this.tank.setFill(this.tank.getFill() - 1);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("mode", this.mode);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.mode = data.func_74765_d("mode");
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (this.mode == 2 || this.mode == 3) {
            return 0;
        }
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getMaxFill() : 0;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list.clear();
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74765_d("mode");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", this.mode);
        this.tank.writeToNBT(nbt, "tank");
    }
}

