/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.effect.EntityCloudFleijaRainbow;
import com.hbm.entity.logic.EntityNukeExplosionMK4;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCatalyst;
import com.hbm.items.machine.ItemSatChip;
import com.hbm.items.special.ItemAMSCore;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.SatelliteResonator;
import com.hbm.tileentity.machine.TileEntityAMSEmitter;
import com.hbm.tileentity.machine.TileEntityAMSLimiter;
import com.hbm.util.ArmorUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldSavedData;
import scala.util.Random;

public class TileEntityAMSBase
extends TileEntity
implements ISidedInventory,
ISource,
IFluidContainer,
IFluidAcceptor {
    private ItemStack[] slots;
    public long power = 0L;
    public static final long maxPower = 1000000000000000L;
    public int field = 0;
    public static final int maxField = 100;
    public int efficiency = 0;
    public static final int maxEfficiency = 100;
    public int heat = 0;
    public static final int maxHeat = 5000;
    public int age = 0;
    public int warning = 0;
    public int mode = 0;
    public boolean locked = false;
    public FluidTank[] tanks;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public int color = -1;
    Random rand = new Random();
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0};
    private static final int[] slots_side = new int[]{0};
    private String customName;

    public TileEntityAMSBase() {
        this.slots = new ItemStack[16];
        this.tanks = new FluidTank[4];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.COOLANT, 8000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.CRYOGEL, 8000, 1);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.DEUTERIUM, 8000, 2);
        this.tanks[3] = new FluidTank(FluidTypeHandler.FluidType.TRITIUM, 8000, 3);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.amsBase";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "coolant1");
        this.tanks[1].readFromNBT(nbt, "coolant2");
        this.tanks[2].readFromNBT(nbt, "fuel1");
        this.tanks[3].readFromNBT(nbt, "fuel2");
        this.field = nbt.func_74762_e("field");
        this.efficiency = nbt.func_74762_e("efficiency");
        this.heat = nbt.func_74762_e("heat");
        this.locked = nbt.func_74767_n("locked");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "coolant1");
        this.tanks[1].writeToNBT(nbt, "coolant2");
        this.tanks[2].writeToNBT(nbt, "fuel1");
        this.tanks[3].writeToNBT(nbt, "fuel2");
        nbt.func_74768_a("field", this.field);
        nbt.func_74768_a("efficiency", this.efficiency);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74757_a("locked", this.locked);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            for (i = 0; i < this.tanks.length; ++i) {
                this.tanks[i].setFill(this.tanks[i].getMaxFill());
            }
            if (!this.locked) {
                TileEntity te;
                ++this.age;
                if (this.age >= 20) {
                    this.age = 0;
                }
                if (this.age == 9 || this.age == 19) {
                    this.ffgeuaInit();
                }
                this.tanks[0].setType(0, 1, this.slots);
                this.tanks[1].setType(2, 3, this.slots);
                this.tanks[2].setType(4, 5, this.slots);
                this.tanks[3].setType(6, 7, this.slots);
                for (i = 0; i < 4; ++i) {
                    this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
                }
                int f1 = 0;
                int f2 = 0;
                int f3 = 0;
                int f4 = 0;
                int booster = 0;
                if (this.field_145850_b.func_147438_o(this.field_145851_c + 6, this.field_145848_d, this.field_145849_e) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_147438_o(this.field_145851_c + 6, this.field_145848_d, this.field_145849_e);
                    if (!te.locked && this.field_145850_b.func_72805_g(this.field_145851_c + 6, this.field_145848_d, this.field_145849_e) == 4) {
                        f1 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                if (this.field_145850_b.func_147438_o(this.field_145851_c - 6, this.field_145848_d, this.field_145849_e) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_147438_o(this.field_145851_c - 6, this.field_145848_d, this.field_145849_e);
                    if (!te.locked && this.field_145850_b.func_72805_g(this.field_145851_c - 6, this.field_145848_d, this.field_145849_e) == 5) {
                        f2 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 6) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 6);
                    if (!te.locked && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e + 6) == 2) {
                        f3 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 6) instanceof TileEntityAMSLimiter) {
                    te = (TileEntityAMSLimiter)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 6);
                    if (!te.locked && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e - 6) == 3) {
                        f4 = te.efficiency;
                        if (te.mode == 2) {
                            ++booster;
                        }
                    }
                }
                this.field = Math.round(this.calcField(f1, f2, f3, f4));
                this.mode = 0;
                if (this.field > 0) {
                    this.mode = 1;
                }
                if (booster > 0) {
                    this.mode = 2;
                }
                if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 9, this.field_145849_e) instanceof TileEntityAMSEmitter) {
                    te = (TileEntityAMSEmitter)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 9, this.field_145849_e);
                    this.efficiency = ((TileEntityAMSEmitter)te).efficiency;
                }
                this.color = -1;
                float powerMod = 1.0f;
                float heatMod = 1.0f;
                float fuelMod = 1.0f;
                long powerBase = 0L;
                int heatBase = 0;
                int fuelBase = 0;
                if (this.slots[8] != null && this.slots[9] != null && this.slots[10] != null && this.slots[11] != null && this.slots[12] != null && this.slots[8].func_77973_b() instanceof ItemCatalyst && this.slots[9].func_77973_b() instanceof ItemCatalyst && this.slots[10].func_77973_b() instanceof ItemCatalyst && this.slots[11].func_77973_b() instanceof ItemCatalyst && this.slots[12].func_77973_b() instanceof ItemAMSCore && this.hasResonators() && this.efficiency > 0) {
                    int g;
                    int a = ((ItemCatalyst)this.slots[8].func_77973_b()).getColor();
                    int b = ((ItemCatalyst)this.slots[9].func_77973_b()).getColor();
                    int c = ((ItemCatalyst)this.slots[10].func_77973_b()).getColor();
                    int d = ((ItemCatalyst)this.slots[11].func_77973_b()).getColor();
                    int e = this.calcAvgHex(a, b);
                    int f = this.calcAvgHex(c, d);
                    this.color = g = this.calcAvgHex(e, f);
                    for (int i2 = 8; i2 < 12; ++i2) {
                        powerBase += ItemCatalyst.getPowerAbs(this.slots[i2]);
                        powerMod *= ItemCatalyst.getPowerMod(this.slots[i2]);
                        heatMod *= ItemCatalyst.getHeatMod(this.slots[i2]);
                        fuelMod *= ItemCatalyst.getFuelMod(this.slots[i2]);
                    }
                    powerBase = ItemAMSCore.getPowerBase(this.slots[12]);
                    heatBase = ItemAMSCore.getHeatBase(this.slots[12]);
                    fuelBase = ItemAMSCore.getFuelBase(this.slots[12]);
                    powerBase *= (long)this.efficiency;
                    powerBase = (long)((double)powerBase * Math.pow(1.25, booster));
                    heatBase = (int)((double)heatBase * Math.pow(1.25, booster));
                    heatBase *= 100 - this.field;
                    if (this.getFuelPower(this.tanks[2].getTankType()) > 0 && this.getFuelPower(this.tanks[3].getTankType()) > 0 && this.tanks[2].getFill() > 0 && this.tanks[3].getFill() > 0) {
                        this.power = (long)((float)this.power + (float)powerBase * powerMod * this.gauss(1.0f, (this.heat - 2500) / 5000) / 1000.0f * (float)this.getFuelPower(this.tanks[2].getTankType()) * (float)this.getFuelPower(this.tanks[3].getTankType()));
                        this.heat = (int)((float)this.heat + (float)heatBase * heatMod / ((float)this.field / 100.0f));
                        this.tanks[2].setFill((int)((float)this.tanks[2].getFill() - (float)fuelBase * fuelMod));
                        this.tanks[3].setFill((int)((float)this.tanks[3].getFill() - (float)fuelBase * fuelMod));
                        if (this.tanks[2].getFill() <= 0) {
                            this.tanks[2].setFill(0);
                        }
                        if (this.tanks[3].getFill() <= 0) {
                            this.tanks[3].setFill(0);
                        }
                        this.radiation();
                        if (this.heat > 5000) {
                            this.explode();
                            this.heat = 5000;
                        }
                        if (this.field <= 0) {
                            this.explode();
                        }
                    }
                }
                if (this.power > 1000000000000000L) {
                    this.power = 1000000000000000L;
                }
                if (this.heat > 0 && this.tanks[0].getFill() > 0 && this.tanks[1].getFill() > 0) {
                    this.heat -= this.getCoolingStrength(this.tanks[0].getTankType()) * this.getCoolingStrength(this.tanks[1].getTankType());
                    this.tanks[0].setFill(this.tanks[0].getFill() - 10);
                    this.tanks[1].setFill(this.tanks[1].getFill() - 10);
                    if (this.tanks[0].getFill() < 0) {
                        this.tanks[0].setFill(0);
                    }
                    if (this.tanks[1].getFill() < 0) {
                        this.tanks[1].setFill(0);
                    }
                    if (this.heat < 0) {
                        this.heat = 0;
                    }
                }
            } else {
                this.field = 0;
                this.efficiency = 0;
                this.power = 0L;
                this.warning = 3;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.locked ? 1 : 0, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.color, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.efficiency, 2), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field, 3), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
        }
    }

    private void radiation() {
        double minSize;
        double maxSize = 5.0;
        double scale = minSize = 0.5;
        scale += ((double)this.tanks[2].getFill() / (double)this.tanks[2].getMaxFill() + (double)this.tanks[3].getFill() / (double)this.tanks[3].getMaxFill()) * ((maxSize - minSize) / 2.0);
        scale *= 0.6;
        List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)(this.field_145851_c - 10) + 0.5), (double)((double)(this.field_145848_d - 10) + 0.5 + 6.0), (double)((double)(this.field_145849_e - 10) + 0.5), (double)((double)(this.field_145851_c + 10) + 0.5), (double)((double)(this.field_145848_d + 10) + 0.5 + 6.0), (double)((double)(this.field_145849_e + 10) + 0.5)));
        for (Entity e : list) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHazmat((EntityPlayer)e) || Library.isObstructed(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5 + 6.0, (double)this.field_145849_e + 0.5, e.field_70165_t, e.field_70163_u + (double)e.func_70047_e(), e.field_70161_v)) continue;
            e.func_70097_a(ModDamageSource.ams, 1000.0f);
            e.func_70015_d(3);
        }
        List list2 = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - scale + 0.5), (double)((double)this.field_145848_d - scale + 0.5 + 6.0), (double)((double)this.field_145849_e - scale + 0.5), (double)((double)this.field_145851_c + scale + 0.5), (double)((double)this.field_145848_d + scale + 0.5 + 6.0), (double)((double)this.field_145849_e + scale + 0.5)));
        for (Entity e : list2) {
            if (e instanceof EntityPlayer && ArmorUtil.checkForHaz2((EntityPlayer)e)) continue;
            e.func_70097_a(ModDamageSource.amsCore, 10000.0f);
        }
    }

    private void explode() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                EntityCloudFleijaRainbow cloud = new EntityCloudFleijaRainbow(this.field_145850_b, 100);
                cloud.field_70165_t = this.field_145851_c + this.rand.nextInt(201) - 100;
                cloud.field_70163_u = this.field_145848_d + this.rand.nextInt(201) - 100;
                cloud.field_70161_v = this.field_145849_e + this.rand.nextInt(201) - 100;
                this.field_145850_b.func_72838_d((Entity)cloud);
            }
            int radius = (int)(50.0 + (double)(this.tanks[2].getFill() + this.tanks[3].getFill()) / 16000.0 * 150.0);
            this.field_145850_b.func_72838_d((Entity)EntityNukeExplosionMK4.statFacExperimental(this.field_145850_b, radius, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private int getCoolingStrength(FluidTypeHandler.FluidType type) {
        switch (type) {
            case WATER: {
                return 5;
            }
            case OIL: {
                return 15;
            }
            case COOLANT: {
                return this.heat / 250;
            }
            case CRYOGEL: {
                return this.heat > this.heat / 2 ? 25 : 5;
            }
        }
        return 0;
    }

    private int getFuelPower(FluidTypeHandler.FluidType type) {
        switch (type) {
            case DEUTERIUM: {
                return 50;
            }
            case TRITIUM: {
                return 75;
            }
        }
        return 0;
    }

    private float gauss(float a, float x) {
        double amplifier = 0.1;
        return (float)(1.0 / Math.sqrt((double)a * Math.PI) * Math.pow(Math.E, -1.0 * Math.pow(x, 2.0) / amplifier));
    }

    private float calcEffect(float a, float x) {
        return (float)((double)this.gauss(1.0f / a, x / 5000.0f) * Math.sqrt(Math.PI * 2) / (Math.sqrt(2.0) * Math.sqrt(1.0E15)));
    }

    private float calcField(int a, int b, int c, int d) {
        return (float)(a + b + c + d) * (float)(a * 25 + b * 25 + c * 25 + d * 25) / 40000.0f;
    }

    private int calcAvgHex(int h1, int h2) {
        int r1 = (h1 & 0xFF0000) >> 16;
        int g1 = (h1 & 0xFF00) >> 8;
        int b1 = (h1 & 0xFF) >> 0;
        int r2 = (h2 & 0xFF0000) >> 16;
        int g2 = (h2 & 0xFF00) >> 8;
        int b2 = (h2 & 0xFF) >> 0;
        int r = (r1 + r2) / 2 << 16;
        int g = (g1 + g2) / 2 << 8;
        int b = (b1 + b2) / 2 << 0;
        return r | g | b;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000000000000L;
    }

    public int getEfficiencyScaled(int i) {
        return this.efficiency * i / 100;
    }

    public int getFieldScaled(int i) {
        return this.field * i / 100;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    public boolean hasResonators() {
        if (this.slots[13] != null && this.slots[14] != null && this.slots[15] != null && this.slots[13].func_77973_b() == ModItems.sat_chip && this.slots[14].func_77973_b() == ModItems.sat_chip && this.slots[15].func_77973_b() == ModItems.sat_chip) {
            SatelliteSavedData data = (SatelliteSavedData)this.field_145850_b.perWorldStorage.func_75742_a(SatelliteSavedData.class, "satellites");
            if (data == null) {
                this.field_145850_b.perWorldStorage.func_75745_a("satellites", (WorldSavedData)new SatelliteSavedData());
                data = (SatelliteSavedData)this.field_145850_b.perWorldStorage.func_75742_a(SatelliteSavedData.class, "satellites");
            }
            data.func_76185_a();
            int i1 = ItemSatChip.getFreq(this.slots[13]);
            int i2 = ItemSatChip.getFreq(this.slots[14]);
            int i3 = ItemSatChip.getFreq(this.slots[15]);
            if (data.getSatFromFreq(i1) != null && data.getSatFromFreq(i2) != null && data.getSatFromFreq(i3) != null && data.getSatFromFreq(i1) instanceof SatelliteResonator && data.getSatFromFreq(i2) instanceof SatelliteResonator && data.getSatFromFreq(i3) instanceof SatelliteResonator && i1 != i2 && i1 != i3 && i2 != i3) {
                return true;
            }
        }
        return true;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getMaxFill();
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            return this.tanks[3].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.tanks[2].setFill(i);
        } else if (type.name().equals(this.tanks[3].getTankType().name())) {
            this.tanks[3].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getFill();
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            return this.tanks[3].getFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 4 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 4 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.tanks[2]);
        list.add(this.tanks[3]);
        return list;
    }
}

