/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.conductor;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRFDuct
extends TileEntity
implements IEnergyHandler {
    public ForgeDirection[] connections = new ForgeDirection[6];
    protected EnergyStorage storage;
    public int output;

    public TileEntityRFDuct(int output) {
        this.output = output;
        this.storage = new EnergyStorage(200);
        this.storage.setMaxReceive(output);
        this.storage.setMaxExtract(output);
        this.storage.setMaxTransfer(output);
    }

    public void func_145845_h() {
        this.updateConnections();
        if (this.storage.getEnergyStored() > 0) {
            for (int i = 0; i < 6; ++i) {
                int targetX = this.field_145851_c + ForgeDirection.getOrientation((int)i).offsetX;
                int targetY = this.field_145848_d + ForgeDirection.getOrientation((int)i).offsetY;
                int targetZ = this.field_145849_e + ForgeDirection.getOrientation((int)i).offsetZ;
                TileEntity tile = this.field_145850_b.func_147438_o(targetX, targetY, targetZ);
                if (!(tile instanceof IEnergyReceiver)) continue;
                int maxExtract = this.storage.getMaxExtract();
                int maxAvailable = this.storage.extractEnergy(maxExtract, true);
                int energyTransferred = ((IEnergyReceiver)tile).receiveEnergy(ForgeDirection.getOrientation((int)i).getOpposite(), maxAvailable, false);
                this.storage.extractEnergy(energyTransferred, false);
            }
        }
    }

    public void updateConnections() {
        this.connections[0] = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) instanceof IEnergyConnection ? ForgeDirection.UP : null;
        this.connections[1] = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof IEnergyConnection ? ForgeDirection.DOWN : null;
        this.connections[2] = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) instanceof IEnergyConnection ? ForgeDirection.NORTH : null;
        this.connections[3] = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) instanceof IEnergyConnection ? ForgeDirection.SOUTH : null;
        this.connections[4] = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) instanceof IEnergyConnection ? ForgeDirection.EAST : null;
        this.connections[5] = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) instanceof IEnergyConnection ? ForgeDirection.WEST : null;
    }

    public boolean onlyOneOpposite(ForgeDirection[] directions) {
        ForgeDirection mainDirection = null;
        boolean isOpposite = false;
        for (int i = 0; i < directions.length; ++i) {
            if (mainDirection == null && directions[i] != null) {
                mainDirection = directions[i];
            }
            if (directions[i] == null || mainDirection == directions[i]) continue;
            if (!this.isOpposite(mainDirection, directions[i])) {
                return false;
            }
            isOpposite = true;
        }
        return isOpposite;
    }

    public boolean isOpposite(ForgeDirection firstDirection, ForgeDirection secondDirection) {
        if (firstDirection.equals((Object)ForgeDirection.NORTH) && secondDirection.equals((Object)ForgeDirection.SOUTH) || firstDirection.equals((Object)ForgeDirection.SOUTH) && secondDirection.equals((Object)ForgeDirection.NORTH)) {
            return true;
        }
        if (firstDirection.equals((Object)ForgeDirection.EAST) && secondDirection.equals((Object)ForgeDirection.WEST) || firstDirection.equals((Object)ForgeDirection.WEST) && secondDirection.equals((Object)ForgeDirection.EAST)) {
            return true;
        }
        return firstDirection.equals((Object)ForgeDirection.UP) && secondDirection.equals((Object)ForgeDirection.DOWN) || firstDirection.equals((Object)ForgeDirection.DOWN) && secondDirection.equals((Object)ForgeDirection.UP);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(Math.min(this.output, maxReceive), simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(this.storage.getMaxExtract(), simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }
}

