/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energy.IBatteryItem;
import com.hbm.entity.effect.EntityNukeCloudSmall;
import com.hbm.entity.logic.EntityBalefire;
import com.hbm.items.ModItems;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityNukeBalefire
extends TileEntityMachineBase {
    public boolean loaded;
    public boolean started;
    public int timer = 18000;

    public TileEntityNukeBalefire() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.nukeFstbmb";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isLoaded()) {
                this.started = false;
            }
            if (this.started) {
                --this.timer;
                if (this.timer % 20 == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.fstbmbPing", 5.0f, 1.0f);
                }
            }
            if (this.timer <= 0) {
                this.explode();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("timer", this.timer);
            data.func_74757_a("loaded", this.isLoaded());
            data.func_74757_a("started", this.started);
            this.networkPack(data, 250);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.timer = data.func_74762_e("timer");
        this.started = data.func_74767_n("started");
        this.loaded = data.func_74767_n("loaded");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0 && this.isLoaded()) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.fstbmbStart", 5.0f, 1.0f);
            this.started = true;
        }
        if (meta == 1) {
            this.timer = value * 20;
        }
    }

    public boolean isLoaded() {
        return this.hasEgg() && this.hasBattery();
    }

    public boolean hasEgg() {
        return this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.egg_balefire;
    }

    public boolean hasBattery() {
        return this.getBattery() > 0;
    }

    public int getBattery() {
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.battery_spark && ((IBatteryItem)ModItems.battery_spark).getCharge(this.slots[1]) == ((IBatteryItem)ModItems.battery_spark).getMaxCharge()) {
            return 1;
        }
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.battery_trixite && ((IBatteryItem)ModItems.battery_trixite).getCharge(this.slots[1]) == ((IBatteryItem)ModItems.battery_trixite).getMaxCharge()) {
            return 2;
        }
        return 0;
    }

    public void explode() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        EntityBalefire bf = new EntityBalefire(this.field_145850_b);
        bf.field_70165_t = (double)this.field_145851_c + 0.5;
        bf.field_70163_u = (double)this.field_145848_d + 0.5;
        bf.field_70161_v = (double)this.field_145849_e + 0.5;
        bf.destructionRange = 250;
        this.field_145850_b.func_72838_d((Entity)bf);
        this.field_145850_b.func_72838_d((Entity)EntityNukeCloudSmall.statFacBale(this.field_145850_b, (double)this.field_145851_c + 0.5, this.field_145848_d + 5, (double)this.field_145849_e + 0.5, 375.0f, 1000));
    }

    public String getMinutes() {
        String mins = "" + this.timer / 1200;
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        return mins;
    }

    public String getSeconds() {
        String mins = "" + this.timer / 20 % 60;
        if (mins.length() == 1) {
            mins = "0" + mins;
        }
        return mins;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.started = nbt.func_74767_n("started");
        this.timer = nbt.func_74762_e("timer");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("started", this.started);
        nbt.func_74768_a("timer", this.timer);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

