/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.handler.MissileStruct;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomMissile;
import com.hbm.items.weapon.ItemMissile;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEMissileMultipartPacket;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityLaunchTable
extends TileEntity
implements ISidedInventory,
IConsumer,
IFluidContainer,
IFluidAcceptor {
    private ItemStack[] slots = new ItemStack[8];
    public long power;
    public static final long maxPower = 100000L;
    public int solid;
    public static final int maxSolid = 100000;
    public FluidTank[] tanks = new FluidTank[2];
    public ItemMissile.PartSize padSize;
    public int height;
    public MissileStruct load;
    private static final int[] access = new int[]{0};
    private String customName;

    public TileEntityLaunchTable() {
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.NONE, 100000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.NONE, 100000, 1);
        this.padSize = ItemMissile.PartSize.SIZE_10;
        this.height = 10;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.launchTable";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getSolidScaled(int i) {
        return this.solid * i / 100000;
    }

    public void func_145845_h() {
        block7: {
            block8: {
                if (this.field_145850_b.field_72995_K) break block8;
                this.updateTypes();
                this.tanks[0].loadTank(2, 6, this.slots);
                this.tanks[1].loadTank(3, 7, this.slots);
                for (int i = 0; i < 2; ++i) {
                    this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
                }
                this.power = Library.chargeTEFromItems(this.slots, 5, this.power, 100000L);
                if (this.slots[4] != null && this.slots[4].func_77973_b() == ModItems.rocket_fuel && this.solid + 250 <= 100000) {
                    this.func_70298_a(4, 1);
                    this.solid += 250;
                }
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.solid, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.padSize.ordinal(), 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
                MissileStruct multipart = TileEntityLaunchTable.getStruct(this.slots[0]);
                if (multipart != null) {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEMissileMultipartPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, multipart), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
                } else {
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEMissileMultipartPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, new MissileStruct()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 250.0));
                }
                for (int x = -4; x <= 4; ++x) {
                    for (int z = -4; z <= 4; ++z) {
                        if (!this.field_145850_b.func_72864_z(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) || !this.canLaunch()) continue;
                        this.launch();
                        break block7;
                    }
                }
                break block7;
            }
            List entities = this.field_145850_b.func_72872_a(EntityMissileCustom.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 10), (double)((double)this.field_145849_e + 1.5)));
            if (entities.isEmpty()) break block7;
            for (int i = 0; i < 15; ++i) {
                boolean dir = this.field_145850_b.field_73012_v.nextBoolean();
                float moX = (float)(dir ? 0.0 : this.field_145850_b.field_73012_v.nextGaussian() * (double)0.65f);
                float moZ = (float)(!dir ? 0.0 : this.field_145850_b.field_73012_v.nextGaussian() * (double)0.65f);
                MainRegistry.proxy.spawnParticle((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.25, (double)this.field_145849_e + 0.5, "launchsmoke", new float[]{moX, 0.0f, moZ});
            }
        }
    }

    public boolean canLaunch() {
        return (double)this.power >= 75000.0 && this.isMissileValid() && this.hasDesignator() && this.hasFuel();
    }

    public void launch() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.missileTakeOff", 10.0f, 1.0f);
        int tX = this.slots[1].field_77990_d.func_74762_e("xCoord");
        int tZ = this.slots[1].field_77990_d.func_74762_e("zCoord");
        EntityMissileCustom missile = new EntityMissileCustom(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 2.5f, (float)this.field_145849_e + 0.5f, tX, tZ, TileEntityLaunchTable.getStruct(this.slots[0]));
        this.field_145850_b.func_72838_d((Entity)missile);
        this.subtractFuel();
        this.slots[0] = null;
    }

    private boolean hasFuel() {
        return this.solidState() != 0 && this.liquidState() != 0 && this.oxidizerState() != 0;
    }

    private void subtractFuel() {
        MissileStruct multipart = TileEntityLaunchTable.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return;
        }
        ItemMissile fuselage = multipart.fuselage;
        float f = ((Float)fuselage.attributes[1]).floatValue();
        int fuel = (int)f;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                this.tanks[1].setFill(this.tanks[1].getFill() - fuel);
                break;
            }
            case HYDROGEN: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                this.tanks[1].setFill(this.tanks[1].getFill() - fuel);
                break;
            }
            case XENON: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                break;
            }
            case BALEFIRE: {
                this.tanks[0].setFill(this.tanks[0].getFill() - fuel);
                this.tanks[1].setFill(this.tanks[1].getFill() - fuel);
                break;
            }
            case SOLID: {
                this.solid -= fuel;
                break;
            }
        }
        this.power = (long)((double)this.power - 75000.0);
    }

    public static MissileStruct getStruct(ItemStack stack) {
        return ItemCustomMissile.getStruct(stack);
    }

    public boolean isMissileValid() {
        MissileStruct multipart = TileEntityLaunchTable.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return false;
        }
        ItemMissile fuselage = multipart.fuselage;
        return fuselage.top == this.padSize;
    }

    public boolean hasDesignator() {
        if (this.slots[1] != null) {
            return (this.slots[1].func_77973_b() == ModItems.designator || this.slots[1].func_77973_b() == ModItems.designator_range || this.slots[1].func_77973_b() == ModItems.designator_manual) && this.slots[1].func_77942_o();
        }
        return false;
    }

    public int solidState() {
        MissileStruct multipart = TileEntityLaunchTable.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemMissile fuselage = multipart.fuselage;
        if ((ItemMissile.FuelType)((Object)fuselage.attributes[0]) == ItemMissile.FuelType.SOLID) {
            if ((float)this.solid >= ((Float)fuselage.attributes[1]).floatValue()) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int liquidState() {
        MissileStruct multipart = TileEntityLaunchTable.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemMissile fuselage = multipart.fuselage;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: 
            case HYDROGEN: 
            case XENON: 
            case BALEFIRE: {
                if ((float)this.tanks[0].getFill() >= ((Float)fuselage.attributes[1]).floatValue()) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public int oxidizerState() {
        MissileStruct multipart = TileEntityLaunchTable.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return -1;
        }
        ItemMissile fuselage = multipart.fuselage;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: 
            case HYDROGEN: 
            case BALEFIRE: {
                if ((float)this.tanks[1].getFill() >= ((Float)fuselage.attributes[1]).floatValue()) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    public void updateTypes() {
        MissileStruct multipart = TileEntityLaunchTable.getStruct(this.slots[0]);
        if (multipart == null || multipart.fuselage == null) {
            return;
        }
        ItemMissile fuselage = multipart.fuselage;
        switch ((ItemMissile.FuelType)((Object)fuselage.attributes[0])) {
            case KEROSENE: {
                this.tanks[0].setTankType(FluidTypeHandler.FluidType.KEROSENE);
                this.tanks[1].setTankType(FluidTypeHandler.FluidType.ACID);
                break;
            }
            case HYDROGEN: {
                this.tanks[0].setTankType(FluidTypeHandler.FluidType.HYDROGEN);
                this.tanks[1].setTankType(FluidTypeHandler.FluidType.OXYGEN);
                break;
            }
            case XENON: {
                this.tanks[0].setTankType(FluidTypeHandler.FluidType.XENON);
                break;
            }
            case BALEFIRE: {
                this.tanks[0].setTankType(FluidTypeHandler.FluidType.BALEFIRE);
                this.tanks[1].setTankType(FluidTypeHandler.FluidType.ACID);
                break;
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.tanks[0].readFromNBT(nbt, "fuel");
        this.tanks[1].readFromNBT(nbt, "oxidizer");
        this.solid = nbt.func_74762_e("solidfuel");
        this.power = nbt.func_74763_f("power");
        this.padSize = ItemMissile.PartSize.values()[nbt.func_74762_e("padSize")];
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "fuel");
        this.tanks[1].writeToNBT(nbt, "oxidizer");
        nbt.func_74768_a("solidfuel", this.solid);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("padSize", this.padSize.ordinal());
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return access;
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(fill);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }
}

