/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata.satellites;

import com.hbm.items.ModItems;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.SatelliteHorizons;
import com.hbm.saveddata.satellites.SatelliteLaser;
import com.hbm.saveddata.satellites.SatelliteMapper;
import com.hbm.saveddata.satellites.SatelliteMiner;
import com.hbm.saveddata.satellites.SatelliteRadar;
import com.hbm.saveddata.satellites.SatelliteRelay;
import com.hbm.saveddata.satellites.SatelliteResonator;
import com.hbm.saveddata.satellites.SatelliteScanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Satellite {
    public static List<Class> satellites = new ArrayList<Class>();
    public static HashMap<Item, Class> itemToClass = new HashMap();
    public List<InterfaceActions> ifaceAcs = new ArrayList<InterfaceActions>();
    public List<CoordActions> coordAcs = new ArrayList<CoordActions>();
    public Interfaces satIface = Interfaces.NONE;

    public static void register() {
        Satellite.registerSatellite(SatelliteMapper.class, ModItems.sat_mapper);
        Satellite.registerSatellite(SatelliteScanner.class, ModItems.sat_scanner);
        Satellite.registerSatellite(SatelliteRadar.class, ModItems.sat_radar);
        Satellite.registerSatellite(SatelliteLaser.class, ModItems.sat_laser);
        Satellite.registerSatellite(SatelliteResonator.class, ModItems.sat_resonator);
        Satellite.registerSatellite(SatelliteRelay.class, ModItems.sat_foeq);
        Satellite.registerSatellite(SatelliteMiner.class, ModItems.sat_miner);
        Satellite.registerSatellite(SatelliteHorizons.class, ModItems.sat_gerald);
    }

    private static void registerSatellite(Class<? extends Satellite> sat, Item item) {
        satellites.add(sat);
        itemToClass.put(item, sat);
    }

    public static void orbit(World world, int id, int freq, double x, double y, double z) {
        Satellite sat = Satellite.create(id);
        if (sat != null && !world.field_72995_K) {
            SatelliteSavedData data = SatelliteSavedData.getData(world);
            data.sats.put(freq, sat);
            sat.onOrbit(world, x, y, z);
            data.func_76185_a();
        }
    }

    public static Satellite create(int id) {
        Satellite sat = null;
        try {
            Class c = satellites.get(id);
            sat = (Satellite)c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sat;
    }

    public static int getIDFromItem(Item item) {
        Class sat = itemToClass.get(item);
        int i = satellites.indexOf(sat);
        return i;
    }

    public int getID() {
        return satellites.indexOf(this.getClass());
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public void onOrbit(World world, double x, double y, double z) {
    }

    public void onClick(World world, int x, int z) {
    }

    public void onCoordAction(World world, EntityPlayer player, int x, int y, int z) {
    }

    public static enum Interfaces {
        NONE,
        SAT_PANEL,
        SAT_COORD;

    }

    public static enum CoordActions {
        HAS_Y;

    }

    public static enum InterfaceActions {
        HAS_MAP,
        CAN_CLICK,
        SHOW_COORDS,
        HAS_RADAR,
        HAS_ORES;

    }
}

