/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.saveddata;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.radiation.ChunkRadiationManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class RadiationSavedData
extends WorldSavedData {
    public HashMap<ChunkCoordIntPair, Float> contamination = new HashMap();
    private static RadiationSavedData openInstance;
    public World worldObj;

    public RadiationSavedData(String p_i2141_1_) {
        super(p_i2141_1_);
    }

    public RadiationSavedData(World p_i1678_1_) {
        super("radiation");
        this.worldObj = p_i1678_1_;
        this.func_76185_a();
    }

    public void jettisonData() {
        this.contamination.clear();
        this.func_76185_a();
    }

    public void setRadForCoord(int x, int y, float radiation) {
        ChunkRadiationManager.proxy.setRadiation(this.worldObj, x, 0, y, radiation);
    }

    public float getRadNumFromCoord(int x, int y) {
        return ChunkRadiationManager.proxy.getRadiation(this.worldObj, (x << 4) + 8, 0, (y << 4) + 8);
    }

    public void updateSystem() {
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (!GeneralConfig.enableRads) {
            return;
        }
        int count = nbt.func_74762_e("radCount");
        for (int i = 0; i < count; ++i) {
            ChunkCoordIntPair pair = new ChunkCoordIntPair(nbt.func_74762_e("cposX" + i), nbt.func_74762_e("cposZ" + i));
            this.contamination.put(pair, Float.valueOf(nbt.func_74760_g("crad" + i)));
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74768_a("radCount", this.contamination.size());
        int i = 0;
        for (Map.Entry<ChunkCoordIntPair, Float> struct : this.contamination.entrySet()) {
            nbt.func_74768_a("cposX" + i, struct.getKey().field_77276_a);
            nbt.func_74768_a("cposZ" + i, struct.getKey().field_77275_b);
            nbt.func_74776_a("crad" + i, struct.getValue().floatValue());
            ++i;
        }
    }

    public static RadiationSavedData getData(World worldObj) {
        if (openInstance != null && RadiationSavedData.openInstance.worldObj == worldObj) {
            return openInstance;
        }
        RadiationSavedData data = (RadiationSavedData)worldObj.perWorldStorage.func_75742_a(RadiationSavedData.class, "radiation");
        if (data == null) {
            worldObj.perWorldStorage.func_75745_a("radiation", (WorldSavedData)new RadiationSavedData(worldObj));
            data = (RadiationSavedData)worldObj.perWorldStorage.func_75742_a(RadiationSavedData.class, "radiation");
        }
        data.worldObj = worldObj;
        openInstance = data;
        return openInstance;
    }

    public static void incrementRad(World worldObj, int x, int z, float rad, float maxRad) {
        ChunkRadiationManager.proxy.incrementRad(worldObj, x, 0, z, rad);
    }

    public static void decrementRad(World worldObj, int x, int z, float rad) {
        ChunkRadiationManager.proxy.decrementRad(worldObj, x, 0, z, rad);
    }
}

