/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderScreenOverlay {
    private static final ResourceLocation misc = new ResourceLocation("hbm:textures/misc/overlay_misc.png");
    private static final RenderItem itemRenderer = RenderItem.getInstance();
    private static long lastSurvey;
    private static float prevResult;
    private static float lastResult;

    public static void renderRadCounter(ScaledResolution resolution, float in, Gui gui) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        float radiation = 0.0f;
        radiation = lastResult - prevResult;
        if (System.currentTimeMillis() >= lastSurvey + 1000L) {
            lastSurvey = System.currentTimeMillis();
            prevResult = lastResult;
            lastResult = in;
        }
        int length = 74;
        int maxRad = 1000;
        int bar = RenderScreenOverlay.getScaled(in, maxRad, 74.0);
        int posX = 16;
        int posY = resolution.func_78328_b() - 18 - 2;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(posX, posY, 0, 0, 94, 18);
        gui.func_73729_b(posX + 1, posY + 1, 1, 19, bar, 16);
        if (radiation >= 25.0f) {
            gui.func_73729_b(posX + length + 2, posY - 18, 36, 36, 18, 18);
        } else if (radiation >= 10.0f) {
            gui.func_73729_b(posX + length + 2, posY - 18, 18, 36, 18, 18);
        } else if ((double)radiation >= 2.5) {
            gui.func_73729_b(posX + length + 2, posY - 18, 0, 36, 18, 18);
        }
        if (radiation > 1000.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(">1000 RAD/s", posX, posY - 8, 0xFF0000);
        } else if (radiation >= 1.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(Math.round(radiation) + " RAD/s", posX, posY - 8, 0xFF0000);
        } else if (radiation > 0.0f) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b("<1 RAD/s", posX, posY - 8, 0xFF0000);
        }
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    private static int getScaled(double cur, double max, double scale) {
        return (int)Math.min(cur / max * scale, scale);
    }

    public static void renderCustomCrosshairs(ScaledResolution resolution, Gui gui, Crosshair cross) {
        if (cross == Crosshair.NONE) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
            return;
        }
        int size = cross.size;
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)775, (int)769, (int)1, (int)0);
        gui.func_73729_b(resolution.func_78326_a() / 2 - size / 2, resolution.func_78328_b() / 2 - size / 2, cross.x, cross.y, size, size);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderAmmo(ScaledResolution resolution, Gui gui, Item ammo, int count, int max, int dura, boolean renderCount) {
        String cap;
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        int pX = resolution.func_78326_a() / 2 + 62 + 36;
        int pZ = resolution.func_78328_b() - 21;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        gui.func_73729_b(pX, pZ + 16, 94, 0, 52, 3);
        gui.func_73729_b(pX + 1, pZ + 16, 95, 3, 50 - dura, 3);
        String string = cap = max == -1 ? "\u221e" : "" + max;
        if (renderCount) {
            Minecraft.func_71410_x().field_71466_p.func_78276_b(count + " / " + cap, pX + 16, pZ + 6, 0xFFFFFF);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        itemRenderer.func_82406_b(mc.field_71466_p, mc.func_110434_K(), new ItemStack(ammo), pX, pZ);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static void renderAmmoAlt(ScaledResolution resolution, Gui gui, Item ammo, int count) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        int pX = resolution.func_78326_a() / 2 + 62 + 36 + 18;
        int pZ = resolution.func_78328_b() - 21 - 16;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(misc);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(count + "x", pX + 16, pZ + 6, 0xFFFFFF);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        itemRenderer.func_82406_b(mc.field_71466_p, mc.func_110434_K(), new ItemStack(ammo), pX, pZ);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    public static enum Crosshair {
        NONE(0, 0, 0),
        CROSS(1, 55, 16),
        CIRCLE(19, 55, 16),
        SEMI(37, 55, 16),
        KRUCK(55, 55, 16),
        DUAL(1, 73, 16),
        SPLIT(19, 73, 16),
        CLASSIC(37, 73, 16),
        BOX(55, 73, 16),
        L_CROSS(0, 90, 32),
        L_KRUCK(32, 90, 32),
        L_CLASSIC(64, 90, 32),
        L_CIRCLE(96, 90, 32),
        L_SPLIT(0, 122, 32),
        L_ARROWS(32, 122, 32),
        L_BOX(64, 122, 32),
        L_CIRCUMFLEX(96, 122, 32),
        L_RAD(0, 154, 32);

        public int x;
        public int y;
        public int size;

        private Crosshair(int x, int y, int size) {
            this.x = x;
            this.y = y;
            this.size = size;
        }
    }
}

