/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.main.ResourceManager;
import com.hbm.render.util.RenderSparks;
import com.hbm.tileentity.machine.TileEntityCore;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderCore
extends TileEntitySpecialRenderer {
    private static final ResourceLocation sky = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation portal = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random random = new Random(31100L);
    FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        TileEntityCore core = (TileEntityCore)tileEntity;
        if (core.heat == 0) {
            this.renderStandby(x, y, z);
        } else {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(RenderManager.field_78727_a.field_78732_j - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            this.renderOrb(core, 0.0, 0.0, 0.0);
            GL11.glPopMatrix();
        }
    }

    public void renderStandby(double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
        ResourceManager.sphere_uv.renderAll();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
        GL11.glColor3f((float)0.1f, (float)0.1f, (float)0.1f);
        ResourceManager.sphere_uv.renderAll();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        if (System.currentTimeMillis() / 100L % 10L == 0L) {
            for (int i = 0; i < 3; ++i) {
                RenderSparks.renderSpark((int)System.currentTimeMillis() / 100 + i * 10000, 0.0, 0.0, 0.0, 1.5f, 5, 10, 0xFFFF00, 0xFFFFFF);
                RenderSparks.renderSpark((int)System.currentTimeMillis() / 50 + i * 10000, 0.0, 0.0, 0.0, 1.5f, 5, 10, 0xFFFF00, 0xFFFFFF);
            }
        }
        GL11.glPopMatrix();
    }

    public void renderOrb(TileEntityCore tile, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        int color = tile.color;
        GL11.glColor3ub((byte)((byte)((color & 0xFF0000) >> 16)), (byte)((byte)((color & 0xFF00) >> 8)), (byte)((byte)((color & 0xFF) >> 0)));
        int tot = tile.tanks[0].getMaxFill() + tile.tanks[1].getMaxFill();
        int fill = tile.tanks[0].getFill() + tile.tanks[1].getFill();
        float scale = 4.5f * (float)fill / (float)tot + 0.5f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        ResourceManager.sphere_ruv.renderAll();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        for (int i = 6; i <= 10; ++i) {
            GL11.glPushMatrix();
            GL11.glScalef((float)((float)i * 0.1f), (float)((float)i * 0.1f), (float)((float)i * 0.1f));
            ResourceManager.sphere_ruv.renderAll();
            GL11.glPopMatrix();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glPopMatrix();
    }

    public void renderVoid(TileEntity tile, double x, double y, double z) {
        TileEntityCore core = (TileEntityCore)tile;
        World world = tile.func_145831_w();
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        random.setSeed(31110L);
        GL11.glDisable((int)2896);
        GL11.glTexGeni((int)8192, (int)9472, (int)9216);
        GL11.glTexGeni((int)8193, (int)9472, (int)9216);
        GL11.glTexGeni((int)8194, (int)9472, (int)9216);
        GL11.glTexGeni((int)8195, (int)9472, (int)9216);
        GL11.glEnable((int)3168);
        GL11.glEnable((int)3169);
        GL11.glEnable((int)3170);
        GL11.glEnable((int)3171);
        GL11.glMatrixMode((int)5890);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        float f100 = (float)(world.func_82737_E() % 500L) / 500.0f;
        GL11.glTranslatef((float)random.nextFloat(), (float)f100, (float)random.nextFloat());
        Tessellator tessellator = Tessellator.field_78398_a;
        int end = 10;
        for (int i = 0; i < 10; ++i) {
            float f5 = 10 - i;
            float f7 = 1.0f / (f5 + 1.0f);
            if (i == 0) {
                this.func_147499_a(sky);
                f7 = 0.0f;
                f5 = 65.0f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(portal);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
            }
            GL11.glTranslatef((float)(random.nextFloat() * (1.0f - f7)), (float)(random.nextFloat() * (1.0f - f7)), (float)(random.nextFloat() * (1.0f - f7)));
            float scale = 0.8f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            float ang = 36.0f;
            GL11.glRotatef((float)(ang * (float)i + ang * random.nextFloat()), (float)0.0f, (float)0.0f, (float)1.0f);
            float f11 = (float)random.nextDouble() * 0.5f + 0.4f;
            float f12 = (float)random.nextDouble() * 0.5f + 0.4f;
            float f13 = (float)random.nextDouble() * 0.5f + 2.0f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            f13 *= f7;
            f12 *= f7;
            f11 *= f7;
            GL11.glTexGen((int)8192, (int)9474, (FloatBuffer)this.func_147525_a(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8193, (int)9474, (FloatBuffer)this.func_147525_a(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9474, (FloatBuffer)this.func_147525_a(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.func_147525_a(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            int tot = core.tanks[0].getMaxFill() + core.tanks[1].getMaxFill();
            int fill = core.tanks[0].getFill() + core.tanks[1].getFill();
            float s = 2.25f * (float)fill / (float)tot + 0.5f;
            int count = 32;
            for (int j = 0; j < count; ++j) {
                Vec3 vec = Vec3.func_72443_a((double)s, (double)0.0, (double)0.0);
                tessellator.func_78371_b(4);
                tessellator.func_78386_a(f11, f12, f13);
                tessellator.func_78380_c(0xF000F0);
                vec.func_72442_b((float)Math.PI * 2 / (float)count * (float)j - 0.0025f);
                tessellator.func_78377_a(x + 0.5 + vec.field_72450_a, y + 1.0, z + 0.5 + vec.field_72449_c);
                vec.func_72442_b((float)Math.PI * 2 / (float)count + 0.005f);
                tessellator.func_78377_a(x + 0.5 + vec.field_72450_a, y + 1.0, z + 0.5 + vec.field_72449_c);
                tessellator.func_78377_a(x + 0.5, y + 1.0, z + 0.5);
                tessellator.func_78381_a();
            }
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private FloatBuffer func_147525_a(float x, float y, float z, float w) {
        this.buffer.clear();
        this.buffer.put(x).put(y).put(z).put(w);
        this.buffer.flip();
        return this.buffer;
    }
}

