/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.loader;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class ModelRendererObj {
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    String[] parts;
    IModelCustom model;

    public ModelRendererObj(IModelCustom model, String ... parts) {
        this.model = model;
        this.parts = parts;
    }

    public ModelRendererObj setPosition(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    public ModelRendererObj setRotationPoint(float x, float y, float z) {
        this.rotationPointX = x;
        this.rotationPointY = y;
        this.rotationPointZ = z;
        return this;
    }

    public void copyTo(ModelRendererObj obj) {
        obj.offsetX = this.offsetX;
        obj.offsetY = this.offsetY;
        obj.offsetZ = this.offsetZ;
        obj.rotateAngleX = this.rotateAngleX;
        obj.rotateAngleY = this.rotateAngleY;
        obj.rotateAngleZ = this.rotateAngleZ;
        obj.rotationPointX = this.rotationPointX;
        obj.rotationPointY = this.rotationPointY;
        obj.rotationPointZ = this.rotationPointZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float scale) {
        if (this.parts == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.offsetX * scale), (float)(this.offsetY * scale), (float)(this.offsetZ * scale));
        GL11.glTranslatef((float)(this.rotationPointX * scale), (float)(this.rotationPointY * scale), (float)(this.rotationPointZ * scale));
        if (this.rotateAngleZ != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleZ * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (this.rotateAngleY != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleY * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.rotateAngleX != 0.0f) {
            GL11.glRotatef((float)(this.rotateAngleX * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)(-this.rotationPointX * scale), (float)(-this.rotationPointY * scale), (float)(-this.rotationPointZ * scale));
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        if (this.parts.length > 0) {
            for (String part : this.parts) {
                this.model.renderPart(part);
            }
        } else {
            this.model.renderAll();
        }
        GL11.glPopMatrix();
    }
}

