/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.modules;

import com.hbm.inventory.BreederRecipes;
import com.hbm.util.ArmorUtil;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;

public class ItemHazardModule {
    public float radiation;
    public float digamma;
    public int fire;
    public boolean blinding;
    public boolean asbestos;
    public boolean hydro;
    public float explosive;
    public float tempMod = 1.0f;

    public void setMod(float tempMod) {
        this.tempMod = tempMod;
    }

    public void addRadiation(float radiation) {
        this.radiation = radiation;
    }

    public void addDigamma(float digamma) {
        this.digamma = digamma;
    }

    public void addFire(int fire) {
        this.fire = fire;
    }

    public void addAsbestos() {
        this.asbestos = true;
    }

    public void addBlinding() {
        this.blinding = true;
    }

    public void addHydroReactivity() {
        this.hydro = true;
    }

    public void addExplosive(float bang) {
        this.explosive = bang;
    }

    public void applyEffects(EntityLivingBase entity, float mod, int slot, boolean currentItem) {
        ItemStack held;
        EntityPlayer player;
        if (this.radiation * this.tempMod > 0.0f) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, this.radiation * this.tempMod * mod / 20.0f);
        }
        if (this.digamma * this.tempMod > 0.0f) {
            ContaminationUtil.applyDigammaData((Entity)entity, this.digamma * this.tempMod * mod / 20.0f);
        }
        if (this.fire > 0) {
            entity.func_70015_d(this.fire);
        }
        if (this.asbestos) {
            ContaminationUtil.applyAsbestos((Entity)entity, (int)(1.0f * mod));
        }
        if (this.hydro && currentItem && !entity.field_70170_p.field_72995_K && entity.func_70090_H() && entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
            held = player.func_70694_bm();
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = held.func_77973_b().getContainerItem(held);
            player.field_71069_bz.func_75142_b();
            player.field_70170_p.func_72885_a(null, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - player.func_70033_W(), player.field_70161_v, 2.0f, true, true);
        }
        if (this.explosive > 0.0f && currentItem && !entity.field_70170_p.field_72995_K && entity.func_70027_ad() && entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
            held = player.func_70694_bm();
            player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = held.func_77973_b().getContainerItem(held);
            player.field_71069_bz.func_75142_b();
            player.field_70170_p.func_72885_a(null, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() - player.func_70033_W(), player.field_70161_v, this.explosive, true, true);
        }
        if (!(!this.blinding || entity instanceof EntityPlayer && ArmorUtil.checkForGoggles((EntityPlayer)entity))) {
            entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
        }
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        int[] breeder;
        if (this.radiation * this.tempMod > 0.0f) {
            list.add(EnumChatFormatting.GREEN + "[" + I18nUtil.resolveKey("trait.radioactive", new Object[0]) + "]");
            String rad = "" + Math.floor(this.radiation * this.tempMod * 1000.0f) / 1000.0;
            list.add(EnumChatFormatting.YELLOW + rad + "RAD/s");
        }
        if (this.fire > 0) {
            list.add(EnumChatFormatting.GOLD + "[" + I18nUtil.resolveKey("trait.hot", new Object[0]) + "]");
        }
        if (this.blinding) {
            list.add(EnumChatFormatting.DARK_AQUA + "[" + I18nUtil.resolveKey("trait.blinding", new Object[0]) + "]");
        }
        if (this.asbestos) {
            list.add(EnumChatFormatting.WHITE + "[" + I18nUtil.resolveKey("trait.asbestos", new Object[0]) + "]");
        }
        if (this.hydro) {
            list.add(EnumChatFormatting.RED + "[" + I18nUtil.resolveKey("trait.hydro", new Object[0]) + "]");
        }
        if (this.explosive > 0.0f) {
            list.add(EnumChatFormatting.RED + "[" + I18nUtil.resolveKey("trait.explosive", new Object[0]) + "]");
        }
        if (this.digamma * this.tempMod > 0.0f) {
            float d = (float)((int)(this.digamma * this.tempMod * 10000.0f)) / 10.0f;
            list.add(EnumChatFormatting.RED + "[" + I18nUtil.resolveKey("trait.digamma", new Object[0]) + "]");
            list.add(EnumChatFormatting.DARK_RED + "" + d + "mDRX/s");
        }
        if ((breeder = BreederRecipes.getFuelValue(stack)) != null) {
            list.add(BreederRecipes.getHEATString("[" + I18nUtil.resolveKey("trait.heat", breeder[0]) + "]", breeder[0]));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.breeding", breeder[1]));
            list.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("trait.furnace", breeder[0] * breeder[1] * 5));
        }
    }

    public boolean onEntityItemUpdate(EntityItem item) {
        if (!item.field_70170_p.field_72995_K) {
            if (this.hydro && item.field_70170_p.func_147439_a((int)Math.floor(item.field_70165_t), (int)Math.floor(item.field_70163_u), (int)Math.floor(item.field_70161_v)).func_149688_o() == Material.field_151586_h) {
                item.func_70106_y();
                item.field_70170_p.func_72885_a((Entity)item, item.field_70165_t, item.field_70163_u, item.field_70161_v, 2.0f, true, true);
                return true;
            }
            if (this.explosive > 0.0f && item.func_70027_ad()) {
                item.func_70106_y();
                item.field_70170_p.func_72885_a((Entity)item, item.field_70165_t, item.field_70163_u, item.field_70161_v, this.explosive, true, true);
                return true;
            }
        }
        return false;
    }
}

