/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.main;

import com.google.common.collect.Multimap;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockAshes;
import com.hbm.config.GeneralConfig;
import com.hbm.config.MobConfig;
import com.hbm.config.WorldConfig;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.entity.mob.EntityCyberCrab;
import com.hbm.entity.mob.EntityDuck;
import com.hbm.entity.mob.EntityNuclearCreeper;
import com.hbm.entity.mob.EntityQuackos;
import com.hbm.entity.mob.EntityTaintedCreeper;
import com.hbm.entity.projectile.EntityBurningFOEQ;
import com.hbm.entity.projectile.EntityMeteor;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.BossSpawnHandler;
import com.hbm.handler.EntityEffectHandler;
import com.hbm.handler.HTTPHandler;
import com.hbm.handler.RadiationWorldHandler;
import com.hbm.interfaces.IBomb;
import com.hbm.items.IEquipReceiver;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.items.armor.ItemModRevive;
import com.hbm.items.armor.ItemModShackles;
import com.hbm.items.special.ItemHot;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.CraftingManager;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.PlayerInformPacket;
import com.hbm.potion.HbmPotion;
import com.hbm.saveddata.AuxSavedData;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ArmorUtil;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.EnchantmentUtil;
import com.hbm.world.generator.TimedGenerator;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.FoodStats;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.Level;

public class ModEventHandler {
    public static int meteorShower = 0;
    static Random rand = new Random();
    public static int currentBrightness = 0;
    public static int lastBrightness = 0;
    private static final String hash = "41eb77f138ce350932e33b6b26b233df9aad0c0c80c6a49cb9a54ddd8fae3f83";

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            event.player.func_145747_a((IChatComponent)new ChatComponentText("Loaded world with Hbm's Nuclear Tech Mod 1.0.27 BETA (3920) for Minecraft 1.7.10!"));
            if (HTTPHandler.newVersion) {
                event.player.func_145747_a(new ChatComponentText("New version " + HTTPHandler.versionNumber + " is available!").func_150255_a(new ChatStyle().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/HbmMods/Hbm-s-Nuclear-Tech-GIT/releases")).func_150228_d(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.YELLOW)));
            }
            if (MobConfig.enableDucks && event.player instanceof EntityPlayerMP && !event.player.getEntityData().func_74775_l("PlayerPersisted").func_74767_n("hasDucked")) {
                PacketDispatcher.wrapper.sendTo((IMessage)new PlayerInformPacket("Press O to Duck!"), (EntityPlayerMP)event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (player.func_110124_au().toString().equals(Library.Dr_Nostalgia) && !player.field_70170_p.field_72995_K) {
            if (!player.field_71071_by.func_146028_b(ModItems.hat)) {
                player.field_71071_by.func_70441_a(new ItemStack(ModItems.hat));
            }
            if (!player.field_71071_by.func_146028_b(ModItems.beta)) {
                player.field_71071_by.func_70441_a(new ItemStack(ModItems.beta));
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            HbmPlayerProps.getData(player);
        }
        if (event.entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)event.entity;
            HbmLivingProps.getData(living);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityDeathFirst(LivingDeathEvent event) {
        for (int i = 1; i < 5; ++i) {
            ItemStack revive;
            ItemStack stack = event.entityLiving.func_71124_b(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor) || !ArmorModHandler.hasMods(stack) || (revive = ArmorModHandler.pryMods(stack)[7]) == null) continue;
            if (revive.func_77973_b() instanceof ItemModRevive) {
                revive.func_77964_b(revive.func_77960_j() + 1);
                if (revive.func_77960_j() >= revive.func_77958_k()) {
                    ArmorModHandler.removeMod(stack, 7);
                } else {
                    ArmorModHandler.applyMod(stack, revive);
                }
                event.entityLiving.func_70606_j(event.entityLiving.func_110138_aP());
                event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 60, 99));
                event.setCanceled(true);
                return;
            }
            if (!(revive.func_77973_b() instanceof ItemModShackles) || !(HbmLivingProps.getRadiation(event.entityLiving) < 1000.0f)) continue;
            event.entityLiving.func_70606_j(event.entityLiving.func_110138_aP());
            HbmLivingProps.incrementRadiation(event.entityLiving, Math.max(HbmLivingProps.getRadiation(event.entityLiving), 10.0f));
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        HbmLivingProps.setRadiation(event.entityLiving, 0.0f);
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (GeneralConfig.enableCataclysm) {
            EntityBurningFOEQ foeq = new EntityBurningFOEQ(event.entity.field_70170_p);
            foeq.func_70080_a(event.entity.field_70165_t, 500.0, event.entity.field_70161_v, 0.0f, 0.0f);
            event.entity.field_70170_p.func_72838_d((Entity)foeq);
        }
        if (event.entity.func_110124_au().toString().equals(Library.HbMinecraft)) {
            event.entity.func_145779_a(ModItems.book_of_, 1);
        }
        if (event.entity instanceof EntityTaintedCreeper && event.source == ModDamageSource.boxcar) {
            for (Object o : event.entity.field_70170_p.func_72872_a(EntityPlayer.class, event.entity.field_70121_D.func_72314_b(50.0, 50.0, 50.0))) {
                EntityPlayer player = (EntityPlayer)o;
                player.func_71029_a((StatBase)MainRegistry.bobHidden);
            }
        }
        if (!event.entityLiving.field_70170_p.field_72995_K && event.source instanceof EntityDamageSource && ((EntityDamageSource)event.source).func_76346_g() instanceof EntityPlayer && !(((EntityDamageSource)event.source).func_76346_g() instanceof FakePlayer)) {
            if (event.entityLiving instanceof EntitySpider && event.entityLiving.func_70681_au().nextInt(500) == 0) {
                event.entityLiving.func_145779_a(ModItems.spider_milk, 1);
            }
            if (event.entityLiving instanceof EntityCaveSpider && event.entityLiving.func_70681_au().nextInt(100) == 0) {
                event.entityLiving.func_145779_a(ModItems.serum, 1);
            }
            if (event.entityLiving instanceof EntityAnimal && event.entityLiving.func_70681_au().nextInt(500) == 0) {
                event.entityLiving.func_145779_a(ModItems.bandaid, 1);
            }
            if (event.entityLiving instanceof IMob && event.entityLiving.func_70681_au().nextInt(1000) == 0) {
                event.entityLiving.func_145779_a(ModItems.heart_piece, 1);
            }
            if (event.entityLiving instanceof EntityCyberCrab && event.entityLiving.func_70681_au().nextInt(500) == 0) {
                event.entityLiving.func_145779_a(ModItems.wd40, 1);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDeathLast(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() != ModItems.detonator_deadman || stack.field_77990_d == null) continue;
                int x = stack.field_77990_d.func_74762_e("x");
                int y = stack.field_77990_d.func_74762_e("y");
                int z = stack.field_77990_d.func_74762_e("z");
                if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_147439_a(x, y, z) instanceof IBomb) {
                    ((IBomb)player.field_70170_p.func_147439_a(x, y, z)).explode(player.field_70170_p, x, y, z);
                    if (GeneralConfig.enableExtendedLogging) {
                        MainRegistry.logger.log(Level.INFO, "[DET] Tried to detonate block at " + x + " / " + y + " / " + z + " by dead man's switch from " + player.getDisplayName() + "!");
                    }
                }
                player.field_71071_by.func_70299_a(i, null);
            }
        }
    }

    @SubscribeEvent
    public void decorateMob(LivingSpawnEvent event) {
        EntityLivingBase entity = event.entityLiving;
        World world = event.world;
        if (!MobConfig.enableMobGear) {
            return;
        }
        if (entity instanceof EntityZombie) {
            if (rand.nextInt(64) == 0) {
                entity.func_70062_b(4, new ItemStack(ModItems.gas_mask_m65, 1, world.field_73012_v.nextInt(100)));
            }
            if (rand.nextInt(128) == 0) {
                entity.func_70062_b(4, new ItemStack(ModItems.gas_mask, 1, world.field_73012_v.nextInt(100)));
            }
            if (rand.nextInt(256) == 0) {
                entity.func_70062_b(4, new ItemStack(ModItems.mask_of_infamy, 1, world.field_73012_v.nextInt(100)));
            }
            if (rand.nextInt(1024) == 0) {
                entity.func_70062_b(3, new ItemStack(ModItems.starmetal_plate, 1, world.field_73012_v.nextInt(ModItems.starmetal_plate.func_77612_l())));
            }
            if (rand.nextInt(128) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.pipe_lead, 1, world.field_73012_v.nextInt(100)));
            }
            if (rand.nextInt(128) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.reer_graar, 1, world.field_73012_v.nextInt(100)));
            }
            if (rand.nextInt(128) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.pipe_rusty, 1, world.field_73012_v.nextInt(100)));
            }
            if (rand.nextInt(128) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.crowbar, 1, world.field_73012_v.nextInt(100)));
            }
            if (rand.nextInt(128) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.geiger_counter, 1));
            }
            if (rand.nextInt(128) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.steel_pickaxe, 1, world.field_73012_v.nextInt(300)));
            }
            if (rand.nextInt(512) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.stopsign));
            }
            if (rand.nextInt(512) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.sopsign));
            }
            if (rand.nextInt(512) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.chernobylsign));
            }
        }
        if (entity instanceof EntitySkeleton && rand.nextInt(16) == 0) {
            entity.func_70062_b(4, new ItemStack(ModItems.gas_mask_m65, 1, world.field_73012_v.nextInt(100)));
            if (rand.nextInt(32) == 0) {
                entity.func_70062_b(0, new ItemStack(ModItems.syringe_poison));
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        ItemStack[] mods;
        ItemStack cladding;
        ItemStack yeet = event.entityItem.func_92059_d();
        if (yeet.func_77973_b() instanceof ItemArmor && ArmorModHandler.hasMods(yeet) && (cladding = (mods = ArmorModHandler.pryMods(yeet))[5]) != null && cladding.func_77973_b() == ModItems.cladding_obsidian) {
            try {
                ReflectionHelper.findField(Entity.class, (String[])new String[]{"field_149500_a", "invulnerable"}).setBoolean(event.entityItem, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack[] prevArmor = null;
        try {
            prevArmor = (ItemStack[])ReflectionHelper.findField(EntityLivingBase.class, (String[])new String[]{"field_82180_bT", "previousEquipment"}).get(event.entityLiving);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (event.entityLiving instanceof EntityPlayer && prevArmor != null && event.entityLiving.func_70694_bm() != null && (prevArmor[0] == null || prevArmor[0].func_77973_b() != event.entityLiving.func_70694_bm().func_77973_b()) && event.entityLiving.func_70694_bm().func_77973_b() instanceof IEquipReceiver) {
            ((IEquipReceiver)event.entityLiving.func_70694_bm().func_77973_b()).onEquip((EntityPlayer)event.entityLiving);
        }
        for (int i = 1; i < 5; ++i) {
            Multimap map;
            boolean reapply;
            ItemStack prev = prevArmor != null ? prevArmor[i] : null;
            ItemStack armor = event.entityLiving.func_71124_b(i);
            boolean bl = reapply = prevArmor != null && !ItemStack.func_77989_b(prev, (ItemStack)armor);
            if (reapply && prev != null && ArmorModHandler.hasMods(prev)) {
                for (ItemStack mod : ArmorModHandler.pryMods(prev)) {
                    if (mod == null || !(mod.func_77973_b() instanceof ItemArmorMod) || (map = ((ItemArmorMod)mod.func_77973_b()).getModifiers(prev)) == null) continue;
                    event.entityLiving.func_110140_aT().func_111148_a(map);
                }
            }
            if (armor == null || !ArmorModHandler.hasMods(armor)) continue;
            for (ItemStack mod : ArmorModHandler.pryMods(armor)) {
                if (mod == null || !(mod.func_77973_b() instanceof ItemArmorMod)) continue;
                ((ItemArmorMod)mod.func_77973_b()).modUpdate(event.entityLiving, armor);
                if (!reapply || (map = ((ItemArmorMod)mod.func_77973_b()).getModifiers(armor)) == null) continue;
                event.entityLiving.func_110140_aT().func_111147_b(map);
            }
        }
        EntityEffectHandler.onUpdate(event.entityLiving);
    }

    @SubscribeEvent
    public void clentTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START && event.side == Side.CLIENT) {
            if (BlockAshes.ashes > 256) {
                BlockAshes.ashes = 256;
            }
            if (BlockAshes.ashes > 0) {
                BlockAshes.ashes -= 2;
            }
            if (mc.field_71441_e.func_82737_E() % 20L == 0L) {
                lastBrightness = currentBrightness;
                currentBrightness = mc.field_71441_e.func_72802_i(MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)mc.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v), 0);
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.world != null && !event.world.field_72995_K && event.world.field_73011_w.func_76569_d() && GeneralConfig.enableMeteorStrikes) {
            EntityPlayer p;
            if (event.world.field_73012_v.nextInt(meteorShower > 0 ? WorldConfig.meteorShowerChance : WorldConfig.meteorStrikeChance) == 0 && !event.world.field_73010_i.isEmpty() && (p = (EntityPlayer)event.world.field_73010_i.get(event.world.field_73012_v.nextInt(event.world.field_73010_i.size()))) != null && p.field_71093_bK == 0) {
                EntityMeteor meteor = new EntityMeteor(event.world);
                meteor.field_70165_t = p.field_70165_t + (double)event.world.field_73012_v.nextInt(201) - 100.0;
                meteor.field_70163_u = 384.0;
                meteor.field_70161_v = p.field_70161_v + (double)event.world.field_73012_v.nextInt(201) - 100.0;
                meteor.field_70159_w = event.world.field_73012_v.nextDouble() - 0.5;
                meteor.field_70181_x = -2.5;
                meteor.field_70179_y = event.world.field_73012_v.nextDouble() - 0.5;
                event.world.func_72838_d((Entity)meteor);
            }
            if (meteorShower > 0 && --meteorShower == 0 && GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("Ended meteor shower.");
            }
            if (event.world.field_73012_v.nextInt(WorldConfig.meteorStrikeChance * 100) == 0 && GeneralConfig.enableMeteorShowers) {
                meteorShower = (int)((double)WorldConfig.meteorShowerDuration * 0.75 + (double)WorldConfig.meteorShowerDuration * 0.25 * (double)event.world.field_73012_v.nextFloat());
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("Started meteor shower! Duration: " + meteorShower);
                }
            }
        }
        if (event.world != null && !event.world.field_72995_K && GeneralConfig.enableRads) {
            int thunder = AuxSavedData.getThunder(event.world);
            if (thunder > 0) {
                AuxSavedData.setThunder(event.world, thunder - 1);
            }
            if (!event.world.field_72996_f.isEmpty()) {
                RadiationSavedData data = RadiationSavedData.getData(event.world);
                if (data.worldObj == null) {
                    data.worldObj = event.world;
                }
                if (event.world.func_82737_E() % 20L == 0L && event.phase == TickEvent.Phase.START) {
                    data.updateSystem();
                }
                ArrayList oList = new ArrayList();
                oList.addAll(event.world.field_72996_f);
                for (Object e : oList) {
                    Object creep;
                    EntityLivingBase entity;
                    if (!(e instanceof EntityLivingBase) || (entity = (EntityLivingBase)e) instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) continue;
                    float eRad = HbmLivingProps.getRadiation(entity);
                    if (entity instanceof EntityCreeper && eRad >= 200.0f && entity.func_110143_aJ() > 0.0f) {
                        if (event.world.field_73012_v.nextInt(3) == 0) {
                            creep = new EntityNuclearCreeper(event.world);
                            creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            if (!entity.field_70128_L && !event.world.field_72995_K) {
                                event.world.func_72838_d((Entity)creep);
                            }
                            entity.func_70106_y();
                            continue;
                        }
                        entity.func_70097_a(ModDamageSource.radiation, 100.0f);
                        continue;
                    }
                    if (entity instanceof EntityCow && !(entity instanceof EntityMooshroom) && eRad >= 50.0f) {
                        creep = new EntityMooshroom(event.world);
                        creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                        if (!entity.field_70128_L && !event.world.field_72995_K) {
                            event.world.func_72838_d((Entity)creep);
                        }
                        entity.func_70106_y();
                        continue;
                    }
                    if (entity instanceof EntityVillager && eRad >= 500.0f) {
                        creep = new EntityZombie(event.world);
                        creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                        if (!entity.field_70128_L && !event.world.field_72995_K) {
                            event.world.func_72838_d((Entity)creep);
                        }
                        entity.func_70106_y();
                        continue;
                    }
                    if (entity.getClass().equals(EntityDuck.class) && eRad >= 200.0f) {
                        EntityQuackos quacc = new EntityQuackos(event.world);
                        quacc.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                        if (!entity.field_70128_L && !event.world.field_72995_K) {
                            event.world.func_72838_d((Entity)quacc);
                        }
                        entity.func_70106_y();
                        continue;
                    }
                    if (eRad < 200.0f || ContaminationUtil.isRadImmune((Entity)entity)) continue;
                    if (eRad > 2500.0f) {
                        HbmLivingProps.setRadiation(entity, 2500.0f);
                    }
                    if (eRad >= 1000.0f) {
                        entity.func_70097_a(ModDamageSource.radiation, 1000.0f);
                        HbmLivingProps.setRadiation(entity, 0.0f);
                        if (entity.func_110143_aJ() > 0.0f) {
                            entity.func_70606_j(0.0f);
                            entity.func_70645_a(ModDamageSource.radiation);
                        }
                        if (!(entity instanceof EntityPlayer)) continue;
                        ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.achRadDeath);
                        continue;
                    }
                    if (eRad >= 800.0f) {
                        if (event.world.field_73012_v.nextInt(300) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0));
                        }
                        if (event.world.field_73012_v.nextInt(300) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2));
                        }
                        if (event.world.field_73012_v.nextInt(300) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 2));
                        }
                        if (event.world.field_73012_v.nextInt(500) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 2));
                        }
                        if (event.world.field_73012_v.nextInt(700) != 0) continue;
                        entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 60, 1));
                        continue;
                    }
                    if (eRad >= 600.0f) {
                        if (event.world.field_73012_v.nextInt(300) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0));
                        }
                        if (event.world.field_73012_v.nextInt(300) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 2));
                        }
                        if (event.world.field_73012_v.nextInt(300) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 2));
                        }
                        if (event.world.field_73012_v.nextInt(500) != 0) continue;
                        entity.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 60, 1));
                        continue;
                    }
                    if (eRad >= 400.0f) {
                        if (event.world.field_73012_v.nextInt(300) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0));
                        }
                        if (event.world.field_73012_v.nextInt(500) == 0) {
                            entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 0));
                        }
                        if (event.world.field_73012_v.nextInt(300) != 0) continue;
                        entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 1));
                        continue;
                    }
                    if (!(eRad >= 200.0f)) continue;
                    if (event.world.field_73012_v.nextInt(300) == 0) {
                        entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 100, 0));
                    }
                    if (event.world.field_73012_v.nextInt(500) == 0) {
                        entity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, 100, 0));
                    }
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.achRadPoison);
                }
            }
        }
        if (event.phase == TickEvent.Phase.START) {
            RadiationWorldHandler.handleWorldDestruction(event.world);
            BossSpawnHandler.rollTheDice(event.world);
            TimedGenerator.automaton(event.world, 100);
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ArmorUtil.checkArmor((EntityPlayer)e, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots)) {
            e.field_70170_p.func_72956_a((Entity)e, "random.break", 5.0f, 1.0f + e.func_70681_au().nextFloat() * 0.5f);
            event.setCanceled(true);
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71071_by.field_70460_b[2] != null && ((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b() instanceof ArmorFSB) {
            ((ArmorFSB)((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b()).handleAttack(event);
        }
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingHurtEvent event) {
        EntityLivingBase e = event.entityLiving;
        for (int i = 1; i < 5; ++i) {
            ItemStack armor = e.func_71124_b(i);
            if (armor == null || !ArmorModHandler.hasMods(armor)) continue;
            for (ItemStack mod : ArmorModHandler.pryMods(armor)) {
                if (mod == null || !(mod.func_77973_b() instanceof ItemArmorMod)) continue;
                ((ItemArmorMod)mod.func_77973_b()).modDamage(event, armor);
            }
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71071_by.field_70460_b[2] != null && ((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b() instanceof ArmorFSB) {
            ((ArmorFSB)((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b()).handleHurt(event);
        }
    }

    @SubscribeEvent
    public void onPlayerFall(PlayerFlyableFallEvent event) {
        EntityPlayer e = event.entityPlayer;
        if (e.field_71071_by.field_70460_b[2] != null && e.field_71071_by.field_70460_b[2].func_77973_b() instanceof ArmorFSB) {
            ((ArmorFSB)e.field_71071_by.field_70460_b[2].func_77973_b()).handleFall(e);
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71071_by.field_70460_b[2] != null && ((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b() instanceof ArmorFSB) {
            ((ArmorFSB)((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b()).handleJump((EntityPlayer)e);
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71071_by.field_70460_b[2] != null && ((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b() instanceof ArmorFSB) {
            ((ArmorFSB)((EntityPlayer)e).field_71071_by.field_70460_b[2].func_77973_b()).handleFall((EntityPlayer)e);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() instanceof ArmorFSB) {
            ((ArmorFSB)player.field_71071_by.field_70460_b[2].func_77973_b()).handleTick(event);
        }
        if (player.field_70173_aa == 100 || player.field_70173_aa == 200) {
            CraftingManager.crumple();
        }
        if (!player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START) {
            if (!Float.isFinite(player.func_110143_aJ()) || !Float.isFinite(player.func_110139_bj())) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Your health has been restored!"));
                player.field_70170_p.func_72956_a((Entity)player, "hbm:item.syringe", 1.0f, 1.0f);
                player.func_70606_j(player.func_110138_aP());
                player.func_110149_m(0.0f);
            }
            if (player.field_71071_by.func_146028_b(ModItems.beta)) {
                if (player.func_71024_bL().func_75116_a() > 10) {
                    player.func_70691_i((float)(player.func_71024_bL().func_75116_a() - 10));
                }
                if (player.func_71024_bL().func_75116_a() != 10) {
                    try {
                        Field food = ReflectionHelper.findField(FoodStats.class, (String[])new String[]{"field_75127_a", "foodLevel"});
                        food.setInt(player.func_71024_bL(), 10);
                    }
                    catch (Exception food) {
                        // empty catch block
                    }
                }
            }
            if (player.func_110124_au().toString().equals(Library.Pu_238)) {
                List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.field_70121_D.func_72314_b(3.0, 3.0, 3.0));
                for (EntityLivingBase e : entities) {
                    if (e == player) continue;
                    e.func_70690_d(new PotionEffect(HbmPotion.radiation.field_76415_H, 300, 2));
                }
            }
        }
        if (player.field_70170_p.field_72995_K) {
            TickEvent.Phase cfr_ignored_0 = event.phase;
            if (event.phase == TickEvent.Phase.START && !player.func_82150_aj() && !player.func_70093_af()) {
                if (player.func_110124_au().toString().equals(Library.HbMinecraft)) {
                    int i = player.field_70173_aa * 3;
                    Vec3 vec = Vec3.func_72443_a((double)3.0, (double)0.0, (double)0.0);
                    vec.func_72442_b((float)((double)i * Math.PI / 180.0));
                    for (int k = 0; k < 5; ++k) {
                        vec.func_72442_b((float)Math.PI / 180);
                        player.field_70170_p.func_72869_a("townaura", player.field_70165_t + vec.field_72450_a, player.field_70163_u + 1.0 + player.field_70170_p.field_73012_v.nextDouble() * 0.05, player.field_70161_v + vec.field_72449_c, 0.0, 0.0, 0.0);
                    }
                }
                if (player.func_110124_au().toString().equals(Library.Pu_238)) {
                    Vec3 vec = Vec3.func_72443_a((double)(3.0 * rand.nextDouble()), (double)0.0, (double)0.0);
                    vec.func_72446_c((float)(rand.nextDouble() * Math.PI));
                    vec.func_72442_b((float)(rand.nextDouble() * Math.PI * 2.0));
                    player.field_70170_p.func_72869_a("townaura", player.field_70165_t + vec.field_72450_a, player.field_70163_u + 1.0 + vec.field_72448_b, player.field_70161_v + vec.field_72449_c, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void enteringChunk(EntityEvent.EnteringChunk evt) {
        if (evt.entity instanceof EntityMissileBaseAdvanced) {
            ((EntityMissileBaseAdvanced)evt.entity).loadNeighboringChunks(evt.newChunkX, evt.newChunkZ);
        }
        if (evt.entity instanceof EntityMissileCustom) {
            ((EntityMissileCustom)evt.entity).loadNeighboringChunks(evt.newChunkX, evt.newChunkZ);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound data = new NBTTagCompound();
        HbmPlayerProps.getData(event.original).saveNBTData(data);
        HbmPlayerProps.getData(event.entityPlayer).loadNBTData(data);
    }

    @SubscribeEvent
    public void itemCrafted(PlayerEvent.ItemCraftedEvent e) {
        Item item = e.crafting.func_77973_b();
        if (item == ModItems.gun_mp40) {
            e.player.func_71064_a((StatBase)MainRegistry.achFreytag, 1);
        }
        if (item == ModItems.piston_selenium || item == ModItems.gun_b92) {
            e.player.func_71064_a((StatBase)MainRegistry.achSelenium, 1);
        }
        if (item == ModItems.battery_potatos) {
            e.player.func_71064_a((StatBase)MainRegistry.achPotato, 1);
        }
        if (item == ModItems.gun_revolver_pip) {
            e.player.func_71064_a((StatBase)MainRegistry.achC44, 1);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.machine_difurnace_off)) {
            e.player.func_71064_a((StatBase)MainRegistry.bobMetalworks, 1);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.machine_assembler)) {
            e.player.func_71064_a((StatBase)MainRegistry.bobAssembly, 1);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.brick_concrete)) {
            e.player.func_71064_a((StatBase)MainRegistry.bobChemistry, 1);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.machine_boiler_electric_off)) {
            e.player.func_71064_a((StatBase)MainRegistry.bobOil, 1);
        }
        if (item == ModItems.ingot_uranium_fuel) {
            e.player.func_71064_a((StatBase)MainRegistry.bobNuclear, 1);
        }
    }

    @SubscribeEvent
    public void itemSmelted(PlayerEvent.ItemSmeltedEvent e) {
        if (!e.player.field_70170_p.field_72995_K && e.smelting.func_77973_b() == Items.field_151042_j && e.player.func_70681_au().nextInt(64) == 0) {
            if (!e.player.field_71071_by.func_70441_a(new ItemStack(ModItems.lodestone))) {
                e.player.func_71019_a(new ItemStack(ModItems.lodestone), false);
            } else {
                e.player.field_71069_bz.func_75142_b();
            }
        }
        if (!e.player.field_70170_p.field_72995_K && e.smelting.func_77973_b() == ModItems.ingot_uranium && e.player.func_70681_au().nextInt(64) == 0) {
            if (!e.player.field_71071_by.func_70441_a(new ItemStack(ModItems.quartz_plutonium))) {
                e.player.func_71019_a(new ItemStack(ModItems.quartz_plutonium), false);
            } else {
                e.player.field_71069_bz.func_75142_b();
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!(event.getPlayer() instanceof EntityPlayerMP)) {
            return;
        }
        if (event.block == ModBlocks.stone_gneiss && !((EntityPlayerMP)event.getPlayer()).func_147099_x().func_77443_a(MainRegistry.achStratum)) {
            event.getPlayer().func_71029_a((StatBase)MainRegistry.achStratum);
            event.setExpToDrop(500);
        }
    }

    @SubscribeEvent
    public void onClickSign(PlayerInteractEvent event) {
        int x = event.x;
        int y = event.y;
        int z = event.z;
        World world = event.world;
        if (!world.field_72995_K && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && world.func_147439_a(x, y, z) == Blocks.field_150472_an) {
            TileEntitySign sign = (TileEntitySign)world.func_147438_o(x, y, z);
            String result = this.smoosh(sign.field_145915_a[0], sign.field_145915_a[1], sign.field_145915_a[2], sign.field_145915_a[3]);
            if (result.equals(hash)) {
                world.func_147480_a(x, y, z, false);
                EntityItem entityitem = new EntityItem(world, (double)x, (double)y, (double)z, new ItemStack(ModItems.bobmazon_hidden));
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    private String smoosh(String s1, String s2, String s3, String s4) {
        Random rand = new Random();
        String s = "";
        byte[] b1 = s1.getBytes();
        byte[] b2 = s2.getBytes();
        byte[] b3 = s3.getBytes();
        byte[] b4 = s4.getBytes();
        if (b1.length == 0 || b2.length == 0 || b3.length == 0 || b4.length == 0) {
            return "";
        }
        s = s + s1;
        rand.setSeed(b1[0]);
        s = s + rand.nextInt(0xFFFFFF);
        s = s + s2;
        rand.setSeed(rand.nextInt(0xFFFFFF) + b2[0]);
        rand.setSeed(b2[0]);
        s = s + rand.nextInt(0xFFFFFF);
        s = s + s3;
        rand.setSeed(rand.nextInt(0xFFFFFF) + b3[0]);
        rand.setSeed(b3[0]);
        s = s + rand.nextInt(0xFFFFFF);
        s = s + s4;
        rand.setSeed(rand.nextInt(0xFFFFFF) + b4[0]);
        rand.setSeed(b4[0]);
        s = s + rand.nextInt(0xFFFFFF);
        return this.getHash(s);
    }

    private String getHash(String inp) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            byte[] bytes = sha256.digest(inp.getBytes());
            String str = "";
            for (byte b : bytes) {
                str = str + Integer.toString((b & 0xFF) + 256, 16).substring(1);
            }
            return str;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    @SubscribeEvent
    public void chatEvent(ServerChatEvent event) {
        EntityPlayerMP player = event.player;
        String message = event.message;
        if (GeneralConfig.enableDebugMode && player.func_110124_au().toString().equals(Library.HbMinecraft) && message.startsWith("!")) {
            String[] msg = message.split(" ");
            String m = msg[0].substring(1, msg[0].length()).toLowerCase();
            if ("gv".equals(m)) {
                Item item;
                int id = 0;
                int size = 1;
                int meta = 0;
                if (msg.length > 1 && NumberUtils.isNumber((String)msg[1])) {
                    id = (int)NumberUtils.createDouble((String)msg[1]).doubleValue();
                }
                if (msg.length > 2 && NumberUtils.isNumber((String)msg[2])) {
                    size = (int)NumberUtils.createDouble((String)msg[2]).doubleValue();
                }
                if (msg.length > 3 && NumberUtils.isNumber((String)msg[3])) {
                    meta = (int)NumberUtils.createDouble((String)msg[3]).doubleValue();
                }
                if ((item = Item.func_150899_d((int)id)) != null && size > 0 && meta >= 0) {
                    player.field_71071_by.func_70441_a(new ItemStack(item, size, meta));
                }
            }
            player.field_71069_bz.func_75142_b();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void anvilUpdateEvent(AnvilUpdateEvent event) {
        double h2;
        ItemStack out;
        if (event.left.func_77973_b() instanceof ItemGunBase && event.right.func_77973_b() == Items.field_151134_bR) {
            event.output = event.left.func_77946_l();
            Map mapright = EnchantmentHelper.func_82781_a((ItemStack)event.right);
            Iterator itr = mapright.keySet().iterator();
            while (itr.hasNext()) {
                int i = (Integer)itr.next();
                int j = (Integer)mapright.get(i);
                Enchantment e = Enchantment.field_77331_b[i];
                EnchantmentUtil.removeEnchantment(event.output, e);
                EnchantmentUtil.addEnchantment(event.output, e, j);
            }
            event.cost = 10;
        }
        if (event.left.func_77973_b() == ModItems.ingot_meteorite && event.right.func_77973_b() == ModItems.ingot_meteorite && event.left.field_77994_a == 1 && event.right.field_77994_a == 1) {
            double h1 = ItemHot.getHeat(event.left);
            double h22 = ItemHot.getHeat(event.right);
            if (h1 >= 0.5 && h22 >= 0.5) {
                out = new ItemStack(ModItems.ingot_meteorite_forged);
                ItemHot.heatUp(out, (h1 + h22) / 2.0);
                event.output = out;
                event.cost = 10;
            }
        }
        if (event.left.func_77973_b() == ModItems.ingot_meteorite_forged && event.right.func_77973_b() == ModItems.ingot_meteorite_forged && event.left.field_77994_a == 1 && event.right.field_77994_a == 1) {
            double h1 = ItemHot.getHeat(event.left);
            double h23 = ItemHot.getHeat(event.right);
            if (h1 >= 0.5 && h23 >= 0.5) {
                out = new ItemStack(ModItems.blade_meteorite);
                ItemHot.heatUp(out, (h1 + h23) / 2.0);
                event.output = out;
                event.cost = 30;
            }
        }
        if (event.left.func_77973_b() == ModItems.meteorite_sword_seared && event.right.func_77973_b() == ModItems.ingot_meteorite_forged && event.left.field_77994_a == 1 && event.right.field_77994_a == 1 && (h2 = ItemHot.getHeat(event.right)) >= 0.5) {
            ItemStack out2;
            event.output = out2 = new ItemStack(ModItems.meteorite_sword_reforged);
            event.cost = 50;
        }
        if (event.left.func_77973_b() == ModItems.ingot_steel_dusted && event.right.func_77973_b() == ModItems.ingot_steel_dusted && event.left.field_77994_a == event.right.field_77994_a) {
            double h1 = ItemHot.getHeat(event.left);
            double h24 = ItemHot.getHeat(event.right);
            if (h24 >= 0.5) {
                int i2;
                int i1 = event.left.func_77960_j();
                int i3 = Math.min(i1, i2 = event.right.func_77960_j()) + 1;
                boolean done = i3 >= 10;
                ItemStack out3 = new ItemStack(done ? ModItems.ingot_chainsteel : ModItems.ingot_steel_dusted, event.left.field_77994_a, done ? 0 : i3);
                ItemHot.heatUp(out3, done ? 1.0 : (h1 + h24) / 2.0);
                event.output = out3;
                event.cost = event.left.field_77994_a;
            }
        }
    }
}

