/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.lib;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.config.WorldConfig;
import com.hbm.items.ModItems;
import com.hbm.lib.HbmChestContents;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntitySafe;
import com.hbm.tileentity.machine.TileEntitySoyuzCapsule;
import com.hbm.world.dungeon.AncientTomb;
import com.hbm.world.dungeon.Antenna;
import com.hbm.world.dungeon.ArcticVault;
import com.hbm.world.dungeon.Barrel;
import com.hbm.world.dungeon.Bunker;
import com.hbm.world.dungeon.CrashedVertibird;
import com.hbm.world.dungeon.DesertAtom001;
import com.hbm.world.dungeon.Factory;
import com.hbm.world.dungeon.LibraryDungeon;
import com.hbm.world.dungeon.Radio01;
import com.hbm.world.dungeon.Relay;
import com.hbm.world.dungeon.Satellite;
import com.hbm.world.dungeon.Silo;
import com.hbm.world.dungeon.Spaceship;
import com.hbm.world.dungeon.Vertibird;
import com.hbm.world.feature.DepthDeposit;
import com.hbm.world.feature.Dud;
import com.hbm.world.feature.Geyser;
import com.hbm.world.feature.GeyserLarge;
import com.hbm.world.feature.OilBubble;
import com.hbm.world.feature.OilSandBubble;
import com.hbm.world.feature.Sellafield;
import com.hbm.world.generator.CellularDungeonFactory;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class HbmWorldGen
implements IWorldGenerator {
    NoiseGeneratorOctaves octaves = new NoiseGeneratorOctaves(new Random(31647717297583469L), 1);

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 0: {
                this.generateSurface(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkX * 16, chunkZ * 16);
                break;
            }
            default: {
                if (!GeneralConfig.enableMDOres) break;
                this.generateSurface(world, rand, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private double generateUnruh(long seed, int x, int z, double scale, int depth) {
        scale = 1.0 / scale;
        double result = 1.0;
        Random rand = new Random(seed);
        for (int i = 0; i < depth; ++i) {
            double offsetX = rand.nextDouble() * Math.PI * 2.0;
            double offsetZ = rand.nextDouble() * Math.PI * 2.0;
            result += Math.sin((double)x / Math.pow(2.0, depth) * scale + offsetX) * Math.sin((double)z / Math.pow(2.0, depth) * scale + offsetZ);
        }
        return result / (double)depth;
    }

    private void generateSurface(World world, Random rand, int i, int j) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double thresh;
                double unruh = Math.abs(this.generateUnruh(world.func_72905_C(), i + x, j + z, 4.0, 4)) * 1.5;
                if (!(unruh >= (thresh = 0.8))) continue;
                int span = (int)Math.floor((unruh - thresh) * 7.0);
                for (int s = -span; s <= span; ++s) {
                    int y = 35 + s;
                    Block b = world.func_147439_a(x, y, z);
                    if (b.func_149688_o() != Material.field_151576_e && b != Blocks.field_150346_d) continue;
                    world.func_147465_d(i + x, y, j + z, ModBlocks.stone_gneiss, 0, 2);
                }
            }
        }
        DungeonToolbox.generateOre(world, rand, i, j, 25, 6, 30, 10, ModBlocks.ore_gneiss_iron, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, 10, 6, 30, 10, ModBlocks.ore_gneiss_gold, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.uraniumSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_uranium, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.copperSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_copper, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.asbestosSpawn * 3, 6, 30, 10, ModBlocks.ore_gneiss_asbestos, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.lithiumSpawn, 6, 30, 10, ModBlocks.ore_gneiss_lithium, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.rareSpawn, 6, 30, 10, ModBlocks.ore_gneiss_asbestos, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.gassshaleSpawn * 3, 10, 30, 10, ModBlocks.ore_gneiss_gas, ModBlocks.stone_gneiss);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.uraniumSpawn, 5, 5, 20, ModBlocks.ore_uranium);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.thoriumSpawn, 5, 5, 25, ModBlocks.ore_thorium);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.titaniumSpawn, 6, 5, 30, ModBlocks.ore_titanium);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.sulfurSpawn, 8, 5, 30, ModBlocks.ore_sulfur);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.aluminiumSpawn, 6, 5, 40, ModBlocks.ore_aluminium);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.copperSpawn, 6, 5, 45, ModBlocks.ore_copper);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.fluoriteSpawn, 4, 5, 45, ModBlocks.ore_fluorite);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.niterSpawn, 6, 5, 30, ModBlocks.ore_niter);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.tungstenSpawn, 8, 5, 30, ModBlocks.ore_tungsten);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.leadSpawn, 9, 5, 30, ModBlocks.ore_lead);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.berylliumSpawn, 4, 5, 30, ModBlocks.ore_beryllium);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.rareSpawn, 5, 5, 20, ModBlocks.ore_rare);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.ligniteSpawn, 24, 35, 25, ModBlocks.ore_lignite);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.asbestosSpawn, 4, 16, 16, ModBlocks.ore_asbestos);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.cinnebarSpawn, 2, 8, 8, ModBlocks.ore_asbestos);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.ironClusterSpawn, 6, 5, 50, ModBlocks.cluster_iron);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.titaniumClusterSpawn, 6, 5, 30, ModBlocks.cluster_titanium);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.aluminiumClusterSpawn, 6, 5, 40, ModBlocks.cluster_aluminium);
        if (WorldConfig.oilcoalSpawn > 0 && rand.nextInt(WorldConfig.oilcoalSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 1, 64, 32, 32, ModBlocks.ore_coal_oil);
        }
        if (WorldConfig.gasbubbleSpawn > 0 && rand.nextInt(WorldConfig.gasbubbleSpawn) == 0) {
            DungeonToolbox.generateOre(world, rand, i, j, 1, 32, 30, 10, ModBlocks.gas_flammable);
        }
        DepthDeposit.generateCondition(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_iron, rand, 24);
        DepthDeposit.generateCondition(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_titanium, rand, 32);
        DepthDeposit.generateCondition(world, i, 0, 3, j, 5, 0.6, ModBlocks.cluster_depth_tungsten, rand, 32);
        DepthDeposit.generateCondition(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_cinnebar, rand, 16);
        DepthDeposit.generateCondition(world, i, 0, 3, j, 5, 0.8, ModBlocks.ore_depth_zirconium, rand, 16);
        for (int k = 0; k < rand.nextInt(4); ++k) {
            int randPosX = i + rand.nextInt(16);
            int randPosY = rand.nextInt(15) + 15;
            int randPosZ = j + rand.nextInt(16);
            if (randPosX > -350 || randPosX < -450 || randPosZ > -350 || randPosZ < -450) continue;
            new WorldGenMinable(ModBlocks.ore_australium, 50).func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        if (GeneralConfig.enableDungeons) {
            int z;
            int y;
            int x;
            int z2;
            int a;
            BiomeGenBase biome = world.func_72959_q().func_76935_a(i, j);
            if ((biome == BiomeGenBase.field_76772_c || biome == BiomeGenBase.field_76769_d) && WorldConfig.radioStructure > 0 && rand.nextInt(WorldConfig.radioStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    int x2 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    int y2 = world.func_72976_f(x2, z2);
                    new Radio01().func_76484_a(world, rand, x2, y2, z2);
                }
            }
            if (biome.field_76750_F >= 0.4f && biome.field_76751_G <= 0.6f && WorldConfig.antennaStructure > 0 && rand.nextInt(WorldConfig.antennaStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    int x3 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    int y3 = world.func_72976_f(x3, z2);
                    new Antenna().func_76484_a(world, rand, x3, y3, z2);
                }
            }
            if (!biome.func_76738_d() && biome.field_76750_F >= 1.5f && WorldConfig.atomStructure > 0 && rand.nextInt(WorldConfig.atomStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    int x4 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    int y4 = world.func_72976_f(x4, z2);
                    new DesertAtom001().func_76484_a(world, rand, x4, y4, z2);
                }
            }
            if (!biome.func_76738_d() && biome.field_76750_F >= 2.0f && WorldConfig.vertibirdStructure > 0 && rand.nextInt(WorldConfig.vertibirdStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    int x5 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    int y5 = world.func_72976_f(x5, z2);
                    if (rand.nextInt(2) == 0) {
                        new Vertibird().func_76484_a(world, rand, x5, y5, z2);
                        continue;
                    }
                    new CrashedVertibird().func_76484_a(world, rand, x5, y5, z2);
                }
            }
            if (WorldConfig.dungeonStructure > 0 && rand.nextInt(WorldConfig.dungeonStructure) == 0) {
                x = i + rand.nextInt(16);
                int y6 = rand.nextInt(256);
                z2 = j + rand.nextInt(16);
                new LibraryDungeon().func_76484_a(world, rand, x, y6, z2);
            }
            if ((biome.field_76750_F == 0.5f || biome.field_76750_F == 2.0f) && WorldConfig.relayStructure > 0 && rand.nextInt(WorldConfig.relayStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    int x6 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    int y7 = world.func_72976_f(x6, z2);
                    new Relay().func_76484_a(world, rand, x6, y7, z2);
                }
            }
            if ((biome.field_76750_F == 0.5f || biome.field_76750_F == 2.0f) && WorldConfig.satelliteStructure > 0 && rand.nextInt(WorldConfig.satelliteStructure) == 0) {
                for (a = 0; a < 1; ++a) {
                    int x7 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    int y8 = world.func_72976_f(x7, z2);
                    new Satellite().func_76484_a(world, rand, x7, y8, z2);
                }
            }
            if (!biome.func_76738_d() && biome.field_76750_F >= 1.5f && rand.nextInt(200) == 0) {
                for (a = 0; a < 1; ++a) {
                    int x8 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    int y9 = world.func_72976_f(x8, z2);
                    OilSandBubble.spawnOil(world, x8, y9, z2, 15 + rand.nextInt(31));
                }
            }
            if (WorldConfig.bunkerStructure > 0 && rand.nextInt(WorldConfig.bunkerStructure) == 0) {
                x = i + rand.nextInt(16);
                int z3 = j + rand.nextInt(16);
                y = world.func_72976_f(x, z3);
                new Bunker().func_76484_a(world, rand, x, y, z3);
            }
            if (WorldConfig.siloStructure > 0 && rand.nextInt(WorldConfig.siloStructure) == 0) {
                x = i + rand.nextInt(16);
                int z4 = j + rand.nextInt(16);
                y = world.func_72976_f(x, z4);
                new Silo().func_76484_a(world, rand, x, y, z4);
            }
            if (WorldConfig.factoryStructure > 0 && rand.nextInt(WorldConfig.factoryStructure) == 0) {
                x = i + rand.nextInt(16);
                int z5 = j + rand.nextInt(16);
                y = world.func_72976_f(x, z5);
                new Factory().func_76484_a(world, rand, x, y, z5);
            }
            if (WorldConfig.dudStructure > 0 && rand.nextInt(WorldConfig.dudStructure) == 0) {
                x = i + rand.nextInt(16);
                int z6 = j + rand.nextInt(16);
                y = world.func_72976_f(x, z6);
                new Dud().func_76484_a(world, rand, x, y, z6);
            }
            if (WorldConfig.spaceshipStructure > 0 && rand.nextInt(WorldConfig.spaceshipStructure) == 0) {
                x = i + rand.nextInt(16);
                int z7 = j + rand.nextInt(16);
                y = world.func_72976_f(x, z7);
                new Spaceship().func_76484_a(world, rand, x, y, z7);
            }
            if (WorldConfig.barrelStructure > 0 && biome.field_76750_F >= 1.5f && !biome.func_76738_d() && rand.nextInt(WorldConfig.barrelStructure) == 0) {
                x = i + rand.nextInt(16);
                int z8 = j + rand.nextInt(16);
                y = world.func_72976_f(x, z8);
                new Barrel().func_76484_a(world, rand, x, y, z8);
            }
            if (WorldConfig.broadcaster > 0 && rand.nextInt(WorldConfig.broadcaster) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y = world.func_72976_f(x, z = j + rand.nextInt(16))) - 1, z).canPlaceTorchOnTop(world, x, y - 1, z)) {
                world.func_147465_d(x, y, z, ModBlocks.broadcaster_pc, rand.nextInt(4) + 2, 2);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned corrupted broadcaster at " + x + " " + y + " " + z);
                }
            }
            if (WorldConfig.minefreq > 0 && GeneralConfig.enableMines && rand.nextInt(WorldConfig.minefreq) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y = world.func_72976_f(x, z = j + rand.nextInt(16))) - 1, z).canPlaceTorchOnTop(world, x, y - 1, z)) {
                world.func_147449_b(x, y, z, ModBlocks.mine_ap);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned landmine at " + x + " " + y + " " + z);
                }
            }
            if (WorldConfig.radfreq > 0 && GeneralConfig.enableRad && rand.nextInt(WorldConfig.radfreq) == 0 && biome == BiomeGenBase.field_76769_d) {
                for (a = 0; a < 1; ++a) {
                    int x9 = i + rand.nextInt(16);
                    z2 = j + rand.nextInt(16);
                    double r = rand.nextInt(15) + 10;
                    if (rand.nextInt(50) == 0) {
                        r = 50.0;
                    }
                    new Sellafield().generate(world, x9, z2, r, r * 0.35);
                    if (!GeneralConfig.enableDebugMode) continue;
                    MainRegistry.logger.info("[Debug] Successfully spawned raditation hotspot at " + x9 + " " + z2);
                }
            }
            if (WorldConfig.geyserChlorine > 0 && biome == BiomeGenBase.field_76772_c && rand.nextInt(WorldConfig.geyserWater) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y = world.func_72976_f(x, z = j + rand.nextInt(16))) - 1, z) == Blocks.field_150349_c) {
                new Geyser().func_76484_a(world, rand, x, y, z);
            }
            if (WorldConfig.geyserWater > 0 && biome == BiomeGenBase.field_76769_d && rand.nextInt(WorldConfig.geyserChlorine) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y = world.func_72976_f(x, z = j + rand.nextInt(16))) - 1, z) == Blocks.field_150354_m) {
                new GeyserLarge().func_76484_a(world, rand, x, y, z);
            }
            if (WorldConfig.capsuleStructure > 0 && biome == BiomeGenBase.field_76787_r && rand.nextInt(WorldConfig.capsuleStructure) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y = world.func_72976_f(x, z = j + rand.nextInt(16)) - 4) + 1, z).canPlaceTorchOnTop(world, x, y + 1, z)) {
                world.func_147465_d(x, y, z, ModBlocks.soyuz_capsule, 3, 2);
                TileEntitySoyuzCapsule cap = (TileEntitySoyuzCapsule)world.func_147438_o(x, y, z);
                if (cap != null) {
                    cap.func_70299_a(rand.nextInt(cap.func_70302_i_()), new ItemStack(ModItems.record_glass));
                }
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned capsule at " + x + " " + z);
                }
            }
            if (WorldConfig.geyserVapor > 0 && rand.nextInt(WorldConfig.geyserVapor) == 0) {
                x = i + rand.nextInt(16);
                if (world.func_147439_a(x, y = world.func_72976_f(x, z = j + rand.nextInt(16)), z) == Blocks.field_150348_b) {
                    world.func_147449_b(x, y, z, ModBlocks.geysir_vapor);
                } else if (world.func_147439_a(x, y - 1, z) == Blocks.field_150348_b) {
                    world.func_147449_b(x, y - 1, z, ModBlocks.geysir_vapor);
                }
            }
            if (rand.nextInt(1000) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                boolean done = false;
                for (int k = 0; k < 256; ++k) {
                    if (world.func_147439_a(x, k, z) != Blocks.field_150364_r || world.func_72805_g(x, k, z) != 0) continue;
                    world.func_147449_b(x, k, z, ModBlocks.pink_log);
                    done = true;
                }
                if (GeneralConfig.enableDebugMode && done) {
                    MainRegistry.logger.info("[Debug] Successfully spawned pink tree at " + x + " " + z);
                }
            }
            if (WorldConfig.vaultfreq > 0 && GeneralConfig.enableVaults && rand.nextInt(WorldConfig.vaultfreq) == 0 && world.func_147439_a(x = i + rand.nextInt(16), (y = world.func_72976_f(x, z = j + rand.nextInt(16))) - 1, z).canPlaceTorchOnTop(world, x, y - 1, z)) {
                world.func_147465_d(x, y, z, ModBlocks.safe, rand.nextInt(4) + 2, 2);
                switch (rand.nextInt(10)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setMod(1.0);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(10), (IInventory)((TileEntitySafe)world.func_147438_o(x, y, z)), (int)(rand.nextInt(4) + 3));
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setMod(0.1);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(11), (IInventory)((TileEntitySafe)world.func_147438_o(x, y, z)), (int)(rand.nextInt(3) + 2));
                        break;
                    }
                    case 7: 
                    case 8: {
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setMod(0.02);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(12), (IInventory)((TileEntitySafe)world.func_147438_o(x, y, z)), (int)(rand.nextInt(3) + 1));
                        break;
                    }
                    case 9: {
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setPins(rand.nextInt(999) + 1);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).setMod(0.0);
                        ((TileEntitySafe)world.func_147438_o(x, y, z)).lock();
                        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(13), (IInventory)((TileEntitySafe)world.func_147438_o(x, y, z)), (int)(rand.nextInt(2) + 1));
                    }
                }
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned safe at " + x + " " + (y + 1) + " " + z);
                }
            }
            if (WorldConfig.meteorStructure > 0 && rand.nextInt(WorldConfig.meteorStructure) == 0) {
                int f;
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                CellularDungeonFactory.meteor.generate(world, x, 10, z, rand);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned meteor dungeon at " + x + " 10 " + z);
                }
                y = world.func_72976_f(x, z);
                for (f = 0; f < 3; ++f) {
                    world.func_147449_b(x, y + f, z, ModBlocks.meteor_pillar);
                }
                world.func_147449_b(x, y + 3, z, ModBlocks.meteor_brick_chiseled);
                for (f = 0; f < 10; ++f) {
                    x = i + rand.nextInt(65) - 32;
                    if (!world.func_147439_a(x, (y = world.func_72976_f(x, z = j + rand.nextInt(65) - 32)) - 1, z).canPlaceTorchOnTop(world, x, y - 1, z)) continue;
                    world.func_147465_d(x, y, z, Blocks.field_150465_bP, 1, 2);
                    TileEntitySkull skull = (TileEntitySkull)world.func_147438_o(x, y, z);
                    if (skull == null) continue;
                    skull.func_145903_a(rand.nextInt(16));
                }
            }
            if ((biome == BiomeGenBase.field_76782_w || biome == BiomeGenBase.field_150574_L || biome == BiomeGenBase.field_76792_x) && WorldConfig.jungleStructure > 0 && rand.nextInt(WorldConfig.jungleStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                CellularDungeonFactory.jungle.generate(world, x, 20, z, world.field_73012_v);
                CellularDungeonFactory.jungle.generate(world, x, 24, z, world.field_73012_v);
                CellularDungeonFactory.jungle.generate(world, x, 28, z, world.field_73012_v);
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Successfully spawned jungle dungeon at " + x + " 10 " + z);
                }
                y = world.func_72976_f(x, z);
                for (int f = 0; f < 3; ++f) {
                    world.func_147449_b(x, y + f, z, ModBlocks.deco_titanium);
                }
                world.func_147449_b(x, y + 3, z, Blocks.field_150451_bX);
            }
            if (WorldConfig.arcticStructure > 0 && rand.nextInt(WorldConfig.arcticStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = 16 + rand.nextInt(32);
                new ArcticVault().trySpawn(world, x, y, z);
            }
            if (WorldConfig.pyramidStructure > 0 && biome.field_76750_F >= 2.0f && !biome.func_76738_d() && rand.nextInt(WorldConfig.pyramidStructure) == 0) {
                x = i + rand.nextInt(16);
                z = j + rand.nextInt(16);
                y = world.func_72976_f(x, z);
                new AncientTomb().build(world, rand, x, y, z);
            }
        }
        if (rand.nextInt(25) == 0) {
            int randPosX = i + rand.nextInt(16);
            int randPosY = rand.nextInt(25);
            int randPosZ = j + rand.nextInt(16);
            OilBubble.spawnOil(world, randPosX, randPosY, randPosZ, 7 + rand.nextInt(9));
        }
        if (GeneralConfig.enableNITAN) {
            if (i <= 10000 && i + 16 >= 10000 && j <= 10000 && j + 16 >= 10000 && world.func_147439_a(10000, 250, 10000) == Blocks.field_150350_a) {
                world.func_147449_b(10000, 250, 10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(10000, 250, 10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(10000, 250, 10000)), (int)29);
                }
            }
            if (i <= 0 && i + 16 >= 0 && j <= 10000 && j + 16 >= 10000 && world.func_147439_a(0, 250, 10000) == Blocks.field_150350_a) {
                world.func_147449_b(0, 250, 10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(0, 250, 10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(0, 250, 10000)), (int)29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= 10000 && j + 16 >= 10000 && world.func_147439_a(-10000, 250, 10000) == Blocks.field_150350_a) {
                world.func_147449_b(-10000, 250, 10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(-10000, 250, 10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(-10000, 250, 10000)), (int)29);
                }
            }
            if (i <= 10000 && i + 16 >= 10000 && j <= 0 && j + 16 >= 0 && world.func_147439_a(10000, 250, 0) == Blocks.field_150350_a) {
                world.func_147449_b(10000, 250, 0, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(10000, 250, 0) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(10000, 250, 0)), (int)29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= 0 && j + 16 >= 0 && world.func_147439_a(-10000, 250, 0) == Blocks.field_150350_a) {
                world.func_147449_b(-10000, 250, 0, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(-10000, 250, 0) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(-10000, 250, 0)), (int)29);
                }
            }
            if (i <= 10000 && i + 16 >= 10000 && j <= -10000 && j + 16 >= -10000 && world.func_147439_a(10000, 250, -10000) == Blocks.field_150350_a) {
                world.func_147449_b(10000, 250, -10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(10000, 250, -10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(10000, 250, -10000)), (int)29);
                }
            }
            if (i <= 0 && i + 16 >= 0 && j <= -10000 && j + 16 >= -10000 && world.func_147439_a(0, 250, -10000) == Blocks.field_150350_a) {
                world.func_147449_b(0, 250, -10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(0, 250, -10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(0, 250, -10000)), (int)29);
                }
            }
            if (i <= -10000 && i + 16 >= -10000 && j <= -10000 && j + 16 >= -10000 && world.func_147439_a(-10000, 250, -10000) == Blocks.field_150350_a) {
                world.func_147449_b(-10000, 250, -10000, (Block)Blocks.field_150486_ae);
                if (world.func_147439_a(-10000, 250, -10000) == Blocks.field_150486_ae) {
                    WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.getLoot(9), (IInventory)((TileEntityChest)world.func_147438_o(-10000, 250, -10000)), (int)29);
                }
            }
        }
    }

    private void generateNether(World world, Random rand, int i, int j) {
        int y;
        int d;
        int z;
        int x;
        int k;
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherUraniumuSpawn, 6, 0, 127, ModBlocks.ore_nether_uranium, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherTungstenSpawn, 10, 0, 127, ModBlocks.ore_nether_tungsten, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherSulfurSpawn, 12, 0, 127, ModBlocks.ore_nether_sulfur, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherPhosphorusSpawn, 6, 0, 127, ModBlocks.ore_nether_fire, Blocks.field_150424_aL);
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherCoalSpawn, 32, 16, 96, ModBlocks.ore_nether_coal, Blocks.field_150424_aL);
        if (GeneralConfig.enablePlutoniumOre) {
            DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.netherPlutoniumSpawn, 4, 0, 127, ModBlocks.ore_nether_plutonium, Blocks.field_150424_aL);
        }
        for (k = 0; k < 30; ++k) {
            x = i + rand.nextInt(16);
            z = j + rand.nextInt(16);
            d = 16 + rand.nextInt(96);
            for (y = d - 5; y <= d; ++y) {
                if (world.func_147439_a(x, y + 1, z) != Blocks.field_150350_a || world.func_147439_a(x, y, z) != Blocks.field_150424_aL) continue;
                world.func_147449_b(x, y, z, ModBlocks.ore_nether_smoldering);
            }
        }
        for (k = 0; k < 1; ++k) {
            x = i + rand.nextInt(16);
            z = j + rand.nextInt(16);
            d = 16 + rand.nextInt(96);
            for (y = d - 5; y <= d; ++y) {
                if (world.func_147439_a(x, y + 1, z) != Blocks.field_150350_a || world.func_147439_a(x, y, z) != Blocks.field_150424_aL) continue;
                world.func_147449_b(x, y, z, ModBlocks.geysir_nether);
            }
        }
    }

    private void generateEnd(World world, Random rand, int i, int j) {
        DungeonToolbox.generateOre(world, rand, i, j, WorldConfig.endTikiteSpawn, 6, 0, 127, ModBlocks.ore_tikite, Blocks.field_150377_bs);
    }
}

