/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.interfaces.IHoldableWeapon;
import com.hbm.interfaces.IItemHUD;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.GunButtonPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ItemGunBase
extends Item
implements IHoldableWeapon,
IItemHUD {
    public GunConfiguration mainConfig;
    public GunConfiguration altConfig;
    @SideOnly(value=Side.CLIENT)
    public boolean m1;
    @SideOnly(value=Side.CLIENT)
    public boolean m2;

    public ItemGunBase(GunConfiguration config) {
        this.mainConfig = config;
        this.func_77625_d(1);
    }

    public ItemGunBase(GunConfiguration config, GunConfiguration alt) {
        this(config);
        this.altConfig = alt;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (entity instanceof EntityPlayer) {
            boolean bl = isCurrentItem = ((EntityPlayer)entity).func_70694_bm() == stack;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && world.field_72995_K) {
                this.updateClient(stack, world, (EntityPlayer)entity, slot, isCurrentItem);
            } else {
                this.updateServer(stack, world, (EntityPlayer)entity, slot, isCurrentItem);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClient(ItemStack stack, World world, EntityPlayer entity, int slot, boolean isCurrentItem) {
        if (!world.field_72995_K) {
            return;
        }
        boolean clickLeft = Mouse.isButtonDown((int)0);
        boolean clickRight = Mouse.isButtonDown((int)1);
        boolean left = this.m1;
        boolean right = this.m2;
        if (isCurrentItem) {
            if (left && right) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0));
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1));
                this.m1 = false;
                this.m2 = false;
            }
            if (left && !clickLeft) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0));
                this.m1 = false;
                this.endActionClient(stack, world, entity, true);
            }
            if (right && !clickRight) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1));
                this.m2 = false;
                this.endActionClient(stack, world, entity, false);
            }
            if ((this.mainConfig.reloadType != 0 || this.altConfig != null && this.altConfig.reloadType != 0) && Keyboard.isKeyDown((int)19) && (ItemGunBase.getMag(stack) < this.mainConfig.ammoCap || this.mainConfig.allowsInfinity && EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0)) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(true, 2));
                ItemGunBase.setIsReloading(stack, true);
                ItemGunBase.resetReloadCycle(stack);
            }
        }
    }

    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, boolean isCurrentItem) {
        if (ItemGunBase.getDelay(stack) > 0 && isCurrentItem) {
            ItemGunBase.setDelay(stack, ItemGunBase.getDelay(stack) - 1);
        }
        if (ItemGunBase.getIsMouseDown(stack) && player.func_70694_bm() != stack) {
            ItemGunBase.setIsMouseDown(stack, false);
        }
        if (ItemGunBase.getIsAltDown(stack) && !isCurrentItem) {
            ItemGunBase.setIsAltDown(stack, false);
        }
        if (GeneralConfig.enableGuns && this.mainConfig.firingMode == 1 && ItemGunBase.getIsMouseDown(stack) && this.tryShoot(stack, world, player, isCurrentItem)) {
            this.fire(stack, world, player);
            ItemGunBase.setDelay(stack, this.mainConfig.rateOfFire);
        }
        if (ItemGunBase.getIsReloading(stack) && isCurrentItem) {
            this.reload2(stack, world, player);
        }
    }

    protected boolean tryShoot(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (main && ItemGunBase.getDelay(stack) == 0 && !ItemGunBase.getIsReloading(stack) && ItemGunBase.getItemWear(stack) < this.mainConfig.durability) {
            return this.hasAmmo(stack, player, main);
        }
        if (!main && this.altConfig != null && ItemGunBase.getDelay(stack) == 0 && !ItemGunBase.getIsReloading(stack) && ItemGunBase.getItemWear(stack) < this.mainConfig.durability) {
            return this.hasAmmo(stack, player, false);
        }
        return false;
    }

    public boolean hasAmmo(ItemStack stack, EntityPlayer player, boolean main) {
        if (this.mainConfig.reloadType == 0 || !main) {
            return ItemGunBase.getBeltSize(player, ItemGunBase.getBeltType(player, stack, main)) > 0;
        }
        return ItemGunBase.getMag(stack) > 0;
    }

    protected void fire(ItemStack stack, World world, EntityPlayer player) {
        BulletConfiguration config = null;
        config = this.mainConfig.reloadType == 0 ? ItemGunBase.getBeltCfg(player, stack, true) : BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
        int bullets = config.bulletsMin;
        for (int k = 0; k < this.mainConfig.roundsPerCycle && this.hasAmmo(stack, player, true); ++k) {
            if (config.bulletsMax > config.bulletsMin) {
                bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
            }
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config));
            }
            this.useUpAmmo(player, stack, true);
            player.field_71069_bz.func_75142_b();
            int wear = (int)Math.ceil((float)config.wear / (1.0f + (float)EnchantmentHelper.func_77506_a((int)Enchantment.field_77347_r.field_77352_x, (ItemStack)stack)));
            ItemGunBase.setItemWear(stack, ItemGunBase.getItemWear(stack) + wear);
        }
        world.func_72956_a((Entity)player, this.mainConfig.firingSound, 1.0f, this.mainConfig.firingPitch);
        if (player.getDisplayName().equals("Vic4Games")) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("type", "justTilt");
            nbt.func_74768_a("time", this.mainConfig.rateOfFire + 1);
            PacketDispatcher.wrapper.sendTo((IMessage)new AuxParticlePacketNT(nbt, player.field_70165_t, player.field_70163_u, player.field_70161_v), (EntityPlayerMP)player);
        }
    }

    protected void altFire(ItemStack stack, World world, EntityPlayer player) {
        if (this.altConfig == null) {
            return;
        }
        BulletConfiguration config = ItemGunBase.getBeltCfg(player, stack, false);
        int bullets = config.bulletsMin;
        for (int k = 0; k < this.altConfig.roundsPerCycle; ++k) {
            if (config.bulletsMax > config.bulletsMin) {
                bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
            }
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config));
            }
            this.useUpAmmo(player, stack, false);
            player.field_71069_bz.func_75142_b();
            ItemGunBase.setItemWear(stack, ItemGunBase.getItemWear(stack) + config.wear);
        }
        world.func_72956_a((Entity)player, this.altConfig.firingSound, 1.0f, this.altConfig.firingPitch);
    }

    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config) {
        EntityBulletBase bullet = new EntityBulletBase(world, config, (EntityLivingBase)player);
        world.func_72838_d((Entity)bullet);
        if (this.mainConfig.animations.containsKey((Object)HbmAnimations.AnimType.CYCLE) && player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal()), (EntityPlayerMP)player);
        }
    }

    public void startAction(ItemStack stack, World world, EntityPlayer player, boolean main) {
        if (this.mainConfig.firingMode == 0 && main && this.tryShoot(stack, world, player, main)) {
            this.fire(stack, world, player);
            ItemGunBase.setDelay(stack, this.mainConfig.rateOfFire);
        }
        if (!main && this.altConfig != null && this.tryShoot(stack, world, player, main)) {
            this.altFire(stack, world, player);
            ItemGunBase.setDelay(stack, this.altConfig.rateOfFire);
        }
    }

    public void startActionClient(ItemStack stack, World world, EntityPlayer player, boolean main) {
    }

    public void endAction(ItemStack stack, World world, EntityPlayer player, boolean main) {
    }

    public void endActionClient(ItemStack stack, World world, EntityPlayer player, boolean main) {
    }

    protected void reload(ItemStack stack, World world, EntityPlayer player) {
        if (ItemGunBase.getReloadCycle(stack) < 0 && stack == player.func_70694_bm()) {
            if (ItemGunBase.getMag(stack) > 0) {
                BulletConfiguration bulletCfg = BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
                Item ammo = bulletCfg.ammo;
                int count = 1;
                if (this.mainConfig.reloadType == 1) {
                    count = this.mainConfig.ammoCap - ItemGunBase.getMag(stack);
                }
                if (count == 0) {
                    ItemGunBase.setIsReloading(stack, false);
                }
                for (int i = 0; i < count; ++i) {
                    if (ItemGunBase.getMag(stack) < this.mainConfig.ammoCap) {
                        if (!player.field_71071_by.func_146028_b(ammo)) {
                            ItemGunBase.setIsReloading(stack, false);
                            world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
                            break;
                        }
                        player.field_71071_by.func_146026_a(ammo);
                        ItemGunBase.setMag(stack, Math.min(ItemGunBase.getMag(stack) + bulletCfg.ammoCount, this.mainConfig.ammoCap));
                    }
                    if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
                        ItemGunBase.setIsReloading(stack, false);
                        world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
                        break;
                    }
                    ItemGunBase.resetReloadCycle(stack);
                }
            } else {
                BulletConfiguration bulletCfg = null;
                for (Integer config : this.mainConfig.config) {
                    BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
                    if (!player.field_71071_by.func_146028_b(cfg.ammo)) continue;
                    bulletCfg = cfg;
                    ItemGunBase.setMagType(stack, this.mainConfig.config.indexOf(config));
                    break;
                }
                if (bulletCfg != null) {
                    int count = 1;
                    if (this.mainConfig.reloadType == 1) {
                        count = this.mainConfig.ammoCap - ItemGunBase.getMag(stack);
                    }
                    for (int i = 0; i < count; ++i) {
                        if (ItemGunBase.getMag(stack) < this.mainConfig.ammoCap) {
                            if (!player.field_71071_by.func_146028_b(bulletCfg.ammo)) {
                                ItemGunBase.setIsReloading(stack, false);
                                world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
                                break;
                            }
                            player.field_71071_by.func_146026_a(bulletCfg.ammo);
                            ItemGunBase.setMag(stack, Math.min(ItemGunBase.getMag(stack) + bulletCfg.ammoCount, this.mainConfig.ammoCap));
                        }
                        if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
                            ItemGunBase.setIsReloading(stack, false);
                            world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
                            break;
                        }
                        ItemGunBase.resetReloadCycle(stack);
                    }
                }
            }
        } else {
            ItemGunBase.setReloadCycle(stack, ItemGunBase.getReloadCycle(stack) - 1);
        }
        if (stack != player.func_70694_bm()) {
            ItemGunBase.setReloadCycle(stack, 0);
            ItemGunBase.setIsReloading(stack, false);
        }
    }

    protected void reload2(ItemStack stack, World world, EntityPlayer player) {
        if (ItemGunBase.getMag(stack) >= this.mainConfig.ammoCap) {
            ItemGunBase.setIsReloading(stack, false);
            return;
        }
        if (ItemGunBase.getReloadCycle(stack) < 0) {
            if (ItemGunBase.getMag(stack) == 0) {
                this.resetAmmoType(stack, world, player);
            }
            int count = 1;
            if (this.mainConfig.reloadType == 1) {
                count = this.mainConfig.ammoCap - ItemGunBase.getMag(stack);
            }
            boolean hasLoaded = false;
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
            Item ammo = cfg.ammo;
            for (int i = 0; i < count; ++i) {
                if (!player.field_71071_by.func_146028_b(ammo) || ItemGunBase.getMag(stack) >= this.mainConfig.ammoCap) {
                    ItemGunBase.setIsReloading(stack, false);
                    break;
                }
                player.field_71071_by.func_146026_a(ammo);
                ItemGunBase.setMag(stack, Math.min(ItemGunBase.getMag(stack) + cfg.ammoCount, this.mainConfig.ammoCap));
                hasLoaded = true;
            }
            if (ItemGunBase.getMag(stack) >= this.mainConfig.ammoCap) {
                ItemGunBase.setIsReloading(stack, false);
            } else {
                ItemGunBase.resetReloadCycle(stack);
            }
            if (hasLoaded && this.mainConfig.reloadSoundEnd) {
                world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
            }
        } else {
            ItemGunBase.setReloadCycle(stack, ItemGunBase.getReloadCycle(stack) - 1);
        }
        if (stack != player.func_70694_bm()) {
            ItemGunBase.setReloadCycle(stack, 0);
            ItemGunBase.setIsReloading(stack, false);
        }
    }

    public void startReloadAction(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af() && this.mainConfig.allowsInfinity && EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0) {
            if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
                ItemGunBase.setMag(stack, 0);
                this.resetAmmoType(stack, world, player);
                player.func_85030_a("block.pistonOut", 1.0f, 1.0f);
            }
            return;
        }
        if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
            return;
        }
        if (ItemGunBase.getIsReloading(stack)) {
            return;
        }
        if (!this.mainConfig.reloadSoundEnd) {
            world.func_72956_a((Entity)player, this.mainConfig.reloadSound, 1.0f, 1.0f);
        }
        if (!world.field_72995_K) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.RELOAD.ordinal()), (EntityPlayerMP)player);
        }
        ItemGunBase.setIsReloading(stack, true);
        ItemGunBase.resetReloadCycle(stack);
    }

    public boolean canReload(ItemStack stack, World world, EntityPlayer player) {
        if (ItemGunBase.getMag(stack) == 0) {
            for (Integer config : this.mainConfig.config) {
                BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
                if (!player.field_71071_by.func_146028_b(cfg.ammo)) continue;
                return true;
            }
        } else {
            Item ammo = BulletConfigSyncingUtil.pullConfig((int)this.mainConfig.config.get((int)ItemGunBase.getMagType((ItemStack)stack)).intValue()).ammo;
            if (player.field_71071_by.func_146028_b(ammo)) {
                return true;
            }
        }
        return false;
    }

    protected void resetAmmoType(ItemStack stack, World world, EntityPlayer player) {
        for (Integer config : this.mainConfig.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!player.field_71071_by.func_146028_b(cfg.ammo)) continue;
            ItemGunBase.setMagType(stack, this.mainConfig.config.indexOf(config));
            break;
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        int dura;
        Item ammo2;
        Item ammo = BulletConfigSyncingUtil.pullConfig((int)this.mainConfig.config.get((int)ItemGunBase.getMagType((ItemStack)stack)).intValue()).ammo;
        if (this.mainConfig.ammoCap > 0) {
            list.add("Ammo: " + ItemGunBase.getMag(stack) + " / " + this.mainConfig.ammoCap);
        } else {
            list.add("Ammo: Belt");
        }
        list.add("Ammo Type: " + I18n.func_135052_a((String)(ammo.func_77658_a() + ".name"), (Object[])new Object[0]));
        if (this.altConfig != null && this.altConfig.ammoCap == 0 && ammo != (ammo2 = BulletConfigSyncingUtil.pullConfig((int)this.altConfig.config.get((int)0).intValue()).ammo)) {
            list.add("Secondary Ammo: " + I18n.func_135052_a((String)(ammo2.func_77658_a() + ".name"), (Object[])new Object[0]));
        }
        if ((dura = this.mainConfig.durability - ItemGunBase.getItemWear(stack)) < 0) {
            dura = 0;
        }
        list.add("Durability: " + dura + " / " + this.mainConfig.durability);
        list.add("");
        list.add("Name: " + this.mainConfig.name);
        list.add("Manufacturer: " + this.mainConfig.manufacturer);
        if (!this.mainConfig.comment.isEmpty()) {
            list.add("");
            for (String s : this.mainConfig.comment) {
                list.add(EnumChatFormatting.ITALIC + s);
            }
        }
        if (GeneralConfig.enableExtendedLogging) {
            list.add("");
            list.add("Type: " + ItemGunBase.getMagType(stack));
            list.add("Is Reloading: " + ItemGunBase.getIsReloading(stack));
            list.add("Reload Cycle: " + ItemGunBase.getReloadCycle(stack));
            list.add("RoF Cooldown: " + ItemGunBase.getDelay(stack));
        }
    }

    public static Item getBeltType(EntityPlayer player, ItemStack stack, boolean main) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration guncfg = main ? gun.mainConfig : (gun.altConfig != null ? gun.altConfig : gun.mainConfig);
        Item ammo = BulletConfigSyncingUtil.pullConfig((int)guncfg.config.get((int)0).intValue()).ammo;
        for (Integer config : guncfg.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!player.field_71071_by.func_146028_b(cfg.ammo)) continue;
            ammo = cfg.ammo;
            break;
        }
        return ammo;
    }

    public static BulletConfiguration getBeltCfg(EntityPlayer player, ItemStack stack, boolean main) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration guncfg = main ? gun.mainConfig : (gun.altConfig != null ? gun.altConfig : gun.mainConfig);
        ItemGunBase.getBeltType(player, stack, main);
        for (Integer config : guncfg.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!player.field_71071_by.func_146028_b(cfg.ammo)) continue;
            return cfg;
        }
        return BulletConfigSyncingUtil.pullConfig(guncfg.config.get(0));
    }

    public static int getBeltSize(EntityPlayer player, Item ammo) {
        int amount = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != ammo) continue;
            amount += stack.field_77994_a;
        }
        return amount;
    }

    public void useUpAmmo(EntityPlayer player, ItemStack stack, boolean main) {
        if (!main && this.altConfig == null) {
            return;
        }
        GunConfiguration config = this.mainConfig;
        if (!main) {
            config = this.altConfig;
        }
        if (config.allowsInfinity && EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0) {
            return;
        }
        if (config.reloadType != 0) {
            ItemGunBase.setMag(stack, ItemGunBase.getMag(stack) - 1);
        } else {
            player.field_71071_by.func_146026_a(ItemGunBase.getBeltType(player, stack, main));
        }
    }

    public static void resetReloadCycle(ItemStack stack) {
        ItemGunBase.writeNBT(stack, "reload", ((ItemGunBase)stack.func_77973_b()).mainConfig.reloadDuration);
    }

    public static void setIsReloading(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isReloading", b ? 1 : 0);
    }

    public static boolean getIsReloading(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isReloading") == 1;
    }

    public static void setIsMouseDown(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isMouseDown", b ? 1 : 0);
    }

    public static boolean getIsMouseDown(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isMouseDown") == 1;
    }

    public static void setIsAltDown(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isAltDown", b ? 1 : 0);
    }

    public static boolean getIsAltDown(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isAltDown") == 1;
    }

    public static void setDelay(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "dlay", i);
    }

    public static int getDelay(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "dlay");
    }

    public static void setItemWear(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "wear", i);
    }

    public static int getItemWear(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "wear");
    }

    public static void setCycleAnim(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "cycle", i);
    }

    public static int getCycleAnim(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "cycle");
    }

    public static void setReloadCycle(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "reload", i);
    }

    public static int getReloadCycle(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "reload");
    }

    public static void setMag(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "magazine", i);
    }

    public static int getMag(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "magazine");
    }

    public static void setMagType(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "magazineType", i);
    }

    public static int getMagType(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "magazineType");
    }

    public static void writeNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a(key, value);
    }

    public static int readNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.field_77990_d.func_74762_e(key);
    }

    @Override
    public RenderScreenOverlay.Crosshair getCrosshair() {
        return this.mainConfig.crosshair;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration gcfg = gun.mainConfig;
        if (type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            BulletConfiguration bcfg = BulletConfigSyncingUtil.pullConfig(gun.mainConfig.config.get(ItemGunBase.getMagType(stack)));
            Item ammo = bcfg.ammo;
            int count = ItemGunBase.getMag(stack);
            int max = gcfg.ammoCap;
            boolean showammo = gcfg.showAmmo;
            if (gcfg.reloadType == 0) {
                ammo = ItemGunBase.getBeltType(player, stack, true);
                count = ItemGunBase.getBeltSize(player, ammo);
                max = -1;
            }
            int dura = ItemGunBase.getItemWear(stack) * 50 / gcfg.durability;
            RenderScreenOverlay.renderAmmo(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ammo, count, max, dura, showammo);
            if (gun.altConfig != null && gun.altConfig.reloadType == 0) {
                Item oldAmmo = ammo;
                ammo = ItemGunBase.getBeltType(player, stack, false);
                if (ammo != oldAmmo) {
                    count = ItemGunBase.getBeltSize(player, ammo);
                    RenderScreenOverlay.renderAmmoAlt(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ammo, count);
                }
            }
        }
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && GeneralConfig.enableCrosshairs) {
            event.setCanceled(true);
            if (!gcfg.hasSights || !player.func_70093_af()) {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, ((IHoldableWeapon)player.func_70694_bm().func_77973_b()).getCrosshair());
            } else {
                RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, RenderScreenOverlay.Crosshair.NONE);
            }
        }
    }
}

