/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.handler.MissileStruct;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemMissile;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class ItemCustomMissile
extends Item {
    public static ItemStack buildMissile(Item chip, Item warhead, Item fuselage, Item stability, Item thruster) {
        if (stability == null) {
            return ItemCustomMissile.buildMissile(new ItemStack(chip), new ItemStack(warhead), new ItemStack(fuselage), null, new ItemStack(thruster));
        }
        return ItemCustomMissile.buildMissile(new ItemStack(chip), new ItemStack(warhead), new ItemStack(fuselage), new ItemStack(stability), new ItemStack(thruster));
    }

    public static ItemStack buildMissile(ItemStack chip, ItemStack warhead, ItemStack fuselage, ItemStack stability, ItemStack thruster) {
        ItemStack missile = new ItemStack(ModItems.missile_custom);
        ItemCustomMissile.writeToNBT(missile, "chip", Item.func_150891_b((Item)chip.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "warhead", Item.func_150891_b((Item)warhead.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "fuselage", Item.func_150891_b((Item)fuselage.func_77973_b()));
        ItemCustomMissile.writeToNBT(missile, "thruster", Item.func_150891_b((Item)thruster.func_77973_b()));
        if (stability != null) {
            ItemCustomMissile.writeToNBT(missile, "stability", Item.func_150891_b((Item)stability.func_77973_b()));
        }
        return missile;
    }

    private static void writeToNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a(key, value);
    }

    public static int readFromNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d.func_74762_e(key);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        ItemMissile chip = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "chip"));
        ItemMissile warhead = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "warhead"));
        ItemMissile fuselage = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "fuselage"));
        ItemMissile stability = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "stability"));
        ItemMissile thruster = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "thruster"));
        list.add(EnumChatFormatting.BOLD + "Warhead: " + EnumChatFormatting.GRAY + warhead.getWarhead((ItemMissile.WarheadType)((Object)warhead.attributes[0])));
        list.add(EnumChatFormatting.BOLD + "Strength: " + EnumChatFormatting.GRAY + (Float)warhead.attributes[1]);
        list.add(EnumChatFormatting.BOLD + "Fuel Type: " + EnumChatFormatting.GRAY + fuselage.getFuel((ItemMissile.FuelType)((Object)fuselage.attributes[0])));
        list.add(EnumChatFormatting.BOLD + "Fuel amount: " + EnumChatFormatting.GRAY + (Float)fuselage.attributes[1] + "l");
        list.add(EnumChatFormatting.BOLD + "Chip inaccuracy: " + EnumChatFormatting.GRAY + ((Float)chip.attributes[0]).floatValue() * 100.0f + "%");
        if (stability != null) {
            list.add(EnumChatFormatting.BOLD + "Fin inaccuracy: " + EnumChatFormatting.GRAY + ((Float)stability.attributes[0]).floatValue() * 100.0f + "%");
        } else {
            list.add(EnumChatFormatting.BOLD + "Fin inaccuracy: " + EnumChatFormatting.GRAY + "100%");
        }
        list.add(EnumChatFormatting.BOLD + "Size: " + EnumChatFormatting.GRAY + fuselage.getSize(fuselage.top) + "/" + fuselage.getSize(fuselage.bottom));
        float health = warhead.health + fuselage.health + thruster.health;
        if (stability != null) {
            health += stability.health;
        }
        list.add(EnumChatFormatting.BOLD + "Health: " + EnumChatFormatting.GRAY + health + "HP");
    }

    public static MissileStruct getStruct(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemCustomMissile)) {
            return null;
        }
        ItemMissile warhead = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "warhead"));
        ItemMissile fuselage = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "fuselage"));
        ItemMissile stability = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "stability"));
        ItemMissile thruster = (ItemMissile)Item.func_150899_d((int)ItemCustomMissile.readFromNBT(stack, "thruster"));
        MissileStruct missile = new MissileStruct(warhead, fuselage, stability, thruster);
        return missile;
    }
}

