/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.entity.particle.EntitySSmokeFX;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.interfaces.IHoldableWeapon;
import com.hbm.items.ModItems;
import com.hbm.render.util.RenderScreenOverlay;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class GunFolly
extends Item
implements IHoldableWeapon {
    @Override
    public RenderScreenOverlay.Crosshair getCrosshair() {
        return RenderScreenOverlay.Crosshair.L_SPLIT;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int state = GunFolly.getState(stack);
        if (state == 0) {
            world.func_72956_a((Entity)player, "hbm:weapon.follyOpen", 1.0f, 1.0f);
            GunFolly.setState(stack, 1);
        } else if (state == 1) {
            if (player.field_71071_by.func_146028_b(ModItems.ammo_folly)) {
                world.func_72956_a((Entity)player, "hbm:weapon.follyReload", 1.0f, 1.0f);
                player.field_71071_by.func_146026_a(ModItems.ammo_folly);
                GunFolly.setState(stack, 2);
            } else {
                world.func_72956_a((Entity)player, "hbm:weapon.follyClose", 1.0f, 1.0f);
                GunFolly.setState(stack, 0);
            }
        } else if (state == 2) {
            world.func_72956_a((Entity)player, "hbm:weapon.follyClose", 1.0f, 1.0f);
            GunFolly.setState(stack, 3);
            GunFolly.setTimer(stack, 100);
        } else if (state == 3 && GunFolly.getTimer(stack) == 0) {
            GunFolly.setState(stack, 0);
            world.func_72956_a((Entity)player, "hbm:weapon.follyFire", 1.0f, 1.0f);
            double mult = 1.75;
            player.field_70159_w -= player.func_70040_Z().field_72450_a * mult;
            player.field_70181_x -= player.func_70040_Z().field_72448_b * mult;
            player.field_70179_y -= player.func_70040_Z().field_72449_c * mult;
            if (!world.field_72995_K) {
                EntityBulletBase bullet = new EntityBulletBase(world, BulletConfigSyncingUtil.TEST_CONFIG, (EntityLivingBase)player);
                world.func_72838_d((Entity)bullet);
                for (int i = 0; i < 25; ++i) {
                    EntitySSmokeFX flame = new EntitySSmokeFX(world);
                    flame.field_70159_w = player.func_70040_Z().field_72450_a;
                    flame.field_70181_x = player.func_70040_Z().field_72448_b;
                    flame.field_70179_y = player.func_70040_Z().field_72449_c;
                    flame.field_70165_t = player.field_70165_t + flame.field_70159_w + world.field_73012_v.nextGaussian() * 0.35;
                    flame.field_70163_u = player.field_70163_u + flame.field_70181_x + world.field_73012_v.nextGaussian() * 0.35 + (double)player.eyeHeight;
                    flame.field_70161_v = player.field_70161_v + flame.field_70179_y + world.field_73012_v.nextGaussian() * 0.35;
                    world.func_72838_d((Entity)flame);
                }
            }
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (GunFolly.getState(stack) == 3) {
            if (isCurrentItem) {
                int timer = GunFolly.getTimer(stack);
                if (timer > 0) {
                    if (--timer % 20 == 0 && timer != 0) {
                        world.func_72956_a(entity, "hbm:weapon.follyBuzzer", 1.0f, 1.0f);
                    }
                    if (timer == 0) {
                        world.func_72956_a(entity, "hbm:weapon.follyAquired", 1.0f, 1.0f);
                    }
                    GunFolly.setTimer(stack, timer);
                }
            } else {
                GunFolly.setTimer(stack, 100);
            }
        }
    }

    public static void setState(ItemStack stack, int i) {
        GunFolly.writeNBT(stack, "state", i);
    }

    public static int getState(ItemStack stack) {
        return GunFolly.readNBT(stack, "state");
    }

    public static void setTimer(ItemStack stack, int i) {
        GunFolly.writeNBT(stack, "timer", i);
    }

    public static int getTimer(ItemStack stack) {
        return GunFolly.readNBT(stack, "timer");
    }

    private static void writeNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a(key, value);
    }

    private static int readNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.field_77990_d.func_74762_e(key);
    }
}

