/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.hbm.handler.ToolAbility;
import com.hbm.handler.WeaponAbility;
import com.hbm.items.tool.IItemAbility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public class ItemToolAbility
extends ItemTool
implements IItemAbility {
    private EnumToolType toolType;
    private EnumRarity rarity = EnumRarity.common;
    protected float damage;
    protected double movement;
    private List<ToolAbility> breakAbility = new ArrayList(){
        {
            this.add(null);
        }
    };
    private List<WeaponAbility> hitAbility = new ArrayList<WeaponAbility>();

    public ItemToolAbility(float damage, double movement, Item.ToolMaterial material, EnumToolType type) {
        super(0.0f, material, type.blocks);
        this.damage = damage;
        this.movement = movement;
        this.toolType = type;
        this.setHarvestLevel(type.toString().toLowerCase(), material.func_77996_d());
    }

    public ItemToolAbility addBreakAbility(ToolAbility breakAbility) {
        this.breakAbility.add(breakAbility);
        return this;
    }

    public ItemToolAbility addHitAbility(WeaponAbility weaponAbility) {
        this.hitAbility.add(weaponAbility);
        return this;
    }

    public ItemToolAbility setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity != EnumRarity.common ? this.rarity : super.func_77613_e(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K && !this.hitAbility.isEmpty() && attacker instanceof EntityPlayer && this.canOperate(stack)) {
            for (WeaponAbility ability : this.hitAbility) {
                ability.onHit(attacker.field_70170_p, (EntityPlayer)attacker, (Entity)victim, this);
            }
        }
        stack.func_77972_a(2, attacker);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!world.field_72995_K && this.canHarvestBlock(block, stack) && this.getCurrentAbility(stack) != null && this.canOperate(stack)) {
            this.getCurrentAbility(stack).onDig(world, x, y, z, player, block, meta, this);
        }
        return false;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!this.canOperate(stack)) {
            return 1.0f;
        }
        if (this.toolType == null) {
            return super.getDigSpeed(stack, block, meta);
        }
        if (this.toolType.blocks.contains(block) || this.toolType.materials.contains(block.func_149688_o())) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        if (!this.canOperate(stack)) {
            return false;
        }
        if (this.getCurrentAbility(stack) instanceof ToolAbility.SilkAbility) {
            return true;
        }
        return this.getDigSpeed(stack, block, 0) > 1.0f;
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.damage, 0));
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.movement, 1));
        return multimap;
    }

    @Override
    public void breakExtraBlock(World world, int x, int y, int z, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        ItemStack stack = player.func_70694_bm();
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!this.canHarvestBlock(block, stack)) {
            return;
        }
        Block refBlock = world.func_147439_a(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        player.func_71045_bC().func_150999_a(world, block, x, y, z, (EntityPlayer)player);
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                block.func_149657_c(world, x, y, z, event.getExpToDrop());
            }
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack;
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if ((itemstack = player.func_71045_bC()) != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.getCurrentAbility(stack) != null ? true : super.func_77636_d(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        if (this.breakAbility.size() > 1) {
            list.add("Abilities: ");
            for (ToolAbility toolAbility : this.breakAbility) {
                if (toolAbility == null) continue;
                if (this.getCurrentAbility(stack) == toolAbility) {
                    list.add(" >" + EnumChatFormatting.GOLD + toolAbility.getFullName());
                    continue;
                }
                list.add("  " + EnumChatFormatting.GOLD + toolAbility.getFullName());
            }
            list.add("Right click to cycle through abilities!");
            list.add("Sneak-click to turn abilitty off!");
        }
        if (!this.hitAbility.isEmpty()) {
            list.add("Weapon modifiers: ");
            for (WeaponAbility weaponAbility : this.hitAbility) {
                list.add("  " + EnumChatFormatting.RED + weaponAbility.getFullName());
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K || this.breakAbility.size() < 2 || !this.canOperate(stack)) {
            return super.func_77659_a(stack, world, player);
        }
        int i = this.getAbility(stack);
        ++i;
        if (player.func_70093_af()) {
            i = 0;
        }
        this.setAbility(stack, i % this.breakAbility.size());
        while (this.getCurrentAbility(stack) != null && !this.getCurrentAbility(stack).isAllowed()) {
            player.func_146105_b(new ChatComponentText("[Ability ").func_150257_a((IChatComponent)new ChatComponentTranslation(this.getCurrentAbility(stack).getName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText(this.getCurrentAbility(stack).getExtension() + " is blacklisted!]")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            this.setAbility(stack, ++i % this.breakAbility.size());
        }
        if (this.getCurrentAbility(stack) != null) {
            player.func_146105_b(new ChatComponentText("[Enabled ").func_150257_a((IChatComponent)new ChatComponentTranslation(this.getCurrentAbility(stack).getName(), new Object[0])).func_150257_a((IChatComponent)new ChatComponentText(this.getCurrentAbility(stack).getExtension() + "]")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        } else {
            player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + "[Tool ability deactivated]"));
        }
        world.func_72956_a((Entity)player, "random.orb", 0.25f, this.getCurrentAbility(stack) == null ? 0.75f : 1.25f);
        return stack;
    }

    private ToolAbility getCurrentAbility(ItemStack stack) {
        int ability = this.getAbility(stack) % this.breakAbility.size();
        return this.breakAbility.get(ability);
    }

    private int getAbility(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.field_77990_d.func_74762_e("ability");
        }
        return 0;
    }

    private void setAbility(ItemStack stack, int ability) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("ability", ability);
    }

    protected boolean canOperate(ItemStack stack) {
        return true;
    }

    public static enum EnumToolType {
        PICKAXE(Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc})),
        AXE(Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151585_k, Material.field_151582_l}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP})),
        SHOVEL(Sets.newHashSet((Object[])new Material[]{Material.field_151571_B, Material.field_151595_p, Material.field_151578_c, Material.field_151597_y, Material.field_151596_z}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh})),
        MINER(Sets.newHashSet((Object[])new Material[]{Material.field_151577_b, Material.field_151573_f, Material.field_151574_g, Material.field_151576_e, Material.field_151571_B, Material.field_151595_p, Material.field_151578_c, Material.field_151597_y, Material.field_151596_z}));

        public Set<Material> materials = new HashSet<Material>();
        public Set<Block> blocks = new HashSet<Block>();

        private EnumToolType(Set<Material> materials) {
            this.materials = materials;
        }

        private EnumToolType(Set<Material> materials, Set<Block> blocks) {
            this.materials = materials;
            this.blocks = blocks;
        }
    }
}

