/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.interfaces.IItemHazard;
import com.hbm.main.MainRegistry;
import com.hbm.modules.ItemHazardModule;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemRBMKPellet
extends Item
implements IItemHazard {
    public String fullName = "";
    ItemHazardModule module;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] enrichmentOverlays;
    @SideOnly(value=Side.CLIENT)
    private IIcon xenonOverlay;

    public ItemRBMKPellet(String fullName) {
        this.fullName = fullName;
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(MainRegistry.controlTab);
        this.module = new ItemHazardModule();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < 10; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
        super.func_94581_a(p_94581_1_);
        this.enrichmentOverlays = new IIcon[5];
        for (int i = 0; i < this.enrichmentOverlays.length; ++i) {
            this.enrichmentOverlays[i] = p_94581_1_.func_94245_a("hbm:rbmk_pellet_overlay_e" + i);
        }
        this.xenonOverlay = p_94581_1_.func_94245_a("hbm:rbmk_pellet_overlay_xenon");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return this.hasXenon(meta) ? 3 : 2;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        list.add(EnumChatFormatting.ITALIC + this.fullName);
        list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "Pellet for recycling");
        int meta = this.rectify(stack.func_77960_j());
        switch (meta % 5) {
            case 0: {
                list.add(EnumChatFormatting.GOLD + "Brand New");
                break;
            }
            case 1: {
                list.add(EnumChatFormatting.YELLOW + "Barely Depleted");
                break;
            }
            case 2: {
                list.add(EnumChatFormatting.GREEN + "Moderately Depleted");
                break;
            }
            case 3: {
                list.add(EnumChatFormatting.DARK_GREEN + "Highly Depleted");
                break;
            }
            case 4: {
                list.add(EnumChatFormatting.DARK_GRAY + "Fully Depleted");
            }
        }
        if (this.hasXenon(meta)) {
            list.add(EnumChatFormatting.DARK_PURPLE + "High Xenon Poison");
        }
        this.updateModule(stack);
        this.module.addInformation(stack, player, list, bool);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        if (pass == 0) {
            return this.field_77791_bV;
        }
        if (pass == 2) {
            return this.xenonOverlay;
        }
        return this.enrichmentOverlays[this.rectify(meta) % 5];
    }

    private boolean hasXenon(int meta) {
        return this.rectify(meta) >= 5;
    }

    private int rectify(int meta) {
        return Math.abs(meta) % 10;
    }

    @Override
    public ItemHazardModule getModule() {
        return this.module;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean b) {
        if (entity instanceof EntityLivingBase) {
            this.updateModule(stack);
            this.module.applyEffects((EntityLivingBase)entity, stack.field_77994_a, i, b);
        }
    }

    public boolean onEntityItemUpdate(EntityItem item) {
        super.onEntityItemUpdate(item);
        this.updateModule(item.func_92059_d());
        return this.module.onEntityItemUpdate(item);
    }

    private void updateModule(ItemStack stack) {
        int index = stack.func_77960_j() % 5;
        float mod = (float)(index * index) / 5.0f;
        if (stack.func_77960_j() >= 5) {
            mod *= 10.0f;
            mod += 1.0f;
        }
        this.module.setMod(1.0f + mod);
    }
}

