/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBattery
extends Item
implements IBatteryItem {
    private long maxCharge;
    private long chargeRate;
    private long dischargeRate;

    public ItemBattery(long dura, long chargeRate, long dischargeRate) {
        this.maxCharge = dura;
        this.chargeRate = chargeRate;
        this.dischargeRate = dischargeRate;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        long charge = this.maxCharge;
        if (itemstack.func_77942_o()) {
            charge = this.getCharge(itemstack);
        }
        if (itemstack.func_77973_b() != ModItems.fusion_core && itemstack.func_77973_b() != ModItems.factory_core_titanium && itemstack.func_77973_b() != ModItems.factory_core_advanced && itemstack.func_77973_b() != ModItems.energy_core && itemstack.func_77973_b() != ModItems.dynosphere_desh && itemstack.func_77973_b() != ModItems.dynosphere_schrabidium && itemstack.func_77973_b() != ModItems.dynosphere_euphemium && itemstack.func_77973_b() != ModItems.dynosphere_dineutronium) {
            list.add("Energy stored: " + Library.getShortNumber(charge) + "/" + Library.getShortNumber(this.maxCharge) + "HE");
        } else {
            String charge1 = Library.getShortNumber(charge * 100L / this.maxCharge);
            list.add("Charge: " + charge1 + "%");
            list.add("(" + Library.getShortNumber(charge) + "/" + Library.getShortNumber(this.maxCharge) + "HE)");
        }
        list.add("Charge rate: " + Library.getShortNumber(this.chargeRate) + "HE/t");
        list.add("Discharge rate: " + Library.getShortNumber(this.dischargeRate) + "HE/t");
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        if (this == ModItems.battery_schrabidium) {
            return EnumRarity.rare;
        }
        if (this == ModItems.fusion_core || this == ModItems.factory_core_titanium || this == ModItems.factory_core_advanced || this == ModItems.energy_core || this == ModItems.dynosphere_desh || this == ModItems.dynosphere_schrabidium || this == ModItems.dynosphere_euphemium || this == ModItems.dynosphere_dineutronium) {
            return EnumRarity.uncommon;
        }
        return EnumRarity.common;
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") + i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.field_77990_d.func_74772_a("charge", stack.field_77990_d.func_74763_f("charge") - i);
            } else {
                stack.field_77990_d = new NBTTagCompound();
                stack.field_77990_d.func_74772_a("charge", this.maxCharge - i);
            }
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                return stack.field_77990_d.func_74763_f("charge");
            }
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", ((ItemBattery)stack.func_77973_b()).maxCharge);
            return stack.field_77990_d.func_74763_f("charge");
        }
        return 0L;
    }

    @Override
    public long getMaxCharge() {
        return this.maxCharge;
    }

    @Override
    public long getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public long getDischargeRate() {
        return this.dischargeRate;
    }

    public static ItemStack getEmptyBattery(Item item) {
        if (item instanceof ItemBattery) {
            ItemStack stack = new ItemStack(item);
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", 0L);
            return stack.func_77946_l();
        }
        return null;
    }

    public static ItemStack getFullBattery(Item item) {
        if (item instanceof ItemBattery) {
            ItemStack stack = new ItemStack(item);
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74772_a("charge", ((ItemBattery)item).getMaxCharge());
            return stack.func_77946_l();
        }
        return new ItemStack(item);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.getMaxCharge();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (this.chargeRate > 0L) {
            list.add(ItemBattery.getEmptyBattery(item));
        }
        if (this.dischargeRate > 0L) {
            list.add(ItemBattery.getFullBattery(item));
        }
    }
}

