/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IPartiallyFillable;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.render.model.ModelJetPack;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;

public abstract class JetpackBase
extends ItemArmorMod
implements IPartiallyFillable {
    private ModelJetPack model;
    public FluidTypeHandler.FluidType fuel;
    public int maxFuel;

    public JetpackBase(FluidTypeHandler.FluidType fuel, int maxFuel) {
        super(1, false, true, false, false);
        this.fuel = fuel;
        this.maxFuel = maxFuel;
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.LIGHT_PURPLE + I18nUtil.resolveKey(this.fuel.getUnlocalizedName(), new Object[0]) + ": " + JetpackBase.getFuel(itemstack) + "mB / " + this.maxFuel + "mB");
        list.add("");
        super.func_77624_a(itemstack, player, list, bool);
        list.add(EnumChatFormatting.GOLD + "Can be worn on its own!");
    }

    @Override
    public void addDesc(List list, ItemStack stack, ItemStack armor) {
        ItemStack jetpack = ArmorModHandler.pryMods(armor)[1];
        if (jetpack == null) {
            return;
        }
        list.add(EnumChatFormatting.RED + "  " + stack.func_82833_r() + " (" + I18nUtil.resolveKey(this.fuel.getUnlocalizedName(), new Object[0]) + ": " + JetpackBase.getFuel(jetpack) + "mB / " + this.maxFuel + "mB");
    }

    @Override
    public void modUpdate(EntityLivingBase entity, ItemStack armor) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        ItemStack jetpack = ArmorModHandler.pryMods(armor)[1];
        if (jetpack == null) {
            return;
        }
        this.onArmorTick(entity.field_70170_p, (EntityPlayer)entity, jetpack);
        ArmorModHandler.applyMod(armor, jetpack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void modRender(RenderPlayerEvent.SetArmorModel event, ItemStack armor) {
        ModelBiped modelJetpack = this.getArmorModel(event.entityLiving, null, 1);
        RenderPlayer renderer = event.renderer;
        ModelBiped model = renderer.field_77111_i;
        EntityPlayer player = event.entityPlayer;
        modelJetpack.field_78117_n = model.field_78117_n;
        float interp = event.partialRenderTick;
        float yawHead = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * interp;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * interp;
        float yaw = yawHead - yawOffset;
        float yawWrapped = MathHelper.func_76142_g((float)(yawHead - yawOffset));
        float pitch = player.field_70125_A;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.getArmorTexture(armor, event.entity, 1, null)));
        modelJetpack.func_78088_a((Entity)event.entityPlayer, 0.0f, 0.0f, yawWrapped, yaw, pitch, 0.0625f);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (armorSlot == 1) {
            if (this.model == null) {
                this.model = new ModelJetPack();
            }
            return this.model;
        }
        return null;
    }

    protected void useUpFuel(EntityPlayer player, ItemStack stack, int rate) {
        if (player.field_70173_aa % rate == 0) {
            JetpackBase.setFuel(stack, JetpackBase.getFuel(stack) - 1);
        }
    }

    public static int getFuel(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            return 0;
        }
        return stack.field_77990_d.func_74762_e("fuel");
    }

    public static void setFuel(ItemStack stack, int i) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("fuel", i);
    }

    @Override
    public FluidTypeHandler.FluidType getType(ItemStack stack) {
        return this.fuel;
    }

    @Override
    public int getFill(ItemStack stack) {
        return JetpackBase.getFuel(stack);
    }

    @Override
    public void setFill(ItemStack stack, int fill) {
        JetpackBase.setFuel(stack, fill);
    }

    @Override
    public int getMaxFill(ItemStack stack) {
        return this.maxFuel;
    }

    @Override
    public int getLoadSpeed(ItemStack stack) {
        return 10;
    }

    @Override
    public int getUnloadSpeed(ItemStack stack) {
        return 0;
    }
}

