/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.Multimap;
import com.hbm.handler.ArmorModHandler;
import com.hbm.interfaces.IItemHazard;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.modules.ItemHazardModule;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ItemModInsert
extends ItemArmorMod
implements IItemHazard {
    float damageMod;
    float projectileMod;
    float explosionMod;
    float speed;
    ItemHazardModule module = new ItemHazardModule();

    public ItemModInsert(int durability, float damageMod, float projectileMod, float explosionMod, float speed) {
        super(6, false, true, false, false);
        this.damageMod = damageMod;
        this.projectileMod = projectileMod;
        this.explosionMod = explosionMod;
        this.speed = speed;
        this.func_77656_e(durability);
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (this.damageMod != 1.0f) {
            list.add(EnumChatFormatting.RED + (this.damageMod < 1.0f ? "-" : "+") + Math.abs(Math.round((1.0f - this.damageMod) * 100.0f)) + "% damage");
        }
        if (this.projectileMod != 1.0f) {
            list.add(EnumChatFormatting.YELLOW + "-" + Math.round((1.0f - this.projectileMod) * 100.0f) + "% projectile damage");
        }
        if (this.explosionMod != 1.0f) {
            list.add(EnumChatFormatting.YELLOW + "-" + Math.round((1.0f - this.explosionMod) * 100.0f) + "% explosion damage");
        }
        if (this.speed != 1.0f) {
            list.add(EnumChatFormatting.BLUE + "-" + Math.round((1.0f - this.speed) * 100.0f) + "% speed");
        }
        if (this == ModItems.insert_polonium) {
            list.add(EnumChatFormatting.DARK_RED + "+100 RAD/s");
        }
        list.add(stack.func_77958_k() - stack.func_77960_j() + "/" + stack.func_77958_k() + "HP");
        list.add("");
        super.func_77624_a(stack, player, list, bool);
        this.module.addInformation(stack, player, list, bool);
    }

    @Override
    public void addDesc(List list, ItemStack stack, ItemStack armor) {
        ArrayList<String> desc = new ArrayList<String>();
        if (this.damageMod != 1.0f) {
            desc.add((this.damageMod < 1.0f ? "-" : "+") + Math.abs(Math.round((1.0f - this.damageMod) * 100.0f)) + "% dmg");
        }
        if (this.projectileMod != 1.0f) {
            desc.add("-" + Math.round((1.0f - this.projectileMod) * 100.0f) + "% proj");
        }
        if (this.explosionMod != 1.0f) {
            desc.add("-" + Math.round((1.0f - this.explosionMod) * 100.0f) + "% exp");
        }
        if (this.explosionMod != 1.0f) {
            desc.add("-" + Math.round((1.0f - this.speed) * 100.0f) + "% speed");
        }
        if (this == ModItems.insert_polonium) {
            desc.add("+100 RAD/s");
        }
        String join = String.join((CharSequence)" / ", desc);
        list.add(EnumChatFormatting.DARK_PURPLE + "  " + stack.func_82833_r() + " (" + join + " / " + (stack.func_77958_k() - stack.func_77960_j()) + "HP)");
    }

    @Override
    public void modDamage(LivingHurtEvent event, ItemStack armor) {
        ItemStack insert;
        event.ammount *= this.damageMod;
        if (event.source.func_76352_a()) {
            event.ammount *= this.projectileMod;
        }
        if (event.source.func_94541_c()) {
            event.ammount *= this.explosionMod;
        }
        if ((insert = ArmorModHandler.pryMods(armor)[6]) == null) {
            return;
        }
        insert.func_77964_b(insert.func_77960_j() + 1);
        if (!event.entity.field_70170_p.field_72995_K && this == ModItems.insert_era) {
            event.entity.field_70170_p.func_72885_a(event.entity, event.entity.field_70165_t, event.entity.field_70163_u - (double)event.entity.field_70129_M + (double)event.entity.field_70131_O * 0.5, event.entity.field_70161_v, 0.05f, false, false);
        }
        if (insert.func_77960_j() >= insert.func_77958_k()) {
            ArmorModHandler.removeMod(armor, 6);
        } else {
            ArmorModHandler.applyMod(armor, insert);
        }
    }

    @Override
    public void modUpdate(EntityLivingBase entity, ItemStack armor) {
        if (!entity.field_70170_p.field_72995_K && this == ModItems.insert_polonium) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 5.0f);
        }
    }

    @Override
    public Multimap getModifiers(ItemStack armor) {
        if (this.speed == 1.0f) {
            return null;
        }
        Multimap multimap = super.func_111205_h();
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ArmorModHandler.UUIDs[((ItemArmor)armor.func_77973_b()).field_77881_a], "NTM Armor Mod Speed", (double)(-1.0f + this.speed), 2));
        return multimap;
    }

    @Override
    public ItemHazardModule getModule() {
        return this.module;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int i, boolean b) {
        if (entity instanceof EntityLivingBase) {
            this.module.applyEffects((EntityLivingBase)entity, stack.field_77994_a, i, b);
        }
    }
}

