/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.lwjgl.opengl.GL11;

public class ArmorFSB
extends ItemArmor {
    private String texture = "";
    private ResourceLocation overlay = null;
    public List<PotionEffect> effects = new ArrayList<PotionEffect>();
    public HashMap<String, Float> resistance = new HashMap();
    public float blastProtection = -1.0f;
    public float damageCap = -1.0f;
    public float damageMod = -1.0f;
    public float damageThreshold = 0.0f;
    public boolean fireproof = false;
    public boolean noHelmet = false;
    public boolean vats = false;
    public boolean thermal = false;
    public boolean geigerSound = false;
    public boolean customGeiger = false;
    public boolean hardLanding = false;
    public double gravity = 0.0;
    public String step;
    public String jump;
    public String fall;

    public ArmorFSB(ItemArmor.ArmorMaterial material, int layer, int slot, String texture) {
        super(material, layer, slot);
        this.texture = texture;
    }

    public ArmorFSB addEffect(PotionEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ArmorFSB addResistance(String damage, float mod) {
        this.resistance.put(damage, Float.valueOf(mod));
        return this;
    }

    public ArmorFSB setCap(float cap) {
        this.damageCap = cap;
        return this;
    }

    public ArmorFSB setMod(float mod) {
        this.damageMod = mod;
        return this;
    }

    public ArmorFSB setThreshold(float threshold) {
        this.damageThreshold = threshold;
        return this;
    }

    public ArmorFSB setBlastProtection(float blastProtection) {
        this.blastProtection = blastProtection;
        return this;
    }

    public ArmorFSB setFireproof(boolean fire) {
        this.fireproof = fire;
        return this;
    }

    public ArmorFSB setNoHelmet(boolean noHelmet) {
        this.noHelmet = noHelmet;
        return this;
    }

    public ArmorFSB enableVATS(boolean vats) {
        this.vats = vats;
        return this;
    }

    public ArmorFSB enableThermalSight(boolean thermal) {
        this.thermal = thermal;
        return this;
    }

    public ArmorFSB setHasGeigerSound(boolean geiger) {
        this.geigerSound = geiger;
        return this;
    }

    public ArmorFSB setHasCustomGeiger(boolean geiger) {
        this.customGeiger = geiger;
        return this;
    }

    public ArmorFSB setHasHardLanding(boolean hardLanding) {
        this.hardLanding = hardLanding;
        return this;
    }

    public ArmorFSB setGravity(double gravity) {
        this.gravity = gravity;
        return this;
    }

    public ArmorFSB setStep(String step) {
        this.step = step;
        return this;
    }

    public ArmorFSB setJump(String jump) {
        this.jump = jump;
        return this;
    }

    public ArmorFSB setFall(String fall) {
        this.fall = fall;
        return this;
    }

    public ArmorFSB setOverlay(String path) {
        this.overlay = new ResourceLocation(path);
        return this;
    }

    public ArmorFSB cloneStats(ArmorFSB original) {
        this.effects = original.effects;
        this.resistance = original.resistance;
        this.damageCap = original.damageCap;
        this.damageMod = original.damageMod;
        this.damageThreshold = original.damageThreshold;
        this.blastProtection = original.blastProtection;
        this.fireproof = original.fireproof;
        this.noHelmet = original.noHelmet;
        this.vats = original.vats;
        this.thermal = original.thermal;
        this.geigerSound = original.geigerSound;
        this.customGeiger = original.customGeiger;
        this.hardLanding = original.hardLanding;
        this.gravity = original.gravity;
        this.step = original.step;
        this.jump = original.jump;
        this.fall = original.fall;
        return this;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        return this.texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("armor.fullSetBonus", new Object[0]));
        if (!this.effects.isEmpty()) {
            for (PotionEffect potionEffect : this.effects) {
                list.add(EnumChatFormatting.AQUA + "  " + I18n.func_135052_a((String)Potion.field_76425_a[potionEffect.func_76456_a()].func_76393_a(), (Object[])new Object[0]));
            }
        }
        if (!this.resistance.isEmpty()) {
            for (Map.Entry entry : this.resistance.entrySet()) {
                if (((Float)entry.getValue()).floatValue() != 0.0f) {
                    list.add(EnumChatFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.damageModifier", entry.getValue(), I18n.func_135052_a((String)((String)entry.getKey()), (Object[])new Object[0])));
                    continue;
                }
                list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.nullDamage", I18n.func_135052_a((String)((String)entry.getKey()), (Object[])new Object[0])));
            }
        }
        if (this.blastProtection != -1.0f) {
            list.add(EnumChatFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.blastProtection", Float.valueOf(this.blastProtection)));
        }
        if (this.damageCap != -1.0f) {
            list.add(EnumChatFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.cap", Float.valueOf(this.damageCap)));
        }
        if (this.damageMod != -1.0f) {
            list.add(EnumChatFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.modifier", Float.valueOf(this.damageMod)));
        }
        if (this.damageThreshold > 0.0f) {
            list.add(EnumChatFormatting.YELLOW + "  " + I18nUtil.resolveKey("armor.threshold", Float.valueOf(this.damageThreshold)));
        }
        if (this.fireproof) {
            list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.fireproof", new Object[0]));
        }
        if (this.geigerSound) {
            list.add(EnumChatFormatting.GOLD + "  " + I18nUtil.resolveKey("armor.geigerSound", new Object[0]));
        }
        if (this.customGeiger) {
            list.add(EnumChatFormatting.GOLD + "  " + I18nUtil.resolveKey("armor.geigerHUD", new Object[0]));
        }
        if (this.vats) {
            list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.vats", new Object[0]));
        }
        if (this.thermal) {
            list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.thermal", new Object[0]));
        }
        if (this.hardLanding) {
            list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.hardLanding", new Object[0]));
        }
        if (this.gravity != 0.0) {
            list.add(EnumChatFormatting.BLUE + "  " + I18nUtil.resolveKey("armor.gravity", this.gravity));
        }
    }

    public static boolean hasFSBArmor(EntityPlayer player) {
        ItemStack plate = player.field_71071_by.field_70460_b[2];
        if (plate != null && plate.func_77973_b() instanceof ArmorFSB) {
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            boolean noHelmet = chestplate.noHelmet;
            for (int i = 0; i < (noHelmet ? 3 : 4); ++i) {
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ArmorFSB)) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).func_82812_d() != chestplate.func_82812_d()) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).isArmorEnabled(armor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasFSBArmorIgnoreCharge(EntityPlayer player) {
        ItemStack plate = player.field_71071_by.field_70460_b[2];
        if (plate != null && plate.func_77973_b() instanceof ArmorFSB) {
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            boolean noHelmet = chestplate.noHelmet;
            for (int i = 0; i < (noHelmet ? 3 : 4); ++i) {
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ArmorFSB)) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).func_82812_d() == chestplate.func_82812_d()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void handleAttack(LivingAttackEvent event) {
        EntityPlayer player;
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor(player = (EntityPlayer)e)) {
            ItemStack plate = player.field_71071_by.field_70460_b[2];
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            if (chestplate.damageThreshold >= event.ammount && !event.source.func_76363_c()) {
                event.setCanceled(true);
            }
            if (chestplate.fireproof && event.source.func_76347_k()) {
                player.func_70066_B();
                event.setCanceled(true);
            }
            if (chestplate.resistance.get(event.source.func_76355_l()) != null && chestplate.resistance.get(event.source.func_76355_l()).floatValue() <= 0.0f) {
                event.setCanceled(true);
            }
        }
    }

    public void handleHurt(LivingHurtEvent event) {
        EntityPlayer player;
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor(player = (EntityPlayer)e)) {
            ArmorFSB chestplate = (ArmorFSB)player.field_71071_by.field_70460_b[2].func_77973_b();
            if (event.ammount < 100.0f) {
                if (!event.source.func_76363_c()) {
                    event.ammount -= chestplate.damageThreshold;
                }
                if (chestplate.damageMod != -1.0f) {
                    event.ammount *= chestplate.damageMod;
                }
                if (chestplate.resistance.get(event.source.func_76355_l()) != null) {
                    event.ammount *= chestplate.resistance.get(event.source.func_76355_l()).floatValue();
                }
                if (chestplate.blastProtection != -1.0f && event.source.func_94541_c()) {
                    event.ammount *= chestplate.blastProtection;
                }
                if (chestplate.damageCap != -1.0f) {
                    event.ammount = Math.min(event.ammount, chestplate.damageCap);
                }
            }
        }
    }

    public void handleTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (ArmorFSB.hasFSBArmor(player)) {
            ItemStack plate = player.field_71071_by.field_70460_b[2];
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            if (!chestplate.effects.isEmpty()) {
                for (PotionEffect i : chestplate.effects) {
                    player.func_70690_d(new PotionEffect(i.func_76456_a(), i.func_76459_b(), i.func_76458_c(), i.func_82720_e()));
                }
            }
            if (!player.field_71075_bZ.field_75100_b && !player.func_70090_H()) {
                player.field_70181_x -= chestplate.gravity;
            }
            if (chestplate.step != null && player.field_70170_p.field_72995_K && player.field_70122_E) {
                try {
                    int pz;
                    int py;
                    int px;
                    Block block;
                    Field nextStepDistance = ReflectionHelper.findField(Entity.class, (String[])new String[]{"nextStepDistance", "field_70150_b"});
                    Field distanceWalkedOnStepModified = ReflectionHelper.findField(Entity.class, (String[])new String[]{"distanceWalkedOnStepModified", "field_82151_R"});
                    if (player.getEntityData().func_74760_g("hfr_nextStepDistance") == 0.0f) {
                        player.getEntityData().func_74776_a("hfr_nextStepDistance", nextStepDistance.getFloat(player));
                    }
                    if ((block = player.field_70170_p.func_147439_a(px = MathHelper.func_76128_c((double)player.field_70165_t), py = MathHelper.func_76128_c((double)(player.field_70163_u - 0.2 - (double)player.field_70129_M)), pz = MathHelper.func_76128_c((double)player.field_70161_v))).func_149688_o() != Material.field_151579_a && player.getEntityData().func_74760_g("hfr_nextStepDistance") <= distanceWalkedOnStepModified.getFloat(player)) {
                        player.func_85030_a(chestplate.step, 1.0f, 1.0f);
                    }
                    player.getEntityData().func_74776_a("hfr_nextStepDistance", nextStepDistance.getFloat(player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void handleJump(EntityPlayer player) {
        if (ArmorFSB.hasFSBArmor(player)) {
            ArmorFSB chestplate = (ArmorFSB)player.field_71071_by.field_70460_b[2].func_77973_b();
            if (chestplate.jump != null) {
                player.func_85030_a(chestplate.jump, 1.0f, 1.0f);
            }
        }
    }

    public void handleFall(EntityPlayer player) {
        if (ArmorFSB.hasFSBArmor(player)) {
            ArmorFSB chestplate = (ArmorFSB)player.field_71071_by.field_70460_b[2].func_77973_b();
            if (chestplate.hardLanding && player.field_70143_R > 10.0f) {
                List entities = player.field_70170_p.func_72839_b((Entity)player, player.field_70121_D.func_72314_b(3.0, 0.0, 3.0));
                for (Entity e : entities) {
                    Vec3 vec = Vec3.func_72443_a((double)(player.field_70165_t - e.field_70165_t), (double)0.0, (double)(player.field_70161_v - e.field_70161_v));
                    if (!(vec.func_72433_c() < 3.0)) continue;
                    double intensity = 3.0 - vec.func_72433_c();
                    e.field_70159_w += vec.field_72450_a * intensity * -2.0;
                    e.field_70181_x += 0.1 * intensity;
                    e.field_70179_y += vec.field_72449_c * intensity * -2.0;
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_76348_h(), (float)(intensity * 10.0));
                }
            }
            if (chestplate.fall != null) {
                player.func_85030_a(chestplate.fall, 1.0f, 1.0f);
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer entity, ItemStack stack) {
        if (this.field_77881_a != 1) {
            return;
        }
        if (!ArmorFSB.hasFSBArmor(entity) || !this.geigerSound) {
            return;
        }
        if (world.func_82737_E() % 5L == 0L) {
            int x = ArmorFSB.check(world, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v);
            if (x > 0) {
                int r;
                ArrayList<Integer> list = new ArrayList<Integer>();
                if (x < 1) {
                    list.add(0);
                }
                if (x < 5) {
                    list.add(0);
                }
                if (x < 10) {
                    list.add(1);
                }
                if (x > 5 && x < 15) {
                    list.add(2);
                }
                if (x > 10 && x < 20) {
                    list.add(3);
                }
                if (x > 15 && x < 25) {
                    list.add(4);
                }
                if (x > 20 && x < 30) {
                    list.add(5);
                }
                if (x > 25) {
                    list.add(6);
                }
                if ((r = ((Integer)list.get(world.field_73012_v.nextInt(list.size()))).intValue()) > 0) {
                    world.func_72956_a((Entity)entity, "hbm:item.geiger" + r, 1.0f, 1.0f);
                }
            } else if (world.field_73012_v.nextInt(50) == 0) {
                world.func_72956_a((Entity)entity, "hbm:item.geiger" + (1 + world.field_73012_v.nextInt(1)), 1.0f, 1.0f);
            }
        }
    }

    public static int check(World world, int x, int y, int z) {
        RadiationSavedData data = RadiationSavedData.getData(world);
        Chunk chunk = world.func_72938_d(x, z);
        int rads = (int)Math.ceil(data.getRadNumFromCoord(chunk.field_76635_g, chunk.field_76647_h));
        return rads;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleOverlay(RenderGameOverlayEvent.Pre event, EntityPlayer player) {
    }

    public boolean isArmorEnabled(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (this.overlay == null) {
            return;
        }
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.overlay);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), -90.0, 0.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), -90.0, 1.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, -90.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

