/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCassette;
import com.hbm.items.machine.ItemChemistryTemplate;
import com.hbm.packet.ItemFolderPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GUIScreenTemplateFolder
extends GuiScreen {
    protected static final ResourceLocation texture = new ResourceLocation("hbm:textures/gui/gui_planner.png");
    protected static final ResourceLocation texture_journal = new ResourceLocation("hbm:textures/gui/gui_planner_journal.png");
    private boolean isJournal = false;
    protected int xSize = 176;
    protected int ySize = 229;
    protected int guiLeft;
    protected int guiTop;
    int currentPage = 0;
    List<ItemStack> allStacks = new ArrayList<ItemStack>();
    List<ItemStack> stacks = new ArrayList<ItemStack>();
    List<FolderButton> buttons = new ArrayList<FolderButton>();
    private GuiTextField search;

    public GUIScreenTemplateFolder(EntityPlayer player) {
        if (player.func_70694_bm() == null) {
            return;
        }
        if (player.func_70694_bm().func_77973_b() == ModItems.template_folder) {
            int i;
            for (Item i2 : MachineRecipes.stamps_plate) {
                this.allStacks.add(new ItemStack(i2));
            }
            for (Item i2 : MachineRecipes.stamps_wire) {
                this.allStacks.add(new ItemStack(i2));
            }
            for (Item i2 : MachineRecipes.stamps_circuit) {
                this.allStacks.add(new ItemStack(i2));
            }
            for (i = 1; i < ItemCassette.TrackType.values().length; ++i) {
                this.allStacks.add(new ItemStack(ModItems.siren_track, 1, i));
            }
            for (i = 1; i < FluidTypeHandler.FluidType.values().length; ++i) {
                if (FluidTypeHandler.FluidType.values()[i].hasNoContainer()) continue;
                this.allStacks.add(new ItemStack(ModItems.fluid_identifier, 1, i));
            }
            for (i = 0; i < AssemblerRecipes.recipeList.size(); ++i) {
                if (AssemblerRecipes.hidden.get(AssemblerRecipes.recipeList.get(i)) != null) continue;
                this.allStacks.add(new ItemStack(ModItems.assembly_template, 1, i));
            }
            for (i = 0; i < ItemChemistryTemplate.EnumChemistryTemplate.values().length; ++i) {
                this.allStacks.add(new ItemStack(ModItems.chemistry_template, 1, i));
            }
        } else {
            for (int i = 0; i < AssemblerRecipes.recipeList.size(); ++i) {
                if (AssemblerRecipes.hidden.get(AssemblerRecipes.recipeList.get(i)) == null || !AssemblerRecipes.hidden.get(AssemblerRecipes.recipeList.get(i)).contains(player.func_70694_bm().func_77973_b())) continue;
                this.allStacks.add(new ItemStack(ModItems.assembly_template, 1, i));
            }
            this.isJournal = true;
        }
        this.search(null);
    }

    private void search(String sub) {
        this.stacks.clear();
        this.currentPage = 0;
        if (sub == null || sub.isEmpty()) {
            this.stacks.addAll(this.allStacks);
            this.updateButtons();
            return;
        }
        sub = sub.toLowerCase();
        for (ItemStack stack : this.allStacks) {
            if (!stack.func_82833_r().toLowerCase().contains(sub)) continue;
            this.stacks.add(stack);
        }
        this.updateButtons();
    }

    int getPageCount() {
        return (int)Math.ceil((this.stacks.size() - 1) / 35);
    }

    public void func_73876_c() {
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        if (this.currentPage > this.getPageCount()) {
            this.currentPage = this.getPageCount();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GL11.glDisable((int)2896);
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GL11.glEnable((int)2896);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.updateButtons();
        Keyboard.enableRepeatEvents((boolean)true);
        this.search = new GuiTextField(this.field_146289_q, this.guiLeft + 61, this.guiTop + 213, 48, 12);
        this.search.func_146193_g(0xFFFFFF);
        this.search.func_146204_h(0xFFFFFF);
        this.search.func_146185_a(false);
        this.search.func_146203_f(100);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void updateButtons() {
        if (!this.buttons.isEmpty()) {
            this.buttons.clear();
        }
        for (int i = this.currentPage * 35; i < Math.min(this.currentPage * 35 + 35, this.stacks.size()); ++i) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 + 27 * (i % 5), this.guiTop + 26 + 27 * (int)Math.floor((double)i / 5.0) - this.currentPage * 27 * 7, this.stacks.get(i)));
        }
        if (this.currentPage != 0) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 - 18, this.guiTop + 26 + 81, 1, "Previous"));
        }
        if (this.currentPage != this.getPageCount()) {
            this.buttons.add(new FolderButton(this.guiLeft + 25 + 108 + 18, this.guiTop + 26 + 81, 2, "Next"));
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        System.out.println(i + " " + j);
        System.out.println(this.guiLeft + i + " " + (this.guiTop + j));
        if (i >= this.guiLeft + 45 && i < this.guiLeft + 117 && j >= this.guiTop + 211 && j < this.guiTop + 223) {
            this.search.func_146195_b(true);
        } else {
            this.search.func_146195_b(false);
        }
        try {
            for (FolderButton b : this.buttons) {
                if (!b.isMouseOnButton(i, j)) continue;
                b.executeAction();
            }
        }
        catch (Exception ex) {
            this.updateButtons();
        }
    }

    protected void drawGuiContainerForegroundLayer(int i, int j) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)(this.currentPage + 1 + "/" + (this.getPageCount() + 1)), (Object[])new Object[0]), this.guiLeft + this.xSize / 2 - this.field_146289_q.func_78256_a(I18n.func_135052_a((String)(this.currentPage + 1 + "/" + (this.getPageCount() + 1)), (Object[])new Object[0])) / 2, this.guiTop + 10, this.isJournal ? 0x404040 : 0xFFFFFF);
        for (FolderButton b : this.buttons) {
            if (!b.isMouseOnButton(i, j)) continue;
            b.drawString(i, j);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!this.isJournal) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        } else {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture_journal);
        }
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.search.func_146206_l()) {
            this.func_73729_b(this.guiLeft + 45, this.guiTop + 211, 176, 54, 72, 12);
        }
        for (FolderButton b : this.buttons) {
            b.drawButton(b.isMouseOnButton(i, j));
        }
        for (FolderButton b : this.buttons) {
            b.drawIcon(b.isMouseOnButton(i, j));
        }
        this.search.func_146194_f();
    }

    protected void func_73869_a(char p_73869_1_, int p_73869_2_) {
        if (this.search.func_146201_a(p_73869_1_, p_73869_2_)) {
            this.search(this.search.func_146179_b());
            return;
        }
        if (p_73869_2_ == 1 || p_73869_2_ == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    class FolderButton {
        int xPos;
        int yPos;
        int type;
        String info;
        ItemStack stack;

        public FolderButton(int x, int y, int t, String i) {
            this.xPos = x;
            this.yPos = y;
            this.type = t;
            this.info = i;
        }

        public FolderButton(int x, int y, ItemStack stack) {
            this.xPos = x;
            this.yPos = y;
            this.type = 0;
            this.info = stack.func_82833_r();
            this.stack = stack.func_77946_l();
        }

        public void updateButton(int mouseX, int mouseY) {
        }

        public boolean isMouseOnButton(int mouseX, int mouseY) {
            return this.xPos <= mouseX && this.xPos + 18 > mouseX && this.yPos < mouseY && this.yPos + 18 >= mouseY;
        }

        public void drawButton(boolean b) {
            if (!GUIScreenTemplateFolder.this.isJournal) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(texture_journal);
            }
            GUIScreenTemplateFolder.this.func_73729_b(this.xPos, this.yPos, b ? 194 : 176, this.type == 1 ? 18 : (this.type == 2 ? 36 : 0), 18, 18);
        }

        public void drawIcon(boolean b) {
            try {
                RenderHelper.func_74520_c();
                GL11.glDisable((int)2896);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.stack != null) {
                    if (this.stack.func_77973_b() == ModItems.assembly_template) {
                        field_146296_j.func_82406_b(GUIScreenTemplateFolder.this.field_146289_q, GUIScreenTemplateFolder.this.field_146297_k.func_110434_K(), AssemblerRecipes.getOutputFromTempate(this.stack), this.xPos + 1, this.yPos + 1);
                    } else if (this.stack.func_77973_b() == ModItems.chemistry_template) {
                        field_146296_j.func_82406_b(GUIScreenTemplateFolder.this.field_146289_q, GUIScreenTemplateFolder.this.field_146297_k.func_110434_K(), new ItemStack(ModItems.chemistry_icon, 1, this.stack.func_77960_j()), this.xPos + 1, this.yPos + 1);
                    } else {
                        field_146296_j.func_82406_b(GUIScreenTemplateFolder.this.field_146289_q, GUIScreenTemplateFolder.this.field_146297_k.func_110434_K(), this.stack, this.xPos + 1, this.yPos + 1);
                    }
                }
                GL11.glEnable((int)2896);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void drawString(int x, int y) {
            if (this.info == null || this.info.isEmpty()) {
                return;
            }
            if (this.stack != null) {
                GUIScreenTemplateFolder.this.func_146285_a(this.stack, x, y);
            } else {
                GUIScreenTemplateFolder.this.func_146283_a(Arrays.asList(this.info), x, y);
            }
        }

        public void executeAction() {
            GUIScreenTemplateFolder.this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.type == 0) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new ItemFolderPacket(this.stack.func_77946_l()));
            } else if (this.type == 1) {
                if (GUIScreenTemplateFolder.this.currentPage > 0) {
                    --GUIScreenTemplateFolder.this.currentPage;
                }
                GUIScreenTemplateFolder.this.updateButtons();
            } else if (this.type == 2) {
                if (GUIScreenTemplateFolder.this.currentPage < GUIScreenTemplateFolder.this.getPageCount()) {
                    ++GUIScreenTemplateFolder.this.currentPage;
                }
                GUIScreenTemplateFolder.this.updateButtons();
            }
        }
    }
}

