/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ShredderRecipes {
    public static HashMap<RecipesCommon.ComparableStack, ItemStack> shredderRecipes = new HashMap();
    public static HashMap<Object, Object> neiShredderRecipes;

    public static void registerShredder() {
        String[] names = OreDictionary.getOreNames();
        for (int i = 0; i < names.length; ++i) {
            ItemStack dust;
            ArrayList matches;
            String name = names[i];
            if (name == null || name.isEmpty() || (matches = OreDictionary.getOres((String)name)) == null || matches.isEmpty()) continue;
            if (name.length() > 5 && name.substring(0, 5).equals("ingot")) {
                dust = ShredderRecipes.getDustByName(name.substring(5));
                if (dust == null || dust.func_77973_b() == ModItems.scrap) continue;
                for (ItemStack stack : matches) {
                    shredderRecipes.put(new RecipesCommon.ComparableStack(stack), dust);
                }
                continue;
            }
            if (name.length() > 3 && name.substring(0, 3).equals("ore")) {
                dust = ShredderRecipes.getDustByName(name.substring(3));
                if (dust == null || dust.func_77973_b() == ModItems.scrap) continue;
                dust.field_77994_a = 2;
                for (ItemStack stack : matches) {
                    shredderRecipes.put(new RecipesCommon.ComparableStack(stack), dust);
                }
                continue;
            }
            if (name.length() > 5 && name.substring(0, 5).equals("block")) {
                dust = ShredderRecipes.getDustByName(name.substring(5));
                if (dust == null || dust.func_77973_b() == ModItems.scrap) continue;
                dust.field_77994_a = 9;
                for (ItemStack stack : matches) {
                    shredderRecipes.put(new RecipesCommon.ComparableStack(stack), dust);
                }
                continue;
            }
            if (name.length() > 3 && name.substring(0, 3).equals("gem")) {
                dust = ShredderRecipes.getDustByName(name.substring(3));
                if (dust == null || dust.func_77973_b() == ModItems.scrap) continue;
                for (ItemStack stack : matches) {
                    shredderRecipes.put(new RecipesCommon.ComparableStack(stack), dust);
                }
                continue;
            }
            if (name.length() <= 3 || !name.substring(0, 4).equals("dust")) continue;
            for (ItemStack stack : matches) {
                shredderRecipes.put(new RecipesCommon.ComparableStack(stack), new ItemStack(ModItems.dust));
            }
        }
    }

    public static void registerOverrides() {
        ShredderRecipes.setRecipe(ModItems.scrap, new ItemStack(ModItems.dust));
        ShredderRecipes.setRecipe(ModItems.dust, new ItemStack(ModItems.dust));
        ShredderRecipes.setRecipe(Blocks.field_150426_aN, new ItemStack(Items.field_151114_aO, 4));
        ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150371_ca, 1, 0), new ItemStack(ModItems.powder_quartz, 4));
        ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150371_ca, 1, 1), new ItemStack(ModItems.powder_quartz, 4));
        ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150371_ca, 1, 2), new ItemStack(ModItems.powder_quartz, 4));
        ShredderRecipes.setRecipe(Blocks.field_150370_cb, new ItemStack(ModItems.powder_quartz, 3));
        ShredderRecipes.setRecipe(new ItemStack((Block)Blocks.field_150333_U, 1, 7), new ItemStack(ModItems.powder_quartz, 2));
        ShredderRecipes.setRecipe(Items.field_151128_bU, new ItemStack(ModItems.powder_quartz));
        ShredderRecipes.setRecipe(Blocks.field_150449_bY, new ItemStack(ModItems.powder_quartz, 2));
        ShredderRecipes.setRecipe(ModBlocks.ore_nether_fire, new ItemStack(ModItems.powder_fire, 6));
        ShredderRecipes.setRecipe(Blocks.field_150403_cj, new ItemStack(ModItems.powder_ice, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_light, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(ModBlocks.concrete, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.concrete_smooth, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete_mossy, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete_cracked, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_concrete_broken, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.brick_obsidian, new ItemStack(ModBlocks.gravel_obsidian, 1));
        ShredderRecipes.setRecipe(Blocks.field_150343_Z, new ItemStack(ModBlocks.gravel_obsidian, 1));
        ShredderRecipes.setRecipe(Blocks.field_150348_b, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(ModBlocks.ore_oil_empty, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(Blocks.field_150347_e, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(Blocks.field_150417_aV, new ItemStack(Blocks.field_150351_n, 1));
        ShredderRecipes.setRecipe(Blocks.field_150351_n, new ItemStack((Block)Blocks.field_150354_m, 1));
        ShredderRecipes.setRecipe((Block)Blocks.field_150354_m, new ItemStack(ModItems.dust, 2));
        ShredderRecipes.setRecipe(Blocks.field_150336_V, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(Blocks.field_150389_bf, new ItemStack(Items.field_151119_aD, 3));
        ShredderRecipes.setRecipe(Items.field_151162_bE, new ItemStack(Items.field_151119_aD, 3));
        ShredderRecipes.setRecipe(Items.field_151118_aC, new ItemStack(Items.field_151119_aD, 1));
        ShredderRecipes.setRecipe(Blocks.field_150322_A, new ItemStack((Block)Blocks.field_150354_m, 4));
        ShredderRecipes.setRecipe(Blocks.field_150372_bz, new ItemStack((Block)Blocks.field_150354_m, 6));
        ShredderRecipes.setRecipe(Blocks.field_150435_aG, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(Blocks.field_150405_ch, new ItemStack(Items.field_151119_aD, 4));
        ShredderRecipes.setRecipe(Blocks.field_150335_W, new ItemStack(Items.field_151016_H, 5));
        ShredderRecipes.setRecipe(ModBlocks.stone_gneiss, new ItemStack(ModItems.powder_lithium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.powder_lapis, new ItemStack(ModItems.powder_cobalt_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_neodymium, new ItemStack(ModItems.powder_neodymium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_cobalt, new ItemStack(ModItems.powder_cobalt_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_niobium, new ItemStack(ModItems.powder_niobium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_cerium, new ItemStack(ModItems.powder_cerium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_lanthanium, new ItemStack(ModItems.powder_lanthanium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_actinium, new ItemStack(ModItems.powder_actinium_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_boron, new ItemStack(ModItems.powder_boron_tiny, 1));
        ShredderRecipes.setRecipe(ModItems.fragment_meteorite, new ItemStack(ModItems.powder_meteorite_tiny, 1));
        ShredderRecipes.setRecipe(ModBlocks.block_meteor, new ItemStack(ModItems.powder_meteorite, 10));
        ShredderRecipes.setRecipe((Item)Items.field_151134_bR, new ItemStack(ModItems.powder_magic, 1));
        ShredderRecipes.setRecipe(ModItems.arc_electrode_burnt, new ItemStack(ModItems.powder_coal, 1));
        ShredderRecipes.setRecipe(ModItems.arc_electrode_desh, new ItemStack(ModItems.powder_desh, 2));
        ShredderRecipes.setRecipe(ModBlocks.meteor_polished, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick_mossy, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick_cracked, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_brick_chiseled, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.meteor_pillar, new ItemStack(ModItems.powder_meteorite, 1));
        ShredderRecipes.setRecipe(ModBlocks.ore_rare, new ItemStack(ModItems.powder_desh_mix, 1));
        ShredderRecipes.setRecipe(Blocks.field_150482_ag, new ItemStack(ModBlocks.gravel_diamond, 2));
        ShredderRecipes.setRecipe(ModBlocks.boxcar, new ItemStack(ModItems.powder_steel, 32));
        ShredderRecipes.setRecipe(ModItems.ingot_schrabidate, new ItemStack(ModItems.powder_schrabidate, 1));
        ShredderRecipes.setRecipe(ModBlocks.block_schrabidate, new ItemStack(ModItems.powder_schrabidate, 9));
        ShredderRecipes.setRecipe(ModItems.coal_infernal, new ItemStack(ModItems.powder_coal, 3));
        ShredderRecipes.setRecipe(Items.field_151120_aE, new ItemStack(Items.field_151121_aF, 3));
        ShredderRecipes.setRecipe(ModItems.ingot_schraranium, new ItemStack(ModItems.nugget_schrabidium, 2));
        ShredderRecipes.setRecipe(ModItems.crystal_coal, new ItemStack(ModItems.powder_coal, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_iron, new ItemStack(ModItems.powder_iron, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_gold, new ItemStack(ModItems.powder_gold, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_redstone, new ItemStack(Items.field_151137_ax, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_lapis, new ItemStack(ModItems.powder_lapis, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_diamond, new ItemStack(ModItems.powder_diamond, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_uranium, new ItemStack(ModItems.powder_uranium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_plutonium, new ItemStack(ModItems.powder_plutonium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_thorium, new ItemStack(ModItems.powder_thorium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_titanium, new ItemStack(ModItems.powder_titanium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_sulfur, new ItemStack(ModItems.sulfur, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_niter, new ItemStack(ModItems.niter, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_copper, new ItemStack(ModItems.powder_copper, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_tungsten, new ItemStack(ModItems.powder_tungsten, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_aluminium, new ItemStack(ModItems.powder_aluminium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_fluorite, new ItemStack(ModItems.fluorite, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_beryllium, new ItemStack(ModItems.powder_beryllium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_lead, new ItemStack(ModItems.powder_lead, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_schraranium, new ItemStack(ModItems.nugget_schrabidium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_schrabidium, new ItemStack(ModItems.powder_schrabidium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_rare, new ItemStack(ModItems.powder_desh_mix, 2));
        ShredderRecipes.setRecipe(ModItems.crystal_phosphorus, new ItemStack(ModItems.powder_fire, 8));
        ShredderRecipes.setRecipe(ModItems.crystal_trixite, new ItemStack(ModItems.powder_plutonium, 6));
        ShredderRecipes.setRecipe(ModItems.crystal_lithium, new ItemStack(ModItems.powder_lithium, 3));
        ShredderRecipes.setRecipe(ModItems.crystal_starmetal, new ItemStack(ModItems.powder_dura_steel, 6));
        ShredderRecipes.setRecipe(ModBlocks.steel_poles, new ItemStack(ModItems.powder_steel_tiny, 3));
        ShredderRecipes.setRecipe(ModBlocks.pole_top, new ItemStack(ModItems.powder_tungsten, 4));
        ShredderRecipes.setRecipe(ModBlocks.tape_recorder, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.pole_satellite_receiver, new ItemStack(ModItems.powder_steel, 5));
        ShredderRecipes.setRecipe(ModBlocks.steel_roof, new ItemStack(ModItems.powder_steel_tiny, 13));
        ShredderRecipes.setRecipe(ModBlocks.steel_wall, new ItemStack(ModItems.powder_steel_tiny, 13));
        ShredderRecipes.setRecipe(ModBlocks.steel_corner, new ItemStack(ModItems.powder_steel_tiny, 26));
        ShredderRecipes.setRecipe(ModBlocks.steel_beam, new ItemStack(ModItems.powder_steel_tiny, 3));
        ShredderRecipes.setRecipe(ModBlocks.steel_scaffold, new ItemStack(ModItems.powder_steel_tiny, 7));
        ShredderRecipes.setRecipe(ModItems.coil_copper, new ItemStack(ModItems.powder_red_copper, 1));
        ShredderRecipes.setRecipe(ModItems.coil_copper_torus, new ItemStack(ModItems.powder_red_copper, 2));
        ShredderRecipes.setRecipe(ModItems.coil_advanced_alloy, new ItemStack(ModItems.powder_advanced_alloy, 1));
        ShredderRecipes.setRecipe(ModItems.coil_advanced_torus, new ItemStack(ModItems.powder_advanced_alloy, 2));
        ShredderRecipes.setRecipe(ModItems.coil_gold, new ItemStack(ModItems.powder_gold, 1));
        ShredderRecipes.setRecipe(ModItems.coil_gold_torus, new ItemStack(ModItems.powder_gold, 2));
        ShredderRecipes.setRecipe(ModItems.coil_tungsten, new ItemStack(ModItems.powder_tungsten, 1));
        ShredderRecipes.setRecipe(ModItems.coil_magnetized_tungsten, new ItemStack(ModItems.powder_magnetized_tungsten, 1));
        ShredderRecipes.setRecipe(ModBlocks.crate_iron, new ItemStack(ModItems.powder_iron, 8));
        ShredderRecipes.setRecipe(ModBlocks.crate_steel, new ItemStack(ModItems.powder_steel, 8));
        ShredderRecipes.setRecipe(ModBlocks.crate_tungsten, new ItemStack(ModItems.powder_tungsten, 36));
        ShredderRecipes.setRecipe(Blocks.field_150467_bQ, new ItemStack(ModItems.powder_iron, 31));
        ShredderRecipes.setRecipe(ModBlocks.chain, new ItemStack(ModItems.powder_steel_tiny, 1));
        ShredderRecipes.setRecipe(ModBlocks.steel_grate, new ItemStack(ModItems.powder_steel_tiny, 3));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_marked, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_rim_marked, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_quad_marked, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_green, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_green_rusted, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_red, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.deco_pipe_framed_marked, new ItemStack(ModItems.powder_steel, 1));
        ShredderRecipes.setRecipe(ModBlocks.turret_light, new ItemStack(ModItems.powder_steel, 16));
        ShredderRecipes.setRecipe(ModBlocks.turret_heavy, new ItemStack(ModItems.powder_steel, 16));
        ShredderRecipes.setRecipe(ModBlocks.turret_flamer, new ItemStack(ModItems.powder_steel, 16));
        ShredderRecipes.setRecipe(ModBlocks.turret_rocket, new ItemStack(ModItems.powder_steel, 16));
        ShredderRecipes.setRecipe(ModBlocks.turret_cwis, new ItemStack(ModItems.powder_steel, 16));
        ShredderRecipes.setRecipe(ModBlocks.turret_tau, new ItemStack(ModItems.powder_steel, 16));
        ShredderRecipes.setRecipe(ModItems.turret_light_ammo, new ItemStack(Items.field_151016_H, 4));
        ShredderRecipes.setRecipe(ModItems.turret_heavy_ammo, new ItemStack(Items.field_151016_H, 4));
        ShredderRecipes.setRecipe(ModItems.turret_flamer_ammo, new ItemStack(Items.field_151016_H, 4));
        ShredderRecipes.setRecipe(ModItems.turret_rocket_ammo, new ItemStack(Items.field_151016_H, 4));
        ShredderRecipes.setRecipe(ModItems.turret_cwis_ammo, new ItemStack(Items.field_151016_H, 4));
        ShredderRecipes.setRecipe(ModItems.turret_tau_ammo, new ItemStack(ModItems.powder_uranium, 4));
        for (int i = 0; i < 16; ++i) {
            ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150406_ce, 1, i), new ItemStack(Items.field_151119_aD, 4));
            ShredderRecipes.setRecipe(new ItemStack(Blocks.field_150325_L, 1, i), new ItemStack(Items.field_151007_F, 4));
        }
    }

    public static ItemStack getDustByName(String name) {
        ArrayList matches = OreDictionary.getOres((String)("dust" + name));
        if (matches != null && !matches.isEmpty()) {
            return ((ItemStack)matches.get(0)).func_77946_l();
        }
        return new ItemStack(ModItems.scrap);
    }

    public static void setRecipe(Item in, ItemStack out) {
        shredderRecipes.put(new RecipesCommon.ComparableStack(in), out);
    }

    public static void setRecipe(Block in, ItemStack out) {
        shredderRecipes.put(new RecipesCommon.ComparableStack(in), out);
    }

    public static void setRecipe(ItemStack in, ItemStack out) {
        shredderRecipes.put(new RecipesCommon.ComparableStack(in), out);
    }

    public static Map<Object, Object> getShredderRecipes() {
        if (neiShredderRecipes == null) {
            neiShredderRecipes = new HashMap<RecipesCommon.ComparableStack, ItemStack>(shredderRecipes);
        }
        return neiShredderRecipes;
    }

    public static ItemStack getShredderResult(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return new ItemStack(ModItems.scrap);
        }
        ItemStack sta = shredderRecipes.get(new RecipesCommon.ComparableStack(stack).makeSingular());
        return sta == null ? new ItemStack(ModItems.scrap) : sta;
    }
}

