/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.Spaghetti;
import com.hbm.inventory.FluidContainer;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.FluidStack;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemChemistryTemplate;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.weapon.ItemGunBase;
import com.hbm.main.MainRegistry;
import com.hbm.util.EnchantmentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

@Spaghetti(value="everything")
public class MachineRecipes {
    public static List<Item> stamps_flat = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_flat);
            this.add(ModItems.stamp_iron_flat);
            this.add(ModItems.stamp_steel_flat);
            this.add(ModItems.stamp_titanium_flat);
            this.add(ModItems.stamp_obsidian_flat);
            this.add(ModItems.stamp_schrabidium_flat);
        }
    };
    public static List<Item> stamps_plate = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_plate);
            this.add(ModItems.stamp_iron_plate);
            this.add(ModItems.stamp_steel_plate);
            this.add(ModItems.stamp_titanium_plate);
            this.add(ModItems.stamp_obsidian_plate);
            this.add(ModItems.stamp_schrabidium_plate);
        }
    };
    public static List<Item> stamps_wire = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_wire);
            this.add(ModItems.stamp_iron_wire);
            this.add(ModItems.stamp_steel_wire);
            this.add(ModItems.stamp_titanium_wire);
            this.add(ModItems.stamp_obsidian_wire);
            this.add(ModItems.stamp_schrabidium_wire);
        }
    };
    public static List<Item> stamps_circuit = new ArrayList<Item>(){
        {
            this.add(ModItems.stamp_stone_circuit);
            this.add(ModItems.stamp_iron_circuit);
            this.add(ModItems.stamp_steel_circuit);
            this.add(ModItems.stamp_titanium_circuit);
            this.add(ModItems.stamp_obsidian_circuit);
            this.add(ModItems.stamp_schrabidium_circuit);
        }
    };

    public static MachineRecipes instance() {
        return new MachineRecipes();
    }

    public static ItemStack getFurnaceProcessingResult(ItemStack item, ItemStack item2) {
        return MachineRecipes.getFurnaceOutput(item, item2);
    }

    public static ItemStack getFurnaceOutput(ItemStack item, ItemStack item2) {
        if (item == null || item2 == null) {
            return null;
        }
        if (GeneralConfig.enableDebugMode && (item.func_77973_b() == Items.field_151042_j && item2.func_77973_b() == Items.field_151128_bU || item.func_77973_b() == Items.field_151128_bU && item2.func_77973_b() == Items.field_151042_j)) {
            return new ItemStack(ModBlocks.test_render, 1);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotTungsten", "dustTungsten"}) && MachineRecipes.mODE(item2, "gemCoal") || MachineRecipes.mODE(item, "gemCoal") && MachineRecipes.mODE(item2, new String[]{"ingotTungsten", "dustTungsten"})) {
            return new ItemStack(ModItems.neutron_reflector, 2);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotLead", "dustLead"}) && MachineRecipes.mODE(item2, new String[]{"ingotCopper", "dustCopper"}) || MachineRecipes.mODE(item, new String[]{"ingotCopper", "dustCopper"}) && MachineRecipes.mODE(item2, new String[]{"ingotLead", "dustLead"})) {
            return new ItemStack(ModItems.neutron_reflector, 4);
        }
        if (MachineRecipes.mODE(item, "plateLead") && MachineRecipes.mODE(item2, "plateCopper") || MachineRecipes.mODE(item, "plateCopper") && MachineRecipes.mODE(item2, "plateLead")) {
            return new ItemStack(ModItems.neutron_reflector, 1);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotIron", "dustIron"}) && MachineRecipes.mODE(item2, new String[]{"gemCoal", "dustCoal"}) || MachineRecipes.mODE(item, new String[]{"gemCoal", "dustCoal"}) && MachineRecipes.mODE(item2, new String[]{"ingotIron", "dustIron"})) {
            return new ItemStack(ModItems.ingot_steel, 2);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotCopper", "dustCopper"}) && item2.func_77973_b() == Items.field_151137_ax || item.func_77973_b() == Items.field_151137_ax && MachineRecipes.mODE(item2, new String[]{"ingotCopper", "dustCopper"})) {
            return new ItemStack(ModItems.ingot_red_copper, 2);
        }
        if (item.func_77973_b() == ModItems.canister_fuel && item2.func_77973_b() == Items.field_151123_aH || item.func_77973_b() == Items.field_151123_aH && item2.func_77973_b() == ModItems.canister_fuel) {
            return new ItemStack(ModItems.canister_napalm, 1);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotRedCopperAlloy", "dustRedCopperAlloy"}) && MachineRecipes.mODE(item2, new String[]{"ingotSteel", "dustSteel"}) || MachineRecipes.mODE(item, new String[]{"ingotSteel", "dustSteel"}) && MachineRecipes.mODE(item2, new String[]{"ingotRedCopperAlloy", "dustRedCopperAlloy"})) {
            return new ItemStack(ModItems.ingot_advanced_alloy, 2);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotTungsten", "dustTungsten"}) && MachineRecipes.mODE(item2, "nuggetSchrabidium") || MachineRecipes.mODE(item, "nuggetSchrabidium") && MachineRecipes.mODE(item2, new String[]{"ingotTungsten", "dustTungsten"})) {
            return new ItemStack(ModItems.ingot_magnetized_tungsten, 1);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotSteel", "dustSteel"}) && MachineRecipes.mODE(item2, new String[]{"nuggetTechnetium99", "tinyTc99"}) || MachineRecipes.mODE(item, new String[]{"nuggetTechnetium99", "tinyTc99"}) && MachineRecipes.mODE(item2, new String[]{"ingotSteel", "dustSteel"})) {
            return new ItemStack(ModItems.ingot_tcalloy, 1);
        }
        if (item.func_77973_b() == ModItems.plate_mixed && MachineRecipes.mODE(item2, "plateGold") || MachineRecipes.mODE(item, "plateGold") && item2.func_77973_b() == ModItems.plate_mixed) {
            return new ItemStack(ModItems.plate_paa, 2);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotSteel", "dustSteel"}) && MachineRecipes.mODE(item2, new String[]{"ingotTungsten", "dustTungsten"}) || MachineRecipes.mODE(item, new String[]{"ingotTungsten", "dustTungsten"}) && MachineRecipes.mODE(item2, new String[]{"ingotSteel", "dustSteel"})) {
            return new ItemStack(ModItems.ingot_dura_steel, 2);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotSteel", "dustSteel"}) && MachineRecipes.mODE(item2, new String[]{"ingotCobalt", "dustCobalt"}) || MachineRecipes.mODE(item, new String[]{"ingotCobalt", "dustCobalt"}) && MachineRecipes.mODE(item2, new String[]{"ingotSteel", "dustSteel"})) {
            return new ItemStack(ModItems.ingot_dura_steel, 2);
        }
        if (MachineRecipes.mODE(item, new String[]{"ingotSaturnite", "dustSaturnite"}) && item2.func_77973_b() == ModItems.powder_meteorite || item.func_77973_b() == ModItems.powder_meteorite && MachineRecipes.mODE(item2, new String[]{"ingotSaturnite", "dustSaturnite"})) {
            return new ItemStack(ModItems.ingot_starmetal, 2);
        }
        if (GeneralConfig.enableBabyMode && (MachineRecipes.mODE(item, new String[]{"gemCoal", "dustCoal"}) && item2.func_77973_b() == ModItems.canister_empty || item.func_77973_b() == ModItems.canister_empty && MachineRecipes.mODE(item2, new String[]{"gemCoal", "dustCoal"}))) {
            return new ItemStack(ModItems.canister_oil);
        }
        if (item.func_77973_b() == Item.func_150898_a((Block)ModBlocks.block_meteor) && MachineRecipes.mODE(item2, new String[]{"ingotCobalt", "dustCobalt"}) || MachineRecipes.mODE(item, new String[]{"ingotCobalt", "dustCobalt"}) && item2.func_77973_b() == Item.func_150898_a((Block)ModBlocks.block_meteor)) {
            return new ItemStack(ModItems.ingot_meteorite);
        }
        if (item.func_77973_b() == ModItems.meteorite_sword_hardened && MachineRecipes.mODE(item2, new String[]{"ingotCobalt", "dustCobalt"}) || MachineRecipes.mODE(item, new String[]{"ingotCobalt", "dustCobalt"}) && item2.func_77973_b() == ModItems.meteorite_sword_hardened) {
            return new ItemStack(ModItems.meteorite_sword_alloyed, 1);
        }
        if (item.func_77973_b() instanceof ItemGunBase && item2.func_77973_b() == Items.field_151134_bR) {
            ItemStack result = item.func_77946_l();
            Map mapright = EnchantmentHelper.func_82781_a((ItemStack)item2);
            Iterator itr = mapright.keySet().iterator();
            while (itr.hasNext()) {
                int i = (Integer)itr.next();
                int j = (Integer)mapright.get(i);
                Enchantment e = Enchantment.field_77331_b[i];
                EnchantmentUtil.removeEnchantment(result, e);
                EnchantmentUtil.addEnchantment(result, e, j);
            }
            return result;
        }
        return null;
    }

    public static List<GasCentOutput> getGasCentOutput(FluidTypeHandler.FluidType fluid) {
        ArrayList<GasCentOutput> list = new ArrayList<GasCentOutput>();
        switch (fluid) {
            case UF6: {
                list.add(new GasCentOutput(3, new ItemStack(ModItems.nugget_u238), 1));
                list.add(new GasCentOutput(3, new ItemStack(ModItems.nugget_u238), 2));
                list.add(new GasCentOutput(2, new ItemStack(ModItems.nugget_u238), 3));
                list.add(new GasCentOutput(1, new ItemStack(ModItems.nugget_u235), 4));
                return list;
            }
            case PUF6: {
                list.add(new GasCentOutput(1, new ItemStack(ModItems.nugget_pu238), 1));
                list.add(new GasCentOutput(2, new ItemStack(ModItems.nugget_pu238), 2));
                list.add(new GasCentOutput(6, new ItemStack(ModItems.nugget_pu_mix), 3));
                list.add(new GasCentOutput(6, new ItemStack(ModItems.nugget_pu_mix), 4));
                return list;
            }
            case WATZ: {
                list.add(new GasCentOutput(1, new ItemStack(ModItems.nugget_solinium), 1));
                list.add(new GasCentOutput(1, new ItemStack(ModItems.nugget_uranium), 1));
                list.add(new GasCentOutput(5, new ItemStack(ModItems.powder_lead), 1));
                list.add(new GasCentOutput(10, new ItemStack(ModItems.dust), 1));
                return list;
            }
            case SAS3: {
                list.add(new GasCentOutput(4, new ItemStack(ModItems.nugget_schrabidium), 1));
                list.add(new GasCentOutput(4, new ItemStack(ModItems.nugget_schrabidium), 2));
                list.add(new GasCentOutput(1, new ItemStack(ModItems.sulfur), 3));
                list.add(new GasCentOutput(1, new ItemStack(ModItems.sulfur), 4));
                return list;
            }
            case NITAN: {
                list.add(new GasCentOutput(1, new ItemStack(ModItems.powder_nitan_mix), 1));
                list.add(new GasCentOutput(1, new ItemStack(ModItems.powder_nitan_mix), 2));
                list.add(new GasCentOutput(1, new ItemStack(ModItems.powder_nitan_mix), 3));
                list.add(new GasCentOutput(1, new ItemStack(ModItems.powder_nitan_mix), 4));
                return list;
            }
        }
        return null;
    }

    public static int getFluidConsumedGasCent(FluidTypeHandler.FluidType fluid) {
        new ArrayList();
        switch (fluid) {
            case LAVA: {
                return 1000;
            }
            case UF6: {
                return 100;
            }
            case PUF6: {
                return 100;
            }
            case WATZ: {
                return 1000;
            }
            case SAS3: {
                return 100;
            }
            case COOLANT: {
                return 2000;
            }
            case CRYOGEL: {
                return 1000;
            }
            case NITAN: {
                return 500;
            }
        }
        return 100;
    }

    public static Object[] getBoilerOutput(FluidTypeHandler.FluidType type) {
        switch (type) {
            case WATER: {
                return new Object[]{FluidTypeHandler.FluidType.STEAM, 500, 5, 10000};
            }
            case STEAM: {
                return new Object[]{FluidTypeHandler.FluidType.HOTSTEAM, 5, 50, 30000};
            }
            case HOTSTEAM: {
                return new Object[]{FluidTypeHandler.FluidType.SUPERHOTSTEAM, 5, 50, 45000};
            }
            case OIL: {
                return new Object[]{FluidTypeHandler.FluidType.HOTOIL, 5, 5, 35000};
            }
        }
        return null;
    }

    public static Object[] getTurbineOutput(FluidTypeHandler.FluidType type) {
        switch (type) {
            case STEAM: {
                return new Object[]{FluidTypeHandler.FluidType.WATER, 5, 500, 50};
            }
            case HOTSTEAM: {
                return new Object[]{FluidTypeHandler.FluidType.STEAM, 50, 5, 100};
            }
            case SUPERHOTSTEAM: {
                return new Object[]{FluidTypeHandler.FluidType.HOTSTEAM, 50, 5, 150};
            }
            case ULTRAHOTSTEAM: {
                return new Object[]{FluidTypeHandler.FluidType.SUPERHOTSTEAM, 50, 5, 250};
            }
        }
        return null;
    }

    public static ItemStack getPressResultNN(ItemStack stamp, ItemStack input) {
        return MachineRecipes.getPressResult(input, stamp) == null ? new ItemStack(ModItems.nothing) : MachineRecipes.getPressResult(input, stamp);
    }

    public static ItemStack getPressResultNN(Item stamp, Item input) {
        return MachineRecipes.getPressResult(new ItemStack(input), new ItemStack(stamp)) == null ? new ItemStack(ModItems.nothing) : MachineRecipes.getPressResult(new ItemStack(input), new ItemStack(stamp));
    }

    public static ItemStack getPressResult(ItemStack input, ItemStack stamp) {
        if (input == null || stamp == null) {
            return null;
        }
        if (stamps_flat.contains(stamp.func_77973_b())) {
            if (MachineRecipes.mODE(input, "dustCoal")) {
                return new ItemStack(Items.field_151044_h);
            }
            if (MachineRecipes.mODE(input, "dustQuartz")) {
                return new ItemStack(Items.field_151128_bU);
            }
            if (MachineRecipes.mODE(input, "dustNetherQuartz")) {
                return new ItemStack(Items.field_151128_bU);
            }
            if (MachineRecipes.mODE(input, "dustLapis")) {
                return new ItemStack(Items.field_151100_aR, 1, 4);
            }
            if (MachineRecipes.mODE(input, "dustDiamond")) {
                return new ItemStack(Items.field_151045_i);
            }
            if (MachineRecipes.mODE(input, "dustEmerald")) {
                return new ItemStack(Items.field_151166_bC);
            }
            if (input.func_77973_b() == ModItems.pellet_coal) {
                return new ItemStack(Items.field_151045_i);
            }
            if (input.func_77973_b() == ModItems.biomass) {
                return new ItemStack(ModItems.biomass_compressed);
            }
            if (input.func_77973_b() == ModItems.powder_lignite) {
                return new ItemStack(ModItems.briquette_lignite);
            }
            if (input.func_77973_b() == ModItems.coke) {
                return new ItemStack(ModItems.ingot_graphite);
            }
            if (input.func_77973_b() == ModItems.meteorite_sword_reforged) {
                return new ItemStack(ModItems.meteorite_sword_hardened);
            }
        }
        if (stamps_plate.contains(stamp.func_77973_b())) {
            if (MachineRecipes.mODE(input, "ingotIron")) {
                return new ItemStack(ModItems.plate_iron);
            }
            if (MachineRecipes.mODE(input, "ingotGold")) {
                return new ItemStack(ModItems.plate_gold);
            }
            if (MachineRecipes.mODE(input, "ingotTitanium")) {
                return new ItemStack(ModItems.plate_titanium);
            }
            if (MachineRecipes.mODE(input, "ingotAluminum")) {
                return new ItemStack(ModItems.plate_aluminium);
            }
            if (MachineRecipes.mODE(input, "ingotSteel")) {
                return new ItemStack(ModItems.plate_steel);
            }
            if (MachineRecipes.mODE(input, "ingotLead")) {
                return new ItemStack(ModItems.plate_lead);
            }
            if (MachineRecipes.mODE(input, "ingotCopper")) {
                return new ItemStack(ModItems.plate_copper);
            }
            if (MachineRecipes.mODE(input, "ingotAdvanced")) {
                return new ItemStack(ModItems.plate_advanced_alloy);
            }
            if (MachineRecipes.mODE(input, "ingotAdvancedAlloy")) {
                return new ItemStack(ModItems.plate_advanced_alloy);
            }
            if (MachineRecipes.mODE(input, "ingotSchrabidium")) {
                return new ItemStack(ModItems.plate_schrabidium);
            }
            if (MachineRecipes.mODE(input, "ingotCMBSteel")) {
                return new ItemStack(ModItems.plate_combine_steel);
            }
            if (MachineRecipes.mODE(input, "ingotSaturnite")) {
                return new ItemStack(ModItems.plate_saturnite);
            }
        }
        if (stamps_wire.contains(stamp.func_77973_b())) {
            if (MachineRecipes.mODE(input, "ingotAluminum")) {
                return new ItemStack(ModItems.wire_aluminium, 8);
            }
            if (MachineRecipes.mODE(input, "ingotCopper")) {
                return new ItemStack(ModItems.wire_copper, 8);
            }
            if (MachineRecipes.mODE(input, "ingotTungsten")) {
                return new ItemStack(ModItems.wire_tungsten, 8);
            }
            if (MachineRecipes.mODE(input, "ingotRedCopperAlloy")) {
                return new ItemStack(ModItems.wire_red_copper, 8);
            }
            if (MachineRecipes.mODE(input, "ingotRedCopperAlloy")) {
                return new ItemStack(ModItems.wire_red_copper, 8);
            }
            if (MachineRecipes.mODE(input, "ingotGold")) {
                return new ItemStack(ModItems.wire_gold, 8);
            }
            if (MachineRecipes.mODE(input, "ingotSchrabidium")) {
                return new ItemStack(ModItems.wire_schrabidium, 8);
            }
            if (MachineRecipes.mODE(input, "ingotAdvanced")) {
                return new ItemStack(ModItems.wire_advanced_alloy, 8);
            }
            if (MachineRecipes.mODE(input, "ingotAdvancedAlloy")) {
                return new ItemStack(ModItems.wire_advanced_alloy, 8);
            }
            if (MachineRecipes.mODE(input, "ingotMagnetizedTungsten")) {
                return new ItemStack(ModItems.wire_magnetized_tungsten, 8);
            }
        }
        if (stamps_circuit.contains(stamp.func_77973_b())) {
            if (input.func_77973_b() == ModItems.circuit_raw) {
                return new ItemStack(ModItems.circuit_aluminium);
            }
            if (input.func_77973_b() == ModItems.circuit_bismuth_raw) {
                return new ItemStack(ModItems.circuit_bismuth);
            }
        }
        if (stamp.func_77973_b() == ModItems.stamp_357) {
            if (input.func_77973_b() == ModItems.assembly_iron) {
                return new ItemStack(ModItems.gun_revolver_iron_ammo);
            }
            if (input.func_77973_b() == ModItems.assembly_steel) {
                return new ItemStack(ModItems.gun_revolver_ammo);
            }
            if (input.func_77973_b() == ModItems.assembly_lead) {
                return new ItemStack(ModItems.gun_revolver_lead_ammo);
            }
            if (input.func_77973_b() == ModItems.assembly_gold) {
                return new ItemStack(ModItems.gun_revolver_gold_ammo);
            }
            if (input.func_77973_b() == ModItems.assembly_schrabidium) {
                return new ItemStack(ModItems.gun_revolver_schrabidium_ammo);
            }
            if (input.func_77973_b() == ModItems.assembly_nightmare) {
                return new ItemStack(ModItems.gun_revolver_nightmare_ammo);
            }
            if (input.func_77973_b() == ModItems.assembly_desh) {
                return new ItemStack(ModItems.ammo_357_desh);
            }
            if (MachineRecipes.mODE(input, "ingotSteel")) {
                return new ItemStack(ModItems.gun_revolver_cursed_ammo);
            }
        }
        if (stamp.func_77973_b() == ModItems.stamp_44 && input.func_77973_b() == ModItems.assembly_nopip) {
            return new ItemStack(ModItems.ammo_44);
        }
        if (stamp.func_77973_b() == ModItems.stamp_9) {
            if (input.func_77973_b() == ModItems.assembly_smg) {
                return new ItemStack(ModItems.ammo_9mm);
            }
            if (input.func_77973_b() == ModItems.assembly_uzi) {
                return new ItemStack(ModItems.ammo_22lr);
            }
            if (MachineRecipes.mODE(input, "ingotGold")) {
                return new ItemStack(ModItems.ammo_566_gold);
            }
            if (input.func_77973_b() == ModItems.assembly_lacunae) {
                return new ItemStack(ModItems.ammo_5mm);
            }
            if (input.func_77973_b() == ModItems.assembly_556) {
                return new ItemStack(ModItems.ammo_556);
            }
        }
        if (stamp.func_77973_b() == ModItems.stamp_50) {
            if (input.func_77973_b() == ModItems.assembly_calamity) {
                return new ItemStack(ModItems.ammo_50bmg);
            }
            if (input.func_77973_b() == ModItems.assembly_actionexpress) {
                return new ItemStack(ModItems.ammo_50ae);
            }
        }
        return null;
    }

    public static Map<Object[], Object> getPressRecipes() {
        HashMap<Object[], Object> recipes = new HashMap<Object[], Object>();
        ArrayList<ItemStack> i_stamps_flat = new ArrayList<ItemStack>();
        for (Item item : stamps_flat) {
            i_stamps_flat.add(new ItemStack(item));
        }
        ArrayList<ItemStack> i_stamps_plate = new ArrayList<ItemStack>();
        for (Item item : stamps_plate) {
            i_stamps_plate.add(new ItemStack(item));
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (Item item : stamps_wire) {
            arrayList.add(new ItemStack(item));
        }
        ArrayList<ItemStack> arrayList2 = new ArrayList<ItemStack>();
        for (Item i : stamps_circuit) {
            arrayList2.add(new ItemStack(i));
        }
        ArrayList<ItemStack> arrayList3 = new ArrayList<ItemStack>();
        arrayList3.add(new ItemStack(ModItems.stamp_357));
        ArrayList<ItemStack> i_stamps_44 = new ArrayList<ItemStack>();
        i_stamps_44.add(new ItemStack(ModItems.stamp_44));
        ArrayList<ItemStack> i_stamps_9 = new ArrayList<ItemStack>();
        i_stamps_9.add(new ItemStack(ModItems.stamp_9));
        ArrayList<ItemStack> i_stamps_50 = new ArrayList<ItemStack>();
        i_stamps_50.add(new ItemStack(ModItems.stamp_50));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.powder_coal)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.powder_coal));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.powder_quartz)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.powder_quartz));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.powder_lapis)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.powder_lapis));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.powder_diamond)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.powder_diamond));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.powder_emerald)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.powder_emerald));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.pellet_coal)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.pellet_coal));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.biomass)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.biomass));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.powder_lignite)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.powder_lignite));
        recipes.put(new Object[]{i_stamps_flat, new ItemStack(ModItems.coke)}, MachineRecipes.getPressResultNN(stamps_flat.get(0), ModItems.coke));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(Items.field_151042_j)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), Items.field_151042_j));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(Items.field_151043_k)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), Items.field_151043_k));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_titanium)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_titanium));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_aluminium)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_aluminium));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_steel)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_steel));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_lead)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_lead));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_copper)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_copper));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_advanced_alloy)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_advanced_alloy));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_schrabidium)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_schrabidium));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_combine_steel)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_combine_steel));
        recipes.put(new Object[]{i_stamps_plate, new ItemStack(ModItems.ingot_saturnite)}, MachineRecipes.getPressResultNN(stamps_plate.get(0), ModItems.ingot_saturnite));
        recipes.put(new Object[]{arrayList, new ItemStack(ModItems.ingot_aluminium)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), ModItems.ingot_aluminium));
        recipes.put(new Object[]{arrayList, new ItemStack(ModItems.ingot_copper)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), ModItems.ingot_copper));
        recipes.put(new Object[]{arrayList, new ItemStack(ModItems.ingot_tungsten)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), ModItems.ingot_tungsten));
        recipes.put(new Object[]{arrayList, new ItemStack(ModItems.ingot_red_copper)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), ModItems.ingot_red_copper));
        recipes.put(new Object[]{arrayList, new ItemStack(Items.field_151043_k)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), Items.field_151043_k));
        recipes.put(new Object[]{arrayList, new ItemStack(ModItems.ingot_schrabidium)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), ModItems.ingot_schrabidium));
        recipes.put(new Object[]{arrayList, new ItemStack(ModItems.ingot_advanced_alloy)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), ModItems.ingot_advanced_alloy));
        recipes.put(new Object[]{arrayList, new ItemStack(ModItems.ingot_magnetized_tungsten)}, MachineRecipes.getPressResultNN(stamps_wire.get(0), ModItems.ingot_magnetized_tungsten));
        recipes.put(new Object[]{arrayList2, new ItemStack(ModItems.circuit_raw)}, MachineRecipes.getPressResultNN(stamps_circuit.get(0), ModItems.circuit_raw));
        recipes.put(new Object[]{arrayList2, new ItemStack(ModItems.circuit_bismuth_raw)}, MachineRecipes.getPressResultNN(stamps_circuit.get(0), ModItems.circuit_bismuth_raw));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.assembly_iron)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.assembly_iron));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.assembly_steel)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.assembly_steel));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.assembly_lead)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.assembly_lead));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.assembly_gold)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.assembly_gold));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.assembly_schrabidium)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.assembly_schrabidium));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.ingot_steel)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.ingot_steel));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.assembly_nightmare)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.assembly_nightmare));
        recipes.put(new Object[]{arrayList3, new ItemStack(ModItems.assembly_desh)}, MachineRecipes.getPressResultNN(((ItemStack)arrayList3.get(0)).func_77973_b(), ModItems.assembly_desh));
        recipes.put(new Object[]{i_stamps_44, new ItemStack(ModItems.assembly_nopip)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_44.get(0)).func_77973_b(), ModItems.assembly_nopip));
        recipes.put(new Object[]{i_stamps_9, new ItemStack(ModItems.assembly_smg)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_9.get(0)).func_77973_b(), ModItems.assembly_smg));
        recipes.put(new Object[]{i_stamps_9, new ItemStack(ModItems.assembly_uzi)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_9.get(0)).func_77973_b(), ModItems.assembly_uzi));
        recipes.put(new Object[]{i_stamps_9, new ItemStack(ModItems.assembly_lacunae)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_9.get(0)).func_77973_b(), ModItems.assembly_lacunae));
        recipes.put(new Object[]{i_stamps_9, new ItemStack(Items.field_151043_k)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_9.get(0)).func_77973_b(), Items.field_151043_k));
        recipes.put(new Object[]{i_stamps_9, new ItemStack(ModItems.assembly_556)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_9.get(0)).func_77973_b(), ModItems.assembly_556));
        recipes.put(new Object[]{i_stamps_50, new ItemStack(ModItems.assembly_actionexpress)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_50.get(0)).func_77973_b(), ModItems.assembly_actionexpress));
        recipes.put(new Object[]{i_stamps_50, new ItemStack(ModItems.assembly_calamity)}, MachineRecipes.getPressResultNN(((ItemStack)i_stamps_50.get(0)).func_77973_b(), ModItems.assembly_calamity));
        return recipes;
    }

    public static ItemStack getCyclotronOutput(ItemStack part, ItemStack item) {
        if (part == null || item == null) {
            return null;
        }
        if (part.func_77973_b() == ModItems.part_lithium) {
            if (item.func_77973_b() == ModItems.niter) {
                return new ItemStack(ModItems.fluorite, 1);
            }
            if (item.func_77973_b() == ModItems.powder_coal) {
                return new ItemStack(ModItems.fluorite, 1);
            }
            if (MachineRecipes.mODE(item, "dustIron")) {
                return new ItemStack(ModItems.powder_cobalt, 1);
            }
            if (MachineRecipes.mODE(item, "dustGold")) {
                return new ItemStack(ModItems.powder_lead, 1);
            }
            if (MachineRecipes.mODE(item, "dustNetherQuartz")) {
                return new ItemStack(ModItems.sulfur, 1);
            }
            if (MachineRecipes.mODE(item, "dustUranium")) {
                return new ItemStack(ModItems.powder_plutonium, 1);
            }
            if (MachineRecipes.mODE(item, "dustAluminum")) {
                return new ItemStack(ModItems.powder_quartz, 1);
            }
            if (MachineRecipes.mODE(item, "dustBeryllium")) {
                return new ItemStack(ModItems.powder_coal, 1);
            }
            if (item.func_77973_b() == ModItems.powder_schrabidium) {
                return new ItemStack(ModItems.powder_reiium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_lithium) {
                return new ItemStack(ModItems.powder_coal, 1);
            }
            if (item.func_77973_b() == ModItems.powder_iodine) {
                return new ItemStack(ModItems.powder_caesium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_thorium) {
                return new ItemStack(ModItems.powder_uranium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_caesium) {
                return new ItemStack(ModItems.powder_lanthanium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_reiium) {
                return new ItemStack(ModItems.powder_weidanium, 1);
            }
            if (MachineRecipes.mODE(item, "dustCobalt")) {
                return new ItemStack(ModItems.powder_copper, 1);
            }
            if (item.func_77973_b() == ModItems.powder_cerium) {
                return new ItemStack(ModItems.powder_neodymium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_actinium) {
                return new ItemStack(ModItems.powder_thorium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_lanthanium) {
                return new ItemStack(ModItems.powder_cerium, 1);
            }
        }
        if (part.func_77973_b() == ModItems.part_beryllium) {
            if (MachineRecipes.mODE(item, "dustSulfur")) {
                return new ItemStack(ModItems.powder_titanium, 1);
            }
            if (item.func_77973_b() == ModItems.fluorite) {
                return new ItemStack(ModItems.powder_aluminium, 1);
            }
            if (MachineRecipes.mODE(item, "dustIron")) {
                return new ItemStack(ModItems.powder_copper, 1);
            }
            if (MachineRecipes.mODE(item, "dustNetherQuartz")) {
                return new ItemStack(ModItems.powder_titanium, 1);
            }
            if (MachineRecipes.mODE(item, "dustTitanium")) {
                return new ItemStack(ModItems.powder_iron, 1);
            }
            if (MachineRecipes.mODE(item, "dustCopper")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (MachineRecipes.mODE(item, "dustTungsten")) {
                return new ItemStack(ModItems.powder_gold, 1);
            }
            if (MachineRecipes.mODE(item, "dustAluminum")) {
                return new ItemStack(ModItems.sulfur, 1);
            }
            if (MachineRecipes.mODE(item, "dustLead")) {
                return new ItemStack(ModItems.powder_astatine, 1);
            }
            if (MachineRecipes.mODE(item, "dustBeryllium")) {
                return new ItemStack(ModItems.niter, 1);
            }
            if (MachineRecipes.mODE(item, "dustLithium")) {
                return new ItemStack(ModItems.niter, 1);
            }
            if (item.func_77973_b() == ModItems.powder_iodine) {
                return new ItemStack(ModItems.powder_cerium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_thorium) {
                return new ItemStack(ModItems.powder_neptunium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_astatine) {
                return new ItemStack(ModItems.powder_actinium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_caesium) {
                return new ItemStack(ModItems.powder_neodymium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_weidanium) {
                return new ItemStack(ModItems.powder_australium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_strontium) {
                return new ItemStack(ModItems.powder_niobium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_bromine) {
                return new ItemStack(ModItems.powder_strontium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_actinium) {
                return new ItemStack(ModItems.powder_uranium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_lanthanium) {
                return new ItemStack(ModItems.powder_neodymium, 1);
            }
        }
        if (part.func_77973_b() == ModItems.part_carbon) {
            if (MachineRecipes.mODE(item, "dustSulfur")) {
                return new ItemStack(ModItems.powder_iron, 1);
            }
            if (item.func_77973_b() == ModItems.niter) {
                return new ItemStack(ModItems.powder_aluminium, 1);
            }
            if (item.func_77973_b() == ModItems.fluorite) {
                return new ItemStack(ModItems.sulfur, 1);
            }
            if (MachineRecipes.mODE(item, "dustCoal")) {
                return new ItemStack(ModItems.powder_aluminium, 1);
            }
            if (MachineRecipes.mODE(item, "dustIron")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (MachineRecipes.mODE(item, "dustGold")) {
                return new ItemStack(ModItems.powder_astatine, 1);
            }
            if (MachineRecipes.mODE(item, "dustNetherQuartz")) {
                return new ItemStack(ModItems.powder_iron, 1);
            }
            if (item.func_77973_b() == ModItems.powder_plutonium) {
                return new ItemStack(ModItems.powder_tennessine, 1);
            }
            if (item.func_77973_b() == ModItems.powder_neptunium) {
                return new ItemStack(ModItems.powder_tennessine, 1);
            }
            if (MachineRecipes.mODE(item, "dustTitanium")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (MachineRecipes.mODE(item, "dustCopper")) {
                return new ItemStack(ModItems.powder_strontium, 1);
            }
            if (MachineRecipes.mODE(item, "dustTungsten")) {
                return new ItemStack(ModItems.powder_lead, 1);
            }
            if (MachineRecipes.mODE(item, "dustAluminum")) {
                return new ItemStack(ModItems.powder_titanium, 1);
            }
            if (MachineRecipes.mODE(item, "dustLead")) {
                return new ItemStack(ModItems.powder_thorium, 1);
            }
            if (MachineRecipes.mODE(item, "dustBeryllium")) {
                return new ItemStack(ModItems.fluorite, 1);
            }
            if (MachineRecipes.mODE(item, "dustLithium")) {
                return new ItemStack(ModItems.fluorite, 1);
            }
            if (item.func_77973_b() == ModItems.powder_iodine) {
                return new ItemStack(ModItems.powder_tungsten, 1);
            }
            if (item.func_77973_b() == ModItems.powder_neodymium) {
                return new ItemStack(ModItems.powder_tungsten, 1);
            }
            if (item.func_77973_b() == ModItems.powder_australium) {
                return new ItemStack(ModItems.powder_verticium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_strontium) {
                return new ItemStack(ModItems.powder_iodine, 1);
            }
            if (MachineRecipes.mODE(item, "dustCobalt")) {
                return new ItemStack(ModItems.powder_strontium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_bromine) {
                return new ItemStack(ModItems.powder_niobium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_niobium) {
                return new ItemStack(ModItems.powder_iodine, 1);
            }
            if (item.func_77973_b() == ModItems.powder_tennessine) {
                return new ItemStack(ModItems.powder_schrabidium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_cerium) {
                return new ItemStack(ModItems.powder_tungsten, 1);
            }
        }
        if (part.func_77973_b() == ModItems.part_copper) {
            if (MachineRecipes.mODE(item, "dustSulfur")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (item.func_77973_b() == ModItems.niter) {
                return new ItemStack(ModItems.powder_cobalt, 1);
            }
            if (item.func_77973_b() == ModItems.fluorite) {
                return new ItemStack(ModItems.powder_iron, 1);
            }
            if (MachineRecipes.mODE(item, "dustCoal")) {
                return new ItemStack(ModItems.powder_iron, 1);
            }
            if (MachineRecipes.mODE(item, "dustIron")) {
                return new ItemStack(ModItems.powder_niobium, 1);
            }
            if (MachineRecipes.mODE(item, "dustGold")) {
                return new ItemStack(ModItems.powder_lanthanium, 1);
            }
            if (MachineRecipes.mODE(item, "dustNetherQuartz")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (MachineRecipes.mODE(item, "dustUranium")) {
                return new ItemStack(ModItems.powder_tennessine, 1);
            }
            if (MachineRecipes.mODE(item, "dustTitanium")) {
                return new ItemStack(ModItems.powder_strontium, 1);
            }
            if (MachineRecipes.mODE(item, "dustCopper")) {
                return new ItemStack(ModItems.powder_niobium, 1);
            }
            if (MachineRecipes.mODE(item, "dustTungsten")) {
                return new ItemStack(ModItems.powder_actinium, 1);
            }
            if (MachineRecipes.mODE(item, "dustAluminum")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (MachineRecipes.mODE(item, "dustLead")) {
                return new ItemStack(ModItems.powder_tennessine, 1);
            }
            if (MachineRecipes.mODE(item, "dustBeryllium")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (MachineRecipes.mODE(item, "dustLithium")) {
                return new ItemStack(ModItems.powder_bromine, 1);
            }
            if (item.func_77973_b() == ModItems.powder_iodine) {
                return new ItemStack(ModItems.powder_astatine, 1);
            }
            if (item.func_77973_b() == ModItems.powder_thorium) {
                return new ItemStack(ModItems.powder_tennessine, 1);
            }
            if (item.func_77973_b() == ModItems.powder_neodymium) {
                return new ItemStack(ModItems.powder_lead, 1);
            }
            if (item.func_77973_b() == ModItems.powder_astatine) {
                return new ItemStack(ModItems.powder_plutonium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_caesium) {
                return new ItemStack(ModItems.powder_tungsten, 1);
            }
            if (item.func_77973_b() == ModItems.powder_verticium) {
                return new ItemStack(ModItems.powder_unobtainium, 1);
            }
            if (MachineRecipes.mODE(item, "dustCobalt")) {
                return new ItemStack(ModItems.powder_iodine, 1);
            }
            if (item.func_77973_b() == ModItems.powder_bromine) {
                return new ItemStack(ModItems.powder_caesium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_niobium) {
                return new ItemStack(ModItems.powder_cerium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_tennessine) {
                return new ItemStack(ModItems.powder_reiium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_cerium) {
                return new ItemStack(ModItems.powder_lead, 1);
            }
            if (item.func_77973_b() == ModItems.powder_actinium) {
                return new ItemStack(ModItems.powder_tennessine, 1);
            }
            if (item.func_77973_b() == ModItems.powder_lanthanium) {
                return new ItemStack(ModItems.powder_astatine, 1);
            }
        }
        if (part.func_77973_b() == ModItems.part_plutonium) {
            if (MachineRecipes.mODE(item, "dustUranium")) {
                return new ItemStack(ModItems.powder_schrabidium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_plutonium) {
                return new ItemStack(ModItems.powder_schrabidium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_neptunium) {
                return new ItemStack(ModItems.powder_schrabidium, 1);
            }
            if (item.func_77973_b() == ModItems.powder_unobtainium) {
                return new ItemStack(ModItems.powder_daffergon, 1);
            }
            if (item.func_77973_b() == ModItems.cell_antimatter) {
                return new ItemStack(ModItems.cell_anti_schrabidium, 1);
            }
        }
        return null;
    }

    public Map<Object[], Object> getAlloyRecipes() {
        HashMap<Object[], Object> recipes = new HashMap<Object[], Object>();
        if (GeneralConfig.enableDebugMode) {
            recipes.put(new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151128_bU)}, new ItemStack(Item.func_150898_a((Block)ModBlocks.test_render)));
        }
        try {
            recipes.put(new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151044_h)}, MachineRecipes.getFurnaceOutput(new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151044_h)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_lead), new ItemStack(ModItems.ingot_copper)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_lead), new ItemStack(ModItems.ingot_copper)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.plate_lead), new ItemStack(ModItems.plate_copper)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.plate_lead), new ItemStack(ModItems.plate_copper)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_tungsten), new ItemStack(Items.field_151044_h)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_tungsten), new ItemStack(Items.field_151044_h)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_copper), new ItemStack(Items.field_151137_ax)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_copper), new ItemStack(Items.field_151137_ax)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_red_copper), new ItemStack(ModItems.ingot_steel)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_red_copper), new ItemStack(ModItems.ingot_steel)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.canister_fuel), new ItemStack(Items.field_151123_aH)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.canister_fuel), new ItemStack(Items.field_151123_aH)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_tungsten), new ItemStack(ModItems.nugget_schrabidium)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_tungsten), new ItemStack(ModItems.nugget_schrabidium)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.plate_mixed), new ItemStack(ModItems.plate_gold)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.plate_mixed), new ItemStack(ModItems.plate_gold)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_steel), new ItemStack(ModItems.ingot_tungsten)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_steel), new ItemStack(ModItems.ingot_tungsten)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_steel), new ItemStack(ModItems.ingot_cobalt)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_steel), new ItemStack(ModItems.ingot_cobalt)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_saturnite), new ItemStack(ModItems.powder_meteorite)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_saturnite), new ItemStack(ModItems.powder_meteorite)).func_77946_l());
            recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_steel), new ItemStack(ModItems.nugget_technetium)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.ingot_steel), new ItemStack(ModItems.nugget_technetium)).func_77946_l());
            if (GeneralConfig.enableBabyMode) {
                recipes.put(new ItemStack[]{new ItemStack(ModItems.canister_empty), new ItemStack(Items.field_151044_h)}, MachineRecipes.getFurnaceOutput(new ItemStack(ModItems.canister_empty), new ItemStack(Items.field_151044_h)).func_77946_l());
            }
        }
        catch (Exception x) {
            MainRegistry.logger.error("Unable to register alloy recipes for NEI!");
        }
        return recipes;
    }

    public ArrayList<ItemStack> getAlloyFuels() {
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        fuels.add(new ItemStack(Items.field_151044_h));
        fuels.add(new ItemStack(Blocks.field_150402_ci));
        fuels.add(new ItemStack(Items.field_151129_at));
        fuels.add(new ItemStack(Items.field_151072_bj));
        fuels.add(new ItemStack(Items.field_151065_br));
        fuels.add(new ItemStack(ModItems.lignite));
        fuels.add(new ItemStack(ModItems.powder_lignite));
        fuels.add(new ItemStack(ModItems.briquette_lignite));
        fuels.add(new ItemStack(ModItems.coke));
        fuels.add(new ItemStack(ModItems.solid_fuel));
        fuels.add(new ItemStack(ModItems.powder_coal));
        return fuels;
    }

    public Map<Object, Object[]> getGasCentrifugeRecipes() {
        HashMap<Object, Object[]> recipes = new HashMap<Object, Object[]>();
        for (int i = 0; i < FluidTypeHandler.FluidType.values().length; ++i) {
            int j;
            if (MachineRecipes.getGasCentOutput(FluidTypeHandler.FluidType.getEnum(i)) == null) continue;
            List<GasCentOutput> outputs = MachineRecipes.getGasCentOutput(FluidTypeHandler.FluidType.getEnum(i));
            int totalWeight = 0;
            for (GasCentOutput o : outputs) {
                totalWeight += o.weight;
            }
            ItemStack input = new ItemStack(ModItems.fluid_icon, 1, i);
            ItemFluidIcon.addQuantity(input, MachineRecipes.getFluidConsumedGasCent(FluidTypeHandler.FluidType.getEnum(i)) * totalWeight);
            ItemStack[] out = new ItemStack[4];
            for (j = 0; j < outputs.size(); ++j) {
                out[j] = outputs.get((int)j).output.func_77946_l();
                out[j].field_77994_a *= outputs.get((int)j).weight;
            }
            for (j = 0; j < 4; ++j) {
                if (out[j] != null) continue;
                out[j] = new ItemStack(ModItems.nothing);
            }
            recipes.put(input, out);
        }
        return recipes;
    }

    public ArrayList<ItemStack> getCentrifugeFuels() {
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        fuels.add(new ItemStack(Items.field_151044_h));
        fuels.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150402_ci)));
        fuels.add(new ItemStack(Items.field_151129_at));
        fuels.add(new ItemStack(Items.field_151137_ax));
        fuels.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150451_bX)));
        fuels.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150424_aL)));
        fuels.add(new ItemStack(Items.field_151072_bj));
        fuels.add(new ItemStack(Items.field_151065_br));
        return fuels;
    }

    public Map<Object[], Object> getCyclotronRecipes() {
        HashMap<Object[], Object> recipes = new HashMap<Object[], Object>();
        Item part = ModItems.part_lithium;
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.niter)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.niter)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_coal)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_coal)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iron)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iron)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_gold)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_gold)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_quartz)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_quartz)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_uranium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_uranium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_aluminium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_aluminium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_beryllium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_beryllium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_schrabidium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_schrabidium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lithium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lithium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iodine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iodine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_thorium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_thorium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_caesium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_caesium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_reiium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_reiium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_cobalt)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_cobalt)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_cerium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_cerium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_actinium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_actinium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lanthanium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lanthanium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.nothing)}, new ItemStack(ModItems.cell_antimatter));
        part = ModItems.part_beryllium;
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.sulfur)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.sulfur)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.fluorite)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.fluorite)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iron)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iron)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_quartz)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_quartz)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_titanium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_titanium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_copper)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_copper)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_tungsten)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_tungsten)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_aluminium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_aluminium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lead)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lead)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_beryllium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_beryllium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lithium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lithium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iodine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iodine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_thorium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_thorium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_astatine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_astatine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_caesium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_caesium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_weidanium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_weidanium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_strontium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_strontium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_bromine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_bromine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_actinium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_actinium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lanthanium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lanthanium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.nothing)}, new ItemStack(ModItems.cell_antimatter));
        part = ModItems.part_carbon;
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.sulfur)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.sulfur)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.niter)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.niter)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.fluorite)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.fluorite)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_coal)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_coal)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iron)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iron)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_gold)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_gold)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_quartz)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_quartz)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_plutonium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_plutonium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_neptunium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_neptunium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_titanium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_titanium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_copper)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_copper)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_tungsten)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_tungsten)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_aluminium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_aluminium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lead)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lead)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_beryllium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_beryllium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lithium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lithium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iodine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iodine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_neodymium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_neodymium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_australium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_australium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_strontium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_strontium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_cobalt)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_cobalt)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_bromine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_bromine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_niobium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_niobium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_tennessine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_tennessine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_cerium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_cerium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.nothing)}, new ItemStack(ModItems.cell_antimatter));
        part = ModItems.part_copper;
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.sulfur)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.sulfur)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.niter)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.niter)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.fluorite)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.fluorite)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_coal)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_coal)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iron)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iron)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_gold)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_gold)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_quartz)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_quartz)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_uranium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_uranium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_titanium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_titanium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_copper)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_copper)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_tungsten)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_tungsten)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_aluminium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_aluminium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lead)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lead)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_beryllium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_beryllium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lithium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lithium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_iodine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_iodine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_thorium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_thorium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_neodymium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_neodymium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_astatine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_astatine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_caesium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_caesium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_verticium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_verticium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_cobalt)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_cobalt)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_bromine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_bromine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_niobium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_niobium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_tennessine)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_tennessine)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_cerium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_cerium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_actinium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_actinium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_lanthanium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_lanthanium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.nothing)}, new ItemStack(ModItems.cell_antimatter));
        part = ModItems.part_plutonium;
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_uranium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_uranium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_plutonium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_plutonium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_neptunium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_neptunium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.powder_unobtainium)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.powder_unobtainium)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.cell_antimatter)}, MachineRecipes.getCyclotronOutput(new ItemStack(part), new ItemStack(ModItems.cell_antimatter)));
        recipes.put(new ItemStack[]{new ItemStack(part), new ItemStack(ModItems.nothing)}, new ItemStack(ModItems.cell_antimatter));
        return recipes;
    }

    public Map<Object[], Object> getCMBRecipes() {
        HashMap<Object[], Object> recipes = new HashMap<Object[], Object>();
        recipes.put(new ItemStack[]{new ItemStack(ModItems.ingot_advanced_alloy), new ItemStack(ModItems.ingot_magnetized_tungsten)}, new ItemStack(ModItems.ingot_combine_steel, 4));
        recipes.put(new ItemStack[]{new ItemStack(ModItems.powder_advanced_alloy), new ItemStack(ModItems.powder_magnetized_tungsten)}, new ItemStack(ModItems.ingot_combine_steel, 4));
        return recipes;
    }

    public ArrayList<ItemStack> getBatteries() {
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        fuels.add(new ItemStack(ModItems.battery_potato));
        fuels.add(new ItemStack(ModItems.battery_potatos));
        fuels.add(new ItemStack(ModItems.battery_su));
        fuels.add(new ItemStack(ModItems.battery_su_l));
        fuels.add(new ItemStack(ModItems.battery_generic));
        fuels.add(new ItemStack(ModItems.battery_red_cell));
        fuels.add(new ItemStack(ModItems.battery_red_cell_6));
        fuels.add(new ItemStack(ModItems.battery_red_cell_24));
        fuels.add(new ItemStack(ModItems.battery_advanced));
        fuels.add(new ItemStack(ModItems.battery_advanced_cell));
        fuels.add(new ItemStack(ModItems.battery_advanced_cell_4));
        fuels.add(new ItemStack(ModItems.battery_advanced_cell_12));
        fuels.add(new ItemStack(ModItems.battery_lithium));
        fuels.add(new ItemStack(ModItems.battery_lithium_cell));
        fuels.add(new ItemStack(ModItems.battery_lithium_cell_3));
        fuels.add(new ItemStack(ModItems.battery_lithium_cell_6));
        fuels.add(new ItemStack(ModItems.battery_schrabidium));
        fuels.add(new ItemStack(ModItems.battery_schrabidium_cell));
        fuels.add(new ItemStack(ModItems.battery_schrabidium_cell_2));
        fuels.add(new ItemStack(ModItems.battery_schrabidium_cell_4));
        fuels.add(new ItemStack(ModItems.battery_trixite));
        fuels.add(new ItemStack(ModItems.battery_spark));
        fuels.add(new ItemStack(ModItems.battery_spark_cell_6));
        fuels.add(new ItemStack(ModItems.battery_spark_cell_25));
        fuels.add(new ItemStack(ModItems.battery_spark_cell_100));
        fuels.add(new ItemStack(ModItems.battery_spark_cell_1000));
        fuels.add(new ItemStack(ModItems.battery_spark_cell_10000));
        fuels.add(new ItemStack(ModItems.battery_spark_cell_power));
        fuels.add(new ItemStack(ModItems.fusion_core));
        fuels.add(new ItemStack(ModItems.energy_core));
        return fuels;
    }

    public ArrayList<ItemStack> getBlades() {
        ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
        fuels.add(new ItemStack(ModItems.blades_advanced_alloy));
        fuels.add(new ItemStack(ModItems.blades_aluminium));
        fuels.add(new ItemStack(ModItems.blades_combine_steel));
        fuels.add(new ItemStack(ModItems.blades_gold));
        fuels.add(new ItemStack(ModItems.blades_iron));
        fuels.add(new ItemStack(ModItems.blades_steel));
        fuels.add(new ItemStack(ModItems.blades_titanium));
        fuels.add(new ItemStack(ModItems.blades_schrabidium));
        return fuels;
    }

    public static boolean mODE(Item item, String[] names) {
        return MachineRecipes.mODE(new ItemStack(item), names);
    }

    public static boolean mODE(ItemStack item, String[] names) {
        boolean flag = false;
        if (names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                if (!MachineRecipes.mODE(item, names[i])) continue;
                flag = true;
            }
        }
        return flag;
    }

    public static boolean mODE(Item item, String name) {
        return MachineRecipes.mODE(new ItemStack(item), name);
    }

    public static boolean mODE(ItemStack stack, String name) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j()));
        for (int i = 0; i < ids.length; ++i) {
            String s = OreDictionary.getOreName((int)ids[i]);
            if (s.length() <= 0 || !s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Map<Object[], Object[]> getChemistryRecipes() {
        HashMap<Object[], Object[]> recipes = new HashMap<Object[], Object[]>();
        for (int i = 0; i < ItemChemistryTemplate.EnumChemistryTemplate.values().length; ++i) {
            int j;
            ItemStack[] inputs = new ItemStack[7];
            ItemStack[] outputs = new ItemStack[6];
            inputs[6] = new ItemStack(ModItems.chemistry_template, 1, i);
            List<ItemStack> listIn = MachineRecipes.getChemInputFromTempate(inputs[6]);
            if (listIn != null) {
                for (int j2 = 0; j2 < listIn.size(); ++j2) {
                    if (listIn.get(j2) == null) continue;
                    inputs[j2 + 2] = listIn.get(j2).func_77946_l();
                }
            }
            FluidStack[] fluidIn = MachineRecipes.getFluidInputFromTempate(inputs[6]);
            for (int j3 = 0; j3 < fluidIn.length; ++j3) {
                if (fluidIn[j3] == null) continue;
                inputs[j3] = ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)fluidIn[j3].type)), fluidIn[j3].fill);
            }
            ItemStack[] listOut = MachineRecipes.getChemOutputFromTempate(inputs[6]);
            for (int j4 = 0; j4 < listOut.length; ++j4) {
                if (listOut[j4] == null) continue;
                outputs[j4 + 2] = listOut[j4].func_77946_l();
            }
            FluidStack[] fluidOut = MachineRecipes.getFluidOutputFromTempate(inputs[6]);
            for (j = 0; j < fluidOut.length; ++j) {
                if (fluidOut[j] == null) continue;
                outputs[j] = ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)fluidOut[j].type)), fluidOut[j].fill);
            }
            for (j = 0; j < inputs.length; ++j) {
                if (inputs[j] != null) continue;
                inputs[j] = new ItemStack(ModItems.nothing);
            }
            for (j = 0; j < outputs.length; ++j) {
                if (outputs[j] != null) continue;
                outputs[j] = new ItemStack(ModItems.nothing);
            }
            recipes.put(inputs, outputs);
        }
        return recipes;
    }

    public Map<Object, Object[]> getRefineryRecipe() {
        HashMap<Object, Object[]> recipes = new HashMap<Object, Object[]>();
        ItemStack oil = new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)FluidTypeHandler.FluidType.HOTOIL));
        oil.field_77990_d = new NBTTagCompound();
        oil.field_77990_d.func_74768_a("fill", 1000);
        ItemStack heavy = new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)FluidTypeHandler.FluidType.HEAVYOIL));
        heavy.field_77990_d = new NBTTagCompound();
        heavy.field_77990_d.func_74768_a("fill", 500);
        ItemStack naphtha = new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)FluidTypeHandler.FluidType.NAPHTHA));
        naphtha.field_77990_d = new NBTTagCompound();
        naphtha.field_77990_d.func_74768_a("fill", 250);
        ItemStack light = new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)FluidTypeHandler.FluidType.LIGHTOIL));
        light.field_77990_d = new NBTTagCompound();
        light.field_77990_d.func_74768_a("fill", 150);
        ItemStack petroleum = new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)FluidTypeHandler.FluidType.PETROLEUM));
        petroleum.field_77990_d = new NBTTagCompound();
        petroleum.field_77990_d.func_74768_a("fill", 100);
        recipes.put(oil, new ItemStack[]{heavy, naphtha, light, petroleum, new ItemStack(ModItems.sulfur, 1)});
        return recipes;
    }

    public Map<Object, Object> getBoilerRecipes() {
        HashMap<Object, Object> recipes = new HashMap<Object, Object>();
        for (int i = 0; i < FluidTypeHandler.FluidType.values().length; ++i) {
            Object[] outs = MachineRecipes.getBoilerOutput(FluidTypeHandler.FluidType.getEnum(i));
            if (outs == null) continue;
            ItemStack in = new ItemStack(ModItems.fluid_icon, 1, i);
            in.field_77990_d = new NBTTagCompound();
            in.field_77990_d.func_74768_a("fill", ((Integer)outs[2]).intValue());
            ItemStack out = new ItemStack(ModItems.fluid_icon, 1, ((FluidTypeHandler.FluidType)((Object)outs[0])).getID());
            out.field_77990_d = new NBTTagCompound();
            out.field_77990_d.func_74768_a("fill", ((Integer)outs[1]).intValue());
            recipes.put(in, out);
        }
        return recipes;
    }

    public static List<ItemStack> getChemInputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        switch (ItemChemistryTemplate.EnumChemistryTemplate.getEnum(stack.func_77960_j())) {
            case CC_OIL: {
                list.add(new ItemStack(Items.field_151044_h, 10));
                break;
            }
            case CC_I: {
                list.add(new ItemStack(Items.field_151044_h, 8));
                break;
            }
            case CC_HEATING: {
                list.add(new ItemStack(Items.field_151044_h, 8));
                break;
            }
            case CC_HEAVY: {
                list.add(new ItemStack(Items.field_151044_h, 10));
                break;
            }
            case CC_NAPHTHA: {
                list.add(new ItemStack(Items.field_151044_h, 10));
                break;
            }
            case ASPHALT: {
                list.add(new ItemStack(Blocks.field_150351_n, 2));
                list.add(new ItemStack((Block)Blocks.field_150354_m, 6));
                break;
            }
            case CONCRETE: {
                list.add(new ItemStack(Blocks.field_150351_n, 8));
                list.add(new ItemStack((Block)Blocks.field_150354_m, 8));
                break;
            }
            case CONCRETE_ASBESTOS: {
                list.add(new ItemStack(Blocks.field_150351_n, 2));
                list.add(new ItemStack((Block)Blocks.field_150354_m, 2));
                list.add(new ItemStack(ModItems.ingot_asbestos, 4));
                break;
            }
            case COOLANT: {
                list.add(new ItemStack(ModItems.niter, 1));
                break;
            }
            case CRYOGEL: {
                list.add(new ItemStack(ModItems.powder_ice, 1));
                break;
            }
            case DESH: {
                list.add(new ItemStack(ModItems.powder_desh_mix, 1));
                break;
            }
            case CIRCUIT_4: {
                list.add(new ItemStack(ModItems.circuit_red_copper, 1));
                list.add(new ItemStack(ModItems.wire_gold, 4));
                list.add(new ItemStack(ModItems.powder_lapis, 1));
                list.add(new ItemStack(ModItems.ingot_polymer, 1));
                break;
            }
            case CIRCUIT_5: {
                list.add(new ItemStack(ModItems.circuit_gold, 1));
                list.add(new ItemStack(ModItems.wire_schrabidium, 4));
                list.add(new ItemStack(ModItems.powder_diamond, 1));
                list.add(new ItemStack(ModItems.ingot_desh, 1));
                break;
            }
            case POLYMER: {
                list.add(new ItemStack(Items.field_151044_h, 2));
                list.add(new ItemStack(ModItems.fluorite, 1));
                break;
            }
            case DEUTERIUM: {
                list.add(new ItemStack(ModItems.sulfur, 1));
                break;
            }
            case BP_BIOGAS: {
                list.add(new ItemStack(ModItems.biomass, 16));
                break;
            }
            case YELLOWCAKE: {
                list.add(new ItemStack(ModItems.powder_uranium, 1));
                list.add(new ItemStack(ModItems.sulfur, 2));
                break;
            }
            case UF6: {
                list.add(new ItemStack(ModItems.powder_yellowcake, 1));
                list.add(new ItemStack(ModItems.fluorite, 3));
                break;
            }
            case PUF6: {
                list.add(new ItemStack(ModItems.powder_plutonium, 1));
                list.add(new ItemStack(ModItems.fluorite, 3));
                break;
            }
            case SAS3: {
                list.add(new ItemStack(ModItems.powder_schrabidium, 1));
                list.add(new ItemStack(ModItems.sulfur, 2));
                break;
            }
            case NITAN: {
                list.add(new ItemStack(ModItems.powder_nitan_mix, 2));
                break;
            }
            case OIL_SAND: {
                list.add(new ItemStack(ModBlocks.ore_oil_sand, 16));
                break;
            }
            case DYN_SCHRAB: {
                list.add(new ItemStack(ModItems.dynosphere_desh_charged, 3));
                list.add(new ItemStack(ModItems.ingot_uranium, 1));
                list.add(new ItemStack(ModItems.catalyst_clay, 8));
                break;
            }
            case DYN_EUPH: {
                list.add(new ItemStack(ModItems.dynosphere_schrabidium_charged, 1));
                list.add(new ItemStack(ModItems.ingot_plutonium, 1));
                list.add(new ItemStack(ModItems.catalyst_clay, 16));
                list.add(new ItemStack(ModItems.ingot_euphemium, 1));
                break;
            }
            case DYN_DNT: {
                list.add(new ItemStack(ModItems.dynosphere_euphemium_charged, 2));
                list.add(new ItemStack(ModItems.powder_spark_mix, 1));
                list.add(new ItemStack(ModItems.ingot_starmetal, 1));
                list.add(new ItemStack(ModItems.catalyst_clay, 32));
                break;
            }
            case CORDITE: {
                list.add(new ItemStack(ModItems.niter, 2));
                list.add(new ItemStack(Blocks.field_150344_f, 1));
                list.add(new ItemStack(Items.field_151102_aT, 1));
                break;
            }
            case KEVLAR: {
                list.add(new ItemStack(ModItems.niter, 2));
                list.add(new ItemStack(Items.field_151118_aC, 1));
                list.add(new ItemStack(Items.field_151044_h, 1));
                break;
            }
            case SOLID_FUEL: {
                list.add(new ItemStack(ModItems.solid_fuel, 2));
                list.add(new ItemStack(ModItems.niter, 1));
                list.add(new ItemStack(Items.field_151137_ax, 1));
                break;
            }
            case SATURN: {
                list.add(new ItemStack(ModItems.powder_dura_steel, 1));
                list.add(new ItemStack(ModItems.powder_fire, 1));
                break;
            }
            case BALEFIRE: {
                list.add(new ItemStack(ModItems.egg_balefire_shard, 1));
                break;
            }
            case SCHRABIDIC: {
                list.add(new ItemStack(ModItems.pellet_charged, 1));
                break;
            }
            case SCHRABIDATE: {
                list.add(new ItemStack(ModItems.powder_iron, 1));
                break;
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    public static FluidStack[] getFluidInputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        FluidStack[] input = new FluidStack[2];
        switch (ItemChemistryTemplate.EnumChemistryTemplate.getEnum(stack.func_77960_j())) {
            case FP_HEAVYOIL: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.HEAVYOIL);
                break;
            }
            case FP_SMEAR: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.SMEAR);
                break;
            }
            case FP_NAPHTHA: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.NAPHTHA);
                break;
            }
            case FP_LIGHTOIL: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.LIGHTOIL);
                break;
            }
            case FR_REOIL: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.SMEAR);
                break;
            }
            case FR_PETROIL: {
                input[0] = new FluidStack(800, FluidTypeHandler.FluidType.RECLAIMED);
                input[1] = new FluidStack(200, FluidTypeHandler.FluidType.LUBRICANT);
                break;
            }
            case FC_BITUMEN: {
                input[0] = new FluidStack(1200, FluidTypeHandler.FluidType.BITUMEN);
                input[1] = new FluidStack(2400, FluidTypeHandler.FluidType.STEAM);
                break;
            }
            case FC_I_NAPHTHA: {
                input[0] = new FluidStack(1400, FluidTypeHandler.FluidType.SMEAR);
                input[1] = new FluidStack(800, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case FC_GAS_PETROLEUM: {
                input[0] = new FluidStack(1800, FluidTypeHandler.FluidType.GAS);
                input[1] = new FluidStack(1200, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case FC_DIESEL_KEROSENE: {
                input[0] = new FluidStack(1200, FluidTypeHandler.FluidType.DIESEL);
                input[1] = new FluidStack(2000, FluidTypeHandler.FluidType.STEAM);
                break;
            }
            case FC_KEROSENE_PETROLEUM: {
                input[0] = new FluidStack(1400, FluidTypeHandler.FluidType.KEROSENE);
                input[1] = new FluidStack(2000, FluidTypeHandler.FluidType.STEAM);
                break;
            }
            case CC_I: {
                input[0] = new FluidStack(800, FluidTypeHandler.FluidType.SMEAR);
                input[1] = new FluidStack(1800, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case CC_OIL: {
                input[0] = new FluidStack(600, FluidTypeHandler.FluidType.OIL);
                input[1] = new FluidStack(1400, FluidTypeHandler.FluidType.STEAM);
                break;
            }
            case CC_HEATING: {
                input[0] = new FluidStack(800, FluidTypeHandler.FluidType.HEATINGOIL);
                input[1] = new FluidStack(2000, FluidTypeHandler.FluidType.STEAM);
                break;
            }
            case CC_HEAVY: {
                input[0] = new FluidStack(600, FluidTypeHandler.FluidType.HEAVYOIL);
                input[1] = new FluidStack(1400, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case CC_NAPHTHA: {
                input[0] = new FluidStack(1200, FluidTypeHandler.FluidType.NAPHTHA);
                input[1] = new FluidStack(2400, FluidTypeHandler.FluidType.STEAM);
                break;
            }
            case ASPHALT: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.BITUMEN);
                break;
            }
            case CONCRETE: {
                input[0] = new FluidStack(2000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case CONCRETE_ASBESTOS: {
                input[0] = new FluidStack(2000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case COOLANT: {
                input[0] = new FluidStack(1800, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case CRYOGEL: {
                input[0] = new FluidStack(1800, FluidTypeHandler.FluidType.COOLANT);
                break;
            }
            case DESH: {
                if (GeneralConfig.enableBabyMode) {
                    input[0] = new FluidStack(200, FluidTypeHandler.FluidType.LIGHTOIL);
                    break;
                }
                input[0] = new FluidStack(200, FluidTypeHandler.FluidType.MERCURY);
                input[1] = new FluidStack(200, FluidTypeHandler.FluidType.LIGHTOIL);
                break;
            }
            case PEROXIDE: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case CIRCUIT_4: {
                input[0] = new FluidStack(400, FluidTypeHandler.FluidType.ACID);
                input[1] = new FluidStack(200, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case CIRCUIT_5: {
                input[0] = new FluidStack(800, FluidTypeHandler.FluidType.ACID);
                input[1] = new FluidStack(200, FluidTypeHandler.FluidType.MERCURY);
                break;
            }
            case SF_OIL: {
                input[0] = new FluidStack(350, FluidTypeHandler.FluidType.OIL);
                break;
            }
            case SF_HEAVYOIL: {
                input[0] = new FluidStack(250, FluidTypeHandler.FluidType.HEAVYOIL);
                break;
            }
            case SF_SMEAR: {
                input[0] = new FluidStack(200, FluidTypeHandler.FluidType.SMEAR);
                break;
            }
            case SF_HEATINGOIL: {
                input[0] = new FluidStack(100, FluidTypeHandler.FluidType.HEATINGOIL);
                break;
            }
            case SF_RECLAIMED: {
                input[0] = new FluidStack(200, FluidTypeHandler.FluidType.RECLAIMED);
                break;
            }
            case SF_PETROIL: {
                input[0] = new FluidStack(250, FluidTypeHandler.FluidType.PETROIL);
                break;
            }
            case SF_LUBRICANT: {
                input[0] = new FluidStack(250, FluidTypeHandler.FluidType.LUBRICANT);
                break;
            }
            case SF_NAPHTHA: {
                input[0] = new FluidStack(300, FluidTypeHandler.FluidType.NAPHTHA);
                break;
            }
            case SF_DIESEL: {
                input[0] = new FluidStack(400, FluidTypeHandler.FluidType.DIESEL);
                break;
            }
            case SF_LIGHTOIL: {
                input[0] = new FluidStack(450, FluidTypeHandler.FluidType.LIGHTOIL);
                break;
            }
            case SF_KEROSENE: {
                input[0] = new FluidStack(550, FluidTypeHandler.FluidType.KEROSENE);
                break;
            }
            case SF_GAS: {
                input[0] = new FluidStack(750, FluidTypeHandler.FluidType.GAS);
                break;
            }
            case SF_PETROLEUM: {
                input[0] = new FluidStack(600, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case SF_BIOGAS: {
                input[0] = new FluidStack(3500, FluidTypeHandler.FluidType.BIOGAS);
                break;
            }
            case SF_BIOFUEL: {
                input[0] = new FluidStack(1500, FluidTypeHandler.FluidType.BIOFUEL);
                break;
            }
            case POLYMER: {
                input[0] = new FluidStack(600, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case DEUTERIUM: {
                input[0] = new FluidStack(4000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case STEAM: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case BP_BIOFUEL: {
                input[0] = new FluidStack(2000, FluidTypeHandler.FluidType.BIOGAS);
                break;
            }
            case YELLOWCAKE: {
                input[0] = new FluidStack(500, FluidTypeHandler.FluidType.ACID);
                break;
            }
            case UF6: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case PUF6: {
                input[0] = new FluidStack(1000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case SAS3: {
                input[0] = new FluidStack(2000, FluidTypeHandler.FluidType.ACID);
                break;
            }
            case NITAN: {
                input[0] = new FluidStack(600, FluidTypeHandler.FluidType.KEROSENE);
                input[1] = new FluidStack(200, FluidTypeHandler.FluidType.MERCURY);
                break;
            }
            case OIL_SAND: {
                input[0] = new FluidStack(400, FluidTypeHandler.FluidType.BITUMEN);
                break;
            }
            case CORDITE: {
                input[0] = new FluidStack(200, FluidTypeHandler.FluidType.HEATINGOIL);
                break;
            }
            case KEVLAR: {
                input[0] = new FluidStack(100, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case SOLID_FUEL: {
                input[0] = new FluidStack(200, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case ELECTROLYSIS: {
                input[0] = new FluidStack(8000, FluidTypeHandler.FluidType.WATER);
                break;
            }
            case XENON: {
                input[0] = new FluidStack(0, FluidTypeHandler.FluidType.NONE);
                break;
            }
            case XENON_OXY: {
                input[0] = new FluidStack(250, FluidTypeHandler.FluidType.OXYGEN);
                break;
            }
            case SATURN: {
                input[0] = new FluidStack(100, FluidTypeHandler.FluidType.ACID);
                input[1] = new FluidStack(50, FluidTypeHandler.FluidType.MERCURY);
                break;
            }
            case BALEFIRE: {
                input[0] = new FluidStack(6000, FluidTypeHandler.FluidType.KEROSENE);
                break;
            }
            case SCHRABIDIC: {
                input[0] = new FluidStack(8000, FluidTypeHandler.FluidType.SAS3);
                input[1] = new FluidStack(6000, FluidTypeHandler.FluidType.ACID);
                break;
            }
            case SCHRABIDATE: {
                input[0] = new FluidStack(250, FluidTypeHandler.FluidType.SCHRABIDIC);
                break;
            }
        }
        return input;
    }

    public static ItemStack[] getChemOutputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        ItemStack[] output = new ItemStack[4];
        switch (ItemChemistryTemplate.EnumChemistryTemplate.getEnum(stack.func_77960_j())) {
            case ASPHALT: {
                output[0] = new ItemStack(ModBlocks.asphalt, 4);
                output[1] = new ItemStack(ModBlocks.asphalt, 4);
                output[2] = new ItemStack(ModBlocks.asphalt, 4);
                output[3] = new ItemStack(ModBlocks.asphalt, 4);
                break;
            }
            case CONCRETE: {
                output[0] = new ItemStack(ModBlocks.concrete_smooth, 4);
                output[1] = new ItemStack(ModBlocks.concrete_smooth, 4);
                output[2] = new ItemStack(ModBlocks.concrete_smooth, 4);
                output[3] = new ItemStack(ModBlocks.concrete_smooth, 4);
                break;
            }
            case CONCRETE_ASBESTOS: {
                output[0] = new ItemStack(ModBlocks.concrete_asbestos, 4);
                output[1] = new ItemStack(ModBlocks.concrete_asbestos, 4);
                output[2] = new ItemStack(ModBlocks.concrete_asbestos, 4);
                output[3] = new ItemStack(ModBlocks.concrete_asbestos, 4);
                break;
            }
            case DESH: {
                output[0] = new ItemStack(ModItems.ingot_desh, 1);
                break;
            }
            case CIRCUIT_4: {
                output[0] = new ItemStack(ModItems.circuit_gold, 1);
                break;
            }
            case CIRCUIT_5: {
                output[0] = new ItemStack(ModItems.circuit_schrabidium, 1);
                break;
            }
            case SF_OIL: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_HEAVYOIL: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_SMEAR: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_HEATINGOIL: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_RECLAIMED: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_PETROIL: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_LUBRICANT: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_NAPHTHA: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_DIESEL: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_LIGHTOIL: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_KEROSENE: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_GAS: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_PETROLEUM: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_BIOGAS: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case SF_BIOFUEL: {
                output[0] = new ItemStack(ModItems.solid_fuel, 1);
                output[1] = new ItemStack(ModItems.solid_fuel, 1);
                break;
            }
            case POLYMER: {
                output[0] = new ItemStack(ModItems.ingot_polymer, 1);
                break;
            }
            case YELLOWCAKE: {
                output[0] = new ItemStack(ModItems.powder_yellowcake, 1);
                break;
            }
            case DYN_SCHRAB: {
                output[0] = new ItemStack(ModItems.ingot_schrabidium, 1);
                output[1] = new ItemStack(ModItems.powder_desh, 12);
                output[2] = new ItemStack(ModItems.powder_desh_mix, 12);
                break;
            }
            case DYN_EUPH: {
                output[0] = new ItemStack(ModItems.nugget_euphemium, 12);
                output[1] = new ItemStack(ModItems.powder_schrabidium, 4);
                output[2] = new ItemStack(ModItems.powder_power, 4);
                break;
            }
            case DYN_DNT: {
                output[0] = new ItemStack(ModItems.ingot_dineutronium, 1);
                output[1] = new ItemStack(ModItems.powder_euphemium, 8);
                output[2] = new ItemStack(ModItems.powder_nitan_mix, 8);
                break;
            }
            case CORDITE: {
                output[0] = new ItemStack(ModItems.cordite, 4);
                break;
            }
            case KEVLAR: {
                output[0] = new ItemStack(ModItems.plate_kevlar, 4);
                break;
            }
            case SOLID_FUEL: {
                output[0] = new ItemStack(ModItems.rocket_fuel, 4);
                break;
            }
            case SATURN: {
                output[0] = new ItemStack(ModItems.ingot_saturnite, 2);
                break;
            }
            case BALEFIRE: {
                output[0] = new ItemStack(ModItems.powder_balefire, 1);
                break;
            }
            case SCHRABIDATE: {
                output[0] = new ItemStack(ModItems.powder_schrabidate, 1);
                break;
            }
        }
        return output;
    }

    public static FluidStack[] getFluidOutputFromTempate(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemChemistryTemplate)) {
            return null;
        }
        FluidStack[] output = new FluidStack[2];
        switch (ItemChemistryTemplate.EnumChemistryTemplate.getEnum(stack.func_77960_j())) {
            case FP_HEAVYOIL: {
                output[0] = new FluidStack(300, FluidTypeHandler.FluidType.BITUMEN);
                output[1] = new FluidStack(700, FluidTypeHandler.FluidType.SMEAR);
                break;
            }
            case FP_SMEAR: {
                output[0] = new FluidStack(600, FluidTypeHandler.FluidType.HEATINGOIL);
                output[1] = new FluidStack(400, FluidTypeHandler.FluidType.LUBRICANT);
                break;
            }
            case FP_NAPHTHA: {
                output[0] = new FluidStack(400, FluidTypeHandler.FluidType.HEATINGOIL);
                output[1] = new FluidStack(600, FluidTypeHandler.FluidType.DIESEL);
                break;
            }
            case FP_LIGHTOIL: {
                output[0] = new FluidStack(400, FluidTypeHandler.FluidType.DIESEL);
                output[1] = new FluidStack(600, FluidTypeHandler.FluidType.KEROSENE);
                break;
            }
            case FR_REOIL: {
                output[0] = new FluidStack(800, FluidTypeHandler.FluidType.RECLAIMED);
                break;
            }
            case FR_PETROIL: {
                output[0] = new FluidStack(1000, FluidTypeHandler.FluidType.PETROIL);
                break;
            }
            case FC_BITUMEN: {
                output[0] = new FluidStack(1000, FluidTypeHandler.FluidType.OIL);
                output[1] = new FluidStack(200, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case FC_I_NAPHTHA: {
                output[0] = new FluidStack(800, FluidTypeHandler.FluidType.NAPHTHA);
                break;
            }
            case FC_GAS_PETROLEUM: {
                output[0] = new FluidStack(800, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case FC_DIESEL_KEROSENE: {
                output[0] = new FluidStack(400, FluidTypeHandler.FluidType.KEROSENE);
                break;
            }
            case FC_KEROSENE_PETROLEUM: {
                output[0] = new FluidStack(800, FluidTypeHandler.FluidType.PETROLEUM);
                break;
            }
            case CC_OIL: {
                output[0] = new FluidStack(2000, FluidTypeHandler.FluidType.OIL);
                break;
            }
            case CC_I: {
                output[0] = new FluidStack(1600, FluidTypeHandler.FluidType.SMEAR);
                break;
            }
            case CC_HEATING: {
                output[0] = new FluidStack(1800, FluidTypeHandler.FluidType.HEATINGOIL);
                break;
            }
            case CC_HEAVY: {
                output[0] = new FluidStack(1800, FluidTypeHandler.FluidType.HEAVYOIL);
                break;
            }
            case CC_NAPHTHA: {
                output[0] = new FluidStack(2000, FluidTypeHandler.FluidType.NAPHTHA);
                break;
            }
            case COOLANT: {
                output[0] = new FluidStack(2000, FluidTypeHandler.FluidType.COOLANT);
                break;
            }
            case CRYOGEL: {
                output[0] = new FluidStack(2000, FluidTypeHandler.FluidType.CRYOGEL);
                break;
            }
            case PEROXIDE: {
                output[0] = new FluidStack(800, FluidTypeHandler.FluidType.ACID);
                break;
            }
            case DEUTERIUM: {
                output[0] = new FluidStack(500, FluidTypeHandler.FluidType.DEUTERIUM);
                break;
            }
            case STEAM: {
                output[0] = new FluidStack(1000, FluidTypeHandler.FluidType.STEAM);
                break;
            }
            case BP_BIOGAS: {
                output[0] = new FluidStack(4000, FluidTypeHandler.FluidType.BIOGAS);
                break;
            }
            case BP_BIOFUEL: {
                output[0] = new FluidStack(1000, FluidTypeHandler.FluidType.BIOFUEL);
                break;
            }
            case UF6: {
                output[0] = new FluidStack(900, FluidTypeHandler.FluidType.UF6);
                break;
            }
            case PUF6: {
                output[0] = new FluidStack(900, FluidTypeHandler.FluidType.PUF6);
                break;
            }
            case SAS3: {
                output[0] = new FluidStack(1000, FluidTypeHandler.FluidType.SAS3);
                break;
            }
            case NITAN: {
                output[0] = new FluidStack(1000, FluidTypeHandler.FluidType.NITAN);
                break;
            }
            case OIL_SAND: {
                output[0] = new FluidStack(1000, FluidTypeHandler.FluidType.BITUMEN);
                break;
            }
            case DYN_SCHRAB: {
                output[0] = new FluidStack(50, FluidTypeHandler.FluidType.WATZ);
                break;
            }
            case DYN_EUPH: {
                output[0] = new FluidStack(100, FluidTypeHandler.FluidType.WATZ);
                break;
            }
            case DYN_DNT: {
                output[0] = new FluidStack(150, FluidTypeHandler.FluidType.WATZ);
                break;
            }
            case ELECTROLYSIS: {
                output[0] = new FluidStack(400, FluidTypeHandler.FluidType.HYDROGEN);
                output[1] = new FluidStack(400, FluidTypeHandler.FluidType.OXYGEN);
                break;
            }
            case XENON: {
                output[0] = new FluidStack(50, FluidTypeHandler.FluidType.XENON);
                break;
            }
            case XENON_OXY: {
                output[0] = new FluidStack(50, FluidTypeHandler.FluidType.XENON);
                break;
            }
            case BALEFIRE: {
                output[0] = new FluidStack(8000, FluidTypeHandler.FluidType.BALEFIRE);
                break;
            }
            case SCHRABIDIC: {
                output[0] = new FluidStack(16000, FluidTypeHandler.FluidType.SCHRABIDIC);
                break;
            }
        }
        return output;
    }

    public Map<Object, Object> getFluidContainers() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (FluidContainer con : FluidContainerRegistry.allContainers) {
            if (con == null) continue;
            ItemStack fluid = new ItemStack(ModItems.fluid_icon, 1, Arrays.asList(FluidTypeHandler.FluidType.values()).indexOf((Object)con.type));
            fluid.field_77990_d = new NBTTagCompound();
            fluid.field_77990_d.func_74768_a("fill", con.content);
            map.put(fluid, con.fullContainer);
        }
        return map;
    }

    public static class GasCentOutput {
        public int weight;
        public ItemStack output;
        public int slot;

        public GasCentOutput(int w, ItemStack s, int i) {
            this.weight = w;
            this.output = s;
            this.slot = i;
        }
    }
}

