/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class HadronRecipes {
    private static final List<HadronRecipe> recipes = new ArrayList<HadronRecipe>();

    public static void register() {
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_hydrogen), new ItemStack(ModItems.particle_copper), 80, new ItemStack(ModItems.particle_aproton), new ItemStack(ModItems.particle_aelectron), true));
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_amat), new ItemStack(ModItems.particle_amat), 80, new ItemStack(ModItems.particle_aschrab), new ItemStack(ModItems.particle_empty), false));
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_aschrab), new ItemStack(ModItems.particle_aschrab), 100000, new ItemStack(ModItems.particle_dark), new ItemStack(ModItems.particle_empty), false));
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_hydrogen), new ItemStack(ModItems.particle_amat), 1000, new ItemStack(ModItems.particle_muon), new ItemStack(ModItems.particle_empty), true));
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_hydrogen), new ItemStack(ModItems.particle_lead), 4000, new ItemStack(ModItems.particle_higgs), new ItemStack(ModItems.particle_empty), false));
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_muon), new ItemStack(ModItems.particle_dark), 100000, new ItemStack(ModItems.particle_strange), new ItemStack(ModItems.particle_empty), false));
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_strange), new ItemStack(ModItems.powder_magic), 500000, new ItemStack(ModItems.particle_sparkticle), new ItemStack(ModItems.dust), false));
        recipes.add(new HadronRecipe(new ItemStack(ModItems.particle_sparkticle), new ItemStack(ModItems.particle_higgs), 1000000, new ItemStack(ModItems.particle_digamma), new ItemStack(ModItems.particle_empty), false));
        recipes.add(new HadronRecipe(new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151076_bf), 100, new ItemStack(ModItems.nugget), new ItemStack(ModItems.nugget), false));
    }

    public static ItemStack[] getOutput(ItemStack in1, ItemStack in2, int momentum, boolean analysisOnly) {
        for (HadronRecipe r : recipes) {
            if ((!r.in1.isApplicable(in1) || !r.in2.isApplicable(in2)) && (!r.in1.isApplicable(in2) || !r.in2.isApplicable(in1)) || momentum < r.momentum || analysisOnly != r.analysisOnly) continue;
            return new ItemStack[]{r.out1, r.out2};
        }
        return null;
    }

    public static List<HadronRecipe> getRecipes() {
        return recipes;
    }

    public static class HadronRecipe {
        public RecipesCommon.ComparableStack in1;
        public RecipesCommon.ComparableStack in2;
        public int momentum;
        public ItemStack out1;
        public ItemStack out2;
        public boolean analysisOnly;

        public HadronRecipe(ItemStack in1, ItemStack in2, int momentum, ItemStack out1, ItemStack out2, boolean analysisOnly) {
            this.in1 = new RecipesCommon.ComparableStack(in1);
            this.in2 = new RecipesCommon.ComparableStack(in2);
            this.momentum = momentum;
            this.out1 = out1;
            this.out2 = out2;
            this.analysisOnly = analysisOnly;
        }
    }
}

