/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IPartiallyFillable;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.gui.GuiInfoContainer;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIdentifier;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEFluidPacket;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;

public class FluidTank {
    FluidTypeHandler.FluidType type;
    int fluid;
    int maxFluid;
    public int index;
    public static int x = 16;
    public static int y = 100;

    public FluidTank(FluidTypeHandler.FluidType type, int maxFluid, int index) {
        this.type = type;
        this.maxFluid = maxFluid;
        this.index = index;
    }

    public void setFill(int i) {
        this.fluid = i;
    }

    public void setTankType(FluidTypeHandler.FluidType type) {
        if (this.type.name().equals(type.name())) {
            return;
        }
        this.type = type;
        this.setFill(0);
    }

    public FluidTypeHandler.FluidType getTankType() {
        return this.type;
    }

    public int getFill() {
        return this.fluid;
    }

    public int getMaxFill() {
        return this.maxFluid;
    }

    public int changeTankSize(int size) {
        this.maxFluid = size;
        if (this.fluid > this.maxFluid) {
            int dif = this.fluid - this.maxFluid;
            this.fluid = this.maxFluid;
            return dif;
        }
        return 0;
    }

    public void updateTank(int x, int y, int z, int dim) {
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new TEFluidPacket(x, y, z, this.fluid, this.index, this.type), new NetworkRegistry.TargetPoint(dim, (double)x, (double)y, (double)z, 100.0));
    }

    public void loadTank(int in, int out, ItemStack[] slots) {
        FluidTypeHandler.FluidType inType = FluidTypeHandler.FluidType.NONE;
        if (slots[in] != null) {
            inType = FluidContainerRegistry.getFluidType(slots[in]);
            if (slots[in].func_77973_b() == ModItems.fluid_barrel_infinite && this.type != FluidTypeHandler.FluidType.NONE) {
                this.fluid = this.maxFluid;
                return;
            }
            if (slots[in].func_77973_b() == ModItems.inf_water && this.type.name().equals(FluidTypeHandler.FluidType.WATER.name())) {
                this.fluid += 50;
                if (this.fluid > this.maxFluid) {
                    this.fluid = this.maxFluid;
                }
                return;
            }
            if (FluidContainerRegistry.getFluidContent(slots[in], this.type) <= 0) {
                return;
            }
        } else {
            return;
        }
        if (slots[in] != null && inType.name().equals(this.type.name()) && this.fluid + FluidContainerRegistry.getFluidContent(slots[in], this.type) <= this.maxFluid) {
            if (slots[out] == null) {
                this.fluid += FluidContainerRegistry.getFluidContent(slots[in], this.type);
                slots[out] = FluidContainerRegistry.getEmptyContainer(slots[in]);
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
            } else if (slots[out] != null && slots[out].func_77973_b() == FluidContainerRegistry.getEmptyContainer(slots[in]).func_77973_b() && slots[out].field_77994_a < slots[out].func_77976_d()) {
                this.fluid += FluidContainerRegistry.getFluidContent(slots[in], this.type);
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
                ++slots[out].field_77994_a;
            }
        }
    }

    public void unloadTank(int in, int out, ItemStack[] slots) {
        ItemStack full = null;
        if (slots[in] != null) {
            ItemStack partial = slots[in];
            if (partial.func_77973_b() instanceof ItemArmor && ArmorModHandler.hasMods(partial) && (partial = ArmorModHandler.pryMods(partial)[1]) == null) {
                return;
            }
            if (partial.func_77973_b() instanceof IPartiallyFillable) {
                IPartiallyFillable fillable = (IPartiallyFillable)partial.func_77973_b();
                int speed = fillable.getLoadSpeed(partial);
                if (fillable.getType(partial) == this.type && speed > 0) {
                    int toLoad = Math.min(this.fluid, speed);
                    int fill = fillable.getFill(partial);
                    if ((toLoad = Math.min(toLoad, fillable.getMaxFill(partial) - fill)) > 0) {
                        this.fluid -= toLoad;
                        fillable.setFill(partial, fill + toLoad);
                    }
                }
                if (slots[in].func_77973_b() instanceof ItemArmor) {
                    ArmorModHandler.applyMod(slots[in], partial);
                }
                return;
            }
            if (slots[in].func_77973_b() == ModItems.fluid_barrel_infinite) {
                this.fluid = 0;
                return;
            }
            if (slots[in].func_77973_b() == ModItems.inf_water && this.type.name().equals(FluidTypeHandler.FluidType.WATER.name())) {
                this.fluid -= 50;
                if (this.fluid < 0) {
                    this.fluid = 0;
                }
                return;
            }
            full = FluidContainerRegistry.getFullContainer(slots[in], this.type);
        }
        if (full == null) {
            return;
        }
        if (slots[in] != null && this.fluid - FluidContainerRegistry.getFluidContent(full, this.type) >= 0) {
            if (slots[out] == null) {
                this.fluid -= FluidContainerRegistry.getFluidContent(full, this.type);
                slots[out] = full.func_77946_l();
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
            } else if (slots[out] != null && slots[out].func_77973_b() == FluidContainerRegistry.getFullContainer(slots[in], this.type).func_77973_b() && slots[out].field_77994_a < slots[out].func_77976_d()) {
                this.fluid -= FluidContainerRegistry.getFluidContent(full, this.type);
                --slots[in].field_77994_a;
                if (slots[in].field_77994_a <= 0) {
                    slots[in] = null;
                }
                ++slots[out].field_77994_a;
            }
        }
    }

    public void setType(int in, int out, ItemStack[] slots) {
        if (in == out && slots[in] != null && slots[in].func_77973_b() instanceof ItemFluidIdentifier) {
            FluidTypeHandler.FluidType newType = ItemFluidIdentifier.getType(slots[in]);
            if (this.type != newType) {
                this.type = newType;
                this.fluid = 0;
            }
            return;
        }
        if (slots[in] != null && slots[out] == null && slots[in].func_77973_b() instanceof ItemFluidIdentifier) {
            FluidTypeHandler.FluidType newType = ItemFluidIdentifier.getType(slots[in]);
            if (!this.type.name().equals(newType.name())) {
                this.type = newType;
                slots[out] = slots[in].func_77946_l();
                slots[in] = null;
                this.fluid = 0;
            }
        }
    }

    public void renderTank(GuiContainer gui, int x, int y, int tx, int ty, int width, int height) {
        int i = this.fluid * height / this.maxFluid;
        gui.func_73729_b(x, y - i, tx, ty - i, width, i);
    }

    public void renderTankInfo(GuiContainer gui, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (gui instanceof GuiInfoContainer) {
            this.renderTankInfo((GuiInfoContainer)gui, mouseX, mouseY, x, y, width, height);
        }
    }

    public void renderTankInfo(GuiInfoContainer gui, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (x <= mouseX && x + width > mouseX && y < mouseY && y + height >= mouseY) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.func_135052_a((String)this.type.getUnlocalizedName(), (Object[])new Object[0]));
            list.add(this.fluid + "/" + this.maxFluid + "mB");
            if (this.type.temperature < 0) {
                list.add(EnumChatFormatting.BLUE + "" + this.type.temperature + "\u00b0C");
            }
            if (this.type.temperature > 0) {
                list.add(EnumChatFormatting.RED + "" + this.type.temperature + "\u00b0C");
            }
            if (this.type.isAntimatter()) {
                list.add(EnumChatFormatting.DARK_RED + "Antimatter");
            }
            if (this.type.traits.contains((Object)FluidTypeHandler.FluidTrait.CORROSIVE)) {
                list.add(EnumChatFormatting.YELLOW + "Corrosive");
            }
            if (this.type.traits.contains((Object)FluidTypeHandler.FluidTrait.CORROSIVE_2)) {
                list.add(EnumChatFormatting.GOLD + "Strongly Corrosive");
            }
            gui.drawFluidInfo(list.toArray(new String[0]), mouseX, mouseY);
        }
    }

    public ResourceLocation getSheet() {
        return new ResourceLocation("hbm:textures/gui/fluids" + this.type.getSheetID() + ".png");
    }

    public void writeToNBT(NBTTagCompound nbt, String s) {
        nbt.func_74768_a(s, this.fluid);
        nbt.func_74768_a(s + "_max", this.maxFluid);
        nbt.func_74778_a(s + "_type", this.type.getName());
    }

    public void readFromNBT(NBTTagCompound nbt, String s) {
        this.fluid = nbt.func_74762_e(s);
        int max = nbt.func_74762_e(s + "_max");
        if (max > 0) {
            this.maxFluid = nbt.func_74762_e(s + "_max");
        }
        this.type = FluidTypeHandler.FluidType.getEnum(nbt.func_74762_e(s + "_type"));
        if (this.type.name().equals(FluidTypeHandler.FluidType.NONE.name())) {
            this.type = FluidTypeHandler.FluidType.getEnumFromName(nbt.func_74779_i(s + "_type"));
        }
    }
}

