/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class AnvilRecipes {
    private static List<AnvilSmithingRecipe> smithingRecipes = new ArrayList<AnvilSmithingRecipe>();

    public static void register() {
        Block[] anvils;
        smithingRecipes.add(new AnvilSmithingRecipe(2, new ItemStack(ModItems.plate_steel, 2), new RecipesCommon.OreDictStack("ingotSteel"), new RecipesCommon.OreDictStack("ingotSteel")));
        for (Block anvil : anvils = new Block[]{ModBlocks.anvil_iron, ModBlocks.anvil_lead}) {
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_bismuth, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_bismuth, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_dnt, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_dineutronium, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_ferrouranium, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_u238, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_meteorite, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_meteorite, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_schrabidate, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_schrabidate, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_starmetal, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.ComparableStack(ModItems.ingot_starmetal, 10)));
            smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModBlocks.anvil_steel, 1), new RecipesCommon.ComparableStack(anvil), new RecipesCommon.OreDictStack("ingotSteel", 10)));
        }
        smithingRecipes.add(new AnvilSmithingRecipe(1, new ItemStack(ModItems.gun_ar15, 1), new RecipesCommon.ComparableStack(ModItems.gun_thompson), new RecipesCommon.ComparableStack(ModItems.pipe_lead)));
    }

    public static List<AnvilSmithingRecipe> getSmithing() {
        return smithingRecipes;
    }

    public static class AnvilSmithingRecipe {
        int tier;
        ItemStack output;
        RecipesCommon.AStack left;
        RecipesCommon.AStack right;
        boolean shapeless = false;

        public AnvilSmithingRecipe(int tier, ItemStack out, RecipesCommon.AStack left, RecipesCommon.AStack right) {
            this.tier = tier;
            this.output = out;
            this.left = left;
            this.right = right;
        }

        public AnvilSmithingRecipe makeShapeless() {
            this.shapeless = true;
            return this;
        }

        public boolean matches(ItemStack left, ItemStack right) {
            return this.matchesInt(left, right) != -1;
        }

        public int matchesInt(ItemStack left, ItemStack right) {
            if (this.doesStackMatch(left, this.left) && this.doesStackMatch(right, this.right)) {
                return 0;
            }
            if (this.shapeless) {
                return this.doesStackMatch(right, this.left) && this.doesStackMatch(left, this.right) ? 1 : -1;
            }
            return -1;
        }

        public boolean doesStackMatch(ItemStack input, RecipesCommon.AStack recipe) {
            return recipe.matchesRecipe(input);
        }

        public ItemStack getOutput(ItemStack left, ItemStack right) {
            return this.output.func_77946_l();
        }

        public int amountConsumed(int index, boolean mirrored) {
            if (index == 0) {
                return mirrored ? this.right.stacksize : this.left.stacksize;
            }
            if (index == 1) {
                return mirrored ? this.left.stacksize : this.right.stacksize;
            }
            return 0;
        }
    }
}

