/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.handler.radiation.ChunkRadiationHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class ChunkRadiationHandlerSimple
extends ChunkRadiationHandler {
    private HashMap<World, SimpleRadiationPerWorld> perWorld = new HashMap();
    private static final String NBT_KEY_CHUNK_RADIATION = "hfr_simple_radiation";

    @Override
    public float getRadiation(World world, int x, int y, int z) {
        SimpleRadiationPerWorld radWorld = this.perWorld.get(world);
        if (radWorld != null) {
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            Float rad = radWorld.radiation.get(coords);
            return rad == null ? 0.0f : rad.floatValue();
        }
        return 0.0f;
    }

    @Override
    public void setRadiation(World world, int x, int y, int z, float rad) {
        SimpleRadiationPerWorld radWorld = this.perWorld.get(world);
        if (radWorld != null && world.func_72899_e(x, 0, z)) {
            ChunkCoordIntPair coords = new ChunkCoordIntPair(x >> 4, z >> 4);
            if (radWorld.radiation.containsKey(coords)) {
                radWorld.radiation.put(coords, Float.valueOf(rad));
            }
            world.func_72938_d((int)x, (int)z).field_76643_l = true;
        }
    }

    @Override
    public void incrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, this.getRadiation(world, x, y, z) + rad);
    }

    @Override
    public void decrementRad(World world, int x, int y, int z, float rad) {
        this.setRadiation(world, x, y, z, Math.max(this.getRadiation(world, x, y, z) - rad, 0.0f));
    }

    @Override
    public void updateSystem() {
        for (Map.Entry<World, SimpleRadiationPerWorld> entry : this.perWorld.entrySet()) {
            HashMap<ChunkCoordIntPair, Float> radiation = entry.getValue().radiation;
            HashMap<ChunkCoordIntPair, Float> buff = new HashMap<ChunkCoordIntPair, Float>(radiation);
            radiation.clear();
            for (Map.Entry<ChunkCoordIntPair, Float> chunk : buff.entrySet()) {
                ChunkCoordIntPair coord = chunk.getKey();
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        int type = Math.abs(i) + Math.abs(j);
                        float percent = type == 0 ? 0.6f : (type == 1 ? 0.075f : 0.025f);
                        ChunkCoordIntPair newCoord = new ChunkCoordIntPair(coord.field_77276_a + i, coord.field_77275_b + j);
                        if (!buff.containsKey(newCoord)) continue;
                        Float val = radiation.get(newCoord);
                        float rad = val == null ? 0.0f : val.floatValue();
                        float newRad = rad + chunk.getValue().floatValue() * percent;
                        newRad = Math.max(0.0f, newRad * 0.999f - 0.05f);
                        radiation.put(newCoord, Float.valueOf(newRad));
                    }
                }
            }
        }
    }

    @Override
    public void receiveWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            this.perWorld.put(event.world, new SimpleRadiationPerWorld());
        }
    }

    @Override
    public void receiveWorldUnload(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            this.perWorld.remove(event.world);
        }
    }

    @Override
    public void receiveChunkLoad(ChunkDataEvent.Load event) {
        SimpleRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            radWorld.radiation.put(event.getChunk().func_76632_l(), Float.valueOf(event.getData().func_74760_g(NBT_KEY_CHUNK_RADIATION)));
        }
    }

    @Override
    public void receiveChunkSave(ChunkDataEvent.Save event) {
        SimpleRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            Float val = radWorld.radiation.get(event.getChunk().func_76632_l());
            float rad = val == null ? 0.0f : val.floatValue();
            event.getData().func_74776_a(NBT_KEY_CHUNK_RADIATION, rad);
        }
    }

    @Override
    public void receiveChunkUnload(ChunkEvent.Unload event) {
        SimpleRadiationPerWorld radWorld;
        if (!event.world.field_72995_K && (radWorld = this.perWorld.get(event.world)) != null) {
            radWorld.radiation.remove(event.getChunk());
        }
    }

    public static class SimpleRadiationPerWorld {
        public HashMap<ChunkCoordIntPair, Float> radiation = new HashMap();
    }
}

