/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.inventory.SILEXRecipes;
import com.hbm.inventory.gui.GUISILEX;
import com.hbm.util.WeightedRandomObject;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class SILEXRecipeHandler
extends TemplateRecipeHandler {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();

    public String getRecipeName() {
        return "SILEX";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("silex") && ((Object)((Object)this)).getClass() == SILEXRecipeHandler.class) {
            Map<Object, SILEXRecipes.SILEXRecipe> recipes = SILEXRecipes.getRecipes();
            for (Map.Entry<Object, SILEXRecipes.SILEXRecipe> recipe : recipes.entrySet()) {
                this.arecipes.add(new RecipeSet(recipe.getKey(), recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map<Object, SILEXRecipes.SILEXRecipe> recipes = SILEXRecipes.getRecipes();
        for (Map.Entry<Object, SILEXRecipes.SILEXRecipe> recipe : recipes.entrySet()) {
            for (WeightedRandomObject out : recipe.getValue().outputs) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)out.asStack(), (ItemStack)result)) continue;
                this.arecipes.add(new RecipeSet(recipe.getKey(), recipe.getValue()));
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("silex") && ((Object)((Object)this)).getClass() == SILEXRecipeHandler.class) {
            this.loadCraftingRecipes("silex", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map<Object, SILEXRecipes.SILEXRecipe> recipes = SILEXRecipes.getRecipes();
        for (Map.Entry<Object, SILEXRecipes.SILEXRecipe> recipe : recipes.entrySet()) {
            if (recipe.getKey() instanceof ItemStack) {
                if (!NEIServerUtils.areStacksSameType((ItemStack)ingredient, (ItemStack)((ItemStack)recipe.getKey()))) continue;
                this.arecipes.add(new RecipeSet(recipe.getKey(), recipe.getValue()));
                continue;
            }
            if (!(recipe.getKey() instanceof ArrayList)) continue;
            for (Object o : (ArrayList)recipe.getKey()) {
                ItemStack stack = (ItemStack)o;
                if (!NEIServerUtils.areStacksSameType((ItemStack)ingredient, (ItemStack)stack)) continue;
                this.arecipes.add(new RecipeSet(stack, recipe.getValue()));
            }
        }
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(42, 23, 24, 18), "silex", new Object[0]));
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(39, 60, 60, 50), "silex", new Object[0]));
        this.guiGui.add(GUISILEX.class);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(this.guiGui, this.transferRectsGui);
    }

    public void drawExtras(int recipe) {
        RecipeSet rec = (RecipeSet)((Object)this.arecipes.get(recipe));
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < rec.chances.size(); ++i) {
            double chance = rec.chances.get(i);
            PositionedStack sta = rec.outputs.get(i);
            fontRenderer.func_78276_b((double)((int)(chance * 10.0)) / 10.0 + "%", sta.relx + 18, sta.rely + 4, 0x404040);
        }
        String am = (double)((int)(rec.produced * 10.0)) / 10.0 + "x";
        fontRenderer.func_78276_b(am, 52 - fontRenderer.func_78256_a(am) / 2, 43, 0x404040);
    }

    public int recipiesPerPage() {
        return 2;
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_silex.png";
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        List<PositionedStack> outputs;
        List<Double> chances;
        double produced;

        public RecipeSet(Object input, SILEXRecipes.SILEXRecipe recipe) {
            super((TemplateRecipeHandler)SILEXRecipeHandler.this);
            this.input = new PositionedStack(input, 12, 24);
            this.outputs = new ArrayList<PositionedStack>();
            this.chances = new ArrayList<Double>();
            this.produced = recipe.fluidProduced / recipe.fluidConsumed;
            double weight = 0.0;
            for (WeightedRandomObject obj : recipe.outputs) {
                weight += (double)obj.field_76292_a;
            }
            int sep = recipe.outputs.size() > 4 ? 3 : 2;
            for (int i = 0; i < recipe.outputs.size(); ++i) {
                WeightedRandomObject obj = recipe.outputs.get(i);
                if (i < sep) {
                    this.outputs.add(new PositionedStack((Object)obj.asStack(), 68, 24 + i * 18 - 9 * ((Math.min(recipe.outputs.size(), sep) + 1) / 2)));
                } else {
                    this.outputs.add(new PositionedStack((Object)obj.asStack(), 116, 24 + (i - sep) * 18 - 9 * ((Math.min(recipe.outputs.size() - sep, sep) + 1) / 2)));
                }
                this.chances.add((double)(100 * obj.field_76292_a) / weight);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(SILEXRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return this.outputs.get(0);
        }
    }
}

