/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.inventory.BreederRecipes;
import com.hbm.inventory.gui.GUIMachineReactor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ReactorRecipeHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Breeding Reactor";
    }

    public String getGuiTexture() {
        return GUIMachineReactor.texture.toString();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("breeding") && ((Object)((Object)this)).getClass() == ReactorRecipeHandler.class) {
            HashMap<ItemStack, BreederRecipes.BreederRecipe> recipes = BreederRecipes.getAllRecipes();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new BreedingSet((ItemStack)recipe.getKey(), ((BreederRecipes.BreederRecipe)recipe.getValue()).output, ((BreederRecipes.BreederRecipe)recipe.getValue()).heat));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<ItemStack, BreederRecipes.BreederRecipe> recipes = BreederRecipes.getAllRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((BreederRecipes.BreederRecipe)recipe.getValue()).output, (ItemStack)result)) continue;
            this.arecipes.add(new BreedingSet((ItemStack)recipe.getKey(), ((BreederRecipes.BreederRecipe)recipe.getValue()).output, ((BreederRecipes.BreederRecipe)recipe.getValue()).heat));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("breeding") && ((Object)((Object)this)).getClass() == ReactorRecipeHandler.class) {
            this.loadCraftingRecipes("breeding", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        HashMap<ItemStack, BreederRecipes.BreederRecipe> recipes = BreederRecipes.getAllRecipes();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)ingredient, (ItemStack)((ItemStack)recipe.getKey()))) continue;
            this.arecipes.add(new BreedingSet((ItemStack)recipe.getKey(), ((BreederRecipes.BreederRecipe)recipe.getValue()).output, ((BreederRecipes.BreederRecipe)recipe.getValue()).heat));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUIMachineReactor.class;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "breeding", new Object[0]));
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(50, 24, 176, 0, 14, 14, 144, 7);
        this.drawProgressBar(75, 23, 176, 16, 24, 16, 48, 0);
        int heat = ((BreedingSet)((Object)this.arecipes.get((int)recipe))).heat;
        this.drawProgressBar(43, 24, 194, 0, 4, 16, 1.0f - (float)heat / 4.0f, 7);
    }

    public static class Fuel {
        public PositionedStack stack;

        public Fuel(ItemStack ingred) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
        }
    }

    public class BreedingSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack result;
        public int heat;
        public ArrayList<Fuel> fuels;

        public BreedingSet(ItemStack input, ItemStack result, int heat) {
            super((TemplateRecipeHandler)ReactorRecipeHandler.this);
            input.field_77994_a = 1;
            this.input = new PositionedStack((Object)input, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
            this.heat = heat;
            this.fuels = new ArrayList();
            for (ItemStack sta : BreederRecipes.getAllFuelsFromHEAT(heat)) {
                this.fuels.add(new Fuel(sta));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(ReactorRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }

        public PositionedStack getOtherStack() {
            return this.fuels.get((int)(ReactorRecipeHandler.this.cycleticks / 48 % this.fuels.size())).stack;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

