/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.inventory.CrystallizerRecipes;
import com.hbm.inventory.MachineRecipes;
import com.hbm.inventory.gui.GUICrystallizer;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class CrystallizerRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<Fuel> batteries;

    public String getRecipeName() {
        return "Ore Acidizer";
    }

    public String getGuiTexture() {
        return GUICrystallizer.texture.toString();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("hbm_crystallizer") && ((Object)((Object)this)).getClass() == CrystallizerRecipeHandler.class) {
            Map<Object, Object> recipes = CrystallizerRecipes.getRecipes();
            for (Map.Entry<Object, Object> recipe : recipes.entrySet()) {
                this.arecipes.add(new RecipeSet(recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map<Object, Object> recipes = CrystallizerRecipes.getRecipes();
        for (Map.Entry<Object, Object> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)recipe.getValue()), (ItemStack)result)) continue;
            this.arecipes.add(new RecipeSet(recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("hbm_crystallizer") && ((Object)((Object)this)).getClass() == CrystallizerRecipeHandler.class) {
            this.loadCraftingRecipes("hbm_crystallizer", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map<Object, Object> recipes = CrystallizerRecipes.getRecipes();
        for (Map.Entry<Object, Object> recipe : recipes.entrySet()) {
            ItemStack stack;
            if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, FluidTypeHandler.FluidType.ACID.ordinal()), 500))) {
                if (recipe.getKey() instanceof ItemStack) {
                    this.arecipes.add(new RecipeSet(recipe.getKey(), (ItemStack)recipe.getValue()));
                    continue;
                }
                if (!(recipe.getKey() instanceof ArrayList)) continue;
                for (Object o : (ArrayList)recipe.getKey()) {
                    stack = (ItemStack)o;
                    this.arecipes.add(new RecipeSet(stack, (ItemStack)recipe.getValue()));
                }
                continue;
            }
            if (recipe.getKey() instanceof ItemStack) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)((ItemStack)recipe.getKey()))) continue;
                this.arecipes.add(new RecipeSet(recipe.getKey(), (ItemStack)recipe.getValue()));
                continue;
            }
            if (!(recipe.getKey() instanceof ArrayList)) continue;
            for (Object o : (ArrayList)recipe.getKey()) {
                stack = (ItemStack)o;
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)stack)) continue;
                this.arecipes.add(new RecipeSet(stack, (ItemStack)recipe.getValue()));
            }
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GUICrystallizer.class;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(99, 23, 24, 18), "hbm_crystallizer", new Object[0]));
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(99, 23, 192, 0, 22, 16, 600, 0);
        this.drawProgressBar(3, 6, 176, 0, 16, 34, 60, 7);
    }

    public TemplateRecipeHandler newInstance() {
        if (batteries == null) {
            batteries = new ArrayList();
        }
        for (ItemStack i : MachineRecipes.instance().getBatteries()) {
            batteries.add(new Fuel(i));
        }
        return super.newInstance();
    }

    public static class Fuel {
        public PositionedStack stack;

        public Fuel(ItemStack ingred) {
            this.stack = new PositionedStack((Object)ingred, 3, 42, false);
        }
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack acid;
        PositionedStack result;

        public RecipeSet(Object input, ItemStack result) {
            super((TemplateRecipeHandler)CrystallizerRecipeHandler.this);
            this.input = new PositionedStack(input, 75, 24);
            this.acid = new PositionedStack((Object)ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, FluidTypeHandler.FluidType.ACID.ordinal()), 500), 39, 24);
            this.result = new PositionedStack((Object)result, 135, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrystallizerRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input, this.acid));
        }

        public PositionedStack getOtherStack() {
            return CrystallizerRecipeHandler.batteries.get((int)(CrystallizerRecipeHandler.this.cycleticks / 48 % CrystallizerRecipeHandler.batteries.size())).stack;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

