/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.interfaces.IBulletUpdateBehavior;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;

public class GunEnergyFactory {
    public static GunConfiguration getEMPConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 30;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 0;
        config.durability = 1500;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_SPLIT;
        config.firingSound = "hbm:weapon.teslaShoot";
        config.name = "EMP Orb Projector";
        config.manufacturer = "MWT Prototype Labs";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.SPECIAL_EMP);
        return config;
    }

    public static GunConfiguration getFlamerConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.ammoCap = 100;
        config.durability = 1000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.firingSound = "hbm:weapon.flamethrowerShoot";
        config.reloadSound = "hbm:weapon.flamerReload";
        config.name = "Heavy Duty Flamer";
        config.manufacturer = "MWT Prototype Labs";
        config.comment.add("Dragon-slaying: Advanced techniques, part 1:");
        config.comment.add("Try not to get eaten by the dragon.");
        config.comment.add("");
        config.comment.add("Hope that helps.");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.FLAMER_NORMAL);
        config.config.add(BulletConfigSyncingUtil.FLAMER_NAPALM);
        config.config.add(BulletConfigSyncingUtil.FLAMER_WP);
        config.config.add(BulletConfigSyncingUtil.FLAMER_VAPORIZER);
        config.config.add(BulletConfigSyncingUtil.FLAMER_GAS);
        return config;
    }

    public static GunConfiguration getZOMGConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 10;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.durability = 100000;
        config.reloadType = 1;
        config.ammoCap = 1000;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_ARROWS;
        config.firingSound = "hbm:weapon.zomgShoot";
        config.reloadSound = "hbm:weapon.b92Reload";
        config.name = "EMC101 Prismatic Negative Energy Cannon";
        config.manufacturer = "MWT Prototype Labs";
        config.comment.add("Taste the rainbow!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.ZOMG_BOLT);
        return config;
    }

    public static GunConfiguration getExtConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.reloadSoundEnd = false;
        config.firingDuration = 0;
        config.ammoCap = 300;
        config.durability = 10000;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.firingSound = "hbm:weapon.extinguisher";
        config.reloadSound = "hbm:weapon.flamerReload";
        config.name = "PROTEX Fire Exinguisher 6kg";
        config.manufacturer = "Gloria GmbH";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.FEXT_NORMAL);
        config.config.add(BulletConfigSyncingUtil.FEXT_FOAM);
        config.config.add(BulletConfigSyncingUtil.FEXT_SAND);
        return config;
    }

    public static GunConfiguration getVortexConfig() {
        GunConfiguration config = new GunConfiguration();
        return config;
    }

    public static BulletConfiguration getOrbusConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.gun_emp_ammo;
        bullet.velocity = 1.0f;
        bullet.spread = 0.0f;
        bullet.wear = 10;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 12.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = 12;
        bullet.plink = 0;
        bullet.emp = 10;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(Potion.field_76421_d.field_76415_H, 200, 1));
        bullet.effects.add(new PotionEffect(Potion.field_76437_t.field_76415_H, 200, 4));
        return bullet;
    }

    public static BulletConfiguration getFlameConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.ammo_fuel;
        bullet.ammoCount = 100;
        bullet.velocity = 0.75f;
        bullet.spread = 0.025f;
        bullet.wear = 1;
        bullet.bulletsMin = 3;
        bullet.bulletsMax = 5;
        bullet.dmgMin = 2.0f;
        bullet.dmgMax = 4.0f;
        bullet.gravity = 0.01;
        bullet.maxAge = 60;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = -1;
        bullet.plink = 0;
        bullet.vPFX = "flame";
        bullet.incendiary = 10;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (!bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaburst");
                    data.func_74778_a("mode", "flame");
                    data.func_74768_a("count", 15);
                    data.func_74780_a("motion", 0.1);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getNapalmConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_napalm;
        bullet.wear = 2;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 6.0f;
        bullet.maxAge = 200;
        return bullet;
    }

    public static BulletConfiguration getPhosphorusConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_phosphorus;
        bullet.wear = 2;
        bullet.spread = 0.0f;
        bullet.bulletsMin = 1;
        bullet.bulletsMax = 1;
        bullet.dmgMin = 4.0f;
        bullet.dmgMax = 6.0f;
        bullet.maxAge = 200;
        bullet.vPFX = "smoke";
        bullet.bImpact = BulletConfigFactory.getPhosphorousEffect(5, 1200, 25, 0.25, 0.1f);
        return bullet;
    }

    public static BulletConfiguration getVaporizerConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_vaporizer;
        bullet.wear = 4;
        bullet.spread = 0.25f;
        bullet.bulletsMin = 8;
        bullet.bulletsMax = 10;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 10.0f;
        bullet.maxAge = 15;
        bullet.vPFX = "flame";
        bullet.incendiary = 0;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        return bullet;
    }

    public static BulletConfiguration getGasConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.ammo = ModItems.ammo_fuel_gas;
        bullet.wear = 1;
        bullet.spread = 0.05f;
        bullet.gravity = 0.0;
        bullet.bulletsMin = 5;
        bullet.bulletsMax = 7;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.vPFX = "cloud";
        bullet.incendiary = 0;
        bullet.bImpact = BulletConfigFactory.getGasEffect(5, 1200);
        return bullet;
    }

    public static BulletConfiguration getFextConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.ammo_fireext;
        bullet.ammoCount = 300;
        bullet.velocity = 0.75f;
        bullet.spread = 0.025f;
        bullet.wear = 1;
        bullet.bulletsMin = 2;
        bullet.bulletsMax = 3;
        bullet.dmgMin = 0.0f;
        bullet.dmgMax = 0.0f;
        bullet.gravity = 0.04;
        bullet.maxAge = 100;
        bullet.doesRicochet = false;
        bullet.doesPenetrate = true;
        bullet.doesBreakGlass = false;
        bullet.style = -1;
        bullet.plink = 0;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    boolean fizz = false;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                if (bullet.field_70170_p.func_147439_a(ix + i, iy + j, iz + k) != Blocks.field_150480_ab) continue;
                                bullet.field_70170_p.func_147449_b(ix + i, iy + j, iz + k, Blocks.field_150350_a);
                                fizz = true;
                            }
                        }
                    }
                    if (fizz) {
                        bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
        };
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150355_j));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getFextFoamConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFextConfig();
        bullet.ammo = ModItems.ammo_fireext_foam;
        bullet.spread = 0.05f;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (!bullet.field_70170_p.field_72995_K) {
                    int ix = (int)Math.floor(bullet.field_70165_t);
                    int iy = (int)Math.floor(bullet.field_70163_u);
                    int iz = (int)Math.floor(bullet.field_70161_v);
                    boolean fizz = false;
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                Block b = bullet.field_70170_p.func_147439_a(ix + i, iy + j, iz + k);
                                if (b.func_149688_o() != Material.field_151581_o) continue;
                                bullet.field_70170_p.func_147449_b(ix + i, iy + j, iz + k, Blocks.field_150350_a);
                                fizz = true;
                            }
                        }
                    }
                    Block b = bullet.field_70170_p.func_147439_a(ix, iy, iz);
                    if (b.isReplaceable((IBlockAccess)bullet.field_70170_p, ix, iy, iz) && ModBlocks.foam_layer.func_149742_c(bullet.field_70170_p, ix, iy, iz)) {
                        if (b != ModBlocks.foam_layer) {
                            bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.foam_layer);
                        } else {
                            int meta = bullet.field_70170_p.func_72805_g(ix, iy, iz);
                            if (meta < 6) {
                                bullet.field_70170_p.func_72921_c(ix, iy, iz, meta + 1, 3);
                            } else {
                                bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.block_foam);
                            }
                        }
                    }
                    if (fizz) {
                        bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
        };
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)ModBlocks.block_foam));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.05);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getFextSandConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFextConfig();
        bullet.ammo = ModItems.ammo_fireext_sand;
        bullet.spread = 0.1f;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                int iz;
                int iy;
                int ix;
                Block b;
                if (!bullet.field_70170_p.field_72995_K && ((b = bullet.field_70170_p.func_147439_a(ix = (int)Math.floor(bullet.field_70165_t), iy = (int)Math.floor(bullet.field_70163_u), iz = (int)Math.floor(bullet.field_70161_v))).isReplaceable((IBlockAccess)bullet.field_70170_p, ix, iy, iz) || b == ModBlocks.sand_boron_layer) && ModBlocks.sand_boron_layer.func_149742_c(bullet.field_70170_p, ix, iy, iz)) {
                    if (b != ModBlocks.sand_boron_layer) {
                        bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.sand_boron_layer);
                    } else {
                        int meta = bullet.field_70170_p.func_72805_g(ix, iy, iz);
                        if (meta < 6) {
                            bullet.field_70170_p.func_72921_c(ix, iy, iz, meta + 1, 3);
                        } else {
                            bullet.field_70170_p.func_147449_b(ix, iy, iz, ModBlocks.sand_boron);
                        }
                    }
                    if (b.func_149688_o() == Material.field_151581_o) {
                        bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "random.fizz", 1.0f, 1.5f + bullet.field_70170_p.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
        };
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (bullet.field_70170_p.field_72995_K) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "vanillaExt");
                    data.func_74778_a("mode", "blockdust");
                    data.func_74768_a("block", Block.func_149682_b((Block)ModBlocks.sand_boron));
                    data.func_74780_a("posX", bullet.field_70165_t);
                    data.func_74780_a("posY", bullet.field_70163_u);
                    data.func_74780_a("posZ", bullet.field_70161_v);
                    data.func_74780_a("mX", bullet.field_70159_w + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    data.func_74780_a("mY", bullet.field_70181_x - 0.2 + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    data.func_74780_a("mZ", bullet.field_70179_y + bullet.field_70170_p.field_73012_v.nextGaussian() * 0.1);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getZOMGBoltConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.nugget_euphemium;
        bullet.ammoCount = 1000;
        bullet.wear = 1;
        bullet.velocity = 1.0f;
        bullet.spread = 0.125f;
        bullet.maxAge = 100;
        bullet.gravity = 0.0;
        bullet.bulletsMin = 5;
        bullet.bulletsMax = 5;
        bullet.dmgMin = 10000.0f;
        bullet.dmgMax = 25000.0f;
        bullet.liveAfterImpact = true;
        bullet.style = 4;
        bullet.trail = 3;
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(HbmPotion.bang.field_76415_H, 200, 0));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (!bullet.field_70170_p.field_72995_K) {
                    ExplosionChaos.explodeZOMG(bullet.field_70170_p, (int)Math.floor(bullet.field_70165_t), (int)Math.floor(bullet.field_70163_u), (int)Math.floor(bullet.field_70161_v), 5);
                    bullet.field_70170_p.func_72908_a(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, "hbm:entity.bombDet", 5.0f, 1.0f);
                    ExplosionLarge.spawnParticles(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 5);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration getTurbineConfig() {
        BulletConfiguration bullet = new BulletConfiguration();
        bullet.ammo = ModItems.nothing;
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 150.0f;
        bullet.velocity = 1.0f;
        bullet.gravity = 0.0;
        bullet.maxAge = 200;
        bullet.style = 15;
        bullet.destroysBlocks = true;
        bullet.doesRicochet = false;
        return bullet;
    }

    public static BulletConfiguration getTurretConfig() {
        BulletConfiguration bullet = GunEnergyFactory.getFlameConfig();
        bullet.spread *= 2.0f;
        bullet.gravity = 0.0025;
        return bullet;
    }
}

