/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHurtBehavior;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;

public class Gun75BoltFactory {
    static float inaccuracy = 0.5f;

    public static GunConfiguration getBolterConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 2;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.hasSights = false;
        config.reloadDuration = 40;
        config.firingDuration = 0;
        config.ammoCap = 30;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.NONE;
        config.durability = 10000;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:weapon.hksShoot";
        config.reloadSoundEnd = false;
        config.showAmmo = false;
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 25)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 75))).addBus("EJECT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 25)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 75))));
        config.animations.put(HbmAnimations.AnimType.RELOAD, new BusAnimation().addBus("TILT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 250)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 1500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 250))).addBus("MAG", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 500)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 1.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 500))));
        config.name = "Manticora Pattern Boltgun";
        config.manufacturer = "Cerix Magnus";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.B75_NORMAL);
        config.config.add(BulletConfigSyncingUtil.B75_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.B75_HE);
        return config;
    }

    public static BulletConfiguration get75BoltConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_75bolt;
        bullet.ammoCount = 30;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 24.0f;
        bullet.dmgMax = 32.0f;
        bullet.doesRicochet = false;
        bullet.explosive = 0.25f;
        bullet.bHurt = new IBulletHurtBehavior(){

            @Override
            public void behaveEntityHurt(EntityBulletBase bullet, Entity hit) {
                EntityLivingBase living;
                float f;
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (hit instanceof EntityLivingBase && (f = (living = (EntityLivingBase)hit).func_110143_aJ()) > 0.0f) {
                    f = Math.max(0.0f, f - 2.0f);
                    living.func_70606_j(f);
                    if (f == 0.0f) {
                        living.func_70645_a(ModDamageSource.lead);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration get75BoltIncConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_75bolt_incendiary;
        bullet.ammoCount = 30;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 26.0f;
        bullet.dmgMax = 36.0f;
        bullet.doesRicochet = false;
        bullet.explosive = 0.25f;
        bullet.incendiary = 5;
        bullet.doesPenetrate = false;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.05);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return bullet;
    }

    public static BulletConfiguration get75BoltHEConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_75bolt_he;
        bullet.ammoCount = 30;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 32.0f;
        bullet.dmgMax = 48.0f;
        bullet.doesRicochet = false;
        bullet.explosive = 2.5f;
        bullet.blockDamage = false;
        return bullet;
    }
}

