/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHitBehavior;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.items.ModItems;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.util.RenderScreenOverlay;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;

public class Gun50BMGFactory {
    static float inaccuracy = 2.5f;

    public static GunConfiguration getCalamityConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 6;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 50;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_BOX;
        config.durability = 2000;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:weapon.calShoot";
        config.reloadSoundEnd = false;
        config.name = "Maxim gun";
        config.manufacturer = "Hiram Maxim";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.BMG50_NORMAL);
        config.config.add(BulletConfigSyncingUtil.BMG50_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.BMG50_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.BMG50_EXPLOSIVE);
        config.config.add(BulletConfigSyncingUtil.BMG50_AP);
        config.config.add(BulletConfigSyncingUtil.BMG50_DU);
        config.config.add(BulletConfigSyncingUtil.BMG50_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_BMG50);
        config.config.add(BulletConfigSyncingUtil.BMG50_SLEEK);
        return config;
    }

    public static GunConfiguration getSaddleConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 3;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 30;
        config.firingDuration = 0;
        config.ammoCap = 100;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_BOX;
        config.durability = 3500;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:weapon.calShoot";
        config.name = "Double Maxim gun";
        config.manufacturer = "???";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.BMG50_NORMAL);
        config.config.add(BulletConfigSyncingUtil.BMG50_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.BMG50_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.BMG50_EXPLOSIVE);
        config.config.add(BulletConfigSyncingUtil.BMG50_AP);
        config.config.add(BulletConfigSyncingUtil.BMG50_DU);
        config.config.add(BulletConfigSyncingUtil.BMG50_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_BMG50);
        config.config.add(BulletConfigSyncingUtil.BMG50_SLEEK);
        return config;
    }

    public static GunConfiguration getAR15Config() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 1;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 1;
        config.reloadDuration = 20;
        config.firingDuration = 0;
        config.ammoCap = 50;
        config.reloadType = 1;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.NONE;
        config.durability = 100000;
        config.reloadSound = "hbm:weapon.magReload";
        config.firingSound = "hbm:turret.howard_fire";
        config.name = "AR-15 .50 BMG Mod";
        config.manufacturer = "Armalite";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.BMG50_FLECHETTE_AM);
        config.config.add(BulletConfigSyncingUtil.BMG50_FLECHETTE_PO);
        config.config.add(BulletConfigSyncingUtil.BMG50_FLECHETTE_NORMAL);
        config.config.add(BulletConfigSyncingUtil.BMG50_NORMAL);
        config.config.add(BulletConfigSyncingUtil.BMG50_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.BMG50_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.BMG50_EXPLOSIVE);
        config.config.add(BulletConfigSyncingUtil.BMG50_AP);
        config.config.add(BulletConfigSyncingUtil.BMG50_DU);
        config.config.add(BulletConfigSyncingUtil.BMG50_STAR);
        config.config.add(BulletConfigSyncingUtil.CHL_BMG50);
        config.config.add(BulletConfigSyncingUtil.BMG50_SLEEK);
        return config;
    }

    public static BulletConfiguration get50BMGConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 18.0f;
        return bullet;
    }

    public static BulletConfiguration get50BMGFireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_incendiary;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 18.0f;
        bullet.wear = 15;
        bullet.incendiary = 5;
        return bullet;
    }

    public static BulletConfiguration get50BMGPhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_phosphorus;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 18.0f;
        bullet.wear = 15;
        bullet.incendiary = 5;
        bullet.doesPenetrate = false;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.05);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return bullet;
    }

    public static BulletConfiguration get50BMGExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_explosive;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 25.0f;
        bullet.wear = 25;
        bullet.explosive = 1.0f;
        return bullet;
    }

    public static BulletConfiguration get50BMGAPConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_ap;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 25.0f;
        bullet.dmgMax = 30.0f;
        bullet.wear = 15;
        bullet.leadChance = 10;
        return bullet;
    }

    public static BulletConfiguration get50BMGDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_du;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 40.0f;
        bullet.dmgMax = 45.0f;
        bullet.wear = 25;
        bullet.leadChance = 50;
        return bullet;
    }

    public static BulletConfiguration get50BMGStarConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_star;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 70.0f;
        bullet.wear = 25;
        bullet.leadChance = 100;
        return bullet;
    }

    public static BulletConfiguration get50BMGSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_sleek;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 70.0f;
        bullet.wear = 10;
        bullet.leadChance = 100;
        bullet.doesPenetrate = false;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                EntityBulletBase meteor = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
                meteor.func_70107_b(hit.field_70165_t, hit.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), hit.field_70161_v);
                meteor.field_70181_x = -1.0;
                meteor.shooter = bullet.shooter;
                bullet.field_70170_p.func_72838_d((Entity)meteor);
            }
        };
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (y == -1) {
                    return;
                }
                EntityBulletBase meteor = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.MASKMAN_METEOR);
                meteor.func_70107_b(bullet.field_70165_t, bullet.field_70163_u + 30.0 + (double)meteor.field_70170_p.field_73012_v.nextInt(10), bullet.field_70161_v);
                meteor.field_70181_x = -1.0;
                meteor.shooter = bullet.shooter;
                bullet.field_70170_p.func_72838_d((Entity)meteor);
            }
        };
        return bullet;
    }

    public static BulletConfiguration get50BMGFlechetteConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_flechette;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 20.0f;
        bullet.dmgMax = 25.0f;
        return bullet;
    }

    public static BulletConfiguration get50BMGFlechetteAMConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_flechette_am;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 50.0f;
        bullet.dmgMax = 65.0f;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (hit instanceof EntityLivingBase) {
                    ContaminationUtil.contaminate((EntityLivingBase)hit, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 100.0f);
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration get50BMGFlechettePOConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_50bmg_flechette_po;
        bullet.spread *= inaccuracy;
        bullet.dmgMin = 30.0f;
        bullet.dmgMax = 40.0f;
        bullet.bHit = new IBulletHitBehavior(){

            @Override
            public void behaveEntityHit(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (hit instanceof EntityLivingBase) {
                    ContaminationUtil.contaminate((EntityLivingBase)hit, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 50.0f);
                }
            }
        };
        return bullet;
    }
}

