/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.explosion.ExplosionNT;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHurtBehavior;
import com.hbm.interfaces.IBulletImpactBehavior;
import com.hbm.interfaces.IBulletUpdateBehavior;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.IExtendedEntityProperties;

public class Gun4GaugeFactory {
    private static GunConfiguration getShotgunConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 15;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 4;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.hasSights = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.reloadSound = "hbm:weapon.shotgunReload";
        return config;
    }

    public static GunConfiguration getKS23Config() {
        GunConfiguration config = Gun4GaugeFactory.getShotgunConfig();
        config.durability = 3000;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.revolverShootAlt";
        config.firingPitch = 0.65f;
        config.name = "KS-23";
        config.manufacturer = "Tulsky Oruzheiny Zavod";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.G4_NORMAL);
        config.config.add(BulletConfigSyncingUtil.G4_SLUG);
        config.config.add(BulletConfigSyncingUtil.G4_FLECHETTE);
        config.config.add(BulletConfigSyncingUtil.G4_FLECHETTE_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.G4_EXPLOSIVE);
        config.config.add(BulletConfigSyncingUtil.G4_SEMTEX);
        config.config.add(BulletConfigSyncingUtil.G4_BALEFIRE);
        config.config.add(BulletConfigSyncingUtil.G4_KAMPF);
        config.config.add(BulletConfigSyncingUtil.G4_CANISTER);
        config.config.add(BulletConfigSyncingUtil.G4_CLAW);
        config.config.add(BulletConfigSyncingUtil.G4_VAMPIRE);
        config.config.add(BulletConfigSyncingUtil.G4_VOID);
        config.config.add(BulletConfigSyncingUtil.G4_SLEEK);
        return config;
    }

    public static GunConfiguration getSauerConfig() {
        GunConfiguration config = Gun4GaugeFactory.getShotgunConfig();
        config.rateOfFire = 20;
        config.ammoCap = 0;
        config.reloadType = 0;
        config.firingMode = 1;
        config.durability = 3000;
        config.reloadSound = "hbm:weapon.shotgunReload";
        config.firingSound = "hbm:weapon.sauergun";
        config.firingPitch = 1.0f;
        config.name = "Sauer Shotgun";
        config.manufacturer = "Cube 2: Sauerbraten";
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("SAUER_RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.5, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 50))).addBus("SAUER_TILT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 30.0, 150)).addKeyframe(new BusAnimationKeyframe(45.0, 0.0, 30.0, 150)).addKeyframe(new BusAnimationKeyframe(45.0, 0.0, 30.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 30.0, 150)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 150))).addBus("SAUER_COCK", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 100))).addBus("SAUER_SHELL_EJECT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 1.0, 500))));
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.G4_NORMAL);
        config.config.add(BulletConfigSyncingUtil.G4_SLUG);
        config.config.add(BulletConfigSyncingUtil.G4_FLECHETTE);
        config.config.add(BulletConfigSyncingUtil.G4_FLECHETTE_PHOSPHORUS);
        config.config.add(BulletConfigSyncingUtil.G4_EXPLOSIVE);
        config.config.add(BulletConfigSyncingUtil.G4_SEMTEX);
        config.config.add(BulletConfigSyncingUtil.G4_BALEFIRE);
        config.config.add(BulletConfigSyncingUtil.G4_KAMPF);
        config.config.add(BulletConfigSyncingUtil.G4_CANISTER);
        config.config.add(BulletConfigSyncingUtil.G4_CLAW);
        config.config.add(BulletConfigSyncingUtil.G4_VAMPIRE);
        config.config.add(BulletConfigSyncingUtil.G4_VOID);
        config.config.add(BulletConfigSyncingUtil.G4_SLEEK);
        return config;
    }

    public static BulletConfiguration get4GaugeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_4gauge;
        bullet.dmgMin = 3.0f;
        bullet.dmgMax = 6.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        return bullet;
    }

    public static BulletConfiguration get4GaugeSlugConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBulletConfig();
        bullet.ammo = ModItems.ammo_4gauge_slug;
        bullet.dmgMin = 15.0f;
        bullet.dmgMax = 20.0f;
        bullet.wear = 7;
        bullet.style = 0;
        return bullet;
    }

    public static BulletConfiguration get4GaugeFlechetteConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_4gauge_flechette;
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 8.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.wear = 15;
        bullet.style = 2;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        return bullet;
    }

    public static BulletConfiguration get4GaugeFlechettePhosphorusConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_4gauge_flechette;
        bullet.dmgMin = 5.0f;
        bullet.dmgMax = 8.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.wear = 15;
        bullet.style = 2;
        bullet.HBRC = 2;
        bullet.LBRC = 95;
        bullet.ammo = ModItems.ammo_4gauge_flechette_phosphorus;
        bullet.incendiary = 5;
        PotionEffect eff = new PotionEffect(HbmPotion.phosphorus.field_76415_H, 400, 0, true);
        eff.getCurativeItems().clear();
        bullet.effects = new ArrayList<PotionEffect>();
        bullet.effects.add(new PotionEffect(eff));
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaburst");
                data.func_74778_a("mode", "flame");
                data.func_74768_a("count", 15);
                data.func_74780_a("motion", 0.05);
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v), new NetworkRegistry.TargetPoint(bullet.field_71093_bK, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 50.0));
            }
        };
        return bullet;
    }

    public static BulletConfiguration get4GaugeExplosiveConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = ModItems.ammo_4gauge_explosive;
        bullet.velocity *= 2.0f;
        bullet.gravity *= 2.0;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 25;
        bullet.trail = 1;
        return bullet;
    }

    public static BulletConfiguration get4GaugeMiningConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = ModItems.ammo_4gauge_semtex;
        bullet.velocity *= 2.0f;
        bullet.gravity *= 2.0;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 25;
        bullet.trail = 1;
        bullet.explosive = 0.0f;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                ExplosionNT explosion = new ExplosionNT(bullet.field_70170_p, null, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 4.0f);
                explosion.atttributes.add(ExplosionNT.ExAttrib.ALLDROP);
                explosion.atttributes.add(ExplosionNT.ExAttrib.NOHURT);
                explosion.func_77278_a();
                explosion.func_77279_a(false);
                ExplosionLarge.spawnParticles(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 15);
            }
        };
        return bullet;
    }

    public static BulletConfiguration get4GaugeBalefireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardGrenadeConfig();
        bullet.ammo = ModItems.ammo_4gauge_balefire;
        bullet.velocity *= 2.0f;
        bullet.gravity *= 2.0;
        bullet.dmgMin = 10.0f;
        bullet.dmgMax = 15.0f;
        bullet.wear = 25;
        bullet.trail = 1;
        bullet.explosive = 0.0f;
        bullet.bImpact = new IBulletImpactBehavior(){

            @Override
            public void behaveBlockHit(EntityBulletBase bullet, int x, int y, int z) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                ExplosionNT explosion = new ExplosionNT(bullet.field_70170_p, null, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 6.0f);
                explosion.atttributes.add(ExplosionNT.ExAttrib.BALEFIRE);
                explosion.func_77278_a();
                explosion.func_77279_a(false);
                ExplosionLarge.spawnParticles(bullet.field_70170_p, bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v, 30);
            }
        };
        return bullet;
    }

    public static BulletConfiguration getGrenadeKampfConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = ModItems.ammo_4gauge_kampf;
        bullet.spread = 0.0f;
        bullet.gravity = 0.0;
        bullet.wear = 15;
        bullet.explosive = 3.5f;
        bullet.style = 10;
        bullet.trail = 4;
        bullet.vPFX = "smoke";
        return bullet;
    }

    public static BulletConfiguration getGrenadeCanisterConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardRocketConfig();
        bullet.ammo = ModItems.ammo_4gauge_canister;
        bullet.spread = 0.0f;
        bullet.gravity = 0.0;
        bullet.wear = 15;
        bullet.explosive = 1.0f;
        bullet.style = 10;
        bullet.trail = 4;
        bullet.vPFX = "smoke";
        bullet.bUpdate = new IBulletUpdateBehavior(){

            @Override
            public void behaveUpdate(EntityBulletBase bullet) {
                if (!bullet.field_70170_p.field_72995_K && bullet.field_70173_aa > 10) {
                    bullet.func_70106_y();
                    for (int i = 0; i < 50; ++i) {
                        EntityBulletBase bolt = new EntityBulletBase(bullet.field_70170_p, BulletConfigSyncingUtil.M44_AP);
                        bolt.func_70107_b(bullet.field_70165_t, bullet.field_70163_u, bullet.field_70161_v);
                        bolt.func_70186_c(bullet.field_70159_w, bullet.field_70181_x, bullet.field_70179_y, 0.25f, 0.1f);
                        bullet.field_70170_p.func_72838_d((Entity)bolt);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration get4GaugeSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardAirstrikeConfig();
        bullet.ammo = ModItems.ammo_4gauge_sleek;
        return bullet;
    }

    public static BulletConfiguration get4GaugeClawConfig() {
        BulletConfiguration bullet = Gun4GaugeFactory.get4GaugeConfig();
        bullet.ammo = ModItems.ammo_4gauge_claw;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 9.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.leadChance = 100;
        bullet.bHurt = new IBulletHurtBehavior(){

            @Override
            public void behaveEntityHurt(EntityBulletBase bullet, Entity hit) {
                EntityLivingBase living;
                float f;
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (hit instanceof EntityLivingBase && (f = (living = (EntityLivingBase)hit).func_110143_aJ()) > 0.0f) {
                    f = Math.max(0.0f, f - 2.0f);
                    living.func_70606_j(f);
                    if (f == 0.0f) {
                        living.func_70645_a(ModDamageSource.causeBulletDamage(bullet, hit));
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration get4GaugeVampireConfig() {
        BulletConfiguration bullet = Gun4GaugeFactory.get4GaugeConfig();
        bullet.ammo = ModItems.ammo_4gauge_vampire;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 9.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.leadChance = 100;
        bullet.style = 2;
        bullet.bHurt = new IBulletHurtBehavior(){

            @Override
            public void behaveEntityHurt(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (hit instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)hit;
                    IExtendedEntityProperties prop = player.getExtendedProperties("WitcheryExtendedPlayer");
                    NBTTagCompound blank = new NBTTagCompound();
                    blank.func_74782_a("WitcheryExtendedPlayer", (NBTBase)new NBTTagCompound());
                    if (prop != null) {
                        prop.loadNBTData(blank);
                    }
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration get4GaugeVoidConfig() {
        BulletConfiguration bullet = Gun4GaugeFactory.get4GaugeConfig();
        bullet.ammo = ModItems.ammo_4gauge_void;
        bullet.dmgMin = 6.0f;
        bullet.dmgMax = 9.0f;
        bullet.bulletsMin *= 2;
        bullet.bulletsMax *= 2;
        bullet.leadChance = 0;
        bullet.bHurt = new IBulletHurtBehavior(){

            @Override
            public void behaveEntityHurt(EntityBulletBase bullet, Entity hit) {
                if (bullet.field_70170_p.field_72995_K) {
                    return;
                }
                if (hit instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)hit;
                    player.field_71071_by.func_70436_m();
                    player.field_70170_p.func_72885_a((Entity)bullet.shooter, player.field_70165_t, player.field_70163_u, player.field_70161_v, 5.0f, true, true);
                }
            }
        };
        return bullet;
    }
}

