/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.guncfg;

import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.guncfg.BulletConfigFactory;
import com.hbm.interfaces.IBulletHurtBehavior;
import com.hbm.items.ModItems;
import com.hbm.potion.HbmPotion;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.util.RenderScreenOverlay;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;

public class Gun12GaugeFactory {
    public static GunConfiguration getUboinikConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 8;
        config.roundsPerCycle = 1;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 6;
        config.durability = 1500;
        config.reloadType = 2;
        config.allowsInfinity = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.reloadSound = "hbm:weapon.revolverReload";
        config.firingSound = "hbm:weapon.shotgunShoot";
        config.name = "Uboinik Revolving Shotgun";
        config.manufacturer = "Metro Gunsmiths";
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.G12_NORMAL);
        config.config.add(BulletConfigSyncingUtil.G12_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.G12_SHRAPNEL);
        config.config.add(BulletConfigSyncingUtil.G12_DU);
        config.config.add(BulletConfigSyncingUtil.G12_AM);
        config.config.add(BulletConfigSyncingUtil.G12_SLEEK);
        return config;
    }

    public static GunConfiguration getShottyConfig() {
        GunConfiguration config = new GunConfiguration();
        config.rateOfFire = 20;
        config.roundsPerCycle = 2;
        config.gunMode = 0;
        config.firingMode = 0;
        config.reloadDuration = 10;
        config.firingDuration = 0;
        config.ammoCap = 0;
        config.durability = 3000;
        config.reloadType = 0;
        config.allowsInfinity = true;
        config.hasSights = true;
        config.crosshair = RenderScreenOverlay.Crosshair.L_CIRCLE;
        config.reloadSound = "hbm:weapon.revolverReload";
        config.firingSound = "hbm:weapon.shottyShoot";
        config.animations.put(HbmAnimations.AnimType.CYCLE, new BusAnimation().addBus("SHOTTY_RECOIL", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.5, 0.0, 0.0, 50)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 50))).addBus("SHOTTY_BREAK", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 100)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 60.0, 200)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 60.0, 500)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 200))).addBus("SHOTTY_EJECT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 700))).addBus("SHOTTY_INSERT", new BusAnimationSequence().addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 300)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 1.0, 0)).addKeyframe(new BusAnimationKeyframe(1.0, 0.0, 0.0, 350)).addKeyframe(new BusAnimationKeyframe(0.0, 0.0, 0.0, 150))));
        config.name = "Double-Barreled Combat Shotgun";
        config.manufacturer = "Union Aerospace Corporation";
        config.comment.add("God-damned ARCH-VILES!");
        config.config = new ArrayList<Integer>();
        config.config.add(BulletConfigSyncingUtil.G12_NORMAL);
        config.config.add(BulletConfigSyncingUtil.G12_INCENDIARY);
        config.config.add(BulletConfigSyncingUtil.G12_SHRAPNEL);
        config.config.add(BulletConfigSyncingUtil.G12_DU);
        config.config.add(BulletConfigSyncingUtil.G12_AM);
        config.config.add(BulletConfigSyncingUtil.G12_SLEEK);
        return config;
    }

    public static BulletConfiguration get12GaugeConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_12gauge;
        bullet.dmgMin = 1.0f;
        bullet.dmgMax = 4.0f;
        return bullet;
    }

    public static BulletConfiguration get12GaugeFireConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_12gauge_incendiary;
        bullet.wear = 15;
        bullet.dmgMin = 1.0f;
        bullet.dmgMax = 4.0f;
        bullet.incendiary = 5;
        return bullet;
    }

    public static BulletConfiguration get12GaugeShrapnelConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_12gauge_shrapnel;
        bullet.wear = 15;
        bullet.dmgMin = 2.0f;
        bullet.dmgMax = 6.0f;
        bullet.ricochetAngle = 15.0;
        bullet.HBRC = 80;
        bullet.LBRC = 95;
        return bullet;
    }

    public static BulletConfiguration get12GaugeDUConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_12gauge_du;
        bullet.wear = 20;
        bullet.dmgMin = 3.0f;
        bullet.dmgMax = 8.0f;
        bullet.doesPenetrate = true;
        bullet.leadChance = 50;
        return bullet;
    }

    public static BulletConfiguration get12GaugeAMConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardBuckshotConfig();
        bullet.ammo = ModItems.ammo_12gauge_marauder;
        bullet.wear = 20;
        bullet.dmgMin = 100.0f;
        bullet.dmgMax = 500.0f;
        bullet.leadChance = 50;
        bullet.bHurt = new IBulletHurtBehavior(){

            @Override
            public void behaveEntityHurt(EntityBulletBase bullet, Entity hit) {
                if (hit instanceof EntityLivingBase) {
                    ((EntityLivingBase)hit).func_70690_d(new PotionEffect(HbmPotion.bang.field_76415_H, 20, 0));
                }
            }
        };
        return bullet;
    }

    public static BulletConfiguration get12GaugeSleekConfig() {
        BulletConfiguration bullet = BulletConfigFactory.standardAirstrikeConfig();
        bullet.ammo = ModItems.ammo_12gauge_sleek;
        return bullet;
    }
}

