/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.render.util.EnumSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FluidTypeHandler {

    public static enum FluidType {
        NONE(0x888888, 0, 1, 1, 0, 0, 0, EnumSymbol.NONE, "hbmfluid.none"),
        WATER(0x3333FF, 1, 1, 1, 0, 0, 0, EnumSymbol.NONE, "hbmfluid.water"),
        STEAM(0xE5E5E5, 9, 2, 1, 3, 0, 0, EnumSymbol.NONE, "hbmfluid.steam", 100),
        HOTSTEAM(15193814, 1, 1, 2, 4, 0, 0, EnumSymbol.NONE, "hbmfluid.hotsteam", 300),
        SUPERHOTSTEAM(0xE7B7B7, 2, 1, 2, 4, 0, 0, EnumSymbol.NONE, "hbmfluid.superhotsteam", 450),
        ULTRAHOTSTEAM(0xE39393, 13, 1, 2, 4, 0, 0, EnumSymbol.NONE, "hbmfluid.ultrahotsteam", 600),
        COOLANT(14220543, 2, 1, 1, 1, 0, 0, EnumSymbol.NONE, "hbmfluid.coolant"),
        LAVA(0xFF3300, 3, 1, 1, 4, 0, 0, EnumSymbol.NOWATER, "hbmfluid.lava", 1200),
        DEUTERIUM(255, 4, 1, 1, 3, 4, 0, EnumSymbol.NONE, "hbmfluid.deuterium"),
        TRITIUM(153, 5, 1, 1, 3, 4, 0, EnumSymbol.RADIATION, "hbmfluid.tritium"),
        OIL(131586, 6, 1, 1, 2, 1, 0, EnumSymbol.NONE, "hbmfluid.oil"),
        HOTOIL(0x300900, 8, 2, 1, 2, 3, 0, EnumSymbol.NONE, "hbmfluid.hotoil", 350),
        HEAVYOIL(1315602, 2, 2, 1, 2, 1, 0, EnumSymbol.NONE, "hbmfluid.heavyoil"),
        BITUMEN(2040870, 3, 2, 1, 2, 0, 0, EnumSymbol.NONE, "hbmfluid.bitumen"),
        SMEAR(1642241, 7, 1, 1, 2, 1, 0, EnumSymbol.NONE, "hbmfluid.smear"),
        HEATINGOIL(2168838, 4, 2, 1, 2, 2, 0, EnumSymbol.NONE, "hbmfluid.heatingoil"),
        RECLAIMED(0x332B22, 8, 1, 1, 2, 2, 0, EnumSymbol.NONE, "hbmfluid.reclaimed"),
        PETROIL(4473149, 9, 1, 1, 1, 3, 0, EnumSymbol.NONE, "hbmfluid.petroil"),
        LUBRICANT(0x606060, 10, 1, 1, 2, 1, 0, EnumSymbol.NONE, "hbmfluid.lubricant"),
        NAPHTHA(5855044, 5, 2, 1, 2, 1, 0, EnumSymbol.NONE, "hbmfluid.naphtha"),
        DIESEL(15920853, 11, 1, 1, 1, 2, 0, EnumSymbol.NONE, "hbmfluid.diesel"),
        LIGHTOIL(9204817, 6, 2, 1, 1, 2, 0, EnumSymbol.NONE, "hbmfluid.lightoil"),
        KEROSENE(16754130, 12, 1, 1, 1, 2, 0, EnumSymbol.NONE, "hbmfluid.kerosene"),
        GAS(0xFFFEED, 13, 1, 1, 1, 4, 1, EnumSymbol.NONE, "hbmfluid.gas"),
        PETROLEUM(8173513, 7, 2, 1, 1, 4, 1, EnumSymbol.NONE, "hbmfluid.petroleum"),
        BIOGAS(12571516, 12, 2, 1, 1, 4, 1, EnumSymbol.NONE, "hbmfluid.biogas"),
        BIOFUEL(15659636, 13, 2, 1, 1, 2, 0, EnumSymbol.NONE, "hbmfluid.biofuel"),
        NITAN(8394925, 15, 2, 1, 2, 4, 1, EnumSymbol.NONE, "hbmfluid.nitan"),
        UF6(13749950, 14, 1, 1, 4, 0, 2, EnumSymbol.RADIATION, "hbmfluid.uf6", FluidTrait.CORROSIVE),
        PUF6(0x4C4C4C, 15, 1, 1, 4, 0, 4, EnumSymbol.RADIATION, "hbmfluid.puf6", FluidTrait.CORROSIVE),
        SAS3(0x4FFFFC, 14, 2, 1, 5, 0, 4, EnumSymbol.RADIATION, "hbmfluid.sas3", FluidTrait.CORROSIVE),
        SCHRABIDIC(27499, 14, 1, 2, 5, 0, 5, EnumSymbol.ACID, "hbmfluid.schrabidic", FluidTrait.CORROSIVE_2),
        AMAT(65793, 0, 2, 1, 5, 0, 5, EnumSymbol.ANTIMATTER, "hbmfluid.amat", FluidTrait.AMAT),
        ASCHRAB(0xB50000, 1, 2, 1, 5, 0, 5, EnumSymbol.ANTIMATTER, "hbmfluid.aschrab", FluidTrait.AMAT),
        ACID(0xFFF7AA, 10, 2, 1, 3, 0, 3, EnumSymbol.OXIDIZER, "hbmfluid.acid", FluidTrait.CORROSIVE),
        WATZ(8807742, 11, 2, 1, 4, 0, 3, EnumSymbol.ACID, "hbmfluid.watz", FluidTrait.CORROSIVE_2),
        CRYOGEL(0x32FFFF, 0, 1, 2, 2, 0, 0, EnumSymbol.CROYGENIC, "hbmfluid.cryogel", -170),
        HYDROGEN(4359924, 3, 1, 2, 3, 4, 0, EnumSymbol.CROYGENIC, "hbmfluid.hydrogen"),
        OXYGEN(10010105, 4, 1, 2, 3, 0, 0, EnumSymbol.CROYGENIC, "hbmfluid.oxygen"),
        XENON(12207592, 5, 1, 2, 0, 0, 0, EnumSymbol.ASPHYXIANT, "hbmfluid.xenon"),
        BALEFIRE(2678830, 6, 1, 2, 4, 4, 3, EnumSymbol.RADIATION, "hbmfluid.balefire", 1500, FluidTrait.CORROSIVE),
        MERCURY(0x808080, 7, 1, 2, 2, 0, 0, EnumSymbol.NONE, "hbmfluid.mercury"),
        PLASMA_DT(16232414, 8, 1, 2, 0, 4, 0, EnumSymbol.RADIATION, "hbmfluid.plasma_dt", 3250, FluidTrait.NO_CONTAINER),
        PLASMA_HD(15773172, 9, 1, 2, 0, 4, 0, EnumSymbol.RADIATION, "hbmfluid.plasma_hd", 2500, FluidTrait.NO_CONTAINER),
        PLASMA_HT(13741042, 10, 1, 2, 0, 4, 0, EnumSymbol.RADIATION, "hbmfluid.plasma_ht", 3000, FluidTrait.NO_CONTAINER),
        PLASMA_XM(13018623, 11, 1, 2, 0, 4, 1, EnumSymbol.RADIATION, "hbmfluid.plasma_xm", 4250, FluidTrait.NO_CONTAINER),
        PLASMA_BF(11006371, 12, 1, 2, 4, 5, 4, EnumSymbol.ANTIMATTER, "hbmfluid.plasma_bf", 8500, FluidTrait.NO_CONTAINER);

        private int color;
        private int textureX;
        private int textureY;
        private int sheetID;
        private String name;
        public int poison;
        public int flammability;
        public int reactivity;
        public EnumSymbol symbol;
        public int temperature;
        public List<FluidTrait> traits = new ArrayList<FluidTrait>();

        private FluidType(int color, int x, int y, int sheet, int p, int f, int r, EnumSymbol symbol, String name) {
            this(color, x, y, sheet, p, f, r, symbol, name, 0, new FluidTrait[0]);
        }

        private FluidType(int color, int x, int y, int sheet, int p, int f, int r, EnumSymbol symbol, String name, FluidTrait ... traits) {
            this(color, x, y, sheet, p, f, r, symbol, name, 0, traits);
        }

        private FluidType(int color, int x, int y, int sheet, int p, int f, int r, EnumSymbol symbol, String name, int temperature) {
            this(color, x, y, sheet, p, f, r, symbol, name, temperature, new FluidTrait[0]);
        }

        private FluidType(int color, int x, int y, int sheet, int p, int f, int r, EnumSymbol symbol, String name, int temperature, FluidTrait ... traits) {
            this.color = color;
            this.textureX = x;
            this.textureY = y;
            this.name = name;
            this.sheetID = sheet;
            this.poison = p;
            this.flammability = f;
            this.reactivity = r;
            this.symbol = symbol;
            this.temperature = temperature;
            Collections.addAll(this.traits, traits);
        }

        public int getColor() {
            return this.color;
        }

        public int getMSAColor() {
            return this.color;
        }

        public int textureX() {
            return this.textureX;
        }

        public int textureY() {
            return this.textureY;
        }

        public int getSheetID() {
            return this.sheetID;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public static FluidType getEnum(int i) {
            if (i < FluidType.values().length) {
                return FluidType.values()[i];
            }
            return NONE;
        }

        public static FluidType getEnumFromName(String s) {
            for (int i = 0; i < FluidType.values().length; ++i) {
                if (!FluidType.values()[i].getName().equals(s)) continue;
                return FluidType.values()[i];
            }
            return NONE;
        }

        public int getID() {
            return Arrays.asList(FluidType.values()).indexOf((Object)this);
        }

        public String getName() {
            return this.toString();
        }

        public boolean isHot() {
            return this.temperature >= 100;
        }

        public boolean isCorrosive() {
            return this.traits.contains((Object)FluidTrait.CORROSIVE) || this.traits.contains((Object)FluidTrait.CORROSIVE_2);
        }

        public boolean isAntimatter() {
            return this.traits.contains((Object)FluidTrait.AMAT);
        }

        public boolean hasNoContainer() {
            return this.traits.contains((Object)FluidTrait.NO_CONTAINER);
        }
    }

    public static enum FluidTrait {
        AMAT,
        CORROSIVE,
        CORROSIVE_2,
        NO_CONTAINER;

    }
}

