/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.config.RadiationConfig;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.ExtPropPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.AuxSavedData;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class EntityEffectHandler {
    public static void onUpdate(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            if (entity.field_70173_aa % 20 == 0) {
                HbmLivingProps.setRadBuf(entity, HbmLivingProps.getRadEnv(entity));
                HbmLivingProps.setRadEnv(entity, 0.0f);
            }
            if (entity instanceof EntityPlayerMP) {
                NBTTagCompound data = new NBTTagCompound();
                HbmLivingProps props = HbmLivingProps.getData(entity);
                props.saveNBTData(data);
                PacketDispatcher.wrapper.sendTo((IMessage)new ExtPropPacket(data), (EntityPlayerMP)entity);
            }
        }
        EntityEffectHandler.handleRadiation(entity);
        EntityEffectHandler.handleDigamma(entity);
    }

    private static void handleRadiation(EntityLivingBase entity) {
        if (ContaminationUtil.isRadImmune((Entity)entity)) {
            return;
        }
        World world = entity.field_70170_p;
        RadiationSavedData data = RadiationSavedData.getData(world);
        if (!world.field_72995_K) {
            NBTTagCompound nbt;
            int ix = MathHelper.func_76128_c((double)entity.field_70165_t);
            int iy = MathHelper.func_76128_c((double)entity.field_70163_u);
            int iz = MathHelper.func_76128_c((double)entity.field_70161_v);
            Chunk chunk = world.func_72938_d(ix, iz);
            float rad = data.getRadNumFromCoord(chunk.field_76635_g, chunk.field_76647_h);
            if (world.field_73011_w.field_76575_d && RadiationConfig.hellRad > 0.0f && rad < RadiationConfig.hellRad) {
                rad = RadiationConfig.hellRad;
            }
            if (rad > 0.0f) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad / 20.0f);
            }
            if (entity.field_70170_p.func_72896_J() && RadiationConfig.cont > 0 && AuxSavedData.getThunder(entity.field_70170_p) > 0 && entity.field_70170_p.func_72937_j(ix, iy, iz)) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, (float)RadiationConfig.cont * 5.0E-4f);
            }
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            Random rand = new Random(entity.func_145782_y());
            if (HbmLivingProps.getRadiation(entity) > 600.0f && (world.func_82737_E() + (long)rand.nextInt(600)) % 600L == 0L) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "bloodvomit");
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                world.func_72908_a((double)ix, (double)iy, (double)iz, "hbm:entity.vomit", 1.0f, 1.0f);
                entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 60, 19));
            } else if (HbmLivingProps.getRadiation(entity) > 200.0f && (world.func_82737_E() + (long)rand.nextInt(1200)) % 1200L == 0L) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "vomit");
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
                world.func_72908_a((double)ix, (double)iy, (double)iz, "hbm:entity.vomit", 1.0f, 1.0f);
                entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 60, 19));
            }
            if (HbmLivingProps.getRadiation(entity) > 900.0f && (world.func_82737_E() + (long)rand.nextInt(10)) % 10L == 0L) {
                nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "sweat");
                nbt.func_74768_a("count", 1);
                nbt.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                nbt.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(nbt, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        } else {
            float radiation = HbmLivingProps.getRadiation(entity);
            if (entity instanceof EntityPlayer && radiation > 600.0f) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("type", "radiation");
                nbt.func_74768_a("count", radiation > 900.0f ? 4 : (radiation > 800.0f ? 2 : 1));
                MainRegistry.proxy.effectNT(nbt);
            }
        }
    }

    private static void handleDigamma(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            float digamma = HbmLivingProps.getDigamma(entity);
            if (digamma < 0.01f) {
                return;
            }
            int chance = Math.max(10 - (int)digamma, 1);
            if (chance == 1 || entity.func_70681_au().nextInt(chance) == 0) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "sweat");
                data.func_74768_a("count", 1);
                data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150425_aM));
                data.func_74768_a("entity", entity.func_145782_y());
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 25.0));
            }
        }
    }
}

