/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.extprop;

import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class HbmLivingProps
implements IExtendedEntityProperties {
    public static final String key = "NTM_EXT_LIVING";
    public static final UUID digamma_UUID = UUID.fromString("2a3d8aec-5ab9-4218-9b8b-ca812bdf378b");
    public EntityLivingBase entity;
    private float radiation;
    private float digamma;
    private int asbestos;
    private float radEnv;
    private float radBuf;

    public HbmLivingProps(EntityLivingBase entity) {
        this.entity = entity;
    }

    public static HbmLivingProps registerData(EntityLivingBase entity) {
        entity.registerExtendedProperties(key, (IExtendedEntityProperties)new HbmLivingProps(entity));
        return (HbmLivingProps)entity.getExtendedProperties(key);
    }

    public static HbmLivingProps getData(EntityLivingBase entity) {
        HbmLivingProps props = (HbmLivingProps)entity.getExtendedProperties(key);
        return props != null ? props : HbmLivingProps.registerData(entity);
    }

    public static float getRadiation(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).radiation;
    }

    public static void setRadiation(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData((EntityLivingBase)entity).radiation = rad;
    }

    public static void incrementRadiation(EntityLivingBase entity, float rad) {
        HbmLivingProps data = HbmLivingProps.getData(entity);
        float radiation = HbmLivingProps.getData((EntityLivingBase)entity).radiation + rad;
        if (radiation > 2500.0f) {
            radiation = 2500.0f;
        }
        if (radiation < 0.0f) {
            radiation = 0.0f;
        }
        HbmLivingProps.setRadiation(entity, radiation);
    }

    public static float getRadEnv(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).radEnv;
    }

    public static void setRadEnv(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData((EntityLivingBase)entity).radEnv = rad;
    }

    public static float getRadBuf(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).radBuf;
    }

    public static void setRadBuf(EntityLivingBase entity, float rad) {
        HbmLivingProps.getData((EntityLivingBase)entity).radBuf = rad;
    }

    public static float getDigamma(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).digamma;
    }

    public static void setDigamma(EntityLivingBase entity, float digamma) {
        HbmLivingProps.getData((EntityLivingBase)entity).digamma = digamma;
        float healthMod = (float)Math.pow(0.5, digamma) - 1.0f;
        IAttributeInstance attributeinstance = entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        try {
            attributeinstance.func_111124_b(attributeinstance.func_111127_a(digamma_UUID));
        }
        catch (Exception exception) {
            // empty catch block
        }
        attributeinstance.func_111121_a(new AttributeModifier(digamma_UUID, "digamma", (double)healthMod, 2));
        if (entity.func_110143_aJ() > entity.func_110138_aP() && entity.func_110138_aP() > 0.0f) {
            entity.func_70606_j(entity.func_110138_aP());
        }
        if ((entity.func_110138_aP() <= 0.0f || digamma >= 10.0f) && entity.func_70089_S()) {
            entity.func_110149_m(0.0f);
            entity.func_70097_a(ModDamageSource.digamma, 500.0f);
            entity.func_70606_j(0.0f);
            entity.func_70645_a(ModDamageSource.digamma);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "sweat");
            data.func_74768_a("count", 50);
            data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150425_aM));
            data.func_74768_a("entity", entity.func_145782_y());
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, 0.0, 0.0, 0.0), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 50.0));
        }
        if (entity instanceof EntityPlayer) {
            float di = HbmLivingProps.getData((EntityLivingBase)entity).digamma;
            if (di > 0.0f) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.digammaSee);
            }
            if (di >= 2.0f) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.digammaFeel);
            }
            if (di >= 10.0f) {
                ((EntityPlayer)entity).func_71029_a((StatBase)MainRegistry.digammaKnow);
            }
        }
    }

    public static void incrementDigamma(EntityLivingBase entity, float digamma) {
        HbmLivingProps data = HbmLivingProps.getData(entity);
        float dRad = HbmLivingProps.getDigamma(entity) + digamma;
        if (dRad > 10.0f) {
            dRad = 10.0f;
        }
        if (dRad < 0.0f) {
            dRad = 0.0f;
        }
        HbmLivingProps.setDigamma(entity, dRad);
    }

    public static int getAsbestos(EntityLivingBase entity) {
        return HbmLivingProps.getData((EntityLivingBase)entity).asbestos;
    }

    public static void setAsbestos(EntityLivingBase entity, int asbestos) {
        HbmLivingProps.getData((EntityLivingBase)entity).asbestos = asbestos;
        if (asbestos >= 36000) {
            HbmLivingProps.getData((EntityLivingBase)entity).asbestos = 0;
            entity.func_70097_a(ModDamageSource.asbestos, 1000.0f);
        }
    }

    public static void incrementAsbestos(EntityLivingBase entity, int asbestos) {
        HbmLivingProps.setAsbestos(entity, HbmLivingProps.getAsbestos(entity) + asbestos);
    }

    public void init(Entity entity, World world) {
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound props = new NBTTagCompound();
        props.func_74776_a("hfr_radiation", this.radiation);
        props.func_74776_a("hfr_digamma", this.digamma);
        props.func_74768_a("hfr_asbestos", this.asbestos);
        nbt.func_74782_a("HbmLivingProps", (NBTBase)props);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound props = (NBTTagCompound)nbt.func_74781_a("HbmLivingProps");
        if (props != null) {
            this.radiation = props.func_74760_g("hfr_radiation");
            this.digamma = props.func_74760_g("hfr_digamma");
            this.asbestos = props.func_74762_e("hfr_asbestos");
        }
    }

    public static class ContaminationEffect {
        public float maxRad;
        public int maxTime;
        public int time;
        public boolean ignoreArmor;

        public ContaminationEffect(float rad, int time, boolean ignoreArmor) {
            this.maxRad = rad;
            this.maxTime = this.time = time;
            this.ignoreArmor = ignoreArmor;
        }

        public float getRad() {
            return this.maxRad * ((float)this.time / (float)this.maxTime);
        }
    }
}

