/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.nt;

import com.hbm.explosion.nt.IExplosionLogic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class Mark5
implements IExplosionLogic {
    private List<MVRay> pendingRays = new ArrayList<MVRay>();
    private List<MVRay> completedRays = new ArrayList<MVRay>();
    private Set<BlockPos> buffer = new HashSet<BlockPos>();
    private World world;
    private float strength;
    float originX;
    float originY;
    float originZ;
    float angularDelta;
    int phase = 0;

    public Mark5(World world, float strength, float x, float y, float z) {
        this.world = world;
        this.strength = strength;
        this.originX = x;
        this.originY = y;
        this.originZ = z;
        this.initRays();
    }

    private void initRays() {
        float startLen = 0.5f;
        this.pendingRays.add(new MVRay(this.strength, this.originX, this.originY, this.originZ, 0.0f, 1.5707964f, startLen));
        this.pendingRays.add(new MVRay(this.strength, this.originX, this.originY, this.originZ, 0.0f, -1.5707964f, startLen));
        float pilet = 0.7853982f;
        for (int i = 0; i < 8; ++i) {
            this.pendingRays.add(new MVRay(this.strength, this.originX, this.originY, this.originZ, pilet * (float)i, 0.0f, startLen));
            this.pendingRays.add(new MVRay(this.strength, this.originX, this.originY, this.originZ, pilet * (float)i, -pilet, startLen));
            this.pendingRays.add(new MVRay(this.strength, this.originX, this.originY, this.originZ, pilet * (float)i, pilet, startLen));
        }
        this.angularDelta = pilet;
    }

    @Override
    public void updateLogic() {
        switch (this.phase) {
            case 0: {
                this.processRays(5000);
                break;
            }
            case 1: {
                this.breakBlocks(10000);
                break;
            }
            case 2: {
                this.repopulate(20000);
            }
        }
    }

    private void processRays(int amount) {
        if (this.phase == 0 && this.pendingRays.isEmpty()) {
            this.phase = 1;
            return;
        }
        int rem = 0;
        for (MVRay ray : this.pendingRays) {
            Vec3 vec = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
            vec.func_72446_c(ray.pitch);
            vec.func_72442_b(ray.yaw);
            boolean shouldSplit = true;
            float lastIndex = 0.0f;
            for (float i = 0.0f; i < ray.length; i += 0.5f) {
                lastIndex = i;
                int x = (int)Math.floor((double)ray.x + vec.field_72450_a * (double)i);
                int y = (int)Math.floor((double)ray.y + vec.field_72448_b * (double)i);
                int z = (int)Math.floor((double)ray.z + vec.field_72449_c * (double)i);
                BlockPos pos = new BlockPos(x, y, z);
                if (y > 255 || y < 0) {
                    shouldSplit = false;
                    break;
                }
                Block b = this.world.func_147439_a(x, y, z);
                float res = (b.func_149688_o().func_76224_d() ? 0.0f : b.func_149638_a(null)) + Blocks.field_150350_a.func_149638_a(null);
                ray.power -= res * res;
                if (ray.power <= 0.0f) {
                    shouldSplit = false;
                    break;
                }
                if (b == Blocks.field_150350_a) continue;
                this.buffer.add(pos);
            }
            if (shouldSplit) {
                ray.x += (float)vec.field_72450_a * lastIndex;
                ray.y += (float)vec.field_72448_b * lastIndex;
                ray.z += (float)vec.field_72449_c * lastIndex;
                this.completedRays.add(ray);
            }
            if (++rem != amount) continue;
            break;
        }
        this.pendingRays.subList(0, rem).clear();
        if (this.pendingRays.isEmpty()) {
            this.phase = 1;
        }
    }

    private void breakBlocks(int amount) {
        if (this.phase == 1 && this.buffer.isEmpty()) {
            this.angularDelta *= 0.5f;
            this.phase = 2;
            return;
        }
        int rem = 0;
        ArrayList<BlockPos> toRem = new ArrayList<BlockPos>();
        for (BlockPos pos : this.buffer) {
            this.world.func_147465_d(pos.x, pos.y, pos.z, Blocks.field_150350_a, 0, 3);
            toRem.add(pos);
            if (++rem != amount) continue;
            break;
        }
        this.buffer.removeAll(toRem);
        if (this.buffer.isEmpty()) {
            this.angularDelta *= 0.5f;
            this.phase = 2;
        }
    }

    private void repopulate(int amount) {
        if (this.phase == 2 && this.completedRays.isEmpty()) {
            this.phase = 0;
        }
        int rem = 0;
        for (MVRay ray : this.completedRays) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    MVRay child = new MVRay(ray.power, ray.x, ray.y, ray.z, ray.yaw + this.angularDelta * (float)i, ray.pitch + this.angularDelta * (float)j, ray.length * 2.0f);
                    this.pendingRays.add(child);
                }
            }
            if (++rem != amount) continue;
            break;
        }
        this.completedRays.subList(0, rem).clear();
    }

    @Override
    public boolean isDone() {
        return this.pendingRays.isEmpty() && this.completedRays.isEmpty() && this.buffer.isEmpty();
    }

    public static class BlockPos {
        int x;
        int y;
        int z;

        public BlockPos(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockPos other = (BlockPos)obj;
            if (this.x != other.x) {
                return false;
            }
            if (this.y != other.y) {
                return false;
            }
            return this.z == other.z;
        }
    }

    public static class MVRay {
        float power;
        boolean collected = false;
        float x;
        float y;
        float z;
        float yaw;
        float pitch;
        float length;

        public MVRay(float power, float x, float y, float z, float yaw, float pitch, float length) {
            this.power = power;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.length = length;
        }

        public MVRay(float power, float x, float y, float z, Vec3 dir, float length) {
            double len = dir.func_72433_c();
            float yaw = (float)Math.atan2(dir.field_72449_c, dir.field_72450_a);
            float pitch = (float)Math.asin(dir.field_72448_b / len);
            this.power = power;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.length = length;
        }
    }
}

