/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.entity.particle.EntityGasFlameFX;
import com.hbm.entity.projectile.EntityOilSpill;
import com.hbm.entity.projectile.EntityRubble;
import com.hbm.entity.projectile.EntityShrapnel;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ExplosionLarge {
    static Random rand = new Random();

    public static void spawnParticles(World world, double x, double y, double z, int count) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "smoke");
        data.func_74778_a("mode", "cloud");
        data.func_74768_a("count", count);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 250.0));
    }

    public static void spawnParticlesRadial(World world, double x, double y, double z, int count) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "smoke");
        data.func_74778_a("mode", "radial");
        data.func_74768_a("count", count);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 250.0));
    }

    public static void spawnShock(World world, double x, double y, double z, int count, double strength) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "smoke");
        data.func_74778_a("mode", "shock");
        data.func_74768_a("count", count);
        data.func_74780_a("strength", strength);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, x, y + 0.5, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 250.0));
    }

    public static void spawnBurst(World world, double x, double y, double z, int count, double strength) {
        Vec3 vec = Vec3.func_72443_a((double)strength, (double)0.0, (double)0.0);
        vec.func_72442_b((float)rand.nextInt(360));
        for (int i = 0; i < count; ++i) {
            EntityGasFlameFX fx = new EntityGasFlameFX(world, x, y, z, 0.0, 0.0, 0.0);
            fx.field_70181_x = 0.0;
            fx.field_70159_w = vec.field_72450_a;
            fx.field_70179_y = vec.field_72449_c;
            world.func_72838_d((Entity)fx);
            vec.func_72442_b((float)(360 / count));
        }
    }

    public static void spawnRubble(World world, double x, double y, double z, int count) {
        for (int i = 0; i < count; ++i) {
            EntityRubble rubble = new EntityRubble(world);
            rubble.field_70165_t = x;
            rubble.field_70163_u = y;
            rubble.field_70161_v = z;
            rubble.field_70181_x = 0.75 * (double)(1 + (count + rand.nextInt(count * 5)) / 25);
            rubble.field_70159_w = rand.nextGaussian() * 0.75 * (double)(1 + count / 50);
            rubble.field_70179_y = rand.nextGaussian() * 0.75 * (double)(1 + count / 50);
            rubble.setMetaBasedOnBlock(Blocks.field_150348_b, 0);
            world.func_72838_d((Entity)rubble);
        }
    }

    public static void spawnShrapnels(World world, double x, double y, double z, int count) {
        for (int i = 0; i < count; ++i) {
            EntityShrapnel shrapnel = new EntityShrapnel(world);
            shrapnel.field_70165_t = x;
            shrapnel.field_70163_u = y;
            shrapnel.field_70161_v = z;
            shrapnel.field_70181_x = ((double)rand.nextFloat() * 0.5 + 0.5) * (double)(1 + count / (15 + rand.nextInt(21))) + (double)(rand.nextFloat() / 50.0f * (float)count);
            shrapnel.field_70159_w = rand.nextGaussian() * 1.0 * (double)(1 + count / 50);
            shrapnel.field_70179_y = rand.nextGaussian() * 1.0 * (double)(1 + count / 50);
            shrapnel.setTrail(rand.nextInt(3) == 0);
            world.func_72838_d((Entity)shrapnel);
        }
    }

    public static void spawnTracers(World world, double x, double y, double z, int count) {
        for (int i = 0; i < count; ++i) {
            EntityShrapnel shrapnel = new EntityShrapnel(world);
            shrapnel.field_70165_t = x;
            shrapnel.field_70163_u = y;
            shrapnel.field_70161_v = z;
            shrapnel.field_70181_x = ((double)rand.nextFloat() * 0.5 + 0.5) * (double)(1 + count / (15 + rand.nextInt(21))) + (double)(rand.nextFloat() / 50.0f * (float)count * 0.25f);
            shrapnel.field_70159_w = rand.nextGaussian() * 1.0 * (double)(1 + count / 50) * 0.25;
            shrapnel.field_70179_y = rand.nextGaussian() * 1.0 * (double)(1 + count / 50) * 0.25;
            shrapnel.setTrail(true);
            world.func_72838_d((Entity)shrapnel);
        }
    }

    public static void spawnShrapnelShower(World world, double x, double y, double z, double motionX, double motionY, double motionZ, int count, double deviation) {
        for (int i = 0; i < count; ++i) {
            EntityShrapnel shrapnel = new EntityShrapnel(world);
            shrapnel.field_70165_t = x;
            shrapnel.field_70163_u = y;
            shrapnel.field_70161_v = z;
            shrapnel.field_70159_w = motionX + rand.nextGaussian() * deviation;
            shrapnel.field_70181_x = motionY + rand.nextGaussian() * deviation;
            shrapnel.field_70179_y = motionZ + rand.nextGaussian() * deviation;
            shrapnel.setTrail(rand.nextInt(3) == 0);
            world.func_72838_d((Entity)shrapnel);
        }
    }

    public static void spawnMissileDebris(World world, double x, double y, double z, double motionX, double motionY, double motionZ, double deviation, List<ItemStack> debris, ItemStack rareDrop) {
        if (debris != null) {
            for (int i = 0; i < debris.size(); ++i) {
                if (debris.get(i) == null) continue;
                int k = rand.nextInt(debris.get((int)i).field_77994_a + 1);
                for (int j = 0; j < k; ++j) {
                    EntityItem item = new EntityItem(world, x, y, z, new ItemStack(debris.get(i).func_77973_b()));
                    item.field_70159_w = (motionX + rand.nextGaussian() * deviation) * 0.85;
                    item.field_70181_x = (motionY + rand.nextGaussian() * deviation) * 0.85;
                    item.field_70179_y = (motionZ + rand.nextGaussian() * deviation) * 0.85;
                    item.field_70165_t += item.field_70159_w * 2.0;
                    item.field_70163_u += item.field_70181_x * 2.0;
                    item.field_70161_v += item.field_70179_y * 2.0;
                    world.func_72838_d((Entity)item);
                }
            }
        }
        if (rareDrop != null && rand.nextInt(10) == 0) {
            EntityItem item = new EntityItem(world, x, y, z, rareDrop.func_77946_l());
            item.field_70159_w = motionX + rand.nextGaussian() * deviation * 0.1;
            item.field_70181_x = motionY + rand.nextGaussian() * deviation * 0.1;
            item.field_70179_y = motionZ + rand.nextGaussian() * deviation * 0.1;
            world.func_72838_d((Entity)item);
        }
    }

    public static void spawnOilSpills(World world, double x, double y, double z, int count) {
        for (int i = 0; i < count; ++i) {
            EntityOilSpill shrapnel = new EntityOilSpill(world);
            shrapnel.field_70165_t = x;
            shrapnel.field_70163_u = y;
            shrapnel.field_70161_v = z;
            shrapnel.field_70181_x = ((double)rand.nextFloat() * 0.5 + 0.5) * (double)(1 + count / (15 + rand.nextInt(21))) + (double)(rand.nextFloat() / 50.0f * (float)count * 0.25f);
            shrapnel.field_70159_w = rand.nextGaussian() * 1.0 * (double)(1 + count / 50) * (double)0.15f;
            shrapnel.field_70179_y = rand.nextGaussian() * 1.0 * (double)(1 + count / 50) * (double)0.15f;
            world.func_72838_d((Entity)shrapnel);
        }
    }

    public static void explode(World world, double x, double y, double z, float strength, boolean cloud, boolean rubble, boolean shrapnel) {
        world.func_72876_a(null, x, y, z, strength, true);
        if (cloud) {
            ExplosionLarge.spawnParticles(world, x, y, z, ExplosionLarge.cloudFunction((int)strength));
        }
        if (rubble) {
            ExplosionLarge.spawnRubble(world, x, y, z, ExplosionLarge.rubbleFunction((int)strength));
        }
        if (shrapnel) {
            ExplosionLarge.spawnShrapnels(world, x, y, z, ExplosionLarge.shrapnelFunction((int)strength));
        }
    }

    public static void explodeFire(World world, double x, double y, double z, float strength, boolean cloud, boolean rubble, boolean shrapnel) {
        world.func_72885_a((Entity)null, (double)((float)x), (double)((float)y), (double)((float)z), strength, true, true);
        if (cloud) {
            ExplosionLarge.spawnParticles(world, x, y, z, ExplosionLarge.cloudFunction((int)strength));
        }
        if (rubble) {
            ExplosionLarge.spawnRubble(world, x, y, z, ExplosionLarge.rubbleFunction((int)strength));
        }
        if (shrapnel) {
            ExplosionLarge.spawnShrapnels(world, x, y, z, ExplosionLarge.shrapnelFunction((int)strength));
        }
    }

    public static void buster(World world, double x, double y, double z, Vec3 vector, float strength, float depth) {
        vector = vector.func_72432_b();
        int i = 0;
        while ((float)i < depth) {
            world.func_72876_a((Entity)null, x + vector.field_72450_a * (double)i, y + vector.field_72448_b * (double)i, z + vector.field_72449_c * (double)i, strength, true);
            i += 2;
        }
    }

    public static void jolt(World world, double posX, double posY, double posZ, double strength, int count, double vel) {
        block0: for (int j = 0; j < count; ++j) {
            double phi = rand.nextDouble() * (Math.PI * 2);
            double costheta = rand.nextDouble() * 2.0 - 1.0;
            double theta = Math.acos(costheta);
            double x = Math.sin(theta) * Math.cos(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            double z = Math.cos(theta);
            Vec3 vec = Vec3.func_72443_a((double)x, (double)y, (double)z);
            int i = 0;
            while ((double)i < strength) {
                double x0 = posX + vec.field_72450_a * (double)i;
                double y0 = posY + vec.field_72448_b * (double)i;
                double z0 = posZ + vec.field_72449_c * (double)i;
                if (!world.field_72995_K) {
                    if (world.func_147439_a((int)x0, (int)y0, (int)z0).func_149688_o().func_76224_d()) {
                        world.func_147449_b((int)x0, (int)y0, (int)z0, Blocks.field_150350_a);
                    }
                    if (world.func_147439_a((int)x0, (int)y0, (int)z0) != Blocks.field_150350_a && !(world.func_147439_a((int)x0, (int)y0, (int)z0).func_149638_a(null) > 70.0f)) {
                        EntityRubble rubble = new EntityRubble(world);
                        rubble.field_70165_t = x0 + 0.5;
                        rubble.field_70163_u = y0 + 0.5;
                        rubble.field_70161_v = z0 + 0.5;
                        rubble.setMetaBasedOnBlock(world.func_147439_a((int)x0, (int)y0, (int)z0), world.func_72805_g((int)x0, (int)y0, (int)z0));
                        Vec3 vec4 = Vec3.func_72443_a((double)(posX - rubble.field_70165_t), (double)(posY - rubble.field_70163_u), (double)(posZ - rubble.field_70161_v));
                        vec4.func_72432_b();
                        rubble.field_70159_w = vec4.field_72450_a * vel;
                        rubble.field_70181_x = vec4.field_72448_b * vel;
                        rubble.field_70179_y = vec4.field_72449_c * vel;
                        world.func_72838_d((Entity)rubble);
                        world.func_147449_b((int)x0, (int)y0, (int)z0, Blocks.field_150350_a);
                        continue block0;
                    }
                }
                ++i;
            }
        }
    }

    public static int cloudFunction(int i) {
        return (int)(850.0 * (1.0 - Math.pow(Math.E, -i / 15)) + 15.0);
    }

    public static int rubbleFunction(int i) {
        return i / 10;
    }

    public static int shrapnelFunction(int i) {
        return i / 3;
    }
}

